/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.StatsEvent;
import android.util.StatsLog;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowStatsLog_StatsLogItem;

@Implements(value=StatsLog.class, minSdk=30)
public class ShadowStatsLog {
    private static List<StatsLogItem> statsLogs = Collections.synchronizedList(new ArrayList());

    @Implementation
    protected static void __staticInitializer__() {
    }

    public static List<StatsLogItem> getStatsLogs() {
        return Collections.unmodifiableList(statsLogs);
    }

    @Resetter
    public static void reset() {
        statsLogs = Collections.synchronizedList(new ArrayList());
    }

    @Implementation
    public static void write(StatsEvent statsEvent) {
        statsLogs.add(StatsLogItem.create(statsEvent.getAtomId(), statsEvent.getNumBytes(), statsEvent.getBytes()));
        statsEvent.release();
    }

    @AutoValue
    public static abstract class StatsLogItem {
        public abstract int atomId();

        public abstract int numBytes();

        public abstract byte[] bytes();

        public static StatsLogItem create(int atomId, int numBytes, byte[] bytes) {
            return new AutoValue_ShadowStatsLog_StatsLogItem(atomId, numBytes, (byte[])bytes.clone());
        }
    }
}

