/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Sensor;
import android.hardware.SensorDirectChannel;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Looper;
import android.os.MemoryFile;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowSensor;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SensorManager.class, looseSignatures=true)
public class ShadowSensorManager {
    public boolean forceListenersToFail = false;
    private final Map<Integer, Sensor> sensorMap = new HashMap<Integer, Sensor>();
    private final Multimap<SensorEventListener, Sensor> listeners = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    @RealObject
    private SensorManager realObject;

    @Deprecated
    public void addSensor(int sensorType, Sensor sensor) {
        Preconditions.checkNotNull((Object)sensor);
        this.sensorMap.put(sensorType, sensor);
    }

    public void addSensor(Sensor sensor) {
        Preconditions.checkNotNull((Object)sensor);
        this.sensorMap.put(sensor.getType(), sensor);
    }

    public void removeSensor(Sensor sensor) {
        Preconditions.checkNotNull((Object)sensor);
        this.sensorMap.remove(sensor.getType());
    }

    @Implementation
    protected Sensor getDefaultSensor(int type) {
        return this.sensorMap.get(type);
    }

    @Implementation
    public List<Sensor> getSensorList(int type) {
        ArrayList<Sensor> sensorList = new ArrayList<Sensor>();
        Sensor sensor = this.sensorMap.get(type);
        if (sensor != null) {
            sensorList.add(sensor);
        }
        return sensorList;
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, Handler handler) {
        return this.registerListener(listener, sensor, rate);
    }

    @Implementation(minSdk=19)
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, int maxLatency) {
        return this.registerListener(listener, sensor, rate);
    }

    @Implementation(minSdk=19)
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, int maxLatency, Handler handler) {
        return this.registerListener(listener, sensor, rate);
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        if (this.forceListenersToFail) {
            return false;
        }
        this.listeners.put((Object)listener, (Object)sensor);
        return true;
    }

    @Implementation
    protected void unregisterListener(SensorEventListener listener, Sensor sensor) {
        this.listeners.remove((Object)listener, (Object)sensor);
    }

    @Implementation
    protected void unregisterListener(SensorEventListener listener) {
        this.listeners.removeAll((Object)listener);
    }

    public boolean hasListener(SensorEventListener listener) {
        return this.listeners.containsKey((Object)listener);
    }

    public boolean hasListener(SensorEventListener listener, Sensor sensor) {
        return this.listeners.containsEntry((Object)listener, (Object)sensor);
    }

    public List<SensorEventListener> getListeners() {
        return ImmutableList.copyOf((Collection)this.listeners.keySet());
    }

    public void sendSensorEventToListeners(SensorEvent event) {
        for (SensorEventListener listener : this.getListeners()) {
            listener.onSensorChanged(event);
        }
    }

    @Implementation(minSdk=19)
    protected boolean flush(SensorEventListener listener) {
        new Handler(Looper.getMainLooper()).post(() -> {
            for (Sensor sensor : this.listeners.get((Object)listener)) {
                for (SensorEventListener registeredListener : this.getListeners()) {
                    if (!(registeredListener instanceof SensorEventListener2) || !this.listeners.containsEntry((Object)registeredListener, (Object)sensor)) continue;
                    ((SensorEventListener2)registeredListener).onFlushCompleted(sensor);
                }
            }
        });
        return this.listeners.containsKey((Object)listener);
    }

    public SensorEvent createSensorEvent() {
        return (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public static SensorEvent createSensorEvent(int valueArraySize) {
        return ShadowSensorManager.createSensorEvent(valueArraySize, 9);
    }

    public static SensorEvent createSensorEvent(int valueArraySize, int sensorType) {
        Preconditions.checkArgument((valueArraySize > 0 ? 1 : 0) != 0);
        ReflectionHelpers.ClassParameter valueArraySizeParam = new ReflectionHelpers.ClassParameter(Integer.TYPE, (Object)valueArraySize);
        SensorEvent sensorEvent = (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{valueArraySizeParam});
        sensorEvent.sensor = ShadowSensor.newInstance(sensorType);
        return sensorEvent;
    }

    @Implementation(minSdk=26)
    protected Object createDirectChannel(MemoryFile mem) {
        return ReflectionHelpers.callConstructor(SensorDirectChannel.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(SensorManager.class, (Object)this.realObject), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)mem.length())});
    }
}

