/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=PixelCopy.class, minSdk=28)
public class ShadowPixelCopy {
    @Implementation
    protected static void request(@NonNull SurfaceView source, @Nullable Rect srcRect, @NonNull Bitmap dest, @NonNull PixelCopy.OnPixelCopyFinishedListener listener, @NonNull Handler listenerThread) {
        Activity activity = ShadowPixelCopy.getActivity((View)source);
        if (srcRect != null && srcRect.isEmpty()) {
            throw new IllegalArgumentException("sourceRect is empty");
        }
        if (activity == null) {
            throw new IllegalArgumentException("SourceView was not attached to an activity");
        }
        ShadowPixelCopy.takeScreenshot(activity.getWindow(), dest, srcRect);
        ShadowPixelCopy.alertFinished(listener, listenerThread, 0);
    }

    @Implementation
    protected static void request(@NonNull Window source, @NonNull Bitmap dest, @NonNull PixelCopy.OnPixelCopyFinishedListener listener, @NonNull Handler listenerThread) {
        ShadowPixelCopy.takeScreenshot(source, dest, null);
        ShadowPixelCopy.alertFinished(listener, listenerThread, 0);
    }

    @Implementation
    protected static void request(@NonNull Window source, @Nullable Rect srcRect, @NonNull Bitmap dest, @NonNull PixelCopy.OnPixelCopyFinishedListener listener, @NonNull Handler listenerThread) {
        if (srcRect != null && srcRect.isEmpty()) {
            throw new IllegalArgumentException("sourceRect is empty");
        }
        ShadowPixelCopy.takeScreenshot(source, dest, srcRect);
        ShadowPixelCopy.alertFinished(listener, listenerThread, 0);
    }

    private static void takeScreenshot(Window window, Bitmap screenshot, @Nullable Rect srcRect) {
        ShadowPixelCopy.validateBitmap(screenshot);
        View decorView = window.getDecorView();
        Bitmap bitmap = Bitmap.createBitmap((int)decorView.getWidth(), (int)decorView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas screenshotCanvas = new Canvas(bitmap);
        decorView.draw(screenshotCanvas);
        Rect dst = new Rect(0, 0, screenshot.getWidth(), screenshot.getHeight());
        Canvas resizingCanvas = new Canvas(screenshot);
        Paint paint = new Paint();
        resizingCanvas.drawBitmap(bitmap, srcRect, dst, paint);
    }

    private static void alertFinished(PixelCopy.OnPixelCopyFinishedListener listener, Handler listenerThread, int result) {
        if (listenerThread.getLooper() == Looper.getMainLooper()) {
            listener.onPixelCopyFinished(result);
            return;
        }
        listenerThread.post(() -> listener.onPixelCopyFinished(result));
    }

    private static void validateBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap cannot be null");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled");
        }
        if (!bitmap.isMutable()) {
            throw new IllegalArgumentException("Bitmap is immutable");
        }
    }

    private static Activity getActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return ShadowPixelCopy.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    private static Activity getActivity(View view) {
        ViewGroup viewGroup;
        Activity activity = ShadowPixelCopy.getActivity(view.getContext());
        if (activity != null) {
            return activity;
        }
        if (view instanceof ViewGroup && (viewGroup = (ViewGroup)view).getChildCount() > 0) {
            return ShadowPixelCopy.getActivity(viewGroup.getChildAt(0).getContext());
        }
        return null;
    }
}

