/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.content.ComponentName;
import android.os.Build;
import android.os.UserHandle;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowService;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=NotificationListenerService.class, minSdk=21)
public class ShadowNotificationListenerService
extends ShadowService {
    private static final AtomicInteger rebindRequestCount = new AtomicInteger(0);
    private final List<StatusBarNotification> activeNotifications = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger interruptionFilter = new AtomicInteger(0);
    private final AtomicInteger hint = new AtomicInteger(0);
    private final AtomicInteger unbindRequestCount = new AtomicInteger(0);
    private final NotificationListenerService.RankingMap emptyRankingMap = ShadowNotificationListenerService.createEmptyRankingMap();

    public String addActiveNotification(String packageName, int id2, Notification notification) {
        StatusBarNotification statusBarNotification = new StatusBarNotification(packageName, packageName, id2, null, 0, 0, 0, notification, UserHandle.CURRENT, notification.when);
        return this.addActiveNotification(statusBarNotification);
    }

    public String addActiveNotification(StatusBarNotification statusBarNotification) {
        this.activeNotifications.add(statusBarNotification);
        return statusBarNotification.getKey();
    }

    @Implementation(minSdk=24)
    protected static void requestRebind(ComponentName componentName) {
        rebindRequestCount.incrementAndGet();
    }

    @Implementation(minSdk=24)
    protected void requestUnbind() {
        this.unbindRequestCount.incrementAndGet();
    }

    @Implementation
    protected final void cancelAllNotifications() {
        this.activeNotifications.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected final void cancelNotification(String key) {
        List<StatusBarNotification> list = this.activeNotifications;
        synchronized (list) {
            Iterator<StatusBarNotification> iterator = this.activeNotifications.iterator();
            while (iterator.hasNext()) {
                StatusBarNotification statusBarNotification = iterator.next();
                if (!statusBarNotification.getKey().equals(key)) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Implementation
    protected StatusBarNotification[] getActiveNotifications(String[] keys, int trim) {
        if (keys == null) {
            return this.activeNotifications.toArray(new StatusBarNotification[0]);
        }
        ImmutableSet keySet = ImmutableSet.copyOf((Object[])keys);
        return this.activeNotifications.stream().filter(notification -> keySet.contains((Object)notification.getKey())).collect(Collectors.toCollection(ArrayList::new)).toArray(new StatusBarNotification[0]);
    }

    @Implementation
    protected void requestInterruptionFilter(int interruptionFilter) {
        this.interruptionFilter.set(interruptionFilter);
    }

    @Implementation
    protected int getCurrentInterruptionFilter() {
        return this.interruptionFilter.get();
    }

    @Implementation
    protected void requestListenerHints(int hint) {
        this.hint.set(hint);
    }

    @Implementation
    protected int getCurrentListenerHints() {
        return this.hint.get();
    }

    @Implementation
    protected NotificationListenerService.RankingMap getCurrentRanking() {
        return this.emptyRankingMap;
    }

    public static int getRebindRequestCount() {
        return rebindRequestCount.get();
    }

    public int getUnbindRequestCount() {
        return this.unbindRequestCount.get();
    }

    @Resetter
    public static void reset() {
        rebindRequestCount.set(0);
    }

    private static NotificationListenerService.RankingMap createEmptyRankingMap() {
        return Build.VERSION.SDK_INT < 29 ? (NotificationListenerService.RankingMap)ReflectionHelpers.callConstructor(NotificationListenerService.RankingMap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]) : (NotificationListenerService.RankingMap)ReflectionHelpers.callConstructor(NotificationListenerService.RankingMap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(NotificationListenerService.Ranking[].class, (Object)new NotificationListenerService.Ranking[0])});
    }
}

