/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telecom.InCallAdapter;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=InCallAdapter.class, isInAndroidSdk=false)
public class ShadowInCallAdapter {
    @RealObject
    private InCallAdapter inCallAdapter;
    private int audioRoute = 1;

    @Implementation(minSdk=21)
    protected void setAudioRoute(int route) {
        this.audioRoute = route;
        if (this.isInternalInCallAdapterSet()) {
            ((ReflectorInCallAdapter)Reflector.reflector(ReflectorInCallAdapter.class, (Object)this.inCallAdapter)).setAudioRoute(route);
        }
    }

    public int getAudioRoute() {
        return this.audioRoute;
    }

    private boolean isInternalInCallAdapterSet() {
        Object internalAdapter = ((ReflectorInCallAdapter)Reflector.reflector(ReflectorInCallAdapter.class, (Object)this.inCallAdapter)).getInternalInCallAdapter();
        return internalAdapter != null;
    }

    @ForType(value=InCallAdapter.class)
    static interface ReflectorInCallAdapter {
        @Direct
        public void setAudioRoute(int var1);

        @Accessor(value="mAdapter")
        public Object getInternalInCallAdapter();
    }
}

