/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.InputStream;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmapDrawable;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Drawable.class)
public class ShadowDrawable {
    @RealObject
    Drawable realDrawable;
    int createdFromResId = -1;
    InputStream createdFromInputStream;
    private boolean wasInvalidated;

    @Deprecated
    public static Drawable createFromResourceId(int resourceId) {
        Bitmap bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        BitmapDrawable drawable = new BitmapDrawable(bitmap);
        ShadowBitmapDrawable shadowBitmapDrawable = (ShadowBitmapDrawable)Shadow.extract((Object)drawable);
        shadowBitmapDrawable.validate();
        shadowBitmapDrawable.setCreatedFromResId(resourceId, null);
        return drawable;
    }

    protected void setCreatedFromResId(int createdFromResId, String resourceName) {
        this.createdFromResId = createdFromResId;
    }

    public InputStream getInputStream() {
        return this.createdFromInputStream;
    }

    @Implementation
    protected void invalidateSelf() {
        this.wasInvalidated = true;
        ((DrawableReflector)Reflector.reflector(DrawableReflector.class, (Object)this.realDrawable)).invalidateSelf();
    }

    public int getCreatedFromResId() {
        return this.createdFromResId;
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public void validate() {
        this.wasInvalidated = false;
    }

    @ForType(value=Drawable.class)
    static interface DrawableReflector {
        @Direct
        public void invalidateSelf();
    }
}

