/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ContentProviderClient.class)
public class ShadowContentProviderClient {
    @RealObject
    private ContentProviderClient realContentProviderClient;
    private ContentProvider provider;

    @Implementation(minSdk=17)
    protected Bundle call(String method, String arg, Bundle extras) throws RemoteException {
        return this.provider.call(method, arg, extras);
    }

    @Implementation
    protected String getType(Uri uri) throws RemoteException {
        return this.provider.getType(uri);
    }

    @Implementation
    protected String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
        return this.provider.getStreamTypes(uri, mimeTypeFilter);
    }

    @Implementation
    protected Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        return this.provider.query(url, projection, selection, selectionArgs, sortOrder);
    }

    @Implementation
    protected Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) throws RemoteException {
        return this.provider.query(url, projection, selection, selectionArgs, sortOrder, cancellationSignal);
    }

    @Implementation
    protected Uri insert(Uri url, ContentValues initialValues) throws RemoteException {
        return this.provider.insert(url, initialValues);
    }

    @Implementation
    protected int bulkInsert(Uri url, ContentValues[] initialValues) throws RemoteException {
        return this.provider.bulkInsert(url, initialValues);
    }

    @Implementation
    protected int delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        return this.provider.delete(url, selection, selectionArgs);
    }

    @Implementation
    protected int update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        return this.provider.update(url, values, selection, selectionArgs);
    }

    @Implementation
    protected ParcelFileDescriptor openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.provider.openFile(url, mode);
    }

    @Implementation
    protected AssetFileDescriptor openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.provider.openAssetFile(url, mode);
    }

    @Implementation
    protected final AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts) throws RemoteException, FileNotFoundException {
        return this.provider.openTypedAssetFile(uri, mimeType, opts);
    }

    @Implementation
    protected ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        return this.provider.applyBatch(operations);
    }

    @Implementation
    protected ContentProvider getLocalContentProvider() {
        return ContentProvider.coerceToLocalContentProvider((IContentProvider)this.provider.getIContentProvider());
    }

    public boolean isStable() {
        return ((ContentProviderClientReflector)Reflector.reflector(ContentProviderClientReflector.class, (Object)this.realContentProviderClient)).getStable();
    }

    public boolean isReleased() {
        ContentProviderClientReflector contentProviderClientReflector = (ContentProviderClientReflector)Reflector.reflector(ContentProviderClientReflector.class, (Object)this.realContentProviderClient);
        if (RuntimeEnvironment.getApiLevel() <= 23) {
            return contentProviderClientReflector.getReleased();
        }
        return contentProviderClientReflector.getClosed().get();
    }

    void setContentProvider(ContentProvider provider) {
        this.provider = provider;
    }

    @ForType(value=ContentProviderClient.class)
    static interface ContentProviderClientReflector {
        @Direct
        public boolean release();

        @Accessor(value="mStable")
        public boolean getStable();

        @Accessor(value="mReleased")
        public boolean getReleased();

        @Accessor(value="mClosed")
        public AtomicBoolean getClosed();
    }
}

