/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Build;
import dalvik.system.CloseGuard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=CloseGuard.class, isInAndroidSdk=false)
public class ShadowCloseGuard {
    private static final Set<CloseGuard> openCloseGuards = Collections.synchronizedSet(new HashSet());
    private static final Set<Throwable> warnedThrowables = Collections.synchronizedSet(new HashSet());
    @RealObject
    private CloseGuard realCloseGuard;
    @ReflectorObject
    private CloseGuardReflector closeGuardReflector;

    @Implementation
    protected void open(String closer) {
        this.closeGuardReflector.open(closer);
        openCloseGuards.add(this.realCloseGuard);
    }

    @Implementation
    protected void close() {
        this.closeGuardReflector.close();
        openCloseGuards.remove(this.realCloseGuard);
    }

    @Implementation
    protected void warnIfOpen() {
        this.closeGuardReflector.warnIfOpen();
        if (openCloseGuards.contains(this.realCloseGuard)) {
            warnedThrowables.add(ShadowCloseGuard.createThrowableFromCloseGuard(this.realCloseGuard));
        }
    }

    @Resetter
    public static void reset() {
        openCloseGuards.clear();
        warnedThrowables.clear();
    }

    public static ArrayList<Throwable> getErrors() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>(openCloseGuards.size() + warnedThrowables.size());
        for (CloseGuard closeGuard : openCloseGuards) {
            errors.add(ShadowCloseGuard.createThrowableFromCloseGuard(closeGuard));
        }
        errors.addAll(warnedThrowables);
        return errors;
    }

    private static Throwable createThrowableFromCloseGuard(CloseGuard closeGuard) {
        if (Build.VERSION.SDK_INT >= 28) {
            Object closerNameOrAllocationInfo = ((CloseGuardReflector)Reflector.reflector(CloseGuardReflector.class, (Object)closeGuard)).getCloserNameOrAllocationInfo();
            if (closerNameOrAllocationInfo instanceof Throwable) {
                return (Throwable)closerNameOrAllocationInfo;
            }
            if (closerNameOrAllocationInfo instanceof String) {
                return new Throwable((String)closerNameOrAllocationInfo);
            }
        } else {
            Throwable allocationSite = ((CloseGuardReflector)Reflector.reflector(CloseGuardReflector.class, (Object)closeGuard)).getAllocationSite();
            if (allocationSite != null) {
                return allocationSite;
            }
        }
        return new Throwable("CloseGuard with no allocation info");
    }

    @ForType(value=CloseGuard.class)
    static interface CloseGuardReflector {
        @Direct
        public void open(String var1);

        @Direct
        public void close();

        @Direct
        public void warnIfOpen();

        @Accessor(value="closerNameOrAllocationInfo")
        public Object getCloserNameOrAllocationInfo();

        @Accessor(value="allocationSite")
        public Throwable getAllocationSite();
    }
}

