/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=BroadcastReceiver.PendingResult.class)
public final class ShadowBroadcastPendingResult {
    @RealObject
    BroadcastReceiver.PendingResult pendingResult;
    private final SettableFuture<BroadcastReceiver.PendingResult> finished = SettableFuture.create();

    static BroadcastReceiver.PendingResult create(int resultCode, String resultData, Bundle resultExtras, boolean ordered) {
        try {
            if (RuntimeEnvironment.getApiLevel() <= 16) {
                return (BroadcastReceiver.PendingResult)BroadcastReceiver.PendingResult.class.getConstructor(Integer.TYPE, String.class, Bundle.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, IBinder.class).newInstance(resultCode, resultData, resultExtras, 0, ordered, false, null);
            }
            if (RuntimeEnvironment.getApiLevel() <= 22) {
                return (BroadcastReceiver.PendingResult)BroadcastReceiver.PendingResult.class.getConstructor(Integer.TYPE, String.class, Bundle.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, IBinder.class, Integer.TYPE).newInstance(resultCode, resultData, resultExtras, 0, ordered, false, null, 0);
            }
            return new BroadcastReceiver.PendingResult(resultCode, resultData, resultExtras, 0, ordered, false, null, 0, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static BroadcastReceiver.PendingResult createSticky(Intent intent) {
        try {
            if (RuntimeEnvironment.getApiLevel() <= 16) {
                return (BroadcastReceiver.PendingResult)BroadcastReceiver.PendingResult.class.getConstructor(Integer.TYPE, String.class, Bundle.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, IBinder.class).newInstance(0, intent.getDataString(), intent.getExtras(), 0, false, true, null);
            }
            if (RuntimeEnvironment.getApiLevel() <= 22) {
                return (BroadcastReceiver.PendingResult)BroadcastReceiver.PendingResult.class.getConstructor(Integer.TYPE, String.class, Bundle.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, IBinder.class, Integer.TYPE).newInstance(0, intent.getDataString(), intent.getExtras(), 0, false, true, null, 0);
            }
            return new BroadcastReceiver.PendingResult(0, intent.getDataString(), intent.getExtras(), 0, false, true, null, 0, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected final void finish() {
        Preconditions.checkState((boolean)this.finished.set((Object)this.pendingResult), (Object)"Broadcast already finished");
    }

    public ListenableFuture<BroadcastReceiver.PendingResult> getFuture() {
        return this.finished;
    }
}

