/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.Scheduler;

@Deprecated
public class RoboExecutorService
implements ExecutorService {
    private final Scheduler scheduler;
    private boolean isShutdown;
    private final HashSet<Runnable> runnables = new HashSet();

    public RoboExecutorService() {
        this.scheduler = ShadowApplication.getInstance().getBackgroundThreadScheduler();
    }

    @Override
    public void shutdown() {
        this.shutdownNow();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.isShutdown = true;
        ArrayList<Runnable> notExecutedRunnables = new ArrayList<Runnable>();
        for (Runnable runnable : this.runnables) {
            this.scheduler.remove(runnable);
            notExecutedRunnables.add(runnable);
        }
        this.runnables.clear();
        return notExecutedRunnables;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.isShutdown();
    }

    @Override
    public <T> Future<T> submit(Callable<T> tCallable) {
        return this.schedule(new AdvancingFutureTask<T>(this.scheduler, tCallable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.schedule(new AdvancingFutureTask<T>(this.scheduler, runnable, t));
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.submit(runnable, null);
    }

    private <T> Future<T> schedule(final FutureTask<T> futureTask) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                futureTask.run();
                RoboExecutorService.this.runnables.remove(this);
            }
        };
        this.runnables.add(runnable);
        this.scheduler.post(runnable);
        return futureTask;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable runnable) {
        Future<?> possiblyIgnoredError = this.submit(runnable);
    }

    static class AdvancingFutureTask<V>
    extends FutureTask<V> {
        private final Scheduler scheduler;

        public AdvancingFutureTask(Scheduler scheduler, Callable<V> callable) {
            super(callable);
            this.scheduler = scheduler;
        }

        public AdvancingFutureTask(Scheduler scheduler, Runnable runnable, V result) {
            super(runnable, result);
            this.scheduler = scheduler;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            while (!this.isDone()) {
                this.scheduler.advanceToNextPostedRunnable();
            }
            return super.get();
        }
    }
}

