/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.app.Activity;
import android.app.Application;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.controller.ComponentController;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowActivity;
import org.robolectric.shadows.ShadowContextThemeWrapper;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.shadows.ShadowViewRootImpl;
import org.robolectric.shadows._Activity_;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

public class ActivityController<T extends Activity>
extends ComponentController<ActivityController<T>, T>
implements AutoCloseable {
    private static final int CONFIG_WINDOW_CONFIGURATION = 0x20000000;
    private _Activity_ _component_;
    private LifecycleState currentState = LifecycleState.INITIAL;

    public static <T extends Activity> ActivityController<T> of(T activity, Intent intent, @Nullable Bundle activityOptions) {
        return super.attach(activityOptions);
    }

    public static <T extends Activity> ActivityController<T> of(T activity, Intent intent) {
        return super.attach(null);
    }

    public static <T extends Activity> ActivityController<T> of(T activity) {
        return super.attach(null);
    }

    private ActivityController(T activity, Intent intent) {
        super(activity, intent);
        this._component_ = (_Activity_)Reflector.reflector(_Activity_.class, (Object)this.component);
    }

    private ActivityController<T> attach(@Nullable Bundle activityOptions) {
        return this.attach(activityOptions, null, null);
    }

    private ActivityController<T> attach(@Nullable Bundle activityOptions, @Nullable @WithType(value="android.app.Activity$NonConfigurationInstances") Object lastNonConfigurationInstances, @Nullable Configuration overrideConfig) {
        if (this.attached) {
            return this;
        }
        Context context = RuntimeEnvironment.getApplication().getBaseContext();
        PackageManager packageManager = context.getPackageManager();
        ComponentName componentName = new ComponentName(context.getPackageName(), ((Activity)this.component).getClass().getName());
        ((ShadowPackageManager)Shadow.extract((Object)packageManager)).addActivityIfNotPresent(componentName);
        packageManager.setComponentEnabledSetting(componentName, 1, 0);
        ShadowActivity shadowActivity = (ShadowActivity)Shadow.extract((Object)this.component);
        shadowActivity.callAttach(this.getIntent(), activityOptions, lastNonConfigurationInstances, overrideConfig);
        shadowActivity.attachController(this);
        this.attached = true;
        return this;
    }

    private ActivityInfo getActivityInfo(Application application) {
        PackageManager packageManager = application.getPackageManager();
        ComponentName componentName = new ComponentName(application.getPackageName(), ((Activity)this.component).getClass().getName());
        try {
            return packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ActivityController<T> create(@Nullable Bundle bundle) {
        this.shadowMainLooper.runPaused(() -> {
            this.getInstrumentation().callActivityOnCreate((Activity)this.component, bundle);
            this.currentState = LifecycleState.CREATED;
        });
        return this;
    }

    @Override
    public ActivityController<T> create() {
        return this.create(null);
    }

    public ActivityController<T> restart() {
        this.invokeWhilePaused(() -> {
            if (RuntimeEnvironment.getApiLevel() <= 27) {
                this._component_.performRestart();
            } else if (RuntimeEnvironment.getApiLevel() <= 33) {
                this._component_.performRestart(true, "restart()");
            } else {
                this._component_.performRestart(true);
            }
            this.currentState = LifecycleState.RESTARTED;
        });
        return this;
    }

    public ActivityController<T> start() {
        this.invokeWhilePaused(() -> {
            if (RuntimeEnvironment.getApiLevel() <= 27) {
                this._component_.performStart();
            } else {
                this._component_.performStart("start()");
            }
            this.currentState = LifecycleState.STARTED;
        });
        return this;
    }

    public ActivityController<T> restoreInstanceState(Bundle bundle) {
        this.shadowMainLooper.runPaused(() -> this.getInstrumentation().callActivityOnRestoreInstanceState((Activity)this.component, bundle));
        return this;
    }

    public ActivityController<T> postCreate(@Nullable Bundle bundle) {
        this.invokeWhilePaused(() -> this._component_.onPostCreate(bundle));
        return this;
    }

    public ActivityController<T> resume() {
        this.invokeWhilePaused(() -> {
            if (RuntimeEnvironment.getApiLevel() <= 27) {
                this._component_.performResume();
            } else {
                this._component_.performResume(true, "resume()");
            }
            this.currentState = LifecycleState.RESUMED;
        });
        return this;
    }

    public ActivityController<T> postResume() {
        this.invokeWhilePaused(() -> this._component_.onPostResume());
        return this;
    }

    @CanIgnoreReturnValue
    public ActivityController<T> topActivityResumed(boolean isTop) {
        if (RuntimeEnvironment.getApiLevel() < 29) {
            return this;
        }
        this.invokeWhilePaused(() -> this._component_.performTopResumedActivityChanged(isTop, "topStateChangedWhenResumed"));
        return this;
    }

    public ActivityController<T> visible() {
        this.shadowMainLooper.runPaused(() -> {
            ((Activity)this.component).getWindow().getAttributes().type = 1;
            this._component_.setDecor(((Activity)this.component).getWindow().getDecorView());
            this._component_.makeVisible();
        });
        this.shadowMainLooper.idleIfPaused();
        ViewRootImpl root = this.getViewRoot();
        if (root != null) {
            this.callDispatchResized(root);
            this.shadowMainLooper.idleIfPaused();
        }
        return this;
    }

    private ViewRootImpl getViewRoot() {
        return ((Activity)this.component).getWindow().getDecorView().getViewRootImpl();
    }

    private void callDispatchResized(ViewRootImpl root) {
        ((ShadowViewRootImpl)Shadow.extract((Object)root)).callDispatchResized();
    }

    public ActivityController<T> windowFocusChanged(boolean hasFocus) {
        ViewRootImpl root = this.getViewRoot();
        if (root == null) {
            this.shadowMainLooper.idle();
            root = (ViewRootImpl)Preconditions.checkNotNull((Object)this.getViewRoot());
            this.callDispatchResized(root);
        }
        ((ShadowViewRootImpl)Shadow.extract((Object)root)).callWindowFocusChanged(hasFocus);
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    public ActivityController<T> userLeaving() {
        this.shadowMainLooper.runPaused(() -> this.getInstrumentation().callActivityOnUserLeaving((Activity)this.component));
        return this;
    }

    public ActivityController<T> pause() {
        this.shadowMainLooper.runPaused(() -> {
            this.getInstrumentation().callActivityOnPause((Activity)this.component);
            this.currentState = LifecycleState.PAUSED;
        });
        return this;
    }

    public ActivityController<T> saveInstanceState(Bundle outState) {
        this.shadowMainLooper.runPaused(() -> this.getInstrumentation().callActivityOnSaveInstanceState((Activity)this.component, outState));
        return this;
    }

    public ActivityController<T> stop() {
        this.invokeWhilePaused(() -> {
            if (RuntimeEnvironment.getApiLevel() <= 23) {
                this._component_.performStop();
            } else if (RuntimeEnvironment.getApiLevel() <= 27) {
                this._component_.performStop(true);
            } else {
                this._component_.performStop(true, "stop()");
            }
            this.currentState = LifecycleState.STOPPED;
        });
        return this;
    }

    @Override
    public ActivityController<T> destroy() {
        this.shadowMainLooper.runPaused(() -> {
            this.getInstrumentation().callActivityOnDestroy((Activity)this.component);
            this.makeActivityEligibleForGc();
            this.currentState = LifecycleState.DESTROYED;
        });
        return this;
    }

    private void makeActivityEligibleForGc() {
        boolean windowAdded = this._component_.getWindowAdded();
        if (windowAdded) {
            WindowManager windowManager = ((Activity)this.component).getWindowManager();
            windowManager.removeViewImmediate(((Activity)this.component).getWindow().getDecorView());
        }
        if (RuntimeEnvironment.getApiLevel() >= 27) {
            ((Activity)this.component).setAutofillClient(null);
        }
    }

    public ActivityController<T> setup() {
        return ((ActivityController)this.create()).start().postCreate(null).resume().visible().topActivityResumed(true);
    }

    public ActivityController<T> setup(Bundle savedInstanceState) {
        return this.create(savedInstanceState).start().restoreInstanceState(savedInstanceState).postCreate(savedInstanceState).resume().visible().topActivityResumed(true);
    }

    public ActivityController<T> newIntent(Intent intent) {
        this.invokeWhilePaused(() -> this._component_.onNewIntent(intent));
        return this;
    }

    public ActivityController<T> configurationChange() {
        return this.configurationChange(((Activity)this.component).getApplicationContext().getResources().getConfiguration());
    }

    public ActivityController<T> configurationChange(Configuration newConfiguration) {
        Resources resources = ((Activity)this.component).getResources();
        return this.configurationChange(newConfiguration, resources.getDisplayMetrics(), resources.getConfiguration().diff(newConfiguration));
    }

    public ActivityController<T> configurationChange(Configuration newConfiguration, DisplayMetrics newMetrics, int changedConfig) {
        ((Activity)this.component).getResources().updateConfiguration(newConfiguration, newMetrics);
        int filteredChanges = ActivityController.filterConfigChanges(changedConfig);
        if ((this.getActivityInfo((Application)((Activity)this.component).getApplication()).configChanges & filteredChanges) == filteredChanges) {
            this.shadowMainLooper.runPaused(() -> {
                ((Activity)this.component).onConfigurationChanged(newConfiguration);
                ViewRootImpl root = this.getViewRoot();
                if (root != null) {
                    if (RuntimeEnvironment.getApiLevel() <= 25) {
                        ReflectionHelpers.callInstanceMethod((Object)root, (String)"updateConfiguration", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)newConfiguration), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)});
                    } else {
                        root.updateConfiguration(-1);
                    }
                }
            });
            return this;
        }
        Activity recreatedActivity = (Activity)ReflectionHelpers.callConstructor(((Activity)this.component).getClass(), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        _Activity_ _recreatedActivity_ = (_Activity_)Reflector.reflector(_Activity_.class, (Object)recreatedActivity);
        this.shadowMainLooper.runPaused(() -> {
            this._component_.setChangingConfigurations(true);
            this._component_.setConfigChangeFlags(filteredChanges);
            Bundle outState = new Bundle();
            this.getInstrumentation().callActivityOnPause((Activity)this.component);
            if (RuntimeEnvironment.getApiLevel() < 28) {
                this._component_.performSaveInstanceState(outState);
                if (RuntimeEnvironment.getApiLevel() <= 23) {
                    this._component_.performStop();
                } else {
                    this._component_.performStop(true);
                }
            } else {
                this._component_.performStop(true, "configurationChange");
                this._component_.performSaveInstanceState(outState);
            }
            Object nonConfigInstance = this._component_.retainNonConfigurationInstances();
            Object activityConfigInstance = nonConfigInstance == null ? null : ((_NonConfigurationInstances_)Reflector.reflector(_NonConfigurationInstances_.class, (Object)nonConfigInstance)).getActivity();
            this.getInstrumentation().callActivityOnDestroy((Activity)this.component);
            this.makeActivityEligibleForGc();
            ShadowContextThemeWrapper shadowContextThemeWrapper = (ShadowContextThemeWrapper)Shadow.extract((Object)this.component);
            int theme = shadowContextThemeWrapper.callGetThemeResId();
            this.attached = false;
            this.component = recreatedActivity;
            this._component_ = _recreatedActivity_;
            System.gc();
            this.attach(null, null, newConfiguration);
            if (theme != 0) {
                recreatedActivity.setTheme(theme);
            }
            _recreatedActivity_.setLastNonConfigurationInstances(nonConfigInstance);
            ShadowActivity shadowActivity = (ShadowActivity)Shadow.extract((Object)recreatedActivity);
            shadowActivity.setLastNonConfigurationInstance(activityConfigInstance);
            this.getInstrumentation().callActivityOnCreate(recreatedActivity, outState);
            if (RuntimeEnvironment.getApiLevel() <= 27) {
                _recreatedActivity_.performStart();
            } else {
                _recreatedActivity_.performStart("configurationChange");
            }
            this.getInstrumentation().callActivityOnRestoreInstanceState(recreatedActivity, outState);
            _recreatedActivity_.onPostCreate(outState);
            if (RuntimeEnvironment.getApiLevel() <= 27) {
                _recreatedActivity_.performResume();
            } else {
                _recreatedActivity_.performResume(true, "configurationChange");
            }
            _recreatedActivity_.onPostResume();
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                _recreatedActivity_.performTopResumedActivityChanged(true, "configurationChange");
            }
        });
        return this;
    }

    public ActivityController<T> recreate() {
        LifecycleState originalState = this.currentState;
        switch (originalState) {
            case INITIAL: {
                this.create();
            }
            case CREATED: 
            case RESTARTED: {
                this.start();
                this.postCreate(null);
            }
            case STARTED: {
                this.resume();
            }
        }
        this._component_.setChangingConfigurations(true);
        switch (originalState) {
            case INITIAL: 
            case CREATED: 
            case RESTARTED: 
            case STARTED: 
            case RESUMED: {
                this.pause();
            }
            case PAUSED: {
                this.stop();
            }
            case STOPPED: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot recreate activity since it's destroyed already");
            }
        }
        Bundle outState = new Bundle();
        this.saveInstanceState(outState);
        Object lastNonConfigurationInstances = this._component_.retainNonConfigurationInstances();
        Configuration overrideConfig = ((Activity)this.component).getResources().getConfiguration();
        this.destroy();
        this.component = (Activity)ReflectionHelpers.callConstructor(((Activity)this.component).getClass(), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this._component_ = (_Activity_)Reflector.reflector(_Activity_.class, (Object)this.component);
        this.attached = false;
        this.attach(null, lastNonConfigurationInstances, overrideConfig);
        this.create(outState);
        this.start();
        this.restoreInstanceState(outState);
        this.postCreate(outState);
        this.resume();
        this.postResume();
        this.visible();
        this.windowFocusChanged(true);
        this.topActivityResumed(true);
        switch (originalState) {
            case PAUSED: {
                this.pause();
                return this;
            }
            case STOPPED: {
                this.pause();
                this.stop();
                return this;
            }
        }
        return this;
    }

    private Instrumentation getInstrumentation() {
        return this._component_.getInstrumentation();
    }

    @Override
    public void close() {
        LifecycleState originalState = this.currentState;
        switch (originalState) {
            case INITIAL: 
            case DESTROYED: {
                return;
            }
            case RESUMED: {
                this.pause();
            }
            case RESTARTED: 
            case STARTED: 
            case PAUSED: {
                this.stop();
            }
        }
        this.destroy();
    }

    private static int filterConfigChanges(int changedConfig) {
        if ((changedConfig & 0x20000000) != 0) {
            changedConfig &= 0xDFFFFFFF;
        }
        return changedConfig;
    }

    @ForType(className="android.app.Activity$NonConfigurationInstances")
    static interface _NonConfigurationInstances_ {
        @Accessor(value="activity")
        public Object getActivity();
    }

    static enum LifecycleState {
        INITIAL,
        CREATED,
        RESTARTED,
        STARTED,
        RESUMED,
        PAUSED,
        STOPPED,
        DESTROYED;

    }
}

