/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class NativeCallHandler {
    private final File exemptionsFile;
    private final boolean writeExemptions;
    private final boolean throwOnNatives;
    private final Set<String> descriptors = new TreeSet<String>();

    public NativeCallHandler(@Nonnull File exemptionsFile, boolean writeExemptions, boolean throwOnNatives) throws IOException {
        this.exemptionsFile = exemptionsFile;
        this.writeExemptions = writeExemptions;
        this.throwOnNatives = throwOnNatives;
        if (exemptionsFile.exists()) {
            this.readExemptionsList(exemptionsFile);
        }
    }

    private String getExemptionFileName() {
        return this.exemptionsFile.getName();
    }

    private void readExemptionsList(File exemptionsFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(exemptionsFile.getPath(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = this.sanitize(line.trim())).isEmpty() || line.charAt(0) == '#') continue;
                this.descriptors.add(line);
            }
        }
        System.out.println("Loaded " + this.descriptors.size() + " exemptions from " + exemptionsFile.getPath());
    }

    public void writeExemptionsList() throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.exemptionsFile.getPath(), StandardCharsets.UTF_8));){
            for (String descriptor : this.descriptors) {
                writer.write(descriptor);
                writer.write(10);
            }
        }
        System.out.println("Wrote " + this.descriptors.size() + " exemptions to " + this.exemptionsFile.getPath());
    }

    public void logNativeCall(@Nonnull String descriptor) {
        if (!this.writeExemptions) {
            return;
        }
        this.descriptors.add(this.sanitize(descriptor));
    }

    public boolean shouldThrow(@Nonnull String descriptor) {
        return this.throwOnNatives && !this.descriptors.contains(this.sanitize(descriptor));
    }

    private String sanitize(String descriptor) {
        return descriptor.replace('$', '^');
    }

    public String getExceptionMessage(@Nonnull String descriptor, @Nonnull String className, @Nonnull String methodName) {
        String shadowHint = "Shadow" + className.replaceAll("[^.]+\\.", "").replaceAll("\\$.*", "") + ".java";
        return "Unexpected Robolectric native method call to '" + className + "#" + methodName + "()'.\nOption 1: If customizing this method is useful, add an implementation in " + shadowHint + ".\nOption 2: If this method just needs to trivially return 0 or null, please add an exemption entry for\n   " + this.sanitize(descriptor) + "\nto exemption file " + this.getExemptionFileName();
    }
}

