/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.MethodInsnNode;
import org.robolectric.annotation.internal.DoNotInstrument;
import org.robolectric.annotation.internal.Instrument;
import org.robolectric.internal.bytecode.ClassDetails;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.MethodRef;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.TypeMapper;
import org.robolectric.shadow.api.Shadow;

public class InstrumentationConfiguration {
    static final Set<String> CLASSES_TO_ALWAYS_ACQUIRE = Sets.newHashSet((Object[])new String[]{RobolectricInternals.class.getName(), InvokeDynamicSupport.class.getName(), Shadow.class.getName(), "org.robolectric.util.FragmentTestUtil", "org.robolectric.util.FragmentTestUtil$FragmentUtilActivity"});
    static final ImmutableSet<String> RESOURCES_TO_ALWAYS_ACQUIRE = ImmutableSet.of((Object)"build.prop", (Object)"usr/share/zoneinfo/tzdata");
    private final List<String> instrumentedPackages;
    private final Set<String> instrumentedClasses;
    private final Set<String> classesToNotInstrument;
    private final String classesToNotInstrumentRegex;
    private final Map<String, String> classNameTranslations;
    private final Set<MethodRef> interceptedMethods;
    private final Set<String> classesToNotAcquire;
    private final Set<String> packagesToNotAcquire;
    private final Set<String> packagesToNotInstrument;
    private int cachedHashCode;
    private final TypeMapper typeMapper;
    private final Set<MethodRef> methodsToIntercept;

    public static Builder newBuilder() {
        return new Builder();
    }

    protected InstrumentationConfiguration(Map<String, String> classNameTranslations, Collection<MethodRef> interceptedMethods, Collection<String> instrumentedPackages, Collection<String> instrumentedClasses, Collection<String> classesToNotAcquire, Collection<String> packagesToNotAquire, Collection<String> classesToNotInstrument, Collection<String> packagesToNotInstrument, String classesToNotInstrumentRegex) {
        this.classNameTranslations = ImmutableMap.copyOf(classNameTranslations);
        this.interceptedMethods = ImmutableSet.copyOf(interceptedMethods);
        this.instrumentedPackages = ImmutableList.copyOf(instrumentedPackages);
        this.instrumentedClasses = ImmutableSet.copyOf(instrumentedClasses);
        this.classesToNotAcquire = ImmutableSet.copyOf(classesToNotAcquire);
        this.packagesToNotAcquire = ImmutableSet.copyOf(packagesToNotAquire);
        this.classesToNotInstrument = ImmutableSet.copyOf(classesToNotInstrument);
        this.packagesToNotInstrument = ImmutableSet.copyOf(packagesToNotInstrument);
        this.classesToNotInstrumentRegex = classesToNotInstrumentRegex;
        this.cachedHashCode = 0;
        this.typeMapper = new TypeMapper(this.classNameTranslations());
        this.methodsToIntercept = ImmutableSet.copyOf(InstrumentationConfiguration.convertToSlashes(this.methodsToIntercept()));
    }

    public boolean shouldInstrument(ClassDetails classDetails) {
        return !classDetails.isAnnotation() && !this.classesToNotInstrument.contains(classDetails.getName()) && !this.isInPackagesToNotInstrument(classDetails.getName()) && !this.classMatchesExclusionRegex(classDetails.getName()) && !classDetails.isInstrumented() && !classDetails.hasAnnotation(DoNotInstrument.class) && (this.isInInstrumentedPackage(classDetails.getName()) || this.instrumentedClasses.contains(classDetails.getName()) || classDetails.hasAnnotation(Instrument.class));
    }

    private boolean classMatchesExclusionRegex(String className) {
        return this.classesToNotInstrumentRegex != null && className.matches(this.classesToNotInstrumentRegex);
    }

    public boolean shouldAcquire(String name) {
        if (CLASSES_TO_ALWAYS_ACQUIRE.contains(name)) {
            return true;
        }
        if (name.equals("java.util.jar.StrictJarFile")) {
            return true;
        }
        if (name.matches("(android|com\\.android\\.internal)\\.R(\\$.+)?")) {
            return true;
        }
        if (name.equals("javax.net.ssl.DistinguishedNameParser") || name.equals("javax.microedition.khronos.opengles.GL")) {
            return true;
        }
        for (String packageName : this.packagesToNotAcquire) {
            if (!name.startsWith(packageName)) continue;
            return false;
        }
        boolean isRClass = name.matches(".*\\.R(|\\$[a-z]+)$");
        return !isRClass && !this.classesToNotAcquire.contains(name);
    }

    public boolean shouldAcquireResource(String name) {
        return RESOURCES_TO_ALWAYS_ACQUIRE.contains((Object)name);
    }

    public Set<MethodRef> methodsToIntercept() {
        return Collections.unmodifiableSet(this.interceptedMethods);
    }

    public Map<String, String> classNameTranslations() {
        return Collections.unmodifiableMap(this.classNameTranslations);
    }

    private boolean isInInstrumentedPackage(String className) {
        for (String instrumentedPackage : this.instrumentedPackages) {
            if (!className.startsWith(instrumentedPackage)) continue;
            return true;
        }
        return false;
    }

    private boolean isInPackagesToNotInstrument(String className) {
        for (String notInstrumentedPackage : this.packagesToNotInstrument) {
            if (!className.startsWith(notInstrumentedPackage)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstrumentationConfiguration)) {
            return false;
        }
        InstrumentationConfiguration that = (InstrumentationConfiguration)o;
        if (!this.classNameTranslations.equals(that.classNameTranslations)) {
            return false;
        }
        if (!this.classesToNotAcquire.equals(that.classesToNotAcquire)) {
            return false;
        }
        if (!this.instrumentedPackages.equals(that.instrumentedPackages)) {
            return false;
        }
        if (!this.instrumentedClasses.equals(that.instrumentedClasses)) {
            return false;
        }
        return this.interceptedMethods.equals(that.interceptedMethods);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = this.instrumentedPackages.hashCode();
        result = 31 * result + this.instrumentedClasses.hashCode();
        result = 31 * result + this.classNameTranslations.hashCode();
        result = 31 * result + this.interceptedMethods.hashCode();
        this.cachedHashCode = result = 31 * result + this.classesToNotAcquire.hashCode();
        return result;
    }

    public String remapParamType(String desc) {
        return this.typeMapper.remapParamType(desc);
    }

    public String remapParams(String desc) {
        return this.typeMapper.remapParams(desc);
    }

    public String mappedTypeName(String internalName) {
        return this.typeMapper.mappedTypeName(internalName);
    }

    boolean shouldIntercept(MethodInsnNode targetMethod) {
        if (targetMethod.name.equals("<init>")) {
            return false;
        }
        return this.methodsToIntercept.contains(new MethodRef(targetMethod.owner, targetMethod.name)) || this.methodsToIntercept.contains(new MethodRef(targetMethod.owner, "*"));
    }

    private static Set<MethodRef> convertToSlashes(Set<MethodRef> methodRefs) {
        HashSet<MethodRef> transformed = new HashSet<MethodRef>();
        for (MethodRef methodRef : methodRefs) {
            transformed.add(new MethodRef(InstrumentationConfiguration.internalize(methodRef.className), methodRef.methodName));
        }
        return transformed;
    }

    private static String internalize(String className) {
        return className.replace('.', '/');
    }

    public static final class Builder {
        public final Collection<String> instrumentedPackages = new HashSet<String>();
        public final Collection<MethodRef> interceptedMethods = new HashSet<MethodRef>();
        public final Map<String, String> classNameTranslations = new HashMap<String, String>();
        public final Collection<String> classesToNotAcquire = new HashSet<String>();
        public final Collection<String> packagesToNotAcquire = new HashSet<String>();
        public final Collection<String> instrumentedClasses = new HashSet<String>();
        public final Collection<String> classesToNotInstrument = new HashSet<String>();
        public final Collection<String> packagesToNotInstrument = new HashSet<String>();
        public String classesToNotInstrumentRegex;

        public Builder() {
        }

        public Builder(InstrumentationConfiguration classLoaderConfig) {
            this.instrumentedPackages.addAll(classLoaderConfig.instrumentedPackages);
            this.interceptedMethods.addAll(classLoaderConfig.interceptedMethods);
            this.classNameTranslations.putAll(classLoaderConfig.classNameTranslations);
            this.classesToNotAcquire.addAll(classLoaderConfig.classesToNotAcquire);
            this.packagesToNotAcquire.addAll(classLoaderConfig.packagesToNotAcquire);
            this.instrumentedClasses.addAll(classLoaderConfig.instrumentedClasses);
            this.classesToNotInstrument.addAll(classLoaderConfig.classesToNotInstrument);
            this.packagesToNotInstrument.addAll(classLoaderConfig.packagesToNotInstrument);
            this.classesToNotInstrumentRegex = classLoaderConfig.classesToNotInstrumentRegex;
        }

        public Builder doNotAcquireClass(Class<?> clazz) {
            this.doNotAcquireClass(clazz.getName());
            return this;
        }

        public Builder doNotAcquireClass(String className) {
            this.classesToNotAcquire.add(className);
            return this;
        }

        public Builder doNotAcquirePackage(String packageName) {
            this.packagesToNotAcquire.add(packageName);
            return this;
        }

        public Builder addClassNameTranslation(String fromName, String toName) {
            this.classNameTranslations.put(fromName, toName);
            return this;
        }

        public Builder addInterceptedMethod(MethodRef methodReference) {
            this.interceptedMethods.add(methodReference);
            return this;
        }

        public Builder addInstrumentedClass(String name) {
            this.instrumentedClasses.add(name);
            return this;
        }

        public Builder addInstrumentedPackage(String packageName) {
            this.instrumentedPackages.add(packageName);
            return this;
        }

        public Builder doNotInstrumentClass(String className) {
            this.classesToNotInstrument.add(className);
            return this;
        }

        public Builder doNotInstrumentPackage(String packageName) {
            this.packagesToNotInstrument.add(packageName);
            return this;
        }

        public Builder setDoNotInstrumentClassRegex(String classNameRegex) {
            this.classesToNotInstrumentRegex = classNameRegex;
            return this;
        }

        public InstrumentationConfiguration build() {
            ArrayList<String> minimalPackages = new ArrayList<String>(this.instrumentedPackages);
            if (!this.instrumentedPackages.isEmpty()) {
                Collections.sort(minimalPackages);
                Iterator iterator = minimalPackages.iterator();
                String cur = (String)iterator.next();
                while (iterator.hasNext()) {
                    String element = (String)iterator.next();
                    if (element.startsWith(cur)) {
                        iterator.remove();
                        continue;
                    }
                    cur = element;
                }
            }
            List<String> minimalClasses = this.instrumentedClasses.stream().filter(className -> minimalPackages.stream().noneMatch(className::startsWith)).collect(Collectors.toList());
            return new InstrumentationConfiguration(this.classNameTranslations, this.interceptedMethods, minimalPackages, minimalClasses, this.classesToNotAcquire, this.packagesToNotAcquire, this.classesToNotInstrument, this.packagesToNotInstrument, this.classesToNotInstrumentRegex);
        }
    }
}

