/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.ResType;
import org.robolectric.res.XmlContext;
import org.robolectric.res.android.ResTable_config;

public class TypedResource<T> {
    private final T data;
    private final ResType resType;
    private final XmlContext xmlContext;

    public TypedResource(T data, ResType resType, XmlContext xmlContext) {
        this.data = data;
        this.resType = resType;
        this.xmlContext = xmlContext;
    }

    public T getData() {
        return this.data;
    }

    public ResType getResType() {
        return this.resType;
    }

    public ResTable_config getConfig() {
        return this.xmlContext.getConfig();
    }

    public XmlContext getXmlContext() {
        return this.xmlContext;
    }

    public String asString() {
        T data = this.getData();
        return data instanceof String ? (String)data : null;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isReference() {
        T data = this.getData();
        if (data instanceof String) {
            String s = (String)data;
            return !s.isEmpty() && s.charAt(0) == '@';
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        String string2 = String.valueOf(this.data);
        String string3 = String.valueOf((Object)this.resType);
        String string4 = String.valueOf(this.xmlContext);
        return new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append("{values=").append(string2).append(", resType=").append(string3).append(", xmlContext=").append(string4).append('}').toString();
    }

    public boolean isXml() {
        return false;
    }
}

