/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.Fs;
import org.robolectric.res.ResBunch;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIdGenerator;
import org.robolectric.res.ResourceIds;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.builder.XmlBlock;

public class PackageResourceTable
implements ResourceTable {
    private final ResBunch resources = new ResBunch();
    private final BiMap<Integer, ResName> resourceTable = HashBiMap.create();
    private final ResourceIdGenerator androidResourceIdGenerator = new ResourceIdGenerator(1);
    private final String packageName;
    private int packageIdentifier;

    public PackageResourceTable(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    int getPackageIdentifier() {
        return this.packageIdentifier;
    }

    @Override
    public Integer getResourceId(ResName resName) {
        Integer id = (Integer)this.resourceTable.inverse().get((Object)resName);
        if (id == null && resName != null && resName.name.contains(".")) {
            id = (Integer)this.resourceTable.inverse().get((Object)new ResName(resName.packageName, resName.type, PackageResourceTable.underscorize(resName.name)));
        }
        return id != null ? id : 0;
    }

    @Override
    public ResName getResName(int resourceId) {
        return (ResName)this.resourceTable.get((Object)resourceId);
    }

    @Override
    public TypedResource getValue(@Nonnull ResName resName, ResTable_config config) {
        return this.resources.get(resName, config);
    }

    @Override
    public TypedResource getValue(int resId, ResTable_config config) {
        return this.resources.get(this.getResName(resId), config);
    }

    @Override
    public XmlBlock getXml(ResName resName, ResTable_config config) {
        FileTypedResource fileTypedResource = this.getFileResource(resName, config);
        if (fileTypedResource == null || !fileTypedResource.isXml()) {
            return null;
        }
        return XmlBlock.create(fileTypedResource.getPath(), resName.packageName);
    }

    @Override
    public InputStream getRawValue(ResName resName, ResTable_config config) {
        FileTypedResource fileTypedResource = this.getFileResource(resName, config);
        if (fileTypedResource == null) {
            return null;
        }
        Path file = fileTypedResource.getPath();
        try {
            return file == null ? null : Fs.getInputStream(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private FileTypedResource getFileResource(ResName resName, ResTable_config config) {
        TypedResource typedResource = this.resources.get(resName, config);
        if (!(typedResource instanceof FileTypedResource)) {
            return null;
        }
        return (FileTypedResource)typedResource;
    }

    @Override
    public InputStream getRawValue(int resId, ResTable_config config) {
        return this.getRawValue(this.getResName(resId), config);
    }

    @Override
    public void receive(ResourceTable.Visitor visitor) {
        this.resources.receive(visitor);
    }

    void addResource(int resId, String type, String name) {
        if (ResourceIds.isFrameworkResource(resId)) {
            this.androidResourceIdGenerator.record(resId, type, name);
        }
        ResName resName = new ResName(this.packageName, type, name);
        int resIdPackageIdentifier = ResourceIds.getPackageIdentifier(resId);
        if (this.getPackageIdentifier() == 0) {
            this.packageIdentifier = resIdPackageIdentifier;
        } else if (this.getPackageIdentifier() != resIdPackageIdentifier) {
            String string = this.packageName;
            int n = this.getPackageIdentifier();
            throw new IllegalArgumentException(new StringBuilder(102 + String.valueOf(string).length() + String.valueOf(type).length() + String.valueOf(name).length()).append("Incompatible package for ").append(string).append(":").append(type).append("/").append(name).append(" with resId ").append(resIdPackageIdentifier).append(" to ResourceIndex with packageIdentifier ").append(n).toString());
        }
        ResName existingEntry = (ResName)this.resourceTable.put((Object)resId, (Object)resName);
        if (existingEntry != null && !existingEntry.equals(resName)) {
            String string = Integer.toHexString(resId);
            String string2 = String.valueOf(resName);
            String string3 = String.valueOf(existingEntry);
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ResId ").append(string).append(" mapped to both ").append(string2).append(" and ").append(string3).toString());
        }
    }

    void addResource(String type, String name, TypedResource value) {
        ResName existing;
        Integer id;
        ResName resName = new ResName(this.packageName, type, name);
        ResName resNameWithUnderscores = new ResName(this.packageName, type, PackageResourceTable.underscorize(name));
        Integer oldId = (Integer)this.resourceTable.inverse().get((Object)resNameWithUnderscores);
        if (oldId != null) {
            this.resourceTable.forcePut((Object)oldId, (Object)resName);
        }
        if ((id = (Integer)this.resourceTable.inverse().get((Object)resName)) == null && this.isAndroidPackage(resName) && (existing = (ResName)this.resourceTable.put((Object)(id = Integer.valueOf(this.androidResourceIdGenerator.generate(type, name))), (Object)resName)) != null) {
            String string = String.valueOf(resName);
            String string2 = String.valueOf(existing);
            throw new IllegalStateException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" assigned ID to already existing ").append(string2).toString());
        }
        this.resources.put(resName, value);
    }

    private boolean isAndroidPackage(ResName resName) {
        return "android".equals(resName.packageName);
    }

    private static String underscorize(String s) {
        return s == null ? null : s.replace('.', '_');
    }
}

