/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LocaleDataTables {
    static final byte[][] SCRIPT_CODES = new byte[][]{{65, 104, 111, 109}, {65, 114, 97, 98}, {65, 114, 109, 105}, {65, 114, 109, 110}, {65, 118, 115, 116}, {66, 97, 109, 117}, {66, 97, 115, 115}, {66, 101, 110, 103}, {66, 114, 97, 104}, {67, 97, 110, 115}, {67, 97, 114, 105}, {67, 104, 97, 109}, {67, 104, 101, 114}, {67, 111, 112, 116}, {67, 112, 114, 116}, {67, 121, 114, 108}, {68, 101, 118, 97}, {69, 103, 121, 112}, {69, 116, 104, 105}, {71, 101, 111, 114}, {71, 111, 116, 104}, {71, 114, 101, 107}, {71, 117, 106, 114}, {71, 117, 114, 117}, {72, 97, 110, 115}, {72, 97, 110, 116}, {72, 97, 116, 114}, {72, 101, 98, 114}, {72, 108, 117, 119}, {72, 109, 110, 103}, {73, 116, 97, 108}, {74, 112, 97, 110}, {75, 97, 108, 105}, {75, 97, 110, 97}, {75, 104, 97, 114}, {75, 104, 109, 114}, {75, 110, 100, 97}, {75, 111, 114, 101}, {76, 97, 110, 97}, {76, 97, 111, 111}, {76, 97, 116, 110}, {76, 101, 112, 99}, {76, 105, 110, 97}, {76, 105, 115, 117}, {76, 121, 99, 105}, {76, 121, 100, 105}, {77, 97, 110, 100}, {77, 97, 110, 105}, {77, 101, 114, 99}, {77, 108, 121, 109}, {77, 111, 110, 103}, {77, 114, 111, 111}, {77, 121, 109, 114}, {78, 97, 114, 98}, {78, 107, 111, 111}, {79, 103, 97, 109}, {79, 114, 107, 104}, {79, 114, 121, 97}, {79, 115, 103, 101}, {80, 97, 117, 99}, {80, 104, 108, 105}, {80, 104, 110, 120}, {80, 108, 114, 100}, {80, 114, 116, 105}, {82, 117, 110, 114}, {83, 97, 109, 114}, {83, 97, 114, 98}, {83, 97, 117, 114}, {83, 103, 110, 119}, {83, 105, 110, 104}, {83, 111, 114, 97}, {83, 121, 114, 99}, {84, 97, 108, 101}, {84, 97, 108, 117}, {84, 97, 109, 108}, {84, 97, 110, 103}, {84, 97, 118, 116}, {84, 101, 108, 117}, {84, 102, 110, 103}, {84, 104, 97, 97}, {84, 104, 97, 105}, {84, 105, 98, 116}, {85, 103, 97, 114}, {86, 97, 105, 105}, {88, 112, 101, 111}, {88, 115, 117, 120}, {89, 105, 105, 105}, {126, 126, 126, 65}, {126, 126, 126, 66}};
    static final Map<Integer, Byte> LIKELY_SCRIPTS;
    static final Set<Long> REPRESENTATIVE_LOCALES;
    static final Map<Integer, Integer> ARAB_PARENTS;
    static final Map<Integer, Integer> HANT_PARENTS;
    static final Map<Integer, Integer> LATN_PARENTS;
    static final Map<String, Map<Integer, Integer>> SCRIPT_PARENTS;
    static final int MAX_PARENT_DEPTH = 3;

    /*
     * Opcode count of 24224 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        Object entries = new int[][]{{0x61610000, 40}, {-1610612736, 40}, {-1476395008, 40}, {-805306368, 40}, {1633812480, 15}, {-1608515584, 40}, {-1004535808, 40}, {-870318080, 40}, {-534773760, 40}, {-1941962752, 40}, {-1874853888, 40}, {-1673527296, 40}, {-2141192192, 40}, {-1872756736, 40}, {-1537212416, 40}, {-530579456, 15}, {-463470592, 40}, {1634009088, 4}, {-2071986176, 1}, {-528482304, 40}, {0x61660000, 40}, {-2000683008, 40}, {-1933574144, 40}, {-1732247552, 40}, {-1329594368, 40}, {-1195376640, 40}, {-1061158912, 40}, {-2132803584, 40}, {-1394606080, 40}, {-1193279488, 0}, {-1725956096, 40}, {1634402304, 40}, {-1455423488, 85}, {-2124414976, 40}, {-1587544064, 40}, {-1251999744, 40}, {-849346560, 15}, {1634533376, 18}, {-1317011456, 40}, {-1249902592, 40}, {-1182793728, 40}, {-1115684864, 40}, {-1986002944, 40}, {-1449132032, 40}, {-1247805440, 40}, {-509607936, 40}, {-1514143744, 40}, {-1312817152, 40}, {-440401920, 40}, {-1981808640, 1}, {-1914699776, 1}, {-1847590912, 40}, {-975175680, 40}, {-908066816, 40}, {-438304768, 40}, {1634861056, 1}, {1634883650, 88}, {-1977614336, 2}, {-1642070016, 40}, {-1239416832, 40}, {-1172307968, 40}, {-1038090240, 1}, {-501219328, 1}, {-434110464, 1}, {1634926592, 7}, {-2109734912, 40}, {-1841299456, 68}, {-1707081728, 40}, {-1170210816, 40}, {-834666496, 40}, {-2107637760, 40}, {-1704984576, 40}, {-1503657984, 40}, {-494927872, 40}, {1635123200, 15}, {-1365245952, 1}, {-1231028224, 40}, {-828375040, 40}, {-761266176, 40}, {-2101346304, 16}, {-2034237440, 40}, {-1161822208, 40}, {-557842432, 40}, {1635319808, 40}, {-2030043136, 40}, {1635385344, 40}, {1635404113, 1}, {1635404114, 1}, {1635406421, 15}, {1650524160, 15}, {-1409220608, 1}, {-1275002880, 40}, {-1140785152, 16}, {-1006567424, 40}, {-939458560, 40}, {-738131968, 40}, {-603914240, 5}, {-2145320960, 40}, {-2078212096, 40}, {-2011103232, 40}, {-1943994368, 40}, {-1541341184, 40}, {-1138688000, 40}, {-1004470272, 40}, {-1807679488, 40}, {-1673461760, 40}, {-1606352896, 40}, {-1337917440, 40}, {-1270808576, 40}, {-1203699712, 40}, {-1069481984, 18}, {-801046528, 40}, {-1939800064, 40}, {1650786304, 15}, {-1803485184, 40}, {-1669267456, 40}, {-1535049728, 1}, {-1333723136, 40}, {-863961088, 40}, {-662634496, 40}, {-595525632, 40}, {-461307904, 40}, {-1935605760, 40}, {-1063190528, 74}, {-861863936, 1}, {-526319616, 16}, {1650917376, 15}, {-2000617472, 16}, {-1262419968, 1}, {-591331328, 21}, {-2065629184, 16}, {-1730084864, 40}, {-1595867136, 16}, {-1461649408, 40}, {-1394540544, 40}, {-1193213952, 16}, {-522125312, 40}, {1651048448, 40}, {-2063532032, 40}, {-1727987712, 40}, {-1459552256, 40}, {-1325334528, 40}, {-1258225664, 40}, {-1191116800, 40}, {-1056899072, 40}, {-1658781696, 40}, {-1591672832, 18}, {-1524563968, 16}, {-1256128512, 40}, {-1189019648, 40}, {-987693056, 40}, {-450822144, 40}, {-1992228864, 40}, {-1321140224, 40}, {-1052704768, 40}, {-784269312, 40}, {-717160448, 40}, {-849281024, 76}, {1651310592, 40}, {-1652490240, 40}, {-1451163648, 40}, {-1048510464, 40}, {-780075008, 40}, {1651376128, 7}, {-1717501952, 40}, {-1314848768, 40}, {-1113522176, 40}, {1651441664, 81}, {-1514078208, 40}, {-1312751616, 40}, {-1245642752, 40}, {-505348096, 7}, {-1979645952, 40}, {-1576992768, 1}, {-1107230720, 40}, {-704577536, 40}, {1651638272, 40}, {-2111766528, 16}, {-1642004480, 1}, {-568262656, 16}, {-434044928, 40}, {1651703808, 40}, {-1505689600, 40}, {-1035927552, 6}, {-901709824, 40}, {-834600960, 18}, {-1168048128, 40}, {-832503808, 40}, {-698286080, 16}, {-2105475072, 15}, {-1971257344, 40}, {-1904148480, 40}, {-1702821888, 40}, {-1434386432, 40}, {-1300168704, 40}, {-1165950976, 40}, {-897515520, 40}, {-763297792, 40}, {-2036269056, 40}, {-1899954176, 40}, {-960430080, 40}, {-1629421568, 40}, {-1828651008, 40}, {-1224671232, 18}, {-956235776, 40}, {-889126912, 40}, {-687800320, 40}, {-553582592, 40}, {-2094989312, 40}, {-1826553856, 40}, {-1759444992, 40}, {-1625227264, 40}, {-618594304, 40}, {1667301376, 40}, {-1274937344, 40}, {-1541275648, 40}, {-1673396224, 40}, {-1136525312, 7}, {1667563520, 15}, {-2071855104, 40}, {-2136866816, 40}, {-1732116480, 40}, {1667760128, 40}, {-1461583872, 40}, {-1327366144, 15}, {-1193148416, 40}, {-1126039552, 40}, {-991821824, 12}, {-2128478208, 1}, {-1323171840, 11}, {-719192064, 40}, {-2059272192, 1}, {-1388183552, 40}, {-1186856960, 40}, {-515768320, 40}, {-2124283904, 40}, {-1853751296, 40}, {1668218880, 40}, {-1111359488, 13}, {-907935744, 40}, {1668415488, 9}, {-1507721216, 9}, {-1440612352, 9}, {-1373503488, 9}, {-1306394624, 9}, {-903741440, 40}, {1668481024, 40}, {-2042494976, 40}, {-633208832, 9}, {-1906180096, 59}, {1668612096, 15}, {1668677632, 15}, {1668874240, 40}, {1684078592, 40}, {-1945960448, 40}, {-1811742720, 40}, {-1744633856, 40}, {-1677524992, 40}, {-1476198400, 40}, {-1006436352, 15}, {-738000896, 40}, {-1943863296, 40}, {-1071448064, 40}, {-2008875008, 1}, {-1268580352, 40}, {1684340736, 40}, {-1937571840, 40}, {-1266483200, 40}, {-2134704128, 40}, {-1664942080, 40}, {-1597833216, 40}, {-1396506624, 1}, {-993853440, 40}, {-456982528, 40}, {-2130509824, 40}, {-1859977216, 40}, {-1516044288, 40}, {-2050818048, 40}, {-1581056000, 1}, {-1111293952, 40}, {-641531904, 40}, {-1574764544, 40}, {-903675904, 18}, {-2042429440, 40}, {-1302134784, 40}, {-1100808192, 40}, {-899481600, 40}, {-496828416, 16}, {-2105344000, 40}, {-1971126272, 40}, {-1904017408, 40}, {-1702690816, 40}, {1685454848, 79}, {-2103246848, 40}, {-624754688, 40}, {-1157431296, 40}, {-754778112, 40}, {1685716992, 81}, {-1692205056, 40}, {-802947072, 40}, {0x65650000, 40}, {-1599864832, 40}, {-1396441088, 40}, {-524025856, 17}, {-515637248, 32}, {1701576704, 21}, {-2122055680, 40}, {-1585184768, 40}, {1701707776, 40}, {1701730369, 87}, {-1247543296, 40}, {-1046216704, 40}, {1701773312, 40}, {-1574699008, 40}, {1702035456, 40}, {-767295488, 40}, {1702100992, 40}, {-966524928, 40}, {-832307200, 30}, {-765198336, 40}, {-563871744, 40}, {1702166528, 40}, {-1161560064, 40}, {-823918592, 40}, {0x66610000, 1}, {-2147155968, 40}, {-2080047104, 40}, {-1744502784, 40}, {-1610285056, 40}, {-1274740736, 40}, {0x66660000, 40}, {-1599799296, 40}, {-1331363840, 40}, {0x66690000, 40}, {-2130378752, 1}, {-1392181248, 40}, {-855310336, 40}, {0x666A0000, 40}, {-983236608, 40}, {-1115357184, 40}, {0x666F0000, 40}, {-1916469248, 40}, {-1245380608, 40}, {-976945152, 40}, {-1847263232, 40}, {-905641984, 40}, {1718747136, 40}, {-1977286656, 40}, {-1104871424, 40}, {-970653696, 40}, {-903544832, 40}, {-2038104064, 1}, {-1903886336, 40}, {-1836777472, 40}, {-1769668608, 40}, {-1635450880, 40}, {-1031471104, 40}, {-964362240, 40}, {-695926784, 40}, {-494600192, 40}, {-962265088, 40}, {1719205888, 40}, {1734410240, 40}, {-2147090432, 40}, {-1811546112, 40}, {-1744437248, 40}, {-1677328384, 40}, {-1543110656, 40}, {-1341784064, 40}, {-1274675200, 24}, {-670695424, 40}, {-536477696, 40}, {-1809448960, 40}, {-1339686912, 16}, {-534380544, 40}, {-467271680, 1}, {-1002045440, 40}, {1734606848, 40}, {-1872363520, 40}, {-1268383744, 40}, {-999948288, 40}, {-2071592960, 40}, {-1534722048, 40}, {-1400504320, 40}, {-460980224, 18}, {-1465516032, 40}, {-1262092288, 16}, {-924450816, 40}, {-1392115712, 40}, {-1325006848, 40}, {-1457127424, 1}, {-1255800832, 40}, {-786038784, 1}, {-1253703680, 40}, {-1119485952, 40}, {1735131136, 40}, {-1452933120, 1}, {-1316618240, 40}, {-712638464, 18}, {1735262208, 40}, {-1918500864, 40}, {-1717174272, 40}, {-1916403712, 40}, {-1782185984, 18}, {-1580859392, 40}, {-1312423936, 16}, {-1245315072, 77}, {-976879616, 40}, {-909770752, 40}, {-842661888, 20}, {-1977221120, 14}, {-836370432, 7}, {-635043840, 40}, {-632946688, 40}, {1735720960, 22}, {-2038038528, 40}, {-1970929664, 40}, {-1903820800, 40}, {-964296704, 40}, {-628752384, 40}, {-561643520, 40}, {-427425792, 40}, {0x67760000, 40}, {-1767505920, 40}, {-962199552, 16}, {-895090688, 40}, {-1966735360, 1}, {-1564082176, 40}, {-825884672, 1}, {-1559887872, 40}, {1751187456, 40}, {1751204685, 1}, {1751208772, 1}, {-1744371712, 40}, {-1475936256, 24}, {-1341718528, 40}, {-670629888, 40}, {-469303296, 1}, {-2077818880, 40}, {-530120704, 18}, {1751449600, 27}, {-521732096, 40}, {1751711744, 16}, {-2130247680, 40}, {-1794703360, 40}, {-1727594496, 40}, {-1660485632, 40}, {-1392050176, 40}, {-2123956224, 40}, {-781778944, 28}, {-1920532480, 62}, {-846790656, 40}, {-1918435328, 1}, {-1851326464, 16}, {-1515782144, 29}, {-1247346688, 40}, {-1180237824, 1}, {1752104960, 40}, {-1983447040, 16}, {-1513684992, 16}, {-842596352, 40}, {1752301568, 40}, {-2042167296, 40}, {-1236860928, 24}, {1752432640, 40}, {1752498176, 40}, {-1568210944, 40}, {1752760320, 3}, {1752825856, 40}, {1767964672, 40}, {-1274544128, 40}, {-1006108672, 40}, {-2144862208, 40}, {-2077753344, 40}, {-534249472, 40}, {-2142765056, 40}, {-1673003008, 40}, {1768161280, 40}, {-1939341312, 40}, {-1603796992, 40}, {-798490624, 40}, {1768357888, 40}, {-2067267584, 40}, {-1865940992, 40}, {0x69690000, 86}, {-1524105216, 40}, {1768620032, 40}, {-1454899200, 40}, {-850919424, 40}, {-649592832, 40}, {-582483968, 40}, {-1184366592, 40}, {-1182269440, 40}, {1768816640, 40}, {-1649934336, 15}, {-775421952, 40}, {-1574436864, 40}, {1769144320, 40}, {1769209856, 40}, {1769275392, 9}, {1769406464, 27}, {-1295515648, 40}, {-892862464, 40}, {-1624768512, 40}, {-1557659648, 40}, {1784741888, 31}, {-2079784960, 40}, {-1341587456, 40}, {-802619392, 40}, {-1266089984, 40}, {-1463222272, 40}, {-1194786816, 40}, {1785266176, 27}, {-2063007744, 40}, {-1987510272, 40}, {-1383530496, 16}, {-2111242240, 40}, {-829882368, 40}, {1786118144, 40}, {1786183680, 40}, {1801519104, 19}, {-2146828288, 15}, {-2079719424, 40}, {-2012610560, 40}, {-1945501696, 40}, {-1609957376, 40}, {-1542848512, 40}, {-1341521920, 40}, {-1207304192, 40}, {-1943404544, 15}, {-1339424768, 40}, {-1138098176, 40}, {-1070989312, 40}, {-601227264, 40}, {-534118400, 1}, {-1739980800, 40}, {-1471545344, 40}, {-1404436480, 40}, {-867565568, 40}, {-1872101376, 40}, {-1670774784, 1}, {-1402339328, 40}, {-865468416, 80}, {-2138439680, 40}, {-1266024448, 40}, {-460718080, 40}, {-1196818432, 40}, {-995491840, 16}, {-525729792, 16}, {1801912320, 40}, {-1865809920, 40}, {-1798701056, 40}, {-1127612416, 40}, {-2132148224, 40}, {-2065039360, 73}, {-1259732992, 16}, {-1058406400, 40}, {-924188672, 40}, {-857079808, 52}, {-655753216, 1}, {-454426624, 40}, {1802043392, 40}, {-1526071296, 40}, {-787873792, 40}, {-653656064, 40}, {1802108928, 40}, {-1926627328, 40}, {-1725300736, 39}, {-919994368, 40}, {-517341184, 40}, {0x6B6B0000, 15}, {1802191174, 1}, {1802191694, 1}, {1802193234, 1}, {1802194254, 1}, {-1991639040, 40}, {-1521876992, 40}, {1802240000, 40}, {-1251344384, 40}, {-1050017792, 40}, {-848691200, 40}, {-580255744, 40}, {1802305536, 35}, {-2054553600, 40}, {-1651900416, 40}, {-1182138368, 40}, {-913702912, 40}, {-779485184, 40}, {-645267456, 40}, {1802371072, 36}, {-1112932352, 40}, {1802436608, 37}, {-1580597248, 15}, {-1446379520, 16}, {-1379270656, 40}, {-909508608, 40}, {-439746560, 40}, {-1846935552, 40}, {-1779826688, 40}, {-1175846912, 40}, {-974520320, 40}, {-571867136, 40}, {-2046164992, 40}, {-1777729536, 40}, {-905314304, 40}, {-502661120, 18}, {-1976958976, 15}, {-1574305792, 40}, {-1507196928, 40}, {-1372979200, 40}, {-903217152, 40}, {-768999424, 16}, {1802698752, 1}, {-2041970688, 40}, {-1907752960, 40}, {-1773535232, 40}, {-1639317504, 40}, {-1505099776, 40}, {-968228864, 40}, {-2039873536, 18}, {-1301676032, 40}, {-1167458304, 40}, {1802829824, 40}, {1802848594, 1}, {1802849346, 1}, {-2037776384, 40}, {-1903558656, 40}, {-1836449792, 40}, {-1500905472, 40}, {-1299578880, 15}, {-1232470016, 40}, {-1098252288, 40}, {-896925696, 40}, {1802895360, 15}, {-1700134912, 40}, {-961937408, 40}, {-559284224, 1}, {1802960896, 40}, {-1496711168, 40}, {-1161166848, 40}, {-2098593792, 40}, {-1964376064, 18}, {-1293287424, 80}, {-1091960832, 1}, {-622198784, 40}, {-420872192, 40}, {1803091968, 15}, {1803109198, 1}, {1803113554, 40}, {-1828061184, 40}, {-552992768, 40}, {-953548800, 40}, {1818296320, 40}, {-2079653888, 42}, {-1945436160, 27}, {-1744109568, 40}, {-1677000704, 1}, {-1542782976, 40}, {-938803200, 40}, {1818361856, 40}, {-1876230144, 15}, {-802488320, 40}, {-668270592, 40}, {-1337262080, 40}, {-1135935488, 80}, {-2073362432, 40}, {-1937047552, 40}, {-1869938688, 40}, {-1333067776, 40}, {-1131741184, 41}, {-1064632320, 40}, {-796196864, 40}, {-460652544, 15}, {1818689536, 40}, {-1731526656, 40}, {1818820608, 40}, {-2129985536, 40}, {-1928658944, 40}, {-1794441216, 16}, {-1727332352, 40}, {-1660223488, 40}, {-1526005760, 40}, {-922025984, 43}, {-1121255424, 40}, {-1588920320, 1}, {-850722816, 40}, {-1855258624, 40}, {-1251278848, 40}, {-1249181696, 77}, {-1182072832, 40}, {-1114963968, 40}, {1819148288, 40}, {-911540224, 40}, {-777322496, 40}, {1819213824, 39}, {-1513422848, 40}, {-1446313984, 40}, {-1379205120, 40}, {-976551936, 40}, {-909443072, 40}, {-439681024, 40}, {-1976893440, 1}, {1819541504, 40}, {-1704263680, 40}, {1819607040, 40}, {-2104819712, 40}, {-1165295616, 40}, {-494206976, 40}, {-427098112, 1}, {1819672576, 40}, {-1362427904, 80}, {-1624571904, 24}, {-416612352, 40}, {-1945370624, 40}, {-1811152896, 40}, {-1744044032, 16}, {-1609826304, 16}, {-1475608576, 40}, {-1274281984, 40}, {-1274263730, 54}, {-938737664, 40}, {-670302208, 40}, {-468975616, 40}, {-1674838016, 40}, {-1205075968, 40}, {-1070858240, 40}, {-802422784, 40}, {-668205056, 40}, {-1605632000, 40}, {-1135869952, 40}, {-1068761088, 40}, {-1001652224, 40}, {-800325632, 40}, {-2140405760, 40}, {-1871970304, 1}, {-1804861440, 15}, {-1670643712, 40}, {-1536425984, 40}, {-999555072, 40}, {-596901888, 18}, {-1936982016, 40}, {-1869873152, 40}, {-1467219968, 40}, {-1265893376, 40}, {-997457920, 40}, {-863240192, 40}, {-796131328, 40}, {-2136211456, 1}, {-1867776000, 40}, {-1263796224, 40}, {-1196687360, 40}, {-1062469632, 40}, {1835466752, 40}, {-1664352256, 40}, {-1395916800, 40}, {-1194590208, 40}, {-1127481344, 16}, {-523501568, 40}, {1835532288, 40}, {-1595146240, 40}, {-1393819648, 40}, {1835597824, 40}, {-1794375680, 40}, {-1257504768, 40}, {-921960448, 26}, {-653524992, 40}, {1835728896, 15}, {-1588854784, 1}, {-1387528192, 40}, {-1119092736, 40}, {-649330688, 40}, {1835794432, 49}, {-1855193088, 40}, {-1116995584, 40}, {-915668992, 40}, {-1182007296, 40}, {-779354112, 40}, {-578027520, 40}, {1835925504, 15}, {1835942734, 50}, {-2119434240, 40}, {-1783889920, 40}, {-1582563328, 7}, {-643039232, 52}, {-2117337088, 40}, {-1848901632, 40}, {-1647575040, 40}, {-909377536, 40}, {-573833216, 40}, {-1108606976, 40}, {-907280384, 40}, {-840171520, 40}, {-571736064, 40}, {-1374945280, 40}, {1836187648, 16}, {-1909719040, 16}, {-1507065856, 15}, {-1171521536, 51}, {1836253184, 40}, {1836270403, 1}, {1836271940, 1}, {1836318720, 40}, {-1972633600, 40}, {-1771307008, 40}, {-1569980416, 40}, {-966000640, 16}, {-2104754176, 40}, {-963903488, 40}, {-896794624, 40}, {-2102657024, 40}, {-1230241792, 40}, {-492044288, 1}, {-1429471232, 40}, {-959709184, 16}, {-691273728, 40}, {-1964244992, 40}, {-1293156352, 40}, {1836646400, 52}, {-1425276928, 40}, {-1291059200, 18}, {-687079424, 15}, {-619970560, 40}, {-552861696, 40}, {-418643968, 46}, {-1423179776, 40}, {-1288962048, 40}, {-1221853184, 1}, {-1087635456, 40}, {-617873408, 40}, {-416546816, 40}, {1851850752, 40}, {-2012413952, 40}, {-1811087360, 40}, {-1475543040, 40}, {-1274216448, 24}, {-1139998720, 40}, {-1072889856, 40}, {-938672128, 40}, {1851916288, 40}, {-2142437376, 40}, {-1874001920, 40}, {-1806893056, 40}, {-1672675328, 40}, {-1202913280, 40}, {-800260096, 40}, {1852047360, 40}, {-2006122496, 40}, {-932380672, 40}, {1852112896, 16}, {-2071134208, 40}, {-661848064, 16}, {-594739200, 40}, {-995295232, 40}, {1852243968, 40}, {-2134048768, 40}, {-2066939904, 40}, {-1395851264, 40}, {-2064842752, 40}, {-1863516160, 40}, {-655556608, 40}, {-1794310144, 40}, {-1592983552, 40}, {-1525874688, 40}, {-1257439232, 40}, {-787677184, 40}, {-519241728, 40}, {-452132864, 40}, {-1188233216, 40}, {-1723006976, 40}, {-1186136064, 40}, {1852571648, 40}, {-1718812672, 40}, {-443744256, 40}, {0x6E6E0000, 40}, {-1783824384, 40}, {-1649606656, 40}, {-1448280064, 40}, {-1314062336, 40}, {1852768256, 40}, {-1915944960, 38}, {-1848836096, 16}, {-1244856320, 64}, {-1110638592, 40}, {-775094272, 40}, {-1173553152, 54}, {1852964864, 40}, {-2043871232, 40}, {-1437794304, 9}, {-1236467712, 40}, {-1169358848, 40}, {-900923392, 40}, {-1301479424, 40}, {-965935104, 40}, {-1567817728, 40}, {-1098055680, 40}, {-896729088, 40}, {-695402496, 40}, {-561184768, 40}, {1853227008, 40}, {-2033385472, 40}, {-1024655360, 40}, {-957546496, 40}, {1853423616, 40}, {-1290993664, 40}, {-1223884800, 40}, {-1557331968, 40}, {1868759040, 40}, {-1999765504, 40}, {-984743936, 40}, {-716308480, 40}, {1869414400, 40}, {-1716649984, 40}, {-1246887936, 40}, {-911343616, 40}, {-1309802496, 40}, {1869742080, 57}, {-1171390464, 40}, {-768737280, 1}, {1869807616, 15}, {-2108817408, 58}, {-2106720256, 1}, {-1435631616, 56}, {-1288830976, 40}, {1885405184, 23}, {1885425739, 1}, {-1743847424, 40}, {-1408303104, 60}, {-1341194240, 40}, {-1139867648, 40}, {-804323328, 40}, {-1607532544, 40}, {-1940979712, 40}, {-1336999936, 40}, {-2005991424, 40}, {-865140736, 40}, {-1936785408, 40}, {-1198587904, 84}, {-594608128, 40}, {-1397817344, 40}, {-1393623040, 1}, {-1259405312, 61}, {-1391525888, 40}, {-1123090432, 40}, {-2125529088, 8}, {-1186004992, 40}, {1886126080, 40}, {-2123431936, 40}, {-913375232, 40}, {-1716584448, 40}, {-1246822400, 40}, {-844169216, 21}, {-1244725248, 40}, {-1175519232, 40}, {-2110849024, 34}, {-1909522432, 1}, {-1708195840, 40}, {0x70730000, 1}, {-900792320, 40}, {0x70740000, 40}, {-1100021760, 40}, {-762380288, 40}, {-2100363264, 40}, {1903493120, 40}, {-1970274304, 40}, {-1701838848, 40}, {-1609498624, 40}, {-1542389760, 16}, {-1206845440, 40}, {-1806630912, 40}, {-1534001152, 40}, {-1399783424, 40}, {-930021376, 40}, {-1261371392, 40}, {-1729036288, 1}, {-2129592320, 40}, {-1794048000, 78}, {-1794027956, 40}, {-919535616, 16}, {-850329600, 7}, {1919746048, 40}, {-1785659392, 40}, {-1181679616, 40}, {-846135296, 1}, {-779026432, 40}, {1919811584, 40}, {-2119106560, 40}, {-1716453376, 40}, {1919877120, 40}, {-2049900544, 40}, {-1781465088, 40}, {-1177485312, 40}, {-1171193856, 40}, {-1301217280, 40}, {1920270336, 15}, {-1835991040, 15}, {-1701773312, 40}, {0x72770000, 40}, {-1429143552, 40}, {-1160708096, 40}, {-753860608, 33}, {1935736832, 16}, {-1810759680, 40}, {-1676541952, 15}, {-1072562176, 40}, {-938344448, 40}, {-871235584, 40}, {-468582400, 67}, {-2144206848, 40}, {-1875771392, 40}, {-1137573888, 40}, {1935867904, 40}, {-1471021056, 16}, {-1403912192, 1}, {-1269694464, 40}, {-1202585600, 40}, {-934150144, 40}, {1935933440, 1}, {-2005794816, 40}, {-1670250496, 1}, {1935998976, 40}, {-1802371072, 40}, {-1668153344, 40}, {-1601044480, 40}, {-929955840, 40}, {1936130048, 40}, {-2133721088, 55}, {-925761536, 40}, {-657326080, 18}, {-455999488, 40}, {1936195584, 40}, {-1594753024, 78}, {-1460535296, 40}, {-1259208704, 52}, {-789446656, 1}, {1936261120, 69}, {-1928200192, 40}, {-1726873600, 40}, {-1391329280, 40}, {-1324220416, 40}, {-986578944, 40}, {1936392192, 40}, {-1991114752, 40}, {-984481792, 1}, {-917372928, 40}, {1936457728, 40}, {-1921908736, 40}, {-1586364416, 40}, {-1385037824, 40}, {-512622592, 40}, {1936523264, 40}, {-2121138176, 40}, {-1517158400, 40}, {-1248722944, 40}, {-1114505216, 65}, {-1047396352, 40}, {-913178624, 40}, {1936588800, 40}, {-1984823296, 40}, {-1447952384, 40}, {-1112408064, 40}, {-575537152, 40}, {-508428288, 40}, {1936654336, 40}, {-1445855232, 40}, {-1043202048, 40}, {-774766592, 80}, {-506331136, 40}, {-1913520128, 40}, {-1376649216, 40}, {-906887168, 40}, {1936785408, 40}, {1936850944, 15}, {1936870725, 40}, {1936872015, 40}, {1936872021, 40}, {1936872530, 40}, {-2043543552, 70}, {-1238237184, 40}, {-969801728, 40}, {-567148544, 16}, {0x73730000, 40}, {-1907228672, 40}, {-1705902080, 40}, {-497942528, 40}, {1936982016, 40}, {-1435369472, 40}, {-1032716288, 40}, {1937047552, 40}, {-2104360960, 40}, {-1835925504, 40}, {-1433272320, 40}, {-963510272, 40}, {-896401408, 40}, {1937113088, 40}, {0x73770000, 40}, {-2033057792, 1}, {-1965948928, 40}, {-1697513472, 40}, {-1093533696, 40}, {-690880512, 16}, {-1225654272, 40}, {-621674496, 40}, {-1357774848, 7}, {-955121664, 71}, {-1355677696, 40}, {1952514048, 74}, {-1542258688, 16}, {-1408040960, 40}, {-1273823232, 40}, {-1072496640, 40}, {-2009923584, 40}, {-1942814720, 40}, {-1808596992, 40}, {-1741488128, 40}, {-1204617216, 40}, {-667746304, 40}, {-466419712, 40}, {-1605173248, 40}, {-531431424, 36}, {-1938620416, 72}, {-1737293824, 16}, {-1670184960, 16}, {1952776192, 77}, {-1936523264, 40}, {-1332543488, 40}, {-1198325760, 40}, {-862781440, 40}, {-1598881792, 40}, {1952907264, 15}, {1952927819, 1}, {-1999437824, 40}, {-1194131456, 40}, {-791478272, 40}, {1952972800, 80}, {-1393360896, 16}, {-1057816576, 16}, {-990707712, 16}, {1953038336, 18}, {-1793916928, 40}, {-1726808064, 18}, {-1458372608, 40}, {-1324154880, 40}, {-1189937152, 40}, {-720175104, 40}, {1953169408, 40}, {-1387069440, 40}, {-984416256, 40}, {-850198528, 16}, {1953234944, 40}, {-1787625472, 40}, {-579665920, 40}, {-512557056, 40}, {-1651310592, 40}, {-510459904, 40}, {1953366016, 40}, {-1649213440, 40}, {1953431552, 40}, {-1781334016, 40}, {-1714225152, 40}, {-1043136512, 40}, {-1577910272, 40}, {-1309474816, 40}, {-437059584, 40}, {-1173159936, 40}, {1953628160, 40}, {-768409600, 40}, {-701300736, 40}, {-634191872, 1}, {1953693696, 40}, {-1907163136, 21}, {-1772945408, 16}, {-1705836544, 40}, {-1504509952, 81}, {-632094720, 40}, {0x74740000, 15}, {-1905065984, 40}, {-1837957120, 40}, {-1502412800, 40}, {-965541888, 40}, {-898433024, 80}, {-831324160, 40}, {-1634533376, 40}, {-1366097920, 40}, {-1298989056, 40}, {-1030553600, 40}, {-1900871680, 40}, {-1364000768, 40}, {-760020992, 40}, {-1630339072, 40}, {-1026359296, 40}, {-1695350784, 75}, {1954086912, 40}, {-2095906816, 40}, {-686620672, 15}, {-1288503296, 40}, {-801898496, 40}, {-1334575104, 15}, {1969684480, 1}, {1969703770, 15}, {1969704270, 15}, {-2133590016, 82}, {1969946624, 15}, {-1586233344, 40}, {-2053898240, 40}, {-978059264, 7}, {-978039216, 16}, {-575406080, 7}, {1970405376, 1}, {-1573650432, 40}, {-835452928, 40}, {-634126336, 40}, {-2108424192, 40}, {-965476352, 40}, {-1632370688, 40}, {-1363935232, 40}, {1970929664, 40}, {1970946374, 1}, {1970946894, 15}, {-1743454208, 40}, {-1609236480, 83}, {-1273692160, 40}, {1986330624, 40}, {-2003501056, 40}, {-1131085824, 40}, {1986592768, 40}, {-1995112448, 40}, {-720044032, 40}, {-915079168, 40}, {-1785397248, 40}, {-644546560, 40}, {1986985984, 40}, {-841678848, 40}, {-1170931712, 40}, {-1231749120, 40}, {-829095936, 40}, {2002845696, 40}, {-1877606400, 40}, {-1542062080, 40}, {-1407844352, 18}, {-1273626624, 40}, {-1005191168, 40}, {-1137311744, 40}, {-1070202880, 77}, {-1003094016, 16}, {-1604976640, 40}, {-996802560, 40}, {-1596588032, 40}, {-1728708608, 40}, {-2062155776, 40}, {-787087360, 40}, {-719978496, 40}, {-2127167488, 40}, {-1590296576, 40}, {-915013632, 40}, {-1181351936, 40}, {-1984561152, 40}, {-1581907968, 1}, {-776601600, 40}, {2003763200, 40}, {-2049572864, 40}, {-908722176, 40}, {-902430720, 40}, {-1437204480, 40}, {-1300889600, 16}, {-761921536, 24}, {-694812672, 40}, {-2099904512, 40}, {-736690176, 40}, {-1607008256, 40}, {-1000931328, 10}, {-929628160, 40}, {2020081664, 40}, {-2122907648, 40}, {-1988689920, 44}, {-1921581056, 45}, {-1785266176, 19}, {-1248395264, 47}, {-979959808, 48}, {-2118713344, 53}, {-977862656, 16}, {-1713963008, 40}, {-1244200960, 40}, {-973668352, 63}, {-2043215872, 40}, {-2108227584, 66}, {-1571356672, 40}, {-1302921216, 40}, {-967376896, 16}, {-1831403520, 40}, {-1340604416, 40}, {-1206386688, 40}, {-1139277824, 40}, {-937951232, 40}, {-870842368, 40}, {-736624640, 40}, {-535298048, 40}, {-468189184, 40}, {-2143813632, 40}, {-2076704768, 40}, {-533200896, 40}, {-996671488, 40}, {-992477184, 40}, {-656932864, 40}, {2036924416, 27}, {-1185415168, 40}, {-1854406656, 40}, {-1720188928, 40}, {-1384644608, 40}, {-1382547456, 40}, {2037317632, 40}, {-1244135424, 40}, {-2043150336, 40}, {-1841823744, 40}, {-1372061696, 40}, {-900202496, 40}, {-2103967744, 40}, {-1835532288, 25}, {-1835515058, 24}, {-1499987968, 40}, {-828899328, 40}, {-627572736, 40}, {2053177344, 40}, {-1743192064, 40}, {-1535574016, 1}, {-2137456640, 40}, {-1663500288, 78}, {2053636096, 24}, {2053652821, 25}, {2053653070, 25}, {2053654338, 25}, {2053654342, 25}, {2053654603, 25}, {2053654852, 25}, {2053655887, 25}, {2053655897, 25}, {2053656641, 25}, {2053656646, 25}, {2053656648, 25}, {2053657426, 25}, {2053657672, 25}, {2053657687, 25}, {2053657939, 25}, {2053658190, 25}, {-2129068032, 40}, {-1317470208, 40}, {-1583808512, 40}, {-1850146816, 40}, {2054488064, 40}, {-2093416448, 40}};
        HashMap<Integer, Number> buildMap = new HashMap<Integer, Number>();
        for (int[] entry : entries) {
            buildMap.put(entry[0], (byte)entry[1]);
        }
        LIKELY_SCRIPTS = Collections.unmodifiableMap(buildMap);
        entries = new long[]{7016965922780968046L, 7017249532207002220L, -4314370067176262546L, -8052355576050387858L, -7187651240570817426L, -9196272063245880210L, -2278730885291740564L, 7018096211961213812L, -8899020168601902750L, 7018396305804325998L, -4557568823625943954L, -5125015775493984403L, 7019782820031722606L, -6250915669065108104L, -5377200874653125522L, -3647825172012371348L, 7020343622385297513L, -5079974311542819730L, -1891431285807549330L, -8223480254561099422L, 7021750941367034210L, -8493708279586591383L, -8493707192742813324L, -8493697254154998675L, -5323180764573895570L, -5034951475048909714L, -4458488476661030558L, -2152635679216869022L, -1864414073388375710L, 7022036844470955623L, -9061149703464192914L, -7908227129292657033L, -3584789079320857490L, -6458087917915900818L, 7022891195088597612L, -9025133052746697119L, 7023718002212303982L, 7024007186471870818L, 7023998424922027118L, 7089037814615601772L, -6052468140058451614L, -5476015114217753490L, -4899548812950538655L, -4323102336984451986L, -4034869791874255762L, -2593717911283470987L, -8637542052631841682L, -6619935977984920466L, -6899159172061760402L, 7090146139516269164L, -6592896826872798878L, -5728197962998123410L, -2845912931833383826L, -1981209614261062546L, -8313289437876226962L, -4566287946405024404L, -3701589134571052702L, -2260444937459501471L, 7090709012160279148L, -8592506013542418847L, -5421964192226582174L, -2539656002497518229L, -8871729190439389599L, -6854116557377407391L, -6277648134128438162L, -5124734300467136927L, 7091294012625220718L, -6268640934873697170L, -5403952009736784786L, -6547871782716213663L, -5394950320925084562L, -5674180056237116306L, -3368322774847097746L, -3647539328770279820L, 7092409978272707694L, -4503233162299476882L, 7092679324094262887L, 7092961941834523252L, -2170372944945648025L, -6773051746954354334L, -3026063492523133842L, 7093809682344670318L, -9069887574043691423L, -7052267257334701726L, -2440588922554321311L, 7094086686260425838L, -4449191040680627341L, -3872740205288917906L, -5016640238464699282L, -2999027592651770271L, -9042856050625514900L, -8466387605886241682L, -7313483762184915858L, -5584108063689706386L, -8745630586877414290L, -5259846670137137047L, -2954005881305336722L, -7844904085808384914L, 7161081106561856622L, -7187095987198790546L, -4881258445645975961L, -4881266185160529043L, 7162221308560372332L, -8898461642281356178L, -7439289869750143890L, 7163053639012021358L, -6277377632793168786L, -5700903652139896212L, -5124439609742101394L, -4836229102109100946L, -4259748481437506190L, -9141661519900941982L, -5682884885649792659L, -8844426104863039134L, 7165022851452466286L, -4773176482682933132L, -3899466055900105618L, 7165863904682274419L, -6475539366622957965L, -6187308990471246221L, -5899078614319534477L, -5610848238167822733L, -3881448380330576786L, 7166145487184163950L, -8772360835535113106L, -2719537277395964301L, -8186896178149755549L, 7166724908187742828L, 7166707255938408807L, 7167006383164453484L, 7167838632011723886L, 7233137566728418414L, -6340130034155424658L, -4322520691187813780L, -3169606951732415378L, -8627971860657446558L, 7234263440865457262L, -5439429977200036754L, -4268494074083707794L, -7988455254483962770L, -6511286654154476434L, -6790503212690284190L, -8772092584762706834L, -5592541322169715602L, -4727850137880005522L, -2133775691791632799L, -9042309627556826002L, 7239058484223304033L, -4971037967932885906L, -3241674437080026002L, 7240172280912372340L, -3448548653652675474L, 7306324346323170414L, -6871281063329434514L, -5997588177343122322L, -2250597741369001616L, -2214560122386944919L, 7308294714027042155L, 7308857595343762542L, 7308873061520995438L, 7308857595461656951L, 7310262844218504302L, 7310271661786362990L, 7310280436404548718L, -3295415211076258706L, 7310544259065672814L, -3574651577866886804L, 7310825794171925614L, -4988788487946668946L, -3538627183140309906L, 7377258282243744098L, -5474891357499591570L, 7378663440923257965L, 7378676635247146094L, -5718079161782668178L, 7379506745051280494L, -9149815515312397982L, -5979284658815142802L, -3673438363951467410L, 7379788224322958446L, 7381195620681348206L, -5348796095556127634L, 7382040058496382062L, -8492287706085100434L, -4745309313082231698L, -4168850815636638610L, -3880620439484926866L, -8753516301635133086L, -8177033588980485010L, -7600590394503367570L, -4430048598907849618L, -4141823655889767314L, -2988896709559356306L, -4132805530238225298L, 7384019153656575086L, 7449315820630537326L, -9221604811149839250L, -7492215974349671314L, -5474614293521404301L, -2304073601665371026L, -5753830873415453087L, -2006835966312816286L, -4303674026651192210L, 7450158033652511854L, -1979818757937928087L, -5420558994841962911L, -5979008677101603730L, -6258226348033941150L, -3375922586516823710L, 7452407707457385582L, -6240219616041082526L, 7452982777808516206L, -5636737283103820191L, -5348506906683675531L, -4195585445160979346L, -3907349537091390354L, -3619111511685893016L, -8492025996697898380L, -8492021628565623198L, -3592103052311171481L, -2718411347273354130L, 7454945358736878194L, -8753235904511773586L, -8465004441733335954L, -4141544431475919762L, -1835697037100616594L, 7455226829501199470L, -4132529501414001055L, -6717607846443125650L, 7521378920816538734L, -6339023946999828877L, -2880239620428041106L, -2015570538223476382L, 7522499344573227634L, 7523625253002901089L, -7708114952298335122L, -5978721708861721490L, -3357622284802296457L, -8248550188869979548L, -8239528709100248734L, -7951306016595544479L, -6510150893069046169L, -5357224960284593042L, -5068994571431419550L, 7525321769513743470L, -8518759569644226975L, -6501146936582244767L, 7526157445595493486L, -8770966684855864210L, -5312203231959355789L, 7526720404138849390L, 7527001883410527342L, 7528120052192800110L, 7528415769464501358L, 7593427766006084718L, -9212027991857466258L, -8923796593503538066L, 7594275429341557870L, 7595125364714730606L, 7595676250323642729L, 7596259012742575214L, -3654597149877767058L, -5086727507665652626L, 7597090179108664430L, -7086323487509745044L, 7598497618416727150L, 7598779097688405102L, 7599053893839974003L, 7599623488191947378L, -6978237096303430546L, 7665489749468012910L, -5761992552389446546L, -5131496301138971538L, -8536198871898819474L, -5942132126686808479L, -3564242539892345746L, 7671399572960277614L, 7671681047936988270L, 7737543997675368306L, -9220463440920219028L, -8932251756316756882L, -8644011540394970002L, -6626397833591163794L, -5761710012260846482L, -5185247030869396370L, -8346768433220062612L, -2293935000834121374L, -7473074563536817042L, -6320139796070960018L, -8040521437911354258L, -7175830391244037790L, -3717065872810417815L, -9184454452141001618L, -5437459600823454610L, -5140222042596871058L, -4275524295731087775L, -2257911662669105567L, 7739228445277779054L, -8013512029264317330L, -4842985528047340434L, -9157426291666750354L, -8869202512450589579L, -5410431401828452767L, -4545735883782785938L, -3681049144765878926L, -2816350332816039582L, 7739800195619189870L, -3383799457569999762L, 7740084951950914670L, -7410026393546690705L, 7740354387950854498L, 7740363235617501804L, -6536337909901855634L, 7740640252567581806L, -5374400444306983826L, 7740926108394614130L, -8824168711039388562L, 7741205410118263905L, 7741489101298168421L, -6788522962149870996L, -6212072135500401055L, -3906232428982602642L, -7932443877307222930L, -8490883621295918484L, -6761500303379303314L, -6473273242942344082L, -5896810235781090194L, -3302746776219060639L, 7742612784834306402L, -8770104577545374610L, -7617201820470774674L, -7040740003015461778L, 7743175747672629602L, 7743187846778942574L, -5581558262014578068L, 7743467135467876972L, -4131409150470949778L, -2402019167097953950L, 7743736434361726062L, -5554534520777580183L, -4689847777802165918L, 7744295037624803682L, 7744303803687072364L, 7744313746685785198L, 7809618067291468910L, -8931967017164378527L, -8355504091674877326L, -7490800808395443090L, -7202574894898192030L, -6626108662033058706L, 7809888633051247726L, -8058256582091640212L, -2870119779830500242L, -4878731767623163543L, -4860710772178325405L, -1978397085141470612L, 7811305843409908846L, 7811861118256772206L, -7706980230662621599L, -7706985736676217502L, -6554064206300089234L, -3959997443773729931L, -4815674818854554514L, -6824280192715693726L, -3653732856428923794L, -5365113930309604235L, -5076883528522566546L, 7813256364152681582L, 7813547721849139055L, -5923566924257463186L, -1888316330711354258L, -8490612054842777246L, 7814955178337072238L, -7319672835828255634L, 7815226688989656174L, -9040057866397846418L, -5004823799885892498L, -2122520038368775058L, -1834291805589184158L, 7815518136880428142L, -5851490621207322263L, -6977409194179596685L, -1789243714504133522L, -8355222650991053714L, -7778768457102691218L, -7490531479720200607L, -6914070727416777119L, -6337610017929071506L, -5472921049842486162L, -5472921045513310353L, -4031764805397154706L, -2014149891707538322L, -7751730332453735828L, -7175271834858720146L, -4292975787102866322L, -5436879062978956178L, -4283966384529902482L, -9174865671548149406L, -8021951807504681874L, 7883354641354814574L, -7148253458319969170L, -5130651876208839570L, -4842409392678275487L, -2248329367159475090L, 7883636120626492526L, 7883918772424242286L, -5400861295436008338L, -3959709358909983630L, 7884480558292103788L, 7884757648274127213L, -3932676821796948882L, 7885324996107137644L, 7885314001157975655L, -6796977137138700697L, -2761747477077332622L, -7940898095227636626L, -7076206966772501394L, -3905673907140463506L, 7886446497982936673L, -8202094714696665503L, -6472708038280514964L, -5031573822555132049L, 7886732418384753774L, 7887013871886627950L, -4148860556211292575L, -9039776352766430098L, -3851609765056514962L, -2113225840992820894L, -6139447201918520210L, -4121838958447069599L, -2968917496655940498L, -8436268670981671826L, 7888421216723758450L, -2950893129676787092L, -2374429138818599826L, -1797981533393293724L, -5247738848159309470L, 7953724532288746606L, -5472643968684429709L, -4896176593474325394L, -4607940801368853394L, 7954005994380555374L, -7184000788952157074L, 7954582172833248366L, -8616145461866040210L, -4004469429237615506L, 7954850423471699553L, -2842529683149064607L, 7955413309134566510L, -5995050478736411538L, -8003655921133587346L, -2815509150402775954L, -6553501325066144658L, -3382961616824732562L, -5103342202103171986L, 7956820731262760046L, -7382170214917376914L, 7957383694101083246L, -7084932639510924178L, 7957665169077793902L, -8228828274640195999L, -7940609967480539551L, -5346525625417634190L, -5040294006309032081L, 7958522728017917038L, -6175205566472688013L, -5022258772947405714L, -3851330489103059858L, 7959643207676032110L, -4400787257303141266L, 7960478853693011054L, -5544682819417967506L, -5256451425359006610L, -6688611495730645906L, 8026336280187073646L, 8029149939032487022L, 8030561686244194657L, 8030840923342074476L, -9057207984291879067L, -6165905841087943832L, 8097841889139646818L, 8097834205544018549L, -7489679383844522898L, -6048535156650120087L, -6048541770899755920L, -5760297126934252434L, -4895622426729024402L, -3454454053296049042L, -8336367065956780946L, -5742284931742993298L, -8615573745884367762L, -3715677219823979410L, -5147815231041280657L, -6003504713836694418L, -5409020779748102536L, -9128997319185637016L, -5093769892526459794L, 8100938118361871470L, -3922836124008876946L, -3625600756298390165L, -5345976934857608082L, -9065939240555617934L, -8201255778784222878L, 8102891924571185506L, 8103174550782571630L, -3274320058295159698L, 8175528957125424238L, -8462185272444881810L, -7309266039875734418L, -6624432976381512095L, -7759330225394977682L, -6588404222178266002L, -5417468250342460306L, -9146448767575034770L, -7705292544469995929L, -3949289291575363999L, -3652064961881608601L, 8245320470583407726L, -7669271409807231890L, -5075201327271676818L, -3634042806677118622L, -3345801491060263826L, 8245600850343457902L, -7372026064804940690L, 8245899943276016750L, -8804175238844550034L, -7651241545120517010L, -5588608377667095442L, 8247588818756661868L, -7885427733755760020L, -7308969176031202194L, 8248151777449440366L, -6138032070324030354L, -3237724948380160415L, 8314006987606423137L, -7777075230670752658L, -7200602328054271380L, -4606536707840314258L, -4030078158855113618L, -3741847739753728914L, -2012465482726017678L, -4885749898938321810L, 8314569963463603310L, -6317906726743607711L, -5453215572384713618L, -5164987472565668754L, -4012070370300300178L, 8314859096183562594L, 8314851412536555105L, 8314851412654190442L, 8314851412788473444L, -8614742510798801810L, -7173590638813617822L, 8315138389500327022L, -7741050827403332498L, -7164579006969187218L, -6876348639407410066L, -3994044929429900178L, 8315689206171137134L, -9164181729711791763L, -3976031596072307602L, -6849327140292891033L, -5408175208110920334L, 8316262073322008168L, -8281480536419896210L, 8316832719738860654L, -4228228815996690078L, 8317114186125636718L, -6813294997628947346L, -2201616710142692242L, 8317400102098531438L, -9110127539117788050L, -6516054153752382354L, -5363146925616827282L, -4786682861776179854L, -3921995044858268562L, 8317684892789994606L, -6218823145350925202L, 8317958636825572462L, -3327504505042869911L, 8318501782684791918L, 8318801979274523244L, 8318801979423945838L, -8776872123035585951L, -5318096597037255570L, -4165175109610277778L, -2435803847950240159L, 8319092173184267374L, -2138570653276474258L, 8319373648160978030L, -4435407618581629842L, 8319636444324918382L, -6155764993856801682L, -3849936329833876370L, 8319928918712874094L, 8320211583395525742L, -8731818509107830430L, -8443612390747966354L, -7290689782334524306L, -2967228603979958687L, -5264064456754629522L, -5831525706552218009L, -4102135696939453853L, -5822503079607438226L, 8386064581912522092L, -6623864520280017311L, -2867860266255551378L, -2282399985524906911L, -8326237282375734171L, -7461534050970929567L, -7173303674819217823L, 8387190481819626613L, -5723139114293693330L, -5146676184441850770L, -3705525381720083346L, 8387761115151622498L, 8387765508937183852L, 8388046975608054121L, -5984353373193406879L, -4543201492434848159L, -4254971116283136415L, 8388312009199085673L, -7416507941694183319L, -3093042450942299026L, 8388891421878350958L, -5957325199700298642L, -4227963769086446482L, -3651488766215489951L, 8389168477333714030L, -2201343936769723282L, -7092238928637234066L, 8389742392338642030L, 8390017330375128174L, -7362455928481680274L, -6776984747108109202L, 8390861768190162030L, -3300201389486934930L, -3011970991860386706L, 8391149767222195310L, -8191124878545230485L, -7614656438301526431L, -7326423897352342418L, -6461748110385651084L, 8391422531855807084L, -6452720076379294610L, -3858647786095877783L, -3570438223490354066L, -5579030476042963858L, -5858245960653507474L, -4408093550724418450L, -7281402168825778585L, 8392827643441017966L, -2948922804839812500L, -5533994574258539410L, -5731865899578068372L, 8459804428423291234L, 8459813276089938540L, -9163607698642083470L, 8460950063738876524L, -6812743038496836498L, -8821353961272282002L, -4200651951959609753L, -4200646445777979807L, -2471269695049339289L, 8462914933933367650L, 8465150219597799778L, 8465172295913141358L, -6911534136609904279L, 8531324305624101998L, -8604890886613928850L, -4857886096742058898L, 8532445863319008366L, -8568851077298817938L, -3930162234409257874L, -7668147726103514002L, -2768221345725451154L, -3614892599587802002L, -5029037244952775570L, -5290229440471534482L, 8602229628655989870L, -8064184104962132882L, -6046569221453485975L, -4317174921338719122L, -4884644911227243410L, -4596405768912802699L, -4308175393029523871L, -3929857665393396626L, -6794160192659234462L, 8606189008682316910L, -5587197687202744735L, -3272354075737231757L, -3163987291968277394L, -4298874607007337879L, 8676283918630089838L, -8541265455837781143L, -8253035079686069143L, -7667581477698834574L, -5361742827776545175L, -4208803773933063581L, -9099712982125809054L, -4199807526995921311L, -7361321301201292178L, -4181793111104392087L, -9054670371518582174L, -4154766024574142879L, -5181306321065905042L, -4893083697330162578L, -3163704738954775442L, -8919305062734269330L, 8750298669135262830L, -5892887191178087314L, -9036387610684984210L, -7883477144211198349L, -7883471659537961356L, 8818403548936107118L, -7486861352722402194L, -6595157384124800670L, -9180220275812109202L, -7144594390862369177L, 8820392603958603887L, 8820392604058349154L, 8820373873705971315L, 8820392604058349172L, -5658398791613451154L, -6802320716237540242L, 8824058281403184238L, -8991062468622977938L};
        HashSet<Long> buildSet = new HashSet<Long>();
        for (int[] entry : entries) {
            buildSet.add((long)entry);
        }
        REPRESENTATIVE_LOCALES = Collections.unmodifiableSet(buildSet);
        entries = new int[][]{{1634878554, 1634898976}, {1634878792, 1634898976}, {1634880601, 1634898976}, {1634880833, 1634898976}, {1634882638, 1634898976}};
        buildMap = new HashMap();
        for (int[] entry : entries) {
            buildMap.put(entry[0], entry[1]);
        }
        ARAB_PARENTS = Collections.unmodifiableMap(buildMap);
        entries = new int[][]{{2053655887, 2053654603}};
        buildMap = new HashMap();
        for (int[] entry : entries) {
            buildMap.put(entry[0], entry[1]);
        }
        HANT_PARENTS = Collections.unmodifiableMap(buildMap);
        entries = new int[][]{{1701740705, 1701741568}, {1701724487, 1701741568}, {1701724489, 1701741568}, {1701724500, 1701740705}, {1701724501, 1701741568}, {1701724738, 1701741568}, {1701724741, 1701741568}, {1701724749, 1701741568}, {1701724755, 1701741568}, {1701724759, 1701741568}, {1701724762, 1701741568}, {1701724993, 1701741568}, {1701724995, 1701741568}, {1701725000, 1701740705}, {1701725003, 1701741568}, {1701725005, 1701741568}, {1701725016, 1701741568}, {1701725017, 1701741568}, {1701725253, 1701740705}, {1701725255, 1701741568}, {1701725259, 1701740705}, {1701725261, 1701741568}, {1701725522, 1701741568}, {1701725769, 1701740705}, {1701725770, 1701741568}, {1701725771, 1701741568}, {1701725773, 1701741568}, {1701726018, 1701741568}, {1701726020, 1701741568}, {1701726023, 1701741568}, {1701726024, 1701741568}, {1701726025, 1701741568}, {1701726029, 1701741568}, {1701726041, 1701741568}, {1701726283, 1701741568}, {1701726533, 1701741568}, {1701726540, 1701741568}, {1701726541, 1701741568}, {1701726542, 1701741568}, {1701726543, 1701741568}, {1701726789, 1701741568}, {1701726797, 1701741568}, {1701727045, 1701741568}, {1701727049, 1701741568}, {1701727054, 1701741568}, {1701727065, 1701741568}, {1701727299, 1701741568}, {1701727314, 1701741568}, {1701727315, 1701741568}, {1701727559, 1701741568}, {1701727567, 1701741568}, {1701727571, 1701741568}, {1701727572, 1701741568}, {1701727573, 1701741568}, {1701727575, 1701741568}, {1701727577, 1701741568}, {1701727809, 1701741568}, {1701727814, 1701741568}, {1701727815, 1701741568}, {1701727820, 1701740705}, {1701727826, 1701741568}, {1701727829, 1701741568}, {1701727834, 1701741568}, {1701728327, 1701741568}, {1701728328, 1701741568}, {1701728331, 1701741568}, {1701728334, 1701741568}, {1701728343, 1701741568}, {1701728855, 1701741568}, {1701729090, 1701741568}, {1701729091, 1701741568}, {1701729092, 1701741568}, {1701729093, 1701740705}, {1701729095, 1701741568}, {1701729096, 1701741568}, {1701729097, 1701740705}, {1701729100, 1701741568}, {1701729107, 1701741568}, {1701729112, 1701741568}, {1701729114, 1701741568}, {1701729347, 1701741568}, {1701729355, 1701741568}, {1701729359, 1701741568}, {1701729364, 1701741568}, {1701729366, 1701741568}, {1701729370, 1701741568}, {1701729607, 1701741568}, {1701729859, 1701741568}, {1701729863, 1701741568}, {0x656E5655, 1701741568}, {1701730131, 1701741568}, {1701730881, 1701741568}, {1701730893, 1701741568}, {1701730903, 1701741568}, {1702052178, 1702077476}, {1702052431, 1702077476}, {1702052434, 1702077476}, {1702052684, 1702077476}, {1702052687, 1702077476}, {1702052690, 1702077476}, {1702052693, 1702077476}, {1702052943, 1702077476}, {1702053187, 1702077476}, {1702053716, 1702077476}, {1702053966, 1702077476}, {1702055256, 1702077476}, {1702055497, 1702077476}, {1702056001, 1702077476}, {1702056005, 1702077476}, {1702056018, 1702077476}, {1702056025, 1702077476}, {1702056790, 1702077476}, {1702057299, 1702077476}, {1702057305, 1702077476}, {1702057541, 1702077476}, {1886667087, 1886670932}, {1886667592, 1886670932}, {1886667606, 1886670932}, {1886668625, 1886670932}, {1886668631, 1886670932}, {1886669909, 1886670932}, {1886670159, 1886670932}, {1886670170, 1886670932}, {1886671700, 1886670932}, {1886671948, 1886670932}};
        buildMap = new HashMap();
        for (int[] entry : entries) {
            buildMap.put(entry[0], entry[1]);
        }
        LATN_PARENTS = Collections.unmodifiableMap(buildMap);
        HashMap<String, Map<Integer, Integer>> buildMap2 = new HashMap<String, Map<Integer, Integer>>();
        buildMap2.put("Arab", ARAB_PARENTS);
        buildMap2.put("Hant", HANT_PARENTS);
        buildMap2.put("Latn", LATN_PARENTS);
        SCRIPT_PARENTS = Collections.unmodifiableMap(buildMap2);
    }
}

