/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.CppAssetManager;
import org.robolectric.res.android.FileMap;
import org.robolectric.res.android.Idmap;
import org.robolectric.res.android.LoadedArsc;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.StringPiece;
import org.robolectric.res.android.Util;
import org.robolectric.res.android.ZipArchiveHandle;
import org.robolectric.res.android.ZipFileRO;
import org.robolectric.util.PerfStatsCollector;

public class CppApkAssets {
    private static final String kResourcesArsc = "resources.arsc";
    ZipArchiveHandle zip_handle_;
    private String path_;
    Asset resources_asset_;
    Asset idmap_asset_;
    private LoadedArsc loaded_arsc_;

    public CppApkAssets(ZipArchiveHandle zip_handle_, String path_) {
        this.zip_handle_ = zip_handle_;
        this.path_ = path_;
    }

    public String GetPath() {
        return this.path_;
    }

    public LoadedArsc GetLoadedArsc() {
        return this.loaded_arsc_;
    }

    public static CppApkAssets Load(String path, boolean system) {
        return CppApkAssets.LoadImpl(-1, path, null, null, system, false);
    }

    public static CppApkAssets LoadAsSharedLibrary(String path, boolean system) {
        return CppApkAssets.LoadImpl(-1, path, null, null, system, true);
    }

    public static CppApkAssets LoadOverlay(String idmap_path, boolean system) {
        throw new UnsupportedOperationException();
    }

    static Asset CreateAssetFromFile(String path) {
        throw new UnsupportedOperationException();
    }

    static CppApkAssets LoadImpl(int fd, String path, Asset idmap_asset, Idmap.LoadedIdmap loaded_idmap, boolean system, boolean load_as_shared_library) {
        return (CppApkAssets)PerfStatsCollector.getInstance().measure("load binary " + (system ? "framework" : "app") + " resources", () -> CppApkAssets.LoadImpl_measured(fd, path, idmap_asset, loaded_idmap, system, load_as_shared_library));
    }

    static CppApkAssets LoadImpl_measured(int fd, String path, Asset idmap_asset, Idmap.LoadedIdmap loaded_idmap, boolean system, boolean load_as_shared_library) {
        Ref<Object> unmanaged_handle = new Ref<Object>(null);
        if (fd >= 0) {
            throw new UnsupportedOperationException();
        }
        int result = ZipFileRO.OpenArchive(path, unmanaged_handle);
        if (result != 0) {
            System.err.println("Failed to open APK '" + path + "' " + CppApkAssets.ErrorCodeString(result));
            return null;
        }
        CppApkAssets loaded_apk = new CppApkAssets(unmanaged_handle.get(), path);
        String entry_name = kResourcesArsc;
        Ref<Object> entry = new Ref<Object>(null);
        result = ZipFileRO.FindEntry(loaded_apk.zip_handle_, entry_name, entry);
        if (result != 0) {
            loaded_apk.loaded_arsc_ = LoadedArsc.CreateEmpty();
            return loaded_apk;
        }
        if (((ZipEntry)entry.get()).getMethod() == 8) {
            System.out.println("resources.arsc in APK '" + path + "' is compressed.");
        }
        loaded_apk.resources_asset_ = loaded_apk.Open(kResourcesArsc, Asset.AccessMode.ACCESS_BUFFER);
        if (loaded_apk.resources_asset_ == null) {
            System.err.println("Failed to open 'resources.arsc' in APK '" + path + "'.");
            return null;
        }
        loaded_apk.idmap_asset_ = idmap_asset;
        StringPiece data = new StringPiece(ByteBuffer.wrap(loaded_apk.resources_asset_.getBuffer(true)).order(ByteOrder.LITTLE_ENDIAN), 0);
        loaded_apk.loaded_arsc_ = LoadedArsc.Load(data, loaded_idmap, system, load_as_shared_library);
        if (loaded_apk.loaded_arsc_ == null) {
            System.err.println("Failed to load 'resources.arsc' in APK '" + path + "'.");
            return null;
        }
        return loaded_apk;
    }

    private static String ErrorCodeString(int result) {
        return "Error " + result;
    }

    public Asset Open(String path, Asset.AccessMode mode) {
        Util.CHECK(this.zip_handle_ != null);
        String name = path;
        ZipFileRO zipFileRO = ZipFileRO.open(this.zip_handle_.zipFile.getName());
        ZipFileRO.ZipEntryRO entry = zipFileRO.findEntryByName(name);
        if (entry == null) {
            return null;
        }
        if (entry.entry.getMethod() == 8) {
            FileMap map = zipFileRO.createEntryFileMap(entry);
            Asset asset = Asset.createFromCompressedMap(map, (int)entry.entry.getSize(), mode);
            if (asset == null) {
                System.err.println("Failed to decompress '" + path + "'.");
                return null;
            }
            return asset;
        }
        FileMap map = zipFileRO.createEntryFileMap(entry);
        Asset asset = Asset.createFromUncompressedMap(map, mode);
        if (asset == null) {
            System.err.println("Failed to mmap file '" + path + "' in APK '" + this.path_ + "'");
            return null;
        }
        return asset;
    }

    boolean ForEachFile(String root_path, ForEachFileCallback f) {
        Util.CHECK(this.zip_handle_ != null);
        String root_path_full = root_path;
        if (!root_path_full.endsWith("/")) {
            root_path_full = root_path_full + '/';
        }
        String prefix = root_path_full;
        Enumeration<? extends ZipEntry> entries = this.zip_handle_.zipFile.entries();
        if (!entries.hasMoreElements()) {
            return false;
        }
        HashSet<String> dirs = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String full_file_path;
            String leaf_file_path;
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().startsWith(prefix) || (leaf_file_path = (full_file_path = zipEntry.getName()).substring(root_path_full.length())).isEmpty()) continue;
            if (zipEntry.isDirectory()) {
                dirs.add(leaf_file_path.substring(0, leaf_file_path.indexOf("/")));
                continue;
            }
            f.callback(leaf_file_path, CppAssetManager.FileType.kFileTypeRegular);
        }
        for (String dir : dirs) {
            f.callback(dir, CppAssetManager.FileType.kFileTypeDirectory);
        }
        return true;
    }

    static interface ForEachFileCallback {
        public void callback(String var1, CppAssetManager.FileType var2);
    }
}

