/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.robolectric.res.android.LocaleData;
import org.robolectric.res.android.Util;

public class ResTable_config {
    public static final int RESTABLE_MAX_LOCALE_LEN = 28;
    private static final int SCREEN_CONFIG_MIN_SIZE = 32;
    private static final int SCREEN_DP_MIN_SIZE = 36;
    private static final int LOCALE_MIN_SIZE = 48;
    private static final int SCREEN_CONFIG_EXTENSION_MIN_SIZE = 52;
    public static final int SIZEOF = 52;
    static final byte[] kEnglish = new byte[]{101, 110};
    static final byte[] kUnitedStates = new byte[]{85, 83};
    static final byte[] kFilipino = new byte[]{-83, 5};
    static final byte[] kTagalog = new byte[]{116, 108};
    public static final int SHIFT_LAYOUTDIR = 6;
    public static final int LAYOUTDIR_ANY = 0;
    public static final int LAYOUTDIR_LTR = 64;
    public static final int LAYOUTDIR_RTL = 128;
    public static final int SCREENWIDTH_ANY = 0;
    public static final int SCREENSIZE_ANY = 0;
    public static final int SCREENSIZE_SMALL = 1;
    public static final int SCREENSIZE_NORMAL = 2;
    public static final int SCREENSIZE_LARGE = 3;
    public static final int SCREENSIZE_XLARGE = 4;
    public static final int MASK_UI_MODE_TYPE = 15;
    public static final int UI_MODE_TYPE_ANY = 0;
    public static final int UI_MODE_TYPE_NORMAL = 1;
    public static final int MASK_UI_MODE_NIGHT = 48;
    public static final int SHIFT_UI_MODE_NIGHT = 4;
    public static final int UI_MODE_NIGHT_ANY = 0;
    public static final int DENSITY_DEFAULT = 0;
    public static final int DENSITY_LOW = 120;
    public static final int DENSITY_MEDIUM = 160;
    public static final int DENSITY_TV = 213;
    public static final int DENSITY_HIGH = 240;
    public static final int DENSITY_XHIGH = 320;
    public static final int DENSITY_XXHIGH = 480;
    public static final int DENSITY_XXXHIGH = 640;
    public static final int DENSITY_ANY = 65534;
    public static final int DENSITY_NONE = 65535;
    public static final int TOUCHSCREEN_ANY = 0;
    public static final int MASK_KEYSHIDDEN = 3;
    public static final byte KEYSHIDDEN_ANY = 0;
    public static final byte KEYSHIDDEN_NO = 1;
    public static final byte KEYSHIDDEN_YES = 2;
    public static final byte KEYSHIDDEN_SOFT = 3;
    public static final int KEYBOARD_ANY = 0;
    public static final int MASK_NAVHIDDEN = 12;
    public static final int SHIFT_NAVHIDDEN = 2;
    public static final byte NAVHIDDEN_ANY = 0;
    public static final byte NAVHIDDEN_NO = 4;
    public static final byte NAVHIDDEN_YES = 8;
    public static final int NAVIGATION_ANY = 0;
    public static final int SCREENHEIGHT_ANY = 0;
    public static final int SDKVERSION_ANY = 0;
    public static final int MINORVERSION_ANY = 0;
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_MASK = 3;
    public static final int WIDE_COLOR_GAMUT_ANY = 0;
    public static final int WIDE_COLOR_GAMUT_NO = 1;
    public static final int WIDE_COLOR_GAMUT_YES = 2;
    public static final int MASK_WIDE_COLOR_GAMUT = 3;
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_UNDEFINED = 0;
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_NO = 1;
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_YES = 2;
    private static final Map<Integer, String> COLOR_MODE_WIDE_COLOR_GAMUT_VALUES;
    public static final int HDR_ANY = 0;
    public static final int HDR_NO = 4;
    public static final int HDR_YES = 8;
    public static final int MASK_HDR = 12;
    static final int COLOR_MODE_HDR_MASK = 12;
    static final int COLOR_MODE_HDR_UNDEFINED = 0;
    static final int COLOR_MODE_HDR_NO = 4;
    static final int COLOR_MODE_HDR_YES = 8;
    private static final Map<Integer, String> COLOR_MODE_HDR_VALUES;
    public static final int DENSITY_DPI_UNDEFINED = 0;
    static final int DENSITY_DPI_LDPI = 120;
    public static final int DENSITY_DPI_MDPI = 160;
    static final int DENSITY_DPI_TVDPI = 213;
    static final int DENSITY_DPI_HDPI = 240;
    static final int DENSITY_DPI_XHDPI = 320;
    static final int DENSITY_DPI_XXHDPI = 480;
    static final int DENSITY_DPI_XXXHDPI = 640;
    public static final int DENSITY_DPI_ANY = 65534;
    public static final int DENSITY_DPI_NONE = 65535;
    private static final Map<Integer, String> DENSITY_DPI_VALUES;
    static final int KEYBOARD_NOKEYS = 1;
    static final int KEYBOARD_QWERTY = 2;
    static final int KEYBOARD_12KEY = 3;
    private static final Map<Integer, String> KEYBOARD_VALUES;
    static final int KEYBOARDHIDDEN_MASK = 3;
    static final int KEYBOARDHIDDEN_NO = 1;
    static final int KEYBOARDHIDDEN_YES = 2;
    static final int KEYBOARDHIDDEN_SOFT = 3;
    private static final Map<Integer, String> KEYBOARDHIDDEN_VALUES;
    static final int NAVIGATION_NONAV = 1;
    static final int NAVIGATION_DPAD = 2;
    static final int NAVIGATION_TRACKBALL = 3;
    static final int NAVIGATION_WHEEL = 4;
    private static final Map<Integer, String> NAVIGATION_VALUES;
    static final int NAVIGATIONHIDDEN_MASK = 12;
    static final int NAVIGATIONHIDDEN_NO = 4;
    static final int NAVIGATIONHIDDEN_YES = 8;
    private static final Map<Integer, String> NAVIGATIONHIDDEN_VALUES;
    public static final int ORIENTATION_ANY = 0;
    public static final int ORIENTATION_PORT = 1;
    public static final int ORIENTATION_LAND = 2;
    public static final int ORIENTATION_SQUARE = 3;
    static final int ORIENTATION_PORTRAIT = 1;
    static final int ORIENTATION_LANDSCAPE = 2;
    private static final Map<Integer, String> ORIENTATION_VALUES;
    static final int SCREENLAYOUT_LAYOUTDIR_MASK = 192;
    static final int SCREENLAYOUT_LAYOUTDIR_LTR = 64;
    static final int SCREENLAYOUT_LAYOUTDIR_RTL = 128;
    private static final Map<Integer, String> SCREENLAYOUT_LAYOUTDIR_VALUES;
    public static final int MASK_SCREENLONG = 48;
    public static final int SHIFT_SCREENLONG = 4;
    public static final int SCREENLONG_ANY = 0;
    public static final int SCREENLONG_NO = 16;
    public static final int SCREENLONG_YES = 32;
    static final int SCREENLAYOUT_LONG_MASK = 48;
    static final int SCREENLAYOUT_LONG_NO = 16;
    static final int SCREENLAYOUT_LONG_YES = 32;
    private static final Map<Integer, String> SCREENLAYOUT_LONG_VALUES;
    static final int MASK_SCREENROUND = 3;
    public static final int SCREENROUND_ANY = 0;
    public static final int SCREENROUND_NO = 1;
    public static final int SCREENROUND_YES = 2;
    static final int SCREENLAYOUT_ROUND_MASK = 3;
    static final int SCREENLAYOUT_ROUND_NO = 1;
    static final int SCREENLAYOUT_ROUND_YES = 2;
    private static final Map<Integer, String> SCREENLAYOUT_ROUND_VALUES;
    static final int SCREENLAYOUT_SIZE_MASK = 15;
    static final int SCREENLAYOUT_SIZE_SMALL = 1;
    static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    static final int SCREENLAYOUT_SIZE_LARGE = 3;
    static final int SCREENLAYOUT_SIZE_XLARGE = 4;
    private static final Map<Integer, String> SCREENLAYOUT_SIZE_VALUES;
    static final int TOUCHSCREEN_NOTOUCH = 1;
    @Deprecated
    static final int TOUCHSCREEN_STYLUS = 2;
    public static final int TOUCHSCREEN_FINGER = 3;
    private static final Map<Integer, String> TOUCHSCREEN_VALUES;
    static final int UI_MODE_NIGHT_MASK = 48;
    public static final int UI_MODE_NIGHT_NO = 16;
    static final int UI_MODE_NIGHT_YES = 32;
    private static final Map<Integer, String> UI_MODE_NIGHT_VALUES;
    static final int UI_MODE_TYPE_MASK = 15;
    static final int UI_MODE_TYPE_DESK = 2;
    static final int UI_MODE_TYPE_CAR = 3;
    static final int UI_MODE_TYPE_TELEVISION = 4;
    static final int UI_MODE_TYPE_APPLIANCE = 5;
    static final int UI_MODE_TYPE_WATCH = 6;
    static final int UI_MODE_TYPE_VR_HEADSET = 7;
    private static final Map<Integer, String> UI_MODE_TYPE_VALUES;
    int size;
    public int mcc;
    public int mnc;
    public final byte[] language;
    public final byte[] country;
    public int orientation;
    public int touchscreen;
    public int density;
    public int keyboard;
    public int navigation;
    public int inputFlags;
    public int screenWidth;
    public int screenHeight;
    public int sdkVersion;
    public int minorVersion;
    public int screenLayout;
    public int uiMode;
    public int smallestScreenWidthDp;
    public int screenWidthDp;
    public int screenHeightDp;
    public final byte[] localeScript;
    public final byte[] localeVariant;
    public byte screenLayout2;
    public byte colorMode;
    public short screenConfigPad2;
    public byte[] unknown;
    boolean localeScriptWasComputed;
    byte[] localeNumberingSystem = new byte[8];
    private static final int CONFIG_MCC = 1;
    private static final int CONFIG_MNC = 2;
    private static final int CONFIG_LOCALE = 4;
    private static final int CONFIG_TOUCHSCREEN = 8;
    private static final int CONFIG_KEYBOARD = 16;
    private static final int CONFIG_KEYBOARD_HIDDEN = 32;
    private static final int CONFIG_NAVIGATION = 64;
    private static final int CONFIG_ORIENTATION = 128;
    private static final int CONFIG_DENSITY = 256;
    private static final int CONFIG_SCREEN_SIZE = 512;
    private static final int CONFIG_SMALLEST_SCREEN_SIZE = 8192;
    private static final int CONFIG_VERSION = 1024;
    private static final int CONFIG_SCREEN_LAYOUT = 2048;
    private static final int CONFIG_UI_MODE = 4096;
    private static final int CONFIG_LAYOUTDIR = 16384;
    private static final int CONFIG_SCREEN_ROUND = 32768;
    private static final int CONFIG_COLOR_MODE = 65536;
    public static final int MASK_LAYOUTDIR = 192;
    static final int MASK_SCREENSIZE = 15;

    static ResTable_config createConfig(ByteBuffer buffer) {
        int startPosition = buffer.position();
        int size = buffer.getInt();
        int mcc = buffer.getShort() & 0xFFFF;
        int mnc = buffer.getShort() & 0xFFFF;
        byte[] language = new byte[2];
        buffer.get(language);
        byte[] region = new byte[2];
        buffer.get(region);
        int orientation = UnsignedBytes.toInt((byte)buffer.get());
        int touchscreen = UnsignedBytes.toInt((byte)buffer.get());
        int density = buffer.getShort() & 0xFFFF;
        int keyboard = UnsignedBytes.toInt((byte)buffer.get());
        int navigation = UnsignedBytes.toInt((byte)buffer.get());
        int inputFlags = UnsignedBytes.toInt((byte)buffer.get());
        buffer.get();
        int screenWidth = buffer.getShort() & 0xFFFF;
        int screenHeight = buffer.getShort() & 0xFFFF;
        int sdkVersion = buffer.getShort() & 0xFFFF;
        int minorVersion = buffer.getShort() & 0xFFFF;
        int screenLayout = 0;
        int uiMode = 0;
        int smallestScreenWidthDp = 0;
        int screenWidthDp = 0;
        int screenHeightDp = 0;
        byte[] localeScript = new byte[4];
        byte[] localeVariant = new byte[8];
        byte screenLayout2 = 0;
        byte screenConfigPad1 = 0;
        short screenConfigPad2 = 0;
        if (size >= 32) {
            screenLayout = UnsignedBytes.toInt((byte)buffer.get());
            uiMode = UnsignedBytes.toInt((byte)buffer.get());
            smallestScreenWidthDp = buffer.getShort() & 0xFFFF;
        }
        if (size >= 36) {
            screenWidthDp = buffer.getShort() & 0xFFFF;
            screenHeightDp = buffer.getShort() & 0xFFFF;
        }
        if (size >= 48) {
            buffer.get(localeScript);
            buffer.get(localeVariant);
        }
        if (size >= 52) {
            screenLayout2 = (byte)UnsignedBytes.toInt((byte)buffer.get());
            screenConfigPad1 = buffer.get();
            screenConfigPad2 = buffer.getShort();
        }
        int bytesRead = buffer.position() - startPosition;
        byte[] unknown = new byte[size - bytesRead];
        buffer.get(unknown);
        return new ResTable_config(size, mcc, mnc, language, region, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, minorVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, screenConfigPad1, screenConfigPad2, unknown);
    }

    @Nonnull
    public final String languageString() {
        return this.unpackLanguage();
    }

    public final String localeScriptString() {
        return this.byteArrayToString(this.localeScript);
    }

    public final String localeVariantString() {
        return this.byteArrayToString(this.localeVariant);
    }

    private String byteArrayToString(byte[] data) {
        int length = Bytes.indexOf((byte[])data, (byte)0);
        return new String(data, 0, length >= 0 ? length : data.length, StandardCharsets.US_ASCII);
    }

    public final int colorModeWideColorGamut() {
        return this.colorMode & 3;
    }

    public final int colorModeHdr() {
        return this.colorMode & 0xC;
    }

    @Nonnull
    public final String regionString() {
        return this.unpackRegion();
    }

    public final String scriptString() {
        if (this.localeScript[0] != 0) {
            return new String(this.localeScript, StandardCharsets.UTF_8);
        }
        return null;
    }

    public final int keyboardHidden() {
        return this.inputFlags & 3;
    }

    public final void keyboardHidden(int value) {
        this.inputFlags = this.inputFlags & 0xFFFFFFFC | value;
    }

    public final int navigationHidden() {
        return (this.inputFlags & 0xC) >> 2;
    }

    public final void navigationHidden(int value) {
        this.inputFlags = this.inputFlags & 0xFFFFFFF3 | value;
    }

    public final ResTable_config withSdkVersion(int sdkVersion) {
        if (sdkVersion == this.sdkVersion) {
            return this;
        }
        return new ResTable_config(this.size, this.mcc, this.mnc, this.language, this.country, this.orientation, this.touchscreen, this.density, this.keyboard, this.navigation, this.inputFlags, this.screenWidth, this.screenHeight, sdkVersion, this.minorVersion, this.screenLayout, this.uiMode, this.smallestScreenWidthDp, this.screenWidthDp, this.screenHeightDp, this.localeScript, this.localeVariant, this.screenLayout2, this.colorMode, this.screenConfigPad2, this.unknown);
    }

    public ResTable_config(ResTable_config other) {
        this.size = other.size;
        this.mcc = other.mcc;
        this.mnc = other.mnc;
        this.language = other.language;
        this.country = other.country;
        this.orientation = other.orientation;
        this.touchscreen = other.touchscreen;
        this.density = other.density;
        this.keyboard = other.keyboard;
        this.navigation = other.navigation;
        this.inputFlags = other.inputFlags;
        this.screenWidth = other.screenWidth;
        this.screenHeight = other.screenHeight;
        this.sdkVersion = other.sdkVersion;
        this.minorVersion = other.minorVersion;
        this.screenLayout = other.screenLayout;
        this.uiMode = other.uiMode;
        this.smallestScreenWidthDp = other.smallestScreenWidthDp;
        this.screenWidthDp = other.screenWidthDp;
        this.screenHeightDp = other.screenHeightDp;
        this.localeScript = other.localeScript;
        this.localeVariant = other.localeVariant;
        this.screenLayout2 = other.screenLayout2;
        this.colorMode = other.colorMode;
        this.screenConfigPad2 = other.screenConfigPad2;
        this.unknown = other.unknown;
    }

    public ResTable_config(int size, int mcc, int mnc, byte[] language, byte[] country, int orientation, int touchscreen, int density, int keyboard, int navigation, int inputFlags, int screenWidth, int screenHeight, int sdkVersion, int minorVersion, int screenLayout, int uiMode, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, byte[] localeScript, byte[] localeVariant, byte screenLayout2, byte colorMode, short screenConfigPad2, byte[] unknown) {
        this.size = size;
        this.mcc = mcc;
        this.mnc = mnc;
        this.language = language;
        this.country = country;
        this.orientation = orientation;
        this.touchscreen = touchscreen;
        this.density = density;
        this.keyboard = keyboard;
        this.navigation = navigation;
        this.inputFlags = inputFlags;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.sdkVersion = sdkVersion;
        this.minorVersion = minorVersion;
        this.screenLayout = screenLayout;
        this.uiMode = uiMode;
        this.smallestScreenWidthDp = smallestScreenWidthDp;
        this.screenWidthDp = screenWidthDp;
        this.screenHeightDp = screenHeightDp;
        this.localeScript = localeScript;
        this.localeVariant = localeVariant;
        this.screenLayout2 = screenLayout2;
        this.colorMode = colorMode;
        this.screenConfigPad2 = screenConfigPad2;
        this.unknown = unknown;
    }

    public ResTable_config() {
        this.language = new byte[2];
        this.country = new byte[2];
        this.localeScript = new byte[4];
        this.localeVariant = new byte[8];
    }

    public final int screenLayoutDirection() {
        return this.screenLayout & 0xC0;
    }

    public final void screenLayoutDirection(int value) {
        this.screenLayout = this.screenLayout & 0xFFFFFF3F | value;
    }

    public final int screenLayoutSize() {
        return this.screenLayout & 0xF;
    }

    public final void screenLayoutSize(int value) {
        this.screenLayout = this.screenLayout & 0xFFFFFFF0 | value;
    }

    public final int screenLayoutLong() {
        return this.screenLayout & 0x30;
    }

    public final void screenLayoutLong(int value) {
        this.screenLayout = this.screenLayout & 0xFFFFFFCF | value;
    }

    public final int screenLayoutRound() {
        return this.screenLayout2 & 3;
    }

    public final void screenLayoutRound(int value) {
        this.screenLayout2 = (byte)(this.screenLayout2 & 0xFFFFFFFC | value);
    }

    public final int uiModeType() {
        return this.uiMode & 0xF;
    }

    public final void uiModeType(int value) {
        this.uiMode = this.uiMode & 0xFFFFFFF0 | value;
    }

    public final int uiModeNight() {
        return this.uiMode & 0x30;
    }

    public final void uiModeNight(int value) {
        this.uiMode = this.uiMode & 0xFFFFFFCF | value;
    }

    private int screenConfig2() {
        return (this.screenLayout2 & 0xFF) << 24 | this.colorMode * 255 << 16 | this.screenConfigPad2 & 0xFFFF;
    }

    @Nonnull
    private String unpackLanguageOrRegion(byte[] value, int base) {
        Preconditions.checkState((value.length == 2 ? 1 : 0) != 0, (Object)"Language or country value must be 2 bytes.");
        if (value[0] == 0 && value[1] == 0) {
            return "";
        }
        if (Util.isTruthy(UnsignedBytes.toInt((byte)value[0]) & 0x80)) {
            byte[] result = new byte[]{(byte)(base + (value[1] & 0x1F)), (byte)(base + ((value[1] & 0xE0) >>> 5) + ((value[0] & 3) << 3)), (byte)(base + ((value[0] & 0x7C) >>> 2))};
            return new String(result, StandardCharsets.US_ASCII);
        }
        return new String(value, StandardCharsets.US_ASCII);
    }

    void packLanguageOrRegion(String in, byte base, byte[] out) {
        if (in == null) {
            out[0] = 0;
            out[1] = 0;
        } else if (in.length() < 3 || in.charAt(2) == '\u0000' || in.charAt(2) == '-') {
            out[0] = (byte)in.charAt(0);
            out[1] = (byte)in.charAt(1);
        } else {
            byte first = (byte)(in.charAt(0) - base & 0x7F);
            byte second = (byte)(in.charAt(1) - base & 0x7F);
            byte third = (byte)(in.charAt(2) - base & 0x7F);
            out[0] = (byte)(0x80 | third << 2 | second >> 3);
            out[1] = (byte)(second << 5 | first);
        }
    }

    public void packLanguage(String language) {
        this.packLanguageOrRegion(language, (byte)97, this.language);
    }

    public void packRegion(String region) {
        this.packLanguageOrRegion(region, (byte)48, this.country);
    }

    @Nonnull
    private String unpackLanguage() {
        return this.unpackLanguageOrRegion(this.language, 97);
    }

    private String unpackRegion() {
        return this.unpackLanguageOrRegion(this.country, 48);
    }

    static ResTable_config fromDtoH(ResTable_config o) {
        return new ResTable_config(0, Util.dtohs((short)o.mcc) & 0xFFFF, Util.dtohs((short)o.mnc) & 0xFFFF, o.language, o.country, o.orientation, o.touchscreen, Util.dtohl(o.density), o.keyboard, o.navigation, o.inputFlags, Util.dtohs((short)o.screenWidth) & 0xFFFF, Util.dtohs((short)o.screenHeight) & 0xFFFF, Util.dtohs((short)o.sdkVersion) & 0xFFFF, Util.dtohs((short)o.minorVersion) & 0xFFFF, o.screenLayout, o.uiMode, Util.dtohs((short)o.smallestScreenWidthDp) & 0xFFFF, Util.dtohs((short)o.screenWidthDp) & 0xFFFF, Util.dtohs((short)o.screenHeightDp) & 0xFFFF, o.localeScript, o.localeVariant, o.screenLayout2, o.colorMode, o.screenConfigPad2, o.unknown);
    }

    void swapHtoD() {
    }

    static final int compareLocales(ResTable_config l, ResTable_config r) {
        byte[] rScript;
        if (l.locale() != r.locale()) {
            return l.locale() > r.locale() ? 1 : -1;
        }
        byte[] emptyScript = new byte[]{0, 0, 0, 0};
        byte[] lScript = l.localeScriptWasComputed ? emptyScript : l.localeScript;
        int d = ResTable_config.arrayCompare(lScript, rScript = r.localeScriptWasComputed ? emptyScript : r.localeScript);
        if (d != 0) {
            return d;
        }
        int variant = ResTable_config.arrayCompare(l.localeVariant, r.localeVariant);
        if (Util.isTruthy(variant)) {
            return variant;
        }
        return ResTable_config.arrayCompare(l.localeNumberingSystem, r.localeNumberingSystem);
    }

    private static int arrayCompare(byte[] l, byte[] r) {
        for (int i = 0; i < l.length; ++i) {
            byte l0 = l[i];
            byte r0 = r[i];
            int d = l0 - r0;
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    int diff(ResTable_config o) {
        int diff;
        int diffs = 0;
        if (this.mcc != o.mcc) {
            diffs |= 1;
        }
        if (this.mnc != o.mnc) {
            diffs |= 2;
        }
        if (this.orientation != o.orientation) {
            diffs |= 0x80;
        }
        if (this.density != o.density) {
            diffs |= 0x100;
        }
        if (this.touchscreen != o.touchscreen) {
            diffs |= 8;
        }
        if (((this.inputFlags ^ o.inputFlags) & 0xF) != 0) {
            diffs |= 0x20;
        }
        if (this.keyboard != o.keyboard) {
            diffs |= 0x10;
        }
        if (this.navigation != o.navigation) {
            diffs |= 0x40;
        }
        if (this.screenSize() != o.screenSize()) {
            diffs |= 0x200;
        }
        if (this.version() != o.version()) {
            diffs |= 0x400;
        }
        if ((this.screenLayout & 0xC0) != (o.screenLayout & 0xC0)) {
            diffs |= 0x4000;
        }
        if ((this.screenLayout & 0xFFFFFF3F) != (o.screenLayout & 0xFFFFFF3F)) {
            diffs |= 0x800;
        }
        if ((this.screenLayout2 & 3) != (o.screenLayout2 & 3)) {
            diffs |= 0x8000;
        }
        if ((this.colorMode & 3) != (o.colorMode & 3)) {
            diffs |= 0x10000;
        }
        if ((this.colorMode & 0xC) != (o.colorMode & 0xC)) {
            diffs |= 0x10000;
        }
        if (this.uiMode != o.uiMode) {
            diffs |= 0x1000;
        }
        if (this.smallestScreenWidthDp != o.smallestScreenWidthDp) {
            diffs |= 0x2000;
        }
        if (this.screenSizeDp() != o.screenSizeDp()) {
            diffs |= 0x200;
        }
        if (Util.isTruthy(diff = ResTable_config.compareLocales(this, o))) {
            diffs |= 4;
        }
        return diffs;
    }

    int getImportanceScoreOfLocale() {
        return (Util.isTruthy(this.localeVariant[0]) ? 4 : 0) + (Util.isTruthy(this.localeScript[0]) && !this.localeScriptWasComputed ? 2 : 0) + (Util.isTruthy(this.localeNumberingSystem[0]) ? 1 : 0);
    }

    int compare(ResTable_config o) {
        if (this.imsi() != o.imsi()) {
            return this.imsi() > o.imsi() ? 1 : -1;
        }
        int diff = ResTable_config.compareLocales(this, o);
        if (diff < 0) {
            return -1;
        }
        if (diff > 0) {
            return 1;
        }
        if (this.screenType() != o.screenType()) {
            return this.screenType() > o.screenType() ? 1 : -1;
        }
        if (this.input() != o.input()) {
            return this.input() > o.input() ? 1 : -1;
        }
        if (this.screenSize() != o.screenSize()) {
            return this.screenSize() > o.screenSize() ? 1 : -1;
        }
        if (this.version() != o.version()) {
            return this.version() > o.version() ? 1 : -1;
        }
        if (this.screenLayout != o.screenLayout) {
            return this.screenLayout > o.screenLayout ? 1 : -1;
        }
        if (this.screenLayout2 != o.screenLayout2) {
            return this.screenLayout2 > o.screenLayout2 ? 1 : -1;
        }
        if (this.colorMode != o.colorMode) {
            return this.colorMode > o.colorMode ? 1 : -1;
        }
        if (this.uiMode != o.uiMode) {
            return this.uiMode > o.uiMode ? 1 : -1;
        }
        if (this.smallestScreenWidthDp != o.smallestScreenWidthDp) {
            return this.smallestScreenWidthDp > o.smallestScreenWidthDp ? 1 : -1;
        }
        if (this.screenSizeDp() != o.screenSizeDp()) {
            return this.screenSizeDp() > o.screenSizeDp() ? 1 : -1;
        }
        return 0;
    }

    public final boolean isDefault() {
        return this.mcc == 0 && this.mnc == 0 && this.isZeroes(this.language) && this.isZeroes(this.country) && this.orientation == 0 && this.touchscreen == 0 && this.density == 0 && this.keyboard == 0 && this.navigation == 0 && this.inputFlags == 0 && this.screenWidth == 0 && this.screenHeight == 0 && this.sdkVersion == 0 && this.minorVersion == 0 && this.screenLayout == 0 && this.uiMode == 0 && this.smallestScreenWidthDp == 0 && this.screenWidthDp == 0 && this.screenHeightDp == 0 && this.isZeroes(this.localeScript) && this.isZeroes(this.localeVariant) && this.screenLayout2 == 0 && this.colorMode == 0;
    }

    private boolean isZeroes(byte[] bytes1) {
        for (byte b : bytes1) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        if (this.isDefault()) {
            return "default";
        }
        Collection<String> parts = this.toStringParts().values();
        parts.removeAll(Collections.singleton(""));
        return Joiner.on((char)'-').join(parts);
    }

    public final Map<Type, String> toStringParts() {
        LinkedHashMap<Type, String> result = new LinkedHashMap<Type, String>();
        result.put(Type.MCC, this.mcc != 0 ? "mcc" + this.mcc : "");
        result.put(Type.MNC, this.mnc != 0 ? "mnc" + this.mnc : "");
        result.put(Type.LANGUAGE_STRING, this.languageString());
        result.put(Type.LOCALE_SCRIPT_STRING, this.localeScriptString());
        result.put(Type.REGION_STRING, !this.regionString().isEmpty() ? "r" + this.regionString() : "");
        result.put(Type.LOCALE_VARIANT_STRING, this.localeVariantString());
        result.put(Type.SCREEN_LAYOUT_DIRECTION, this.getOrDefault(SCREENLAYOUT_LAYOUTDIR_VALUES, this.screenLayoutDirection(), ""));
        result.put(Type.SMALLEST_SCREEN_WIDTH_DP, this.smallestScreenWidthDp != 0 ? "sw" + this.smallestScreenWidthDp + "dp" : "");
        result.put(Type.SCREEN_WIDTH_DP, this.screenWidthDp != 0 ? "w" + this.screenWidthDp + "dp" : "");
        result.put(Type.SCREEN_HEIGHT_DP, this.screenHeightDp != 0 ? "h" + this.screenHeightDp + "dp" : "");
        result.put(Type.SCREEN_LAYOUT_SIZE, this.getOrDefault(SCREENLAYOUT_SIZE_VALUES, this.screenLayoutSize(), ""));
        result.put(Type.SCREEN_LAYOUT_LONG, this.getOrDefault(SCREENLAYOUT_LONG_VALUES, this.screenLayoutLong(), ""));
        result.put(Type.SCREEN_LAYOUT_ROUND, this.getOrDefault(SCREENLAYOUT_ROUND_VALUES, this.screenLayoutRound(), ""));
        result.put(Type.COLOR_MODE_HDR, this.getOrDefault(COLOR_MODE_HDR_VALUES, this.colorModeHdr(), ""));
        result.put(Type.COLOR_MODE_WIDE_COLOR_GAMUT, this.getOrDefault(COLOR_MODE_WIDE_COLOR_GAMUT_VALUES, this.colorModeWideColorGamut(), ""));
        result.put(Type.ORIENTATION, this.getOrDefault(ORIENTATION_VALUES, this.orientation, ""));
        result.put(Type.UI_MODE_TYPE, this.getOrDefault(UI_MODE_TYPE_VALUES, this.uiModeType(), ""));
        result.put(Type.UI_MODE_NIGHT, this.getOrDefault(UI_MODE_NIGHT_VALUES, this.uiModeNight(), ""));
        result.put(Type.DENSITY_DPI, this.getOrDefault(DENSITY_DPI_VALUES, this.density, this.density + "dpi"));
        result.put(Type.TOUCHSCREEN, this.getOrDefault(TOUCHSCREEN_VALUES, this.touchscreen, ""));
        result.put(Type.KEYBOARD_HIDDEN, this.getOrDefault(KEYBOARDHIDDEN_VALUES, this.keyboardHidden(), ""));
        result.put(Type.KEYBOARD, this.getOrDefault(KEYBOARD_VALUES, this.keyboard, ""));
        result.put(Type.NAVIGATION_HIDDEN, this.getOrDefault(NAVIGATIONHIDDEN_VALUES, this.navigationHidden(), ""));
        result.put(Type.NAVIGATION, this.getOrDefault(NAVIGATION_VALUES, this.navigation, ""));
        result.put(Type.SCREEN_SIZE, this.screenWidth != 0 || this.screenHeight != 0 ? this.screenWidth + "x" + this.screenHeight : "");
        String sdkVersion = "";
        if (this.sdkVersion != 0) {
            sdkVersion = "v" + this.sdkVersion;
            if (this.minorVersion != 0) {
                sdkVersion = sdkVersion + "." + this.minorVersion;
            }
        }
        result.put(Type.SDK_VERSION, sdkVersion);
        return result;
    }

    private <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        return value != null ? value : defaultValue;
    }

    public boolean isBetterThan(ResTable_config o, ResTable_config requested) {
        if (Util.isTruthy(requested)) {
            int otherDelta;
            int myDelta;
            if (Util.isTruthy(this.imsi()) || Util.isTruthy(o.imsi())) {
                if (this.mcc != o.mcc && Util.isTruthy(requested.mcc)) {
                    return Util.isTruthy(this.mcc);
                }
                if (this.mnc != o.mnc && Util.isTruthy(requested.mnc)) {
                    return Util.isTruthy(this.mnc);
                }
            }
            if (this.isLocaleBetterThan(o, requested)) {
                return true;
            }
            if ((Util.isTruthy(this.screenLayout) || Util.isTruthy(o.screenLayout)) && Util.isTruthy((this.screenLayout ^ o.screenLayout) & 0xC0) && Util.isTruthy(requested.screenLayout & 0xC0)) {
                int myLayoutDir = this.screenLayout & 0xC0;
                int oLayoutDir = o.screenLayout & 0xC0;
                return myLayoutDir > oLayoutDir;
            }
            if ((Util.isTruthy(this.smallestScreenWidthDp) || Util.isTruthy(o.smallestScreenWidthDp)) && this.smallestScreenWidthDp != o.smallestScreenWidthDp) {
                return this.smallestScreenWidthDp > o.smallestScreenWidthDp;
            }
            if (Util.isTruthy(this.screenSizeDp()) || Util.isTruthy(o.screenSizeDp())) {
                myDelta = 0;
                otherDelta = 0;
                if (Util.isTruthy(requested.screenWidthDp)) {
                    myDelta += requested.screenWidthDp - this.screenWidthDp;
                    otherDelta += requested.screenWidthDp - o.screenWidthDp;
                }
                if (Util.isTruthy(requested.screenHeightDp)) {
                    myDelta += requested.screenHeightDp - this.screenHeightDp;
                    otherDelta += requested.screenHeightDp - o.screenHeightDp;
                }
                if (myDelta != otherDelta) {
                    return myDelta < otherDelta;
                }
            }
            if (Util.isTruthy(this.screenLayout) || Util.isTruthy(o.screenLayout)) {
                if (Util.isTruthy((this.screenLayout ^ o.screenLayout) & 0xF) && Util.isTruthy(requested.screenLayout & 0xF)) {
                    int mySL = this.screenLayout & 0xF;
                    int oSL = o.screenLayout & 0xF;
                    int fixedMySL = mySL;
                    int fixedOSL = oSL;
                    if ((requested.screenLayout & 0xF) >= 2) {
                        if (fixedMySL == 0) {
                            fixedMySL = 2;
                        }
                        if (fixedOSL == 0) {
                            fixedOSL = 2;
                        }
                    }
                    if (fixedMySL == fixedOSL) {
                        return mySL != 0;
                    }
                    if (fixedMySL != fixedOSL) {
                        return fixedMySL > fixedOSL;
                    }
                }
                if (((this.screenLayout ^ o.screenLayout) & 0x30) != 0 && Util.isTruthy(requested.screenLayout & 0x30)) {
                    return Util.isTruthy(this.screenLayout & 0x30);
                }
            }
            if ((Util.isTruthy(this.screenLayout2) || Util.isTruthy(o.screenLayout2)) && ((this.screenLayout2 ^ o.screenLayout2) & 3) != 0 && Util.isTruthy(requested.screenLayout2 & 3)) {
                return Util.isTruthy(this.screenLayout2 & 3);
            }
            if (Util.isTruthy(this.colorMode) || Util.isTruthy(o.colorMode)) {
                if (((this.colorMode ^ o.colorMode) & 3) != 0 && Util.isTruthy(requested.colorMode & 3)) {
                    return Util.isTruthy(this.colorMode & 3);
                }
                if (((this.colorMode ^ o.colorMode) & 0xC) != 0 && Util.isTruthy(requested.colorMode & 0xC)) {
                    return Util.isTruthy(this.colorMode & 0xC);
                }
            }
            if (this.orientation != o.orientation && Util.isTruthy(requested.orientation)) {
                return Util.isTruthy(this.orientation);
            }
            if (Util.isTruthy(this.uiMode) || Util.isTruthy(o.uiMode)) {
                if (((this.uiMode ^ o.uiMode) & 0xF) != 0 && Util.isTruthy(requested.uiMode & 0xF)) {
                    return Util.isTruthy(this.uiMode & 0xF);
                }
                if (((this.uiMode ^ o.uiMode) & 0x30) != 0 && Util.isTruthy(requested.uiMode & 0x30)) {
                    return Util.isTruthy(this.uiMode & 0x30);
                }
            }
            if (Util.isTruthy(this.screenType()) || Util.isTruthy(o.screenType())) {
                if (this.density != o.density) {
                    int otherDensity;
                    int thisDensity = Util.isTruthy(this.density) ? this.density : 160;
                    int n = otherDensity = Util.isTruthy(o.density) ? o.density : 160;
                    if (thisDensity == 65534) {
                        return true;
                    }
                    if (otherDensity == 65534) {
                        return false;
                    }
                    int requestedDensity = requested.density;
                    if (requested.density == 0 || requested.density == 65534) {
                        requestedDensity = 160;
                    }
                    int h = thisDensity;
                    int l = otherDensity;
                    boolean bImBigger = true;
                    if (l > h) {
                        int t = h;
                        h = l;
                        l = t;
                        bImBigger = false;
                    }
                    if (requestedDensity >= h) {
                        return bImBigger;
                    }
                    if (l >= requestedDensity) {
                        return !bImBigger;
                    }
                    if ((2 * l - requestedDensity) * h > requestedDensity * requestedDensity) {
                        return !bImBigger;
                    }
                    return bImBigger;
                }
                if (this.touchscreen != o.touchscreen && Util.isTruthy(requested.touchscreen)) {
                    return Util.isTruthy(this.touchscreen);
                }
            }
            if (Util.isTruthy(this.input()) || Util.isTruthy(o.input())) {
                int reqNavHidden;
                int oNavHidden;
                int navHidden;
                int reqKeysHidden;
                int keysHidden = this.inputFlags & 3;
                int oKeysHidden = o.inputFlags & 3;
                if (keysHidden != oKeysHidden && Util.isTruthy(reqKeysHidden = requested.inputFlags & 3)) {
                    if (keysHidden == 0) {
                        return false;
                    }
                    if (oKeysHidden == 0) {
                        return true;
                    }
                    if (reqKeysHidden == keysHidden) {
                        return true;
                    }
                    if (reqKeysHidden == oKeysHidden) {
                        return false;
                    }
                }
                if ((navHidden = this.inputFlags & 0xC) != (oNavHidden = o.inputFlags & 0xC) && Util.isTruthy(reqNavHidden = requested.inputFlags & 0xC)) {
                    if (navHidden == 0) {
                        return false;
                    }
                    if (oNavHidden == 0) {
                        return true;
                    }
                }
                if (this.keyboard != o.keyboard && Util.isTruthy(requested.keyboard)) {
                    return Util.isTruthy(this.keyboard);
                }
                if (this.navigation != o.navigation && Util.isTruthy(requested.navigation)) {
                    return Util.isTruthy(this.navigation);
                }
            }
            if (Util.isTruthy(this.screenSize()) || Util.isTruthy(o.screenSize())) {
                myDelta = 0;
                otherDelta = 0;
                if (Util.isTruthy(requested.screenWidth)) {
                    myDelta += requested.screenWidth - this.screenWidth;
                    otherDelta += requested.screenWidth - o.screenWidth;
                }
                if (Util.isTruthy(requested.screenHeight)) {
                    myDelta += requested.screenHeight - this.screenHeight;
                    otherDelta += requested.screenHeight - o.screenHeight;
                }
                if (myDelta != otherDelta) {
                    return myDelta < otherDelta;
                }
            }
            if (Util.isTruthy(this.version()) || Util.isTruthy(o.version())) {
                if (this.sdkVersion != o.sdkVersion && Util.isTruthy(requested.sdkVersion)) {
                    return this.sdkVersion > o.sdkVersion;
                }
                if (this.minorVersion != o.minorVersion && Util.isTruthy(requested.minorVersion)) {
                    return Util.isTruthy(this.minorVersion);
                }
            }
            return false;
        }
        return this.isMoreSpecificThan(o);
    }

    public boolean match(ResTable_config settings) {
        if (this.imsi() != 0) {
            if (this.mcc != 0 && this.mcc != settings.mcc) {
                return false;
            }
            if (this.mnc != 0 && this.mnc != settings.mnc) {
                return false;
            }
        }
        if (this.locale() != 0) {
            if (!this.langsAreEquivalent(this.language, settings.language)) {
                return false;
            }
            boolean countriesMustMatch = false;
            byte[] computed_script = new byte[4];
            byte[] script = null;
            if (settings.localeScript[0] == 0) {
                countriesMustMatch = true;
            } else if (this.localeScript[0] == 0 && !this.localeScriptWasComputed) {
                LocaleData.localeDataComputeScript(computed_script, this.language, this.country);
                if (computed_script[0] == 0) {
                    countriesMustMatch = true;
                } else {
                    script = computed_script;
                }
            } else {
                script = this.localeScript;
            }
            if (countriesMustMatch ? this.country[0] != 0 && !this.areIdentical(this.country, settings.country) : !Arrays.equals(script, settings.localeScript)) {
                return false;
            }
        }
        if (this.screenConfig() != 0) {
            int layoutDir = this.screenLayout & 0xC0;
            int setLayoutDir = settings.screenLayout & 0xC0;
            if (layoutDir != 0 && layoutDir != setLayoutDir) {
                return false;
            }
            int screenSize = this.screenLayout & 0xF;
            int setScreenSize = settings.screenLayout & 0xF;
            if (screenSize != 0 && screenSize > setScreenSize) {
                return false;
            }
            int screenLong = this.screenLayout & 0x30;
            int setScreenLong = settings.screenLayout & 0x30;
            if (screenLong != 0 && screenLong != setScreenLong) {
                return false;
            }
            int uiModeType = this.uiMode & 0xF;
            int setUiModeType = settings.uiMode & 0xF;
            if (uiModeType != 0 && uiModeType != setUiModeType) {
                return false;
            }
            int uiModeNight = this.uiMode & 0x30;
            int setUiModeNight = settings.uiMode & 0x30;
            if (uiModeNight != 0 && uiModeNight != setUiModeNight) {
                return false;
            }
            if (this.smallestScreenWidthDp != 0 && this.smallestScreenWidthDp > settings.smallestScreenWidthDp) {
                return false;
            }
        }
        if (this.screenConfig2() != 0) {
            int screenRound = this.screenLayout2 & 3;
            int setScreenRound = settings.screenLayout2 & 3;
            if (screenRound != 0 && screenRound != setScreenRound) {
                return false;
            }
        }
        int hdr = this.colorMode & 0xC;
        int setHdr = settings.colorMode & 0xC;
        if (hdr != 0 && hdr != setHdr) {
            return false;
        }
        int wideColorGamut = this.colorMode & 3;
        int setWideColorGamut = settings.colorMode & 3;
        if (wideColorGamut != 0 && wideColorGamut != setWideColorGamut) {
            return false;
        }
        if (this.screenSizeDp() != 0) {
            if (this.screenWidthDp != 0 && this.screenWidthDp > settings.screenWidthDp) {
                return false;
            }
            if (this.screenHeightDp != 0 && this.screenHeightDp > settings.screenHeightDp) {
                return false;
            }
        }
        if (this.screenType() != 0) {
            if (this.orientation != 0 && this.orientation != settings.orientation) {
                return false;
            }
            if (this.touchscreen != 0 && this.touchscreen != settings.touchscreen) {
                return false;
            }
        }
        if (this.input() != 0) {
            int keysHidden = this.inputFlags & 3;
            int setKeysHidden = settings.inputFlags & 3;
            if (keysHidden != 0 && keysHidden != setKeysHidden && (keysHidden != 1 || setKeysHidden != 3)) {
                return false;
            }
            int navHidden = this.inputFlags & 0xC;
            int setNavHidden = settings.inputFlags & 0xC;
            if (navHidden != 0 && navHidden != setNavHidden) {
                return false;
            }
            if (this.keyboard != 0 && this.keyboard != settings.keyboard) {
                return false;
            }
            if (this.navigation != 0 && this.navigation != settings.navigation) {
                return false;
            }
        }
        if (this.screenSize() != 0) {
            if (this.screenWidth != 0 && this.screenWidth > settings.screenWidth) {
                return false;
            }
            if (this.screenHeight != 0 && this.screenHeight > settings.screenHeight) {
                return false;
            }
        }
        if (this.version() != 0) {
            if (this.sdkVersion != 0 && this.sdkVersion > settings.sdkVersion) {
                return false;
            }
            if (this.minorVersion != 0 && this.minorVersion != settings.minorVersion) {
                return false;
            }
        }
        return true;
    }

    String getBcp47Locale(boolean canonicalize) {
        Object regionStr;
        StringBuilder str = new StringBuilder();
        if (this.language[0] == 0 && this.country[0] == 0) {
            return "";
        }
        if (this.language[0] != 0) {
            if (canonicalize && this.areIdentical(this.language, kTagalog)) {
                str.setLength(0);
                str.append("fil");
            } else {
                str.append(this.unpackLanguage());
            }
        }
        if (Util.isTruthy(this.localeScript[0]) && !this.localeScriptWasComputed) {
            if (str.length() > 0) {
                str.append('-');
            }
            for (Object aLocaleScript : this.localeScript) {
                str.append((char)aLocaleScript);
            }
        }
        if (this.country[0] != 0) {
            if (str.length() > 0) {
                str.append('-');
            }
            regionStr = this.unpackRegion();
            str.append((String)regionStr);
        }
        if (Util.isTruthy(this.localeVariant[0])) {
            if (str.length() > 0) {
                str.append('-');
            }
            regionStr = this.localeVariant;
            int n = ((Object)regionStr).length;
            for (int i = 0; i < n; ++i) {
                Object aLocaleScript;
                aLocaleScript = regionStr[i];
                str.append((char)aLocaleScript);
            }
        }
        if (this.localeNumberingSystem[0] != 0 && str.length() > 0) {
            String NU_PREFIX = "-u-nu-";
            str.append(NU_PREFIX);
            str.append(new String(this.localeNumberingSystem, StandardCharsets.UTF_8));
        }
        return str.toString();
    }

    static LocaleParserState assignLocaleComponent(ResTable_config config, String start, int size, LocaleParserState state) {
        if (state.parserState == State.UNICODE_EXTENSION) {
            block0 : switch (size) {
                case 1: {
                    state.parserState = State.IGNORE_THE_REST;
                    break;
                }
                case 2: {
                    if (state.unicodeState == UnicodeState.NO_KEY || state.unicodeState == UnicodeState.EXPECT_KEY) {
                        if (!(start.charAt(0) != 'n' && start.charAt(0) != 'N' || start.charAt(1) != 'u' && start.charAt(1) != 'U')) {
                            state.unicodeState = UnicodeState.NUMBERING_SYSTEM;
                            break;
                        }
                        state.unicodeState = UnicodeState.IGNORE_KEY;
                        break;
                    }
                    state.parserState = State.IGNORE_THE_REST;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    switch (state.unicodeState) {
                        case NUMBERING_SYSTEM: {
                            if (config.localeNumberingSystem[0] == 0) {
                                for (int i = 0; i < size; ++i) {
                                    config.localeNumberingSystem[i] = (byte)Character.toLowerCase(start.charAt(i));
                                }
                                state.unicodeState = UnicodeState.EXPECT_KEY;
                                break block0;
                            }
                            state.parserState = State.IGNORE_THE_REST;
                            break block0;
                        }
                        case IGNORE_KEY: {
                            state.unicodeState = UnicodeState.EXPECT_KEY;
                            break block0;
                        }
                        case EXPECT_KEY: {
                            state.parserState = State.IGNORE_THE_REST;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    state.parserState = State.IGNORE_THE_REST;
                }
            }
            return state;
        }
        switch (size) {
            case 0: {
                state.parserState = State.IGNORE_THE_REST;
                break;
            }
            case 1: {
                state.parserState = start.charAt(0) == 'u' || start.charAt(0) == 'U' ? State.UNICODE_EXTENSION : State.IGNORE_THE_REST;
                break;
            }
            case 2: 
            case 3: {
                if (Util.isTruthy(config.language[0])) {
                    config.packRegion(start);
                    break;
                }
                config.packLanguage(start);
                break;
            }
            case 4: {
                char start0 = start.charAt(0);
                if ('0' > start0 || start0 > '9') {
                    config.localeScript[0] = (byte)Character.toUpperCase(start0);
                    for (int i = 1; i < 4; ++i) {
                        config.localeScript[i] = (byte)Character.toLowerCase(start.charAt(i));
                    }
                    break;
                }
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                for (int i = 0; i < size; ++i) {
                    config.localeVariant[i] = (byte)Character.toLowerCase(start.charAt(i));
                }
                break;
            }
            default: {
                state.parserState = State.IGNORE_THE_REST;
            }
        }
        return state;
    }

    public void setBcp47Locale(String in) {
        int size;
        int separator;
        this.clearLocale();
        int start = 0;
        LocaleParserState state = new LocaleParserState();
        while ((separator = in.indexOf(45, start)) > 0) {
            size = separator - start;
            state = ResTable_config.assignLocaleComponent(this, in.substring(start), size, state);
            if (state.parserState == State.IGNORE_THE_REST) {
                System.err.println(String.format("Invalid BCP-47 locale string: %s", in));
                break;
            }
            start = separator + 1;
        }
        if (state.parserState != State.IGNORE_THE_REST) {
            size = in.length() - start;
            ResTable_config.assignLocaleComponent(this, in.substring(start), size, state);
        }
        boolean bl = this.localeScriptWasComputed = this.localeScript[0] == 0;
        if (this.localeScriptWasComputed) {
            this.computeScript();
        }
    }

    void clearLocale() {
        this.clear(this.language);
        this.clear(this.country);
        this.localeScriptWasComputed = false;
        this.clear(this.localeScript);
        this.clear(this.localeVariant);
    }

    void computeScript() {
        LocaleData.localeDataComputeScript(this.localeScript, this.language, this.country);
    }

    private void clear(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
    }

    private int imsi() {
        return (this.mcc & 0xFFFF) << 16 | this.mnc & 0xFFFF;
    }

    private int screenSize() {
        return (this.screenWidth & 0xFFFF) << 16 | this.screenHeight & 0xFFFF;
    }

    private int screenConfig() {
        return (this.screenLayout & 0xFF) << 24 | this.uiMode * 255 << 16 | this.smallestScreenWidthDp & 0xFFFF;
    }

    private int screenSizeDp() {
        return (this.screenWidthDp & 0xFFFF) << 16 | this.screenHeightDp & 0xFFFF;
    }

    private int screenType() {
        return (this.orientation & 0xFF) << 24 | (this.touchscreen & 0xFF) << 16 | this.density & 0xFFFF;
    }

    private int input() {
        return (this.keyboard & 0xFF) << 24 | (this.navigation & 0xFF) << 16 | (this.inputFlags & 0xFF) << 8;
    }

    private int version() {
        return (this.sdkVersion & 0xFFFF) << 16 | this.minorVersion & 0xFFFF;
    }

    int locale() {
        return (this.language[0] & 0xFF) << 24 | (this.language[1] & 0xFF) << 16 | (this.country[0] & 0xFF) << 8 | this.country[1] & 0xFF;
    }

    private boolean isLocaleBetterThan(ResTable_config o, ResTable_config requested) {
        boolean otherNumsysMatches;
        boolean otherMatches;
        if (requested.locale() == 0) {
            return false;
        }
        if (this.locale() == 0 && o.locale() == 0) {
            return false;
        }
        if (!this.langsAreEquivalent(this.language, o.language)) {
            if (this.areIdentical(requested.language, kEnglish)) {
                if (this.areIdentical(requested.country, kUnitedStates)) {
                    if (this.language[0] != 0) {
                        return this.country[0] == 0 || this.areIdentical(this.country, kUnitedStates);
                    }
                    return o.country[0] != 0 && !this.areIdentical(o.country, kUnitedStates);
                }
                if (LocaleData.localeDataIsCloseToUsEnglish(requested.country)) {
                    if (this.language[0] != 0) {
                        return LocaleData.localeDataIsCloseToUsEnglish(this.country);
                    }
                    return !LocaleData.localeDataIsCloseToUsEnglish(o.country);
                }
            }
            return this.language[0] != 0;
        }
        int region_comparison = LocaleData.localeDataCompareRegions(this.country, o.country, requested.language, this.str(requested.localeScript), requested.country);
        if (region_comparison != 0) {
            return region_comparison > 0;
        }
        boolean localeMatches = Arrays.equals(this.localeVariant, requested.localeVariant);
        if (localeMatches != (otherMatches = Arrays.equals(o.localeVariant, requested.localeVariant))) {
            return localeMatches;
        }
        boolean localeNumsysMatches = ResTable_config.arrayCompare(this.localeNumberingSystem, requested.localeNumberingSystem) == 0;
        boolean bl = otherNumsysMatches = ResTable_config.arrayCompare(o.localeNumberingSystem, requested.localeNumberingSystem) == 0;
        if (localeNumsysMatches != otherNumsysMatches) {
            return localeNumsysMatches;
        }
        return this.areIdentical(this.language, requested.language) && !this.areIdentical(o.language, requested.language);
    }

    private String str(byte[] country) {
        return new String(country, StandardCharsets.UTF_8);
    }

    private boolean langsAreEquivalent(byte[] lang1, byte[] lang2) {
        return this.areIdentical(lang1, lang2) || this.areIdentical(lang1, kTagalog) && this.areIdentical(lang2, kFilipino) || this.areIdentical(lang1, kFilipino) && this.areIdentical(lang2, kTagalog);
    }

    private boolean areIdentical(byte[] code1, byte[] code2) {
        return code1[0] == code2[0] && code1[1] == code2[1];
    }

    int isLocaleMoreSpecificThan(ResTable_config o) {
        if (Util.isTruthy(this.locale()) || Util.isTruthy(o.locale())) {
            if (this.language[0] != o.language[0]) {
                if (!Util.isTruthy(this.language[0])) {
                    return -1;
                }
                if (!Util.isTruthy(o.language[0])) {
                    return 1;
                }
            }
            if (this.country[0] != o.country[0]) {
                if (!Util.isTruthy(this.country[0])) {
                    return -1;
                }
                if (!Util.isTruthy(o.country[0])) {
                    return 1;
                }
            }
        }
        return this.getImportanceScoreOfLocale() - o.getImportanceScoreOfLocale();
    }

    private boolean isMoreSpecificThan(ResTable_config o) {
        if (Util.isTruthy(this.imsi()) || Util.isTruthy(o.imsi())) {
            if (this.mcc != o.mcc) {
                if (!Util.isTruthy(this.mcc)) {
                    return false;
                }
                if (!Util.isTruthy(o.mcc)) {
                    return true;
                }
            }
            if (this.mnc != o.mnc) {
                if (!Util.isTruthy(this.mnc)) {
                    return false;
                }
                if (!Util.isTruthy(o.mnc)) {
                    return true;
                }
            }
        }
        if (Util.isTruthy(this.locale()) || Util.isTruthy(o.locale())) {
            int diff = this.isLocaleMoreSpecificThan(o);
            if (diff < 0) {
                return false;
            }
            if (diff > 0) {
                return true;
            }
        }
        if ((Util.isTruthy(this.screenLayout) || Util.isTruthy(o.screenLayout)) && ((this.screenLayout ^ o.screenLayout) & 0xC0) != 0) {
            if (!Util.isTruthy(this.screenLayout & 0xC0)) {
                return false;
            }
            if (!Util.isTruthy(o.screenLayout & 0xC0)) {
                return true;
            }
        }
        if ((Util.isTruthy(this.smallestScreenWidthDp) || Util.isTruthy(o.smallestScreenWidthDp)) && this.smallestScreenWidthDp != o.smallestScreenWidthDp) {
            if (!Util.isTruthy(this.smallestScreenWidthDp)) {
                return false;
            }
            if (!Util.isTruthy(o.smallestScreenWidthDp)) {
                return true;
            }
        }
        if (Util.isTruthy(this.screenSizeDp()) || Util.isTruthy(o.screenSizeDp())) {
            if (this.screenWidthDp != o.screenWidthDp) {
                if (!Util.isTruthy(this.screenWidthDp)) {
                    return false;
                }
                if (!Util.isTruthy(o.screenWidthDp)) {
                    return true;
                }
            }
            if (this.screenHeightDp != o.screenHeightDp) {
                if (!Util.isTruthy(this.screenHeightDp)) {
                    return false;
                }
                if (!Util.isTruthy(o.screenHeightDp)) {
                    return true;
                }
            }
        }
        if (Util.isTruthy(this.screenLayout) || Util.isTruthy(o.screenLayout)) {
            if (((this.screenLayout ^ o.screenLayout) & 0xF) != 0) {
                if (!Util.isTruthy(this.screenLayout & 0xF)) {
                    return false;
                }
                if (!Util.isTruthy(o.screenLayout & 0xF)) {
                    return true;
                }
            }
            if (((this.screenLayout ^ o.screenLayout) & 0x30) != 0) {
                if (!Util.isTruthy(this.screenLayout & 0x30)) {
                    return false;
                }
                if (!Util.isTruthy(o.screenLayout & 0x30)) {
                    return true;
                }
            }
        }
        if ((Util.isTruthy(this.screenLayout2) || Util.isTruthy(o.screenLayout2)) && ((this.screenLayout2 ^ o.screenLayout2) & 3) != 0) {
            if (!Util.isTruthy(this.screenLayout2 & 3)) {
                return false;
            }
            if (!Util.isTruthy(o.screenLayout2 & 3)) {
                return true;
            }
        }
        if (Util.isTruthy(this.colorMode) || Util.isTruthy(o.colorMode)) {
            if (((this.colorMode ^ o.colorMode) & 0xC) != 0) {
                if (!Util.isTruthy(this.colorMode & 0xC)) {
                    return false;
                }
                if (!Util.isTruthy(o.colorMode & 0xC)) {
                    return true;
                }
            }
            if (((this.colorMode ^ o.colorMode) & 3) != 0) {
                if (!Util.isTruthy(this.colorMode & 3)) {
                    return false;
                }
                if (!Util.isTruthy(o.colorMode & 3)) {
                    return true;
                }
            }
        }
        if (this.orientation != o.orientation) {
            if (!Util.isTruthy(this.orientation)) {
                return false;
            }
            if (!Util.isTruthy(o.orientation)) {
                return true;
            }
        }
        if (Util.isTruthy(this.uiMode) || Util.isTruthy(o.uiMode)) {
            if (((this.uiMode ^ o.uiMode) & 0xF) != 0) {
                if (!Util.isTruthy(this.uiMode & 0xF)) {
                    return false;
                }
                if (!Util.isTruthy(o.uiMode & 0xF)) {
                    return true;
                }
            }
            if (((this.uiMode ^ o.uiMode) & 0x30) != 0) {
                if (!Util.isTruthy(this.uiMode & 0x30)) {
                    return false;
                }
                if (!Util.isTruthy(o.uiMode & 0x30)) {
                    return true;
                }
            }
        }
        if (this.touchscreen != o.touchscreen) {
            if (!Util.isTruthy(this.touchscreen)) {
                return false;
            }
            if (!Util.isTruthy(o.touchscreen)) {
                return true;
            }
        }
        if (Util.isTruthy(this.input()) || Util.isTruthy(o.input())) {
            if (((this.inputFlags ^ o.inputFlags) & 3) != 0) {
                if (!Util.isTruthy(this.inputFlags & 3)) {
                    return false;
                }
                if (!Util.isTruthy(o.inputFlags & 3)) {
                    return true;
                }
            }
            if (((this.inputFlags ^ o.inputFlags) & 0xC) != 0) {
                if (!Util.isTruthy(this.inputFlags & 0xC)) {
                    return false;
                }
                if (!Util.isTruthy(o.inputFlags & 0xC)) {
                    return true;
                }
            }
            if (this.keyboard != o.keyboard) {
                if (!Util.isTruthy(this.keyboard)) {
                    return false;
                }
                if (!Util.isTruthy(o.keyboard)) {
                    return true;
                }
            }
            if (this.navigation != o.navigation) {
                if (!Util.isTruthy(this.navigation)) {
                    return false;
                }
                if (!Util.isTruthy(o.navigation)) {
                    return true;
                }
            }
        }
        if (Util.isTruthy(this.screenSize()) || Util.isTruthy(o.screenSize())) {
            if (this.screenWidth != o.screenWidth) {
                if (!Util.isTruthy(this.screenWidth)) {
                    return false;
                }
                if (!Util.isTruthy(o.screenWidth)) {
                    return true;
                }
            }
            if (this.screenHeight != o.screenHeight) {
                if (!Util.isTruthy(this.screenHeight)) {
                    return false;
                }
                if (!Util.isTruthy(o.screenHeight)) {
                    return true;
                }
            }
        }
        if (Util.isTruthy(this.version()) || Util.isTruthy(o.version())) {
            if (this.sdkVersion != o.sdkVersion) {
                if (!Util.isTruthy(this.sdkVersion)) {
                    return false;
                }
                if (!Util.isTruthy(o.sdkVersion)) {
                    return true;
                }
            }
            if (this.minorVersion != o.minorVersion) {
                if (!Util.isTruthy(this.minorVersion)) {
                    return false;
                }
                if (!Util.isTruthy(o.minorVersion)) {
                    return true;
                }
            }
        }
        return false;
    }

    static {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "");
        map.put(1, "nowidecg");
        map.put(2, "widecg");
        COLOR_MODE_WIDE_COLOR_GAMUT_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(0, "");
        map.put(4, "lowdr");
        map.put(8, "highdr");
        COLOR_MODE_HDR_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(0, "");
        map.put(120, "ldpi");
        map.put(160, "mdpi");
        map.put(213, "tvdpi");
        map.put(240, "hdpi");
        map.put(320, "xhdpi");
        map.put(480, "xxhdpi");
        map.put(640, "xxxhdpi");
        map.put(65534, "anydpi");
        map.put(65535, "nodpi");
        DENSITY_DPI_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "nokeys");
        map.put(2, "qwerty");
        map.put(3, "12key");
        KEYBOARD_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "keysexposed");
        map.put(2, "keyshidden");
        map.put(3, "keyssoft");
        KEYBOARDHIDDEN_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "nonav");
        map.put(2, "dpad");
        map.put(3, "trackball");
        map.put(4, "wheel");
        NAVIGATION_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(4, "navexposed");
        map.put(8, "navhidden");
        NAVIGATIONHIDDEN_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "port");
        map.put(2, "land");
        ORIENTATION_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(64, "ldltr");
        map.put(128, "ldrtl");
        SCREENLAYOUT_LAYOUTDIR_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(16, "notlong");
        map.put(32, "long");
        SCREENLAYOUT_LONG_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "notround");
        map.put(2, "round");
        SCREENLAYOUT_ROUND_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "small");
        map.put(2, "normal");
        map.put(3, "large");
        map.put(4, "xlarge");
        SCREENLAYOUT_SIZE_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "notouch");
        map.put(3, "finger");
        TOUCHSCREEN_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(16, "notnight");
        map.put(32, "night");
        UI_MODE_NIGHT_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(2, "desk");
        map.put(3, "car");
        map.put(4, "television");
        map.put(5, "appliance");
        map.put(6, "watch");
        map.put(7, "vrheadset");
        UI_MODE_TYPE_VALUES = Collections.unmodifiableMap(map);
    }

    public static enum Type {
        MCC,
        MNC,
        LANGUAGE_STRING,
        LOCALE_SCRIPT_STRING,
        REGION_STRING,
        LOCALE_VARIANT_STRING,
        SCREEN_LAYOUT_DIRECTION,
        SMALLEST_SCREEN_WIDTH_DP,
        SCREEN_WIDTH_DP,
        SCREEN_HEIGHT_DP,
        SCREEN_LAYOUT_SIZE,
        SCREEN_LAYOUT_LONG,
        SCREEN_LAYOUT_ROUND,
        COLOR_MODE_WIDE_COLOR_GAMUT,
        COLOR_MODE_HDR,
        ORIENTATION,
        UI_MODE_TYPE,
        UI_MODE_NIGHT,
        DENSITY_DPI,
        TOUCHSCREEN,
        KEYBOARD_HIDDEN,
        KEYBOARD,
        NAVIGATION_HIDDEN,
        NAVIGATION,
        SCREEN_SIZE,
        SDK_VERSION;

    }

    static class LocaleParserState {
        State parserState = State.BASE;
        UnicodeState unicodeState = UnicodeState.NO_KEY;
    }

    static enum State {
        BASE,
        UNICODE_EXTENSION,
        IGNORE_THE_REST;

    }

    static enum UnicodeState {
        NO_KEY,
        EXPECT_KEY,
        IGNORE_KEY,
        NUMBERING_SYSTEM;

    }
}

