/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import org.robolectric.res.android.Ref;

class ResourceUtils {
    ResourceUtils() {
    }

    static int fix_package_id(int resid, int package_id) {
        return resid & 0xFFFFFF | package_id << 24;
    }

    static int get_package_id(int resid) {
        return resid >>> 24;
    }

    static int get_type_id(int resid) {
        return (resid & 0xFF0000) >>> 16;
    }

    static int get_entry_id(int resid) {
        return (short)(resid & 0xFFFF);
    }

    static boolean is_internal_resid(int resid) {
        return (resid & 0xFFFF0000) != 0 && (resid & 0xFF0000) == 0;
    }

    static boolean is_valid_resid(int resid) {
        return (resid & 0xFF0000) != 0 && (resid & 0xFF000000) != 0;
    }

    static int make_resid(byte package_id, byte type_id, short entry_id) {
        return package_id << 24 | type_id << 16 | entry_id;
    }

    static boolean ExtractResourceName(String str, Ref<String> out_package, Ref<String> out_type, Ref<String> out_entry) {
        out_package.set("");
        out_type.set("");
        boolean has_package_separator = false;
        boolean has_type_separator = false;
        int start = 0;
        int end = start + str.length();
        for (int current = start; current != end; ++current) {
            if (out_type.get().length() == 0 && str.charAt(current) == '/') {
                has_type_separator = true;
                out_type.set(str.substring(start, current));
                start = current + 1;
                continue;
            }
            if (out_package.get().length() != 0 || str.charAt(current) != ':') continue;
            has_package_separator = true;
            out_package.set(str.substring(start, current));
            start = current + 1;
        }
        out_entry.set(str.substring(start, end));
        return !(has_package_separator && out_package.get().isEmpty() || has_type_separator && out_type.get().isEmpty());
    }
}

