/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.internal;

import android.os.Build;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static String[] parseStringArrayProperty(String property) {
        if (property.isEmpty()) {
            return new String[0];
        }
        return property.split("[, ]+");
    }

    public static int[] parseSdkArrayProperty(String property) {
        String[] parts = ConfigUtils.parseStringArrayProperty(property);
        int[] result = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = ConfigUtils.parseSdkInt(parts[i]);
        }
        return result;
    }

    public static int parseSdkInt(String part) {
        String spec;
        switch (spec = part.trim()) {
            case "ALL_SDKS": {
                return -2;
            }
            case "TARGET_SDK": {
                return -3;
            }
            case "OLDEST_SDK": {
                return -4;
            }
            case "NEWEST_SDK": {
                return -5;
            }
        }
        try {
            return Integer.parseInt(spec);
        }
        catch (NumberFormatException e) {
            try {
                return (Integer)Build.VERSION_CODES.class.getField(part).get(null);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("unknown SDK \"" + part + "\"");
            }
        }
    }
}

