/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainerShortIterator;
import org.roaringbitmap.buffer.RawMappeableRunContainerShortIterator;
import org.roaringbitmap.buffer.RawReverseMappeableRunContainerShortIterator;
import org.roaringbitmap.buffer.ReverseMappeableRunContainerShortIterator;

public final class MappeableRunContainer
extends MappeableContainer
implements Cloneable {
    private static final int DEFAULT_INIT_SIZE = 4;
    protected ShortBuffer valueslength;
    protected int nbrruns = 0;
    private static final long serialVersionUID = 1L;

    private MappeableRunContainer(int nbrruns, ShortBuffer valueslength) {
        this.nbrruns = nbrruns;
        ShortBuffer tmp = valueslength.duplicate();
        this.valueslength = ShortBuffer.allocate(Math.max(2 * nbrruns, tmp.limit()));
        tmp.rewind();
        this.valueslength.put(tmp);
    }

    public MappeableRunContainer(ShortBuffer array, int numRuns) {
        if (array.limit() < 2 * numRuns) {
            throw new RuntimeException("Mismatch between buffer and numRuns");
        }
        this.nbrruns = numRuns;
        this.valueslength = array;
    }

    protected MappeableRunContainer(ShortIterator sIt, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = ShortBuffer.allocate(2 * nbrRuns);
        if (nbrRuns == 0) {
            return;
        }
        int prevVal = -2;
        int runLen = 0;
        int runCount = 0;
        while (sIt.hasNext()) {
            int curVal = BufferUtil.toIntUnsigned(sIt.next());
            if (curVal == prevVal + 1) {
                ++runLen;
            } else {
                if (runCount > 0) {
                    this.setLength(runCount - 1, (short)runLen);
                }
                this.setValue(runCount, (short)curVal);
                runLen = 0;
                ++runCount;
            }
            prevVal = curVal;
        }
        this.setLength(runCount - 1, (short)runLen);
    }

    protected MappeableRunContainer(MappeableBitmapContainer bc, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = ShortBuffer.allocate(2 * nbrRuns);
        if (!BufferUtil.isBackedBySimpleArray(this.valueslength)) {
            throw new RuntimeException("Unexpected internal error.");
        }
        short[] vl = this.valueslength.array();
        if (nbrRuns == 0) {
            return;
        }
        if (bc.isArrayBacked()) {
            long[] b = bc.bitmap.array();
            int longCtr = 0;
            long curWord = b[0];
            int runCount = 0;
            int len = bc.bitmap.limit();
            while (true) {
                if (curWord == 0L && longCtr < len - 1) {
                    curWord = b[++longCtr];
                    continue;
                }
                if (curWord == 0L) {
                    return;
                }
                int localRunStart = Long.numberOfTrailingZeros(curWord);
                int runStart = localRunStart + 64 * longCtr;
                long curWordWith1s = curWord | (1L << runStart) - 1L;
                int runEnd = 0;
                while (curWordWith1s == -1L && longCtr < len - 1) {
                    curWordWith1s = b[++longCtr];
                }
                if (curWordWith1s == -1L) {
                    runEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL) + longCtr * 64;
                    vl[2 * runCount] = (short)runStart;
                    vl[2 * runCount + 1] = (short)(runEnd - runStart - 1);
                    return;
                }
                int localRunEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL);
                runEnd = localRunEnd + longCtr * 64;
                vl[2 * runCount] = (short)runStart;
                vl[2 * runCount + 1] = (short)(runEnd - runStart - 1);
                ++runCount;
                curWord = curWordWith1s >>> localRunEnd << localRunEnd;
            }
        }
        int longCtr = 0;
        long curWord = bc.bitmap.get(0);
        int runCount = 0;
        int len = bc.bitmap.limit();
        while (true) {
            if (curWord == 0L && longCtr < len - 1) {
                curWord = bc.bitmap.get(++longCtr);
                continue;
            }
            if (curWord == 0L) {
                return;
            }
            int localRunStart = Long.numberOfTrailingZeros(curWord);
            int runStart = localRunStart + 64 * longCtr;
            long curWordWith1s = curWord | (1L << runStart) - 1L;
            int runEnd = 0;
            while (curWordWith1s == -1L && longCtr < len - 1) {
                curWordWith1s = bc.bitmap.get(++longCtr);
            }
            if (curWordWith1s == -1L) {
                runEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL) + longCtr * 64;
                vl[2 * runCount] = (short)runStart;
                vl[2 * runCount + 1] = (short)(runEnd - runStart - 1);
                return;
            }
            int localRunEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL);
            runEnd = localRunEnd + longCtr * 64;
            vl[2 * runCount] = (short)runStart;
            vl[2 * runCount + 1] = (short)(runEnd - runStart - 1);
            ++runCount;
            curWord = curWordWith1s >>> localRunEnd << localRunEnd;
        }
    }

    @Override
    int numberOfRuns() {
        return this.nbrruns;
    }

    MappeableContainer toBitmapOrArrayContainer(int card) {
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                int runEnd = runStart + BufferUtil.toIntUnsigned(this.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content.put(answer.cardinality++, (short)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    private MappeableContainer toEfficientContainer() {
        int card;
        int sizeAsArrayContainer;
        int sizeAsBitmapContainer;
        int sizeAsRunContainer = MappeableRunContainer.serializedSizeInBytes(this.nbrruns);
        if (sizeAsRunContainer <= Math.min(sizeAsBitmapContainer = MappeableBitmapContainer.serializedSizeInBytes(0), sizeAsArrayContainer = MappeableArrayContainer.serializedSizeInBytes(card = this.getCardinality()))) {
            return this;
        }
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                int runEnd = runStart + BufferUtil.toIntUnsigned(this.getLength(rlepos));
                if (BufferUtil.isBackedBySimpleArray(answer.content)) {
                    short[] ba = answer.content.array();
                    for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                        ba[answer.cardinality++] = (short)runValue;
                    }
                    continue;
                }
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content.put(answer.cardinality++, (short)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    private MappeableContainer toBitmapIfNeeded() {
        int sizeAsRunContainer = MappeableRunContainer.serializedSizeInBytes(this.nbrruns);
        int sizeAsBitmapContainer = MappeableBitmapContainer.serializedSizeInBytes(0);
        if (sizeAsBitmapContainer > sizeAsRunContainer) {
            return this;
        }
        int card = this.getCardinality();
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    @Override
    public MappeableContainer runOptimize() {
        int currentSize = this.getArraySizeInBytes();
        int card = this.getCardinality();
        if (card <= 4096 ? currentSize > MappeableArrayContainer.getArraySizeInBytes(card) : currentSize > MappeableBitmapContainer.getArraySizeInBytes(card)) {
            return this.toBitmapOrArrayContainer(card);
        }
        return this;
    }

    private void increaseCapacity() {
        int newCapacity = this.valueslength.capacity() == 0 ? 4 : (this.valueslength.capacity() < 64 ? this.valueslength.capacity() * 2 : (this.valueslength.capacity() < 1024 ? this.valueslength.capacity() * 3 / 2 : this.valueslength.capacity() * 5 / 4));
        ShortBuffer nv = ShortBuffer.allocate(newCapacity);
        this.valueslength.rewind();
        nv.put(this.valueslength);
        this.valueslength = nv;
    }

    private void copyToOffset(int offset) {
        int minCapacity = 2 * (offset + this.nbrruns);
        if (this.valueslength.capacity() < minCapacity) {
            int newCapacity = this.valueslength.capacity();
            while (newCapacity < minCapacity) {
                newCapacity = newCapacity == 0 ? 4 : (newCapacity < 64 ? newCapacity * 2 : (newCapacity < 1024 ? newCapacity * 3 / 2 : newCapacity * 5 / 4));
            }
            ShortBuffer newvalueslength = ShortBuffer.allocate(newCapacity);
            this.copyValuesLength(this.valueslength, 0, newvalueslength, offset, this.nbrruns);
            this.valueslength = newvalueslength;
        } else {
            this.copyValuesLength(this.valueslength, 0, this.valueslength, offset, this.nbrruns);
        }
    }

    protected void ensureCapacity(int minNbRuns) {
        int minCapacity = 2 * minNbRuns;
        if (this.valueslength.capacity() < minCapacity) {
            int newCapacity = this.valueslength.capacity();
            while (newCapacity < minCapacity) {
                newCapacity = newCapacity == 0 ? 4 : (newCapacity < 64 ? newCapacity * 2 : (newCapacity < 1024 ? newCapacity * 3 / 2 : newCapacity * 5 / 4));
            }
            ShortBuffer nv = ShortBuffer.allocate(newCapacity);
            this.valueslength.rewind();
            nv.put(this.valueslength);
            this.valueslength = nv;
        }
    }

    public MappeableRunContainer() {
        this(4);
    }

    public MappeableRunContainer(int capacity) {
        this.valueslength = ShortBuffer.allocate(2 * capacity);
    }

    @Override
    public Iterator<Short> iterator() {
        final ShortIterator i = this.getShortIterator();
        return new Iterator<Short>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Short next() {
                return i.next();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(Short.reverseBytes((short)this.nbrruns));
        for (int k = 0; k < 2 * this.nbrruns; ++k) {
            out.writeShort(Short.reverseBytes(this.valueslength.get(k)));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nbrruns = 0xFFFF & Short.reverseBytes(in.readShort());
        if (this.valueslength.capacity() < 2 * this.nbrruns) {
            this.valueslength = ShortBuffer.allocate(2 * this.nbrruns);
        }
        for (int k = 0; k < 2 * this.nbrruns; ++k) {
            this.valueslength.put(k, Short.reverseBytes(in.readShort()));
        }
    }

    @Override
    public MappeableContainer flip(short x) {
        if (this.contains(x)) {
            return this.remove(x);
        }
        return this.add(x);
    }

    @Override
    public MappeableContainer add(short k) {
        int index = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, k);
        if (index >= 0) {
            return this;
        }
        if ((index = -index - 2) >= 0) {
            int le;
            int offset = BufferUtil.toIntUnsigned(k) - BufferUtil.toIntUnsigned(this.getValue(index));
            if (offset <= (le = BufferUtil.toIntUnsigned(this.getLength(index)))) {
                return this;
            }
            if (offset == le + 1) {
                if (index + 1 < this.nbrruns && BufferUtil.toIntUnsigned(this.getValue(index + 1)) == BufferUtil.toIntUnsigned(k) + 1) {
                    this.setLength(index, (short)(this.getValue(index + 1) + this.getLength(index + 1) - this.getValue(index)));
                    this.recoverRoomAtIndex(index + 1);
                    return this;
                }
                this.incrementLength(index);
                return this;
            }
            if (index + 1 < this.nbrruns && BufferUtil.toIntUnsigned(this.getValue(index + 1)) == BufferUtil.toIntUnsigned(k) + 1) {
                this.setValue(index + 1, k);
                this.setLength(index + 1, (short)(this.getLength(index + 1) + 1));
                return this;
            }
        }
        if (index == -1 && 0 < this.nbrruns && this.getValue(0) == k + 1) {
            this.incrementLength(0);
            this.decrementValue(0);
            return this;
        }
        this.makeRoomAtIndex(index + 1);
        this.setValue(index + 1, k);
        this.setLength(index + 1, (short)0);
        return this;
    }

    @Override
    public MappeableContainer add(int begin, int end) {
        MappeableRunContainer rc = (MappeableRunContainer)this.clone();
        return rc.iadd(begin, end);
    }

    @Override
    public MappeableContainer and(MappeableArrayContainer x) {
        MappeableArrayContainer ac = new MappeableArrayContainer(x.cardinality);
        if (this.nbrruns == 0) {
            return ac;
        }
        int rlepos = 0;
        int arraypos = 0;
        int rleval = BufferUtil.toIntUnsigned(this.getValue(rlepos));
        int rlelength = BufferUtil.toIntUnsigned(this.getLength(rlepos));
        while (arraypos < x.cardinality) {
            int arrayval = BufferUtil.toIntUnsigned(x.content.get(arraypos));
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return ac;
                }
                rleval = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                rlelength = BufferUtil.toIntUnsigned(this.getLength(rlepos));
            }
            if (rleval > arrayval) {
                arraypos = BufferUtil.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            ac.content.put(ac.cardinality, (short)arrayval);
            ++ac.cardinality;
            ++arraypos;
        }
        return ac;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                int runEnd = runStart + BufferUtil.toIntUnsigned(this.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (!x.contains((short)runValue)) continue;
                    answer.content.put(answer.cardinality++, (short)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = x.clone();
        int start = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int end = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            BufferUtil.resetBitmapRange(answer.bitmap, start, end);
            start = end + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
        }
        BufferUtil.resetBitmapRange(answer.bitmap, start, BufferUtil.maxLowBitAsInteger() + 1);
        answer.computeCardinality();
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public MappeableContainer andNot(MappeableBitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                int runEnd = runStart + BufferUtil.toIntUnsigned(this.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (x.contains((short)runValue)) continue;
                    answer.content.put(answer.cardinality++, (short)runValue);
                }
            }
            return answer;
        }
        MappeableBitmapContainer answer = x.clone();
        int lastPos = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
            BufferUtil.resetBitmapRange(answer.bitmap, lastPos, start);
            BufferUtil.flipBitmapRange(answer.bitmap, start, end);
            lastPos = end;
        }
        BufferUtil.resetBitmapRange(answer.bitmap, lastPos, answer.bitmap.capacity() * 64);
        answer.computeCardinality();
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public MappeableContainer andNot(MappeableArrayContainer x) {
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.lazyandNot(x).toEfficientContainer();
        }
        int card = this.getCardinality();
        if (card <= 4096) {
            MappeableArrayContainer ac = new MappeableArrayContainer(card);
            ac.cardinality = Util.unsignedDifference(this.getShortIterator(), x.getShortIterator(), ac.content.array());
            return ac;
        }
        return this.toBitmapOrArrayContainer(card).iandNot(x);
    }

    @Override
    public void clear() {
        this.nbrruns = 0;
    }

    @Override
    public MappeableContainer clone() {
        return new MappeableRunContainer(this.nbrruns, this.valueslength);
    }

    @Override
    public boolean contains(short x) {
        int le;
        int offset;
        int index = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            return true;
        }
        return (index = -index - 2) != -1 && (offset = BufferUtil.toIntUnsigned(x) - BufferUtil.toIntUnsigned(this.getValue(index))) <= (le = BufferUtil.toIntUnsigned(this.getLength(index)));
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        for (int k = 0; k < this.nbrruns; ++k) {
            int limit = BufferUtil.toIntUnsigned(this.getLength(k));
            int base = BufferUtil.toIntUnsigned(this.getValue(k));
            for (int le = 0; le <= limit; ++le) {
                x[pos++] = base + le | mask;
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return 2 + 4 * this.nbrruns;
    }

    protected static int getArraySizeInBytes(int nbrruns) {
        return 2 + 4 * nbrruns;
    }

    @Override
    public int getCardinality() {
        int sum = 0;
        if (this.isArrayBacked()) {
            short[] vl = this.valueslength.array();
            for (int k = 0; k < this.nbrruns; ++k) {
                sum = sum + BufferUtil.toIntUnsigned(vl[2 * k + 1]) + 1;
            }
        } else {
            for (int k = 0; k < this.nbrruns; ++k) {
                sum = sum + BufferUtil.toIntUnsigned(this.getLength(k)) + 1;
            }
        }
        return sum;
    }

    @Override
    public ShortIterator getShortIterator() {
        if (this.isArrayBacked()) {
            return new RawMappeableRunContainerShortIterator(this);
        }
        return new MappeableRunContainerShortIterator(this);
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        if (this.isArrayBacked()) {
            return new RawReverseMappeableRunContainerShortIterator(this);
        }
        return new ReverseMappeableRunContainerShortIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.nbrruns * 4 + 4;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.nbrruns * 2; ++k) {
            hash += 31 * hash + this.valueslength.get(k);
        }
        return hash;
    }

    @Override
    public MappeableContainer iand(MappeableArrayContainer x) {
        return this.and(x);
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer x) {
        return this.and(x);
    }

    @Override
    public MappeableContainer iandNot(MappeableArrayContainer x) {
        return this.andNot(x);
    }

    @Override
    public MappeableContainer iandNot(MappeableBitmapContainer x) {
        return this.andNot(x);
    }

    @Override
    public MappeableContainer inot(int rangeStart, int rangeEnd) {
        if (rangeEnd <= rangeStart) {
            return this;
        }
        return this.not(rangeStart, rangeEnd);
    }

    @Override
    public MappeableContainer ior(MappeableArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        short[] vl = this.valueslength.array();
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableShortIterator i = (PeekableShortIterator)x.getShortIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (BufferUtil.compareUnsigned(MappeableRunContainer.getValue(vl, rlepos + offset), i.peekNext()) <= 0) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(vl, i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(vl, i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
            }
        }
        return this.toEfficientContainer();
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.or(x);
    }

    @Override
    public MappeableContainer ixor(MappeableArrayContainer x) {
        return this.xor(x);
    }

    @Override
    public MappeableContainer ixor(MappeableBitmapContainer x) {
        return this.xor(x);
    }

    @Override
    public MappeableContainer not(int rangeStart, int rangeEnd) {
        int k;
        if (rangeEnd <= rangeStart) {
            return this.clone();
        }
        MappeableRunContainer ans = new MappeableRunContainer(this.nbrruns + 1);
        if (!ans.isArrayBacked()) {
            throw new RuntimeException("internal bug");
        }
        short[] vl = ans.valueslength.array();
        for (k = 0; k < this.nbrruns && BufferUtil.toIntUnsigned(this.getValue(k)) < rangeStart; ++k) {
            vl[2 * k] = this.getValue(k);
            vl[2 * k + 1] = this.getLength(k);
            ++ans.nbrruns;
        }
        ans.smartAppendExclusive(vl, (short)rangeStart, (short)(rangeEnd - rangeStart - 1));
        while (k < this.nbrruns) {
            ans.smartAppendExclusive(vl, this.getValue(k), this.getLength(k));
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public MappeableContainer or(MappeableArrayContainer x) {
        return this.lazyorToRun(x).repairAfterLazy();
    }

    protected boolean isFull() {
        return this.nbrruns == 1 && this.getValue(0) == 0 && this.getLength(0) == -1;
    }

    protected MappeableContainer ilazyor(MappeableArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.ilazyorToRun(x);
    }

    protected MappeableContainer lazyor(MappeableArrayContainer x) {
        return this.lazyorToRun(x);
    }

    private MappeableContainer lazyorToRun(MappeableArrayContainer x) {
        if (this.isFull()) {
            return this.clone();
        }
        MappeableRunContainer answer = new MappeableRunContainer(ShortBuffer.allocate(2 * (this.nbrruns + x.getCardinality())), 0);
        short[] vl = answer.valueslength.array();
        int rlepos = 0;
        PeekableShortIterator i = (PeekableShortIterator)x.getShortIterator();
        while (rlepos < this.nbrruns && i.hasNext()) {
            if (BufferUtil.compareUnsigned(this.getValue(rlepos), i.peekNext()) <= 0) {
                answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(vl, i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                answer.smartAppend(vl, i.next());
            }
        } else {
            while (rlepos < this.nbrruns) {
                answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
            }
        }
        return answer.convertToLazyBitmapIfNeeded();
    }

    private MappeableContainer ilazyorToRun(MappeableArrayContainer x) {
        if (this.isFull()) {
            return this.clone();
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        short[] vl = this.valueslength.array();
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableShortIterator i = (PeekableShortIterator)x.getShortIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (BufferUtil.compareUnsigned(MappeableRunContainer.getValue(vl, rlepos + offset), i.peekNext()) <= 0) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(vl, i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(vl, i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(vl, MappeableRunContainer.getValue(vl, rlepos + offset), MappeableRunContainer.getLength(vl, rlepos + offset));
                ++rlepos;
            }
        }
        return this.convertToLazyBitmapIfNeeded();
    }

    private MappeableContainer lazyxor(MappeableArrayContainer x) {
        if (x.getCardinality() == 0) {
            return this;
        }
        if (this.nbrruns == 0) {
            return x;
        }
        MappeableRunContainer answer = new MappeableRunContainer(ShortBuffer.allocate(2 * (this.nbrruns + x.getCardinality())), 0);
        short[] vl = answer.valueslength.array();
        int rlepos = 0;
        ShortIterator i = x.getShortIterator();
        short cv = i.next();
        while (true) {
            if (BufferUtil.compareUnsigned(this.getValue(rlepos), cv) < 0) {
                answer.smartAppendExclusive(vl, this.getValue(rlepos), this.getLength(rlepos));
                if (++rlepos != this.nbrruns) continue;
                answer.smartAppendExclusive(vl, cv);
                while (i.hasNext()) {
                    answer.smartAppendExclusive(vl, i.next());
                }
                break;
            }
            answer.smartAppendExclusive(vl, cv);
            if (!i.hasNext()) {
                while (rlepos < this.nbrruns) {
                    answer.smartAppendExclusive(vl, this.getValue(rlepos), this.getLength(rlepos));
                    ++rlepos;
                }
                break;
            }
            cv = i.next();
        }
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer x) {
        if (this.isFull()) {
            return this.clone();
        }
        MappeableBitmapContainer answer = x.clone();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
            BufferUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.computeCardinality();
        return answer;
    }

    @Override
    public MappeableContainer remove(short x) {
        int index = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            int le = BufferUtil.toIntUnsigned(this.getLength(index));
            if (le == 0) {
                this.recoverRoomAtIndex(index);
            } else {
                this.incrementValue(index);
                this.decrementLength(index);
            }
            return this;
        }
        if ((index = -index - 2) >= 0) {
            int le;
            int offset = BufferUtil.toIntUnsigned(x) - BufferUtil.toIntUnsigned(this.getValue(index));
            if (offset < (le = BufferUtil.toIntUnsigned(this.getLength(index)))) {
                this.setLength(index, (short)(offset - 1));
                int newvalue = BufferUtil.toIntUnsigned(x) + 1;
                int newlength = le - offset - 1;
                this.makeRoomAtIndex(index + 1);
                this.setValue(index + 1, (short)newvalue);
                this.setLength(index + 1, (short)newlength);
                return this;
            }
            if (offset == le) {
                this.decrementLength(index);
            }
        }
        return this;
    }

    @Override
    public int serializedSizeInBytes() {
        return MappeableRunContainer.serializedSizeInBytes(this.nbrruns);
    }

    protected static int serializedSizeInBytes(int numberOfRuns) {
        return 2 + 4 * numberOfRuns;
    }

    @Override
    public void trim() {
        if (this.valueslength.limit() == 2 * this.nbrruns) {
            return;
        }
        if (BufferUtil.isBackedBySimpleArray(this.valueslength)) {
            this.valueslength = ShortBuffer.wrap(Arrays.copyOf(this.valueslength.array(), 2 * this.nbrruns));
        } else {
            ShortBuffer co = ShortBuffer.allocate(2 * this.nbrruns);
            short[] a = co.array();
            for (int k = 0; k < 2 * this.nbrruns; ++k) {
                a[k] = this.valueslength.get(k);
            }
            this.valueslength = co;
        }
    }

    @Override
    protected boolean isArrayBacked() {
        return BufferUtil.isBackedBySimpleArray(this.valueslength);
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        out.writeShort(Short.reverseBytes((short)this.nbrruns));
        for (int k = 0; k < 2 * this.nbrruns; ++k) {
            out.writeShort(Short.reverseBytes(this.valueslength.get(k)));
        }
    }

    @Override
    public MappeableContainer xor(MappeableArrayContainer x) {
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.lazyxor(x).repairAfterLazy();
        }
        int card = this.getCardinality();
        if (card <= 4096) {
            return x.xor(this.getShortIterator());
        }
        return this.toBitmapOrArrayContainer(card).ixor(x);
    }

    @Override
    public MappeableContainer xor(MappeableBitmapContainer x) {
        MappeableBitmapContainer answer = x.clone();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
            BufferUtil.flipBitmapRange(answer.bitmap, start, end);
        }
        answer.computeCardinality();
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public int rank(short lowbits) {
        int x = BufferUtil.toIntUnsigned(lowbits);
        int answer = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            int value = BufferUtil.toIntUnsigned(this.getValue(k));
            int length = BufferUtil.toIntUnsigned(this.getLength(k));
            if (x < value) {
                return answer;
            }
            if (value + length + 1 >= x) {
                return answer + x - value + 1;
            }
            answer += length + 1;
        }
        return answer;
    }

    @Override
    public short select(int j) {
        int offset = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            int nextOffset = offset + BufferUtil.toIntUnsigned(this.getLength(k)) + 1;
            if (nextOffset > j) {
                return (short)(this.getValue(k) + (j - offset));
            }
            offset = nextOffset;
        }
        throw new IllegalArgumentException("Cannot select " + j + " since cardinality is " + this.getCardinality());
    }

    @Override
    public MappeableContainer limit(int maxcardinality) {
        int r;
        if (maxcardinality >= this.getCardinality()) {
            return this.clone();
        }
        int cardinality = 0;
        for (r = 1; r <= this.nbrruns && maxcardinality > (cardinality += BufferUtil.toIntUnsigned(this.getLength(r)) + 1); ++r) {
        }
        ShortBuffer newBuf = ShortBuffer.allocate(2 * maxcardinality);
        for (int i = 0; i < 2 * r; ++i) {
            newBuf.put(this.valueslength.get(i));
        }
        MappeableRunContainer rc = new MappeableRunContainer(newBuf, r);
        rc.setLength(r - 1, (short)(BufferUtil.toIntUnsigned(rc.getLength(r - 1)) - cardinality + maxcardinality));
        return rc;
    }

    @Override
    public MappeableContainer iadd(int begin, int end) {
        if (begin >= end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            this.add((short)begin);
            return this;
        }
        int bIndex = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)begin);
        int eIndex = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)(end - 1));
        if (bIndex >= 0 && eIndex >= 0) {
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (bIndex >= 0 && eIndex < 0) {
            if (this.canPrependValueLength(end - 1, (eIndex = -eIndex - 2) + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (bIndex < 0 && eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin - 1, bIndex)) {
                this.mergeValuesLength(bIndex, eIndex);
                return this;
            }
            this.prependValueLength(begin, bIndex + 1);
            this.mergeValuesLength(bIndex + 1, eIndex);
            return this;
        }
        bIndex = -bIndex - 2;
        if ((eIndex = -eIndex - 2) >= 0) {
            if (bIndex >= 0) {
                if (!this.valueLengthContains(begin - 1, bIndex)) {
                    if (bIndex == eIndex) {
                        if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                            this.prependValueLength(begin, eIndex + 1);
                            return this;
                        }
                        this.makeRoomAtIndex(eIndex + 1);
                        this.setValue(eIndex + 1, (short)begin);
                        this.setLength(eIndex + 1, (short)(end - 1 - begin));
                        return this;
                    }
                    this.prependValueLength(begin, ++bIndex);
                }
            } else {
                bIndex = 0;
                this.prependValueLength(begin, bIndex);
            }
            if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (this.canPrependValueLength(end - 1, 0)) {
            this.prependValueLength(begin, 0);
        } else {
            this.makeRoomAtIndex(0);
            this.setValue(0, (short)begin);
            this.setLength(0, (short)(end - 1 - begin));
        }
        return this;
    }

    @Override
    public MappeableContainer iremove(int begin, int end) {
        if (begin >= end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            this.remove((short)begin);
            return this;
        }
        int bIndex = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)begin);
        int eIndex = MappeableRunContainer.bufferedUnsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)(end - 1));
        if (bIndex >= 0) {
            if (eIndex < 0) {
                eIndex = -eIndex - 2;
            }
            if (this.valueLengthContains(end, eIndex)) {
                this.initValueLength(end, eIndex);
                this.recoverRoomsInRange(bIndex - 1, eIndex - 1);
            } else {
                this.recoverRoomsInRange(bIndex - 1, eIndex);
            }
        } else if (bIndex < 0 && eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin, bIndex)) {
                this.closeValueLength(begin - 1, bIndex);
            }
            this.incrementValue(eIndex);
            this.decrementLength(eIndex);
            this.recoverRoomsInRange(bIndex, eIndex - 1);
        } else {
            bIndex = -bIndex - 2;
            if ((eIndex = -eIndex - 2) >= 0) {
                if (bIndex >= 0) {
                    if (bIndex == eIndex) {
                        if (this.valueLengthContains(begin, bIndex)) {
                            if (this.valueLengthContains(end, eIndex)) {
                                this.makeRoomAtIndex(bIndex);
                                this.closeValueLength(begin - 1, bIndex);
                                this.initValueLength(end, bIndex + 1);
                                return this;
                            }
                            this.closeValueLength(begin - 1, bIndex);
                        }
                    } else {
                        if (this.valueLengthContains(begin, bIndex)) {
                            this.closeValueLength(begin - 1, bIndex);
                        }
                        if (this.valueLengthContains(end, eIndex)) {
                            this.initValueLength(end, eIndex);
                            --eIndex;
                        }
                        this.recoverRoomsInRange(bIndex, eIndex);
                    }
                } else if (this.valueLengthContains(end, eIndex)) {
                    this.initValueLength(end, eIndex);
                    this.recoverRoomsInRange(bIndex, eIndex - 1);
                } else {
                    this.recoverRoomsInRange(bIndex, eIndex);
                }
            }
        }
        return this;
    }

    @Override
    public MappeableContainer remove(int begin, int end) {
        MappeableRunContainer rc = (MappeableRunContainer)this.clone();
        return rc.iremove(begin, end);
    }

    public boolean equals(Object o) {
        if (o instanceof MappeableRunContainer) {
            MappeableRunContainer srb = (MappeableRunContainer)o;
            if (srb.nbrruns != this.nbrruns) {
                return false;
            }
            for (int i = 0; i < this.nbrruns; ++i) {
                if (this.getValue(i) != srb.getValue(i)) {
                    return false;
                }
                if (this.getLength(i) == srb.getLength(i)) continue;
                return false;
            }
            return true;
        }
        if (o instanceof MappeableContainer) {
            if (((MappeableContainer)o).getCardinality() != this.getCardinality()) {
                return false;
            }
            ShortIterator me = this.getShortIterator();
            ShortIterator you = ((MappeableContainer)o).getShortIterator();
            while (me.hasNext()) {
                if (me.next() == you.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int bufferedUnsignedInterleavedBinarySearch(ShortBuffer sb, int begin, int end, short k) {
        int ikey = BufferUtil.toIntUnsigned(k);
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = BufferUtil.toIntUnsigned(sb.get(2 * middleIndex));
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    short getValue(int index) {
        return this.valueslength.get(2 * index);
    }

    short getLength(int index) {
        return this.valueslength.get(2 * index + 1);
    }

    static short getValue(short[] vl, int index) {
        return vl[2 * index];
    }

    static short getLength(short[] vl, int index) {
        return vl[2 * index + 1];
    }

    private void incrementLength(int index) {
        this.valueslength.put(2 * index + 1, (short)(1 + this.valueslength.get(2 * index + 1)));
    }

    private void incrementValue(int index) {
        this.valueslength.put(2 * index, (short)(1 + this.valueslength.get(2 * index)));
    }

    private void decrementLength(int index) {
        this.valueslength.put(2 * index + 1, (short)(this.valueslength.get(2 * index + 1) - 1));
    }

    private void decrementValue(int index) {
        this.valueslength.put(2 * index, (short)(this.valueslength.get(2 * index) - 1));
    }

    private void setLength(int index, short v) {
        this.setLength(this.valueslength, index, v);
    }

    private void setLength(ShortBuffer valueslength, int index, short v) {
        valueslength.put(2 * index + 1, v);
    }

    private void setValue(int index, short v) {
        this.setValue(this.valueslength, index, v);
    }

    private void setValue(ShortBuffer valueslength, int index, short v) {
        valueslength.put(2 * index, v);
    }

    private void makeRoomAtIndex(int index) {
        if (2 * (this.nbrruns + 1) > this.valueslength.capacity()) {
            this.increaseCapacity();
        }
        this.copyValuesLength(this.valueslength, index, this.valueslength, index + 1, this.nbrruns - index);
        ++this.nbrruns;
    }

    private void recoverRoomAtIndex(int index) {
        this.copyValuesLength(this.valueslength, index + 1, this.valueslength, index, this.nbrruns - index - 1);
        --this.nbrruns;
    }

    private void recoverRoomsInRange(int begin, int end) {
        if (end + 1 < this.nbrruns) {
            this.copyValuesLength(this.valueslength, end + 1, this.valueslength, begin + 1, this.nbrruns - 1 - end);
        }
        this.nbrruns -= end - begin;
    }

    private void mergeValuesLength(int begin, int end) {
        if (begin < end) {
            int bValue = BufferUtil.toIntUnsigned(this.getValue(begin));
            int eValue = BufferUtil.toIntUnsigned(this.getValue(end));
            int eLength = BufferUtil.toIntUnsigned(this.getLength(end));
            int newLength = eValue - bValue + eLength;
            this.setLength(begin, (short)newLength);
            this.recoverRoomsInRange(begin, end);
        }
    }

    private boolean canPrependValueLength(int value, int index) {
        int nextValue;
        return index < this.nbrruns && (nextValue = BufferUtil.toIntUnsigned(this.getValue(index))) == value + 1;
    }

    private void prependValueLength(int value, int index) {
        int initialValue = BufferUtil.toIntUnsigned(this.getValue(index));
        int length = BufferUtil.toIntUnsigned(this.getLength(index));
        this.setValue(index, (short)value);
        this.setLength(index, (short)(initialValue - value + length));
    }

    private void appendValueLength(int value, int index) {
        int length;
        int previousValue = BufferUtil.toIntUnsigned(this.getValue(index));
        int offset = value - previousValue;
        if (offset > (length = BufferUtil.toIntUnsigned(this.getLength(index)))) {
            this.setLength(index, (short)offset);
        }
    }

    private boolean valueLengthContains(int value, int index) {
        int length;
        int initialValue = BufferUtil.toIntUnsigned(this.getValue(index));
        return value <= initialValue + (length = BufferUtil.toIntUnsigned(this.getLength(index)));
    }

    private void initValueLength(int value, int index) {
        int initialValue = BufferUtil.toIntUnsigned(this.getValue(index));
        int length = BufferUtil.toIntUnsigned(this.getLength(index));
        this.setValue(index, (short)value);
        this.setLength(index, (short)(length - (value - initialValue)));
    }

    private void closeValueLength(int value, int index) {
        int initialValue = BufferUtil.toIntUnsigned(this.getValue(index));
        this.setLength(index, (short)(value - initialValue));
    }

    private void copyValuesLength(ShortBuffer src, int srcIndex, ShortBuffer dst, int dstIndex, int length) {
        int i;
        if (BufferUtil.isBackedBySimpleArray(src) && BufferUtil.isBackedBySimpleArray(dst)) {
            System.arraycopy(src.array(), 2 * srcIndex, dst.array(), 2 * dstIndex, 2 * length);
            return;
        }
        ShortBuffer temp = ShortBuffer.allocate(2 * length);
        for (i = 0; i < 2 * length; ++i) {
            temp.put(src.get(2 * srcIndex + i));
        }
        temp.flip();
        for (i = 0; i < 2 * length; ++i) {
            dst.put(2 * dstIndex + i, temp.get());
        }
    }

    @Override
    public MappeableContainer and(MappeableRunContainer x) {
        MappeableRunContainer answer = new MappeableRunContainer(ShortBuffer.allocate(2 * (this.nbrruns + x.nbrruns)), 0);
        short[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
        int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            int lateststart;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            int n = lateststart = start > xstart ? start : xstart;
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                    end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                    end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            }
            vl[2 * answer.nbrruns] = (short)lateststart;
            vl[2 * answer.nbrruns + 1] = (short)(earliestend - lateststart - 1);
            ++answer.nbrruns;
        }
        return answer;
    }

    @Override
    public MappeableContainer andNot(MappeableRunContainer x) {
        MappeableRunContainer answer = new MappeableRunContainer(ShortBuffer.allocate(2 * (this.nbrruns + x.nbrruns)), 0);
        short[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
        int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                vl[2 * answer.nbrruns] = (short)start;
                vl[2 * answer.nbrruns + 1] = (short)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            if (start < xstart) {
                vl[2 * answer.nbrruns] = (short)start;
                vl[2 * answer.nbrruns + 1] = (short)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xend < end) {
                start = xend;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
        }
        if (rlepos < this.nbrruns) {
            vl[2 * answer.nbrruns] = (short)start;
            vl[2 * answer.nbrruns + 1] = (short)(end - start - 1);
            ++answer.nbrruns;
            ++rlepos;
            while (rlepos < this.nbrruns) {
                vl[2 * answer.nbrruns] = this.valueslength.get(2 * rlepos);
                vl[2 * answer.nbrruns + 1] = this.valueslength.get(2 * rlepos + 1);
                ++answer.nbrruns;
                ++rlepos;
            }
        }
        return answer;
    }

    private MappeableRunContainer lazyandNot(MappeableArrayContainer x) {
        if (x.getCardinality() == 0) {
            return this;
        }
        MappeableRunContainer answer = new MappeableRunContainer(ShortBuffer.allocate(2 * (this.nbrruns + x.cardinality)), 0);
        short[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
        int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = BufferUtil.toIntUnsigned(x.content.get(xrlepos));
        while (rlepos < this.nbrruns && xrlepos < x.cardinality) {
            if (end <= xstart) {
                vl[2 * answer.nbrruns] = (short)start;
                vl[2 * answer.nbrruns + 1] = (short)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xstart + 1 <= start) {
                if (++xrlepos >= x.cardinality) continue;
                xstart = BufferUtil.toIntUnsigned(x.content.get(xrlepos));
                continue;
            }
            if (start < xstart) {
                vl[2 * answer.nbrruns] = (short)start;
                vl[2 * answer.nbrruns + 1] = (short)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xstart + 1 < end) {
                start = xstart + 1;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
        }
        if (rlepos < this.nbrruns) {
            vl[2 * answer.nbrruns] = (short)start;
            vl[2 * answer.nbrruns + 1] = (short)(end - start - 1);
            ++answer.nbrruns;
            ++rlepos;
            while (rlepos < this.nbrruns) {
                vl[2 * answer.nbrruns] = this.valueslength.get(2 * rlepos);
                vl[2 * answer.nbrruns + 1] = this.valueslength.get(2 * rlepos + 1);
                ++answer.nbrruns;
                ++rlepos;
            }
        }
        return answer;
    }

    @Override
    public MappeableContainer iand(MappeableRunContainer x) {
        return this.and(x);
    }

    @Override
    public MappeableContainer iandNot(MappeableRunContainer x) {
        return this.andNot(x);
    }

    @Override
    public MappeableContainer ior(MappeableRunContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int xnbrruns = x.nbrruns;
        int offset = Math.max(nbrruns, xnbrruns);
        this.copyToOffset(offset);
        this.nbrruns = 0;
        int rlepos = 0;
        int xrlepos = 0;
        short[] vl = this.valueslength.array();
        while (rlepos < nbrruns && xrlepos < xnbrruns) {
            short value = MappeableRunContainer.getValue(vl, offset + rlepos);
            short xvalue = x.getValue(xrlepos);
            short length = MappeableRunContainer.getLength(vl, offset + rlepos);
            short xlength = x.getLength(xrlepos);
            if (BufferUtil.compareUnsigned(value, xvalue) <= 0) {
                this.smartAppend(vl, value, length);
                ++rlepos;
                continue;
            }
            this.smartAppend(vl, xvalue, xlength);
            ++xrlepos;
        }
        while (rlepos < nbrruns) {
            this.smartAppend(vl, MappeableRunContainer.getValue(vl, offset + rlepos), MappeableRunContainer.getLength(vl, offset + rlepos));
            ++rlepos;
        }
        while (xrlepos < xnbrruns) {
            this.smartAppend(vl, x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        return this.toBitmapIfNeeded();
    }

    @Override
    public MappeableContainer ixor(MappeableRunContainer x) {
        return this.xor(x);
    }

    private void smartAppend(short[] vl, short start, short length) {
        int oldend;
        block5: {
            block4: {
                if (this.nbrruns == 0) break block4;
                oldend = BufferUtil.toIntUnsigned(vl[2 * (this.nbrruns - 1)]) + BufferUtil.toIntUnsigned(vl[2 * (this.nbrruns - 1) + 1]);
                if (BufferUtil.toIntUnsigned(start) <= oldend + 1) break block5;
            }
            vl[2 * this.nbrruns] = start;
            vl[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        int newend = BufferUtil.toIntUnsigned(start) + BufferUtil.toIntUnsigned(length) + 1;
        if (newend > oldend) {
            vl[2 * (this.nbrruns - 1) + 1] = (short)(newend - 1 - BufferUtil.toIntUnsigned(vl[2 * (this.nbrruns - 1)]));
        }
    }

    private void smartAppendExclusive(short[] vl, short start, short length) {
        int oldend;
        block11: {
            block10: {
                if (this.nbrruns == 0) break block10;
                oldend = BufferUtil.toIntUnsigned(this.getValue(this.nbrruns - 1)) + BufferUtil.toIntUnsigned(this.getLength(this.nbrruns - 1)) + 1;
                if (BufferUtil.toIntUnsigned(start) <= oldend) break block11;
            }
            vl[2 * this.nbrruns] = start;
            vl[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        if (oldend == BufferUtil.toIntUnsigned(start)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            vl[n] = (short)(vl[n] + (length + 1));
            return;
        }
        int newend = BufferUtil.toIntUnsigned(start) + BufferUtil.toIntUnsigned(length) + 1;
        if (BufferUtil.toIntUnsigned(start) == BufferUtil.toIntUnsigned(this.getValue(this.nbrruns - 1))) {
            if (newend < oldend) {
                this.setValue(this.nbrruns - 1, (short)newend);
                this.setLength(this.nbrruns - 1, (short)(oldend - newend - 1));
                return;
            }
            if (newend > oldend) {
                this.setValue(this.nbrruns - 1, (short)oldend);
                this.setLength(this.nbrruns - 1, (short)(newend - oldend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (short)(start - BufferUtil.toIntUnsigned(this.getValue(this.nbrruns - 1)) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (short)newend);
            this.setLength(this.nbrruns, (short)(oldend - newend - 1));
            ++this.nbrruns;
        } else if (newend > oldend) {
            this.setValue(this.nbrruns, (short)oldend);
            this.setLength(this.nbrruns, (short)(newend - oldend - 1));
            ++this.nbrruns;
        }
    }

    private void smartAppendExclusive(short[] vl, short val) {
        int oldend;
        block10: {
            block9: {
                if (this.nbrruns == 0) break block9;
                oldend = BufferUtil.toIntUnsigned(this.getValue(this.nbrruns - 1)) + BufferUtil.toIntUnsigned(this.getLength(this.nbrruns - 1)) + 1;
                if (BufferUtil.toIntUnsigned(val) <= oldend) break block10;
            }
            vl[2 * this.nbrruns] = val;
            vl[2 * this.nbrruns + 1] = 0;
            ++this.nbrruns;
            return;
        }
        if (oldend == BufferUtil.toIntUnsigned(val)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            vl[n] = (short)(vl[n] + 1);
            return;
        }
        int newend = BufferUtil.toIntUnsigned(val) + 1;
        if (BufferUtil.toIntUnsigned(val) == BufferUtil.toIntUnsigned(this.getValue(this.nbrruns - 1))) {
            if (newend != oldend) {
                this.setValue(this.nbrruns - 1, (short)newend);
                this.setLength(this.nbrruns - 1, (short)(oldend - newend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (short)(val - BufferUtil.toIntUnsigned(this.getValue(this.nbrruns - 1)) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (short)newend);
            this.setLength(this.nbrruns, (short)(oldend - newend - 1));
            ++this.nbrruns;
        } else if (oldend < newend) {
            this.setValue(this.nbrruns, (short)oldend);
            this.setLength(this.nbrruns, (short)(newend - oldend - 1));
            ++this.nbrruns;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < this.nbrruns; ++k) {
            sb.append("[");
            sb.append(BufferUtil.toIntUnsigned(this.getValue(k)));
            sb.append(",");
            sb.append(BufferUtil.toIntUnsigned(this.getValue(k)) + BufferUtil.toIntUnsigned(this.getLength(k)) + 1);
            sb.append("]");
        }
        return sb.toString();
    }

    private void smartAppend(short[] vl, short val) {
        int oldend;
        block5: {
            block4: {
                if (this.nbrruns == 0) break block4;
                oldend = BufferUtil.toIntUnsigned(vl[2 * (this.nbrruns - 1)]) + BufferUtil.toIntUnsigned(vl[2 * (this.nbrruns - 1) + 1]);
                if (BufferUtil.toIntUnsigned(val) <= oldend + 1) break block5;
            }
            vl[2 * this.nbrruns] = val;
            vl[2 * this.nbrruns + 1] = 0;
            ++this.nbrruns;
            return;
        }
        if (val == (short)(oldend + 1)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            vl[n] = (short)(vl[n] + 1);
        }
    }

    @Override
    public MappeableContainer or(MappeableRunContainer x) {
        if (this.isFull()) {
            return this.clone();
        }
        if (x.isFull()) {
            return x.clone();
        }
        MappeableRunContainer answer = new MappeableRunContainer(ShortBuffer.allocate(2 * (this.nbrruns + x.nbrruns)), 0);
        short[] vl = answer.valueslength.array();
        int rlepos = 0;
        int xrlepos = 0;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (BufferUtil.compareUnsigned(this.getValue(rlepos), x.getValue(xrlepos)) <= 0) {
                answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(vl, x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (xrlepos < x.nbrruns) {
            answer.smartAppend(vl, x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (rlepos < this.nbrruns) {
            answer.smartAppend(vl, this.getValue(rlepos), this.getLength(rlepos));
            ++rlepos;
        }
        return answer.toBitmapIfNeeded();
    }

    @Override
    public MappeableContainer xor(MappeableRunContainer x) {
        MappeableRunContainer answer;
        block6: {
            if (x.nbrruns == 0) {
                return this.clone();
            }
            if (this.nbrruns == 0) {
                return x.clone();
            }
            answer = new MappeableRunContainer(ShortBuffer.allocate(2 * (this.nbrruns + x.nbrruns)), 0);
            short[] vl = answer.valueslength.array();
            int rlepos = 0;
            int xrlepos = 0;
            while (true) {
                if (BufferUtil.compareUnsigned(this.getValue(rlepos), x.getValue(xrlepos)) < 0) {
                    answer.smartAppendExclusive(vl, this.getValue(rlepos), this.getLength(rlepos));
                    if (++rlepos != this.nbrruns) continue;
                    while (xrlepos < x.nbrruns) {
                        answer.smartAppendExclusive(vl, x.getValue(xrlepos), x.getLength(xrlepos));
                        ++xrlepos;
                    }
                    break block6;
                }
                answer.smartAppendExclusive(vl, x.getValue(xrlepos), x.getLength(xrlepos));
                if (++xrlepos == x.nbrruns) break;
            }
            while (rlepos < this.nbrruns) {
                answer.smartAppendExclusive(vl, this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
            }
        }
        return answer.toEfficientContainer();
    }

    @Override
    public MappeableContainer repairAfterLazy() {
        return this.toEfficientContainer();
    }

    private MappeableContainer convertToLazyBitmapIfNeeded() {
        if (this.nbrruns > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
                BufferUtil.setBitmapRange(answer.bitmap, start, end);
            }
            answer.cardinality = -1;
            return answer;
        }
        return this;
    }

    @Override
    public boolean intersects(MappeableArrayContainer x) {
        if (this.nbrruns == 0) {
            return false;
        }
        int rlepos = 0;
        int arraypos = 0;
        int rleval = BufferUtil.toIntUnsigned(this.getValue(rlepos));
        int rlelength = BufferUtil.toIntUnsigned(this.getLength(rlepos));
        while (arraypos < x.cardinality) {
            int arrayval = BufferUtil.toIntUnsigned(x.content.get(arraypos));
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return false;
                }
                rleval = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                rlelength = BufferUtil.toIntUnsigned(this.getLength(rlepos));
            }
            if (rleval > arrayval) {
                arraypos = BufferUtil.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableBitmapContainer x) {
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int runStart = BufferUtil.toIntUnsigned(this.getValue(rlepos));
            int runEnd = runStart + BufferUtil.toIntUnsigned(this.getLength(rlepos));
            for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                if (!x.contains((short)runValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableRunContainer x) {
        int rlepos = 0;
        int xrlepos = 0;
        int start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
        int end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = BufferUtil.toIntUnsigned(this.getValue(rlepos));
                end = start + BufferUtil.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = BufferUtil.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + BufferUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            return true;
        }
        return false;
    }
}

