/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerPointer;
import org.roaringbitmap.FastAggregation;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class RoaringBitmap
implements Cloneable,
Serializable,
Iterable<Integer>,
Externalizable,
ImmutableBitmapDataProvider {
    private static final long serialVersionUID = 6L;
    RoaringArray highLowContainer = new RoaringArray();

    public static RoaringBitmap and(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.and(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return answer;
    }

    public static int andCardinality(RoaringBitmap x1, RoaringBitmap x2) {
        int answer = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                Container c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                answer += c1.andCardinality(c2);
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return answer;
    }

    public static RoaringBitmap andNot(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.andNot(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                int nextPos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, nextPos1);
                pos1 = nextPos1;
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap bitmapOf(int ... dat) {
        RoaringBitmap ans = new RoaringBitmap();
        for (int i : dat) {
            ans.add(i);
        }
        return ans;
    }

    public static RoaringBitmap flip(RoaringBitmap bm, int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return bm.clone();
        }
        RoaringBitmap answer = new RoaringBitmap();
        int hbStart = Util.toIntUnsigned(Util.highbits(rangeStart));
        int lbStart = Util.toIntUnsigned(Util.lowbits(rangeStart));
        int hbLast = Util.toIntUnsigned(Util.highbits(rangeEnd - 1));
        int lbLast = Util.toIntUnsigned(Util.lowbits(rangeEnd - 1));
        answer.highLowContainer.appendCopiesUntil(bm.highLowContainer, (short)hbStart);
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            int containerStart = hb == hbStart ? lbStart : 0;
            int containerLast = hb == hbLast ? lbLast : Util.maxLowBitAsInteger();
            int i = bm.highLowContainer.getIndex((short)hb);
            int j = answer.highLowContainer.getIndex((short)hb);
            assert (j < 0);
            if (i >= 0) {
                Container c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast + 1);
                if (c.getCardinality() <= 0) continue;
                answer.highLowContainer.insertNewKeyValueAt(-j - 1, (short)hb, c);
                continue;
            }
            answer.highLowContainer.insertNewKeyValueAt(-j - 1, (short)hb, Container.rangeOfOnes(containerStart, containerLast + 1));
        }
        answer.highLowContainer.appendCopiesAfter(bm.highLowContainer, (short)hbLast);
        return answer;
    }

    public static RoaringBitmap or(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    answer.highLowContainer.append(s1, x1.highLowContainer.getContainerAtIndex(pos1).or(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static int orCardinality(RoaringBitmap x1, RoaringBitmap x2) {
        int answer = 0;
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    answer += x1.highLowContainer.getContainerAtIndex(pos1).or(x2.highLowContainer.getContainerAtIndex(pos2)).getCardinality();
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    answer += x1.highLowContainer.getContainerAtIndex(pos1).getCardinality();
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer += x2.highLowContainer.getContainerAtIndex(pos2).getCardinality();
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        while (pos2 < length2) {
            answer += x2.highLowContainer.getContainerAtIndex(pos2).getCardinality();
            ++pos2;
        }
        while (pos1 < length1) {
            answer += x1.highLowContainer.getContainerAtIndex(pos1).getCardinality();
            ++pos1;
        }
        return answer;
    }

    protected static RoaringBitmap lazyor(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    answer.highLowContainer.append(s1, x1.highLowContainer.getContainerAtIndex(pos1).lazyOR(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    protected static RoaringBitmap lazyorfromlazyinputs(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                    Container c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                    if (c2 instanceof BitmapContainer && !(c1 instanceof BitmapContainer)) {
                        Container tmp = c1;
                        c1 = c2;
                        c2 = tmp;
                    }
                    answer.highLowContainer.append(s1, c1.lazyIOR(c2));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    @Override
    public int rank(int x) {
        int size = 0;
        short xhigh = Util.highbits(x);
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            short key = this.highLowContainer.getKeyAtIndex(i);
            if (Util.compareUnsigned(key, xhigh) < 0) {
                size += this.highLowContainer.getContainerAtIndex(i).getCardinality();
                continue;
            }
            return size + this.highLowContainer.getContainerAtIndex(i).rank(Util.lowbits(x));
        }
        return size;
    }

    @Override
    public int select(int j) {
        int leftover = j;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            int thiscard = c.getCardinality();
            if (thiscard > leftover) {
                int keycontrib = this.highLowContainer.getKeyAtIndex(i) << 16;
                int lowcontrib = Util.toIntUnsigned(c.select(leftover));
                return lowcontrib + keycontrib;
            }
            leftover -= thiscard;
        }
        throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getCardinality());
    }

    public static RoaringBitmap xor(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    Container c = x1.highLowContainer.getContainerAtIndex(pos1).xor(x2.highLowContainer.getContainerAtIndex(pos2));
                    if (c.getCardinality() > 0) {
                        answer.highLowContainer.append(s1, c);
                    }
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public RoaringBitmap() {
    }

    public RoaringBitmap(ImmutableRoaringBitmap rb) {
        MappeableContainerPointer cp = rb.getContainerPointer();
        while (cp.getContainer() != null) {
            this.highLowContainer.append(cp.key(), cp.getContainer().toContainer());
            cp.advance();
        }
    }

    public boolean checkedAdd(int x) {
        short hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            int oldCard = c.getCardinality();
            Container newCont = c.add(Util.lowbits(x));
            this.highLowContainer.setContainerAtIndex(i, newCont);
            return newCont.getCardinality() > oldCard;
        }
        ArrayContainer newac = new ArrayContainer();
        this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
        return true;
    }

    public void add(int x) {
        short hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).add(Util.lowbits(x)));
        } else {
            ArrayContainer newac = new ArrayContainer();
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
        }
    }

    public void flip(int x) {
        short hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            Container c = this.highLowContainer.getContainerAtIndex(i).flip(Util.lowbits(x));
            if (c.getCardinality() > 0) {
                this.highLowContainer.setContainerAtIndex(i, c);
            } else {
                this.highLowContainer.removeAtIndex(i);
            }
        } else {
            ArrayContainer newac = new ArrayContainer();
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
        }
    }

    public void add(int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return;
        }
        int hbStart = Util.toIntUnsigned(Util.highbits(rangeStart));
        int lbStart = Util.toIntUnsigned(Util.lowbits(rangeStart));
        int hbLast = Util.toIntUnsigned(Util.highbits(rangeEnd - 1));
        int lbLast = Util.toIntUnsigned(Util.lowbits(rangeEnd - 1));
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            int containerStart = hb == hbStart ? lbStart : 0;
            int containerLast = hb == hbLast ? lbLast : Util.maxLowBitAsInteger();
            int i = this.highLowContainer.getIndex((short)hb);
            if (i >= 0) {
                Container c = this.highLowContainer.getContainerAtIndex(i).iadd(containerStart, containerLast + 1);
                this.highLowContainer.setContainerAtIndex(i, c);
                continue;
            }
            this.highLowContainer.insertNewKeyValueAt(-i - 1, (short)hb, Container.rangeOfOnes(containerStart, containerLast + 1));
        }
    }

    public static RoaringBitmap add(RoaringBitmap rb, int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return rb.clone();
        }
        int hbStart = Util.toIntUnsigned(Util.highbits(rangeStart));
        int lbStart = Util.toIntUnsigned(Util.lowbits(rangeStart));
        int hbLast = Util.toIntUnsigned(Util.highbits(rangeEnd - 1));
        int lbLast = Util.toIntUnsigned(Util.lowbits(rangeEnd - 1));
        RoaringBitmap answer = new RoaringBitmap();
        answer.highLowContainer.appendCopiesUntil(rb.highLowContainer, (short)hbStart);
        if (hbStart == hbLast) {
            int i = rb.highLowContainer.getIndex((short)hbStart);
            Container c = i >= 0 ? rb.highLowContainer.getContainerAtIndex(i).add(lbStart, lbLast + 1) : Container.rangeOfOnes(lbStart, lbLast + 1);
            answer.highLowContainer.append((short)hbStart, c);
            answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, (short)hbLast);
            return answer;
        }
        int ifirst = rb.highLowContainer.getIndex((short)hbStart);
        int ilast = rb.highLowContainer.getIndex((short)hbLast);
        Container c = ifirst >= 0 ? rb.highLowContainer.getContainerAtIndex(ifirst).add(lbStart, Util.maxLowBitAsInteger() + 1) : Container.rangeOfOnes(lbStart, Util.maxLowBitAsInteger() + 1);
        answer.highLowContainer.append((short)hbStart, c);
        for (int hb = hbStart + 1; hb < hbLast; ++hb) {
            Container c2 = Container.rangeOfOnes(0, Util.maxLowBitAsInteger() + 1);
            answer.highLowContainer.append((short)hb, c2);
        }
        c = ilast >= 0 ? rb.highLowContainer.getContainerAtIndex(ilast).add(0, lbLast + 1) : Container.rangeOfOnes(0, lbLast + 1);
        answer.highLowContainer.append((short)hbLast, c);
        answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, (short)hbLast);
        return answer;
    }

    public void remove(int rangeStart, int rangeEnd) {
        Container c;
        if (rangeStart >= rangeEnd) {
            return;
        }
        int hbStart = Util.toIntUnsigned(Util.highbits(rangeStart));
        int lbStart = Util.toIntUnsigned(Util.lowbits(rangeStart));
        int hbLast = Util.toIntUnsigned(Util.highbits(rangeEnd - 1));
        int lbLast = Util.toIntUnsigned(Util.lowbits(rangeEnd - 1));
        if (hbStart == hbLast) {
            int i = this.highLowContainer.getIndex((short)hbStart);
            if (i < 0) {
                return;
            }
            Container c2 = this.highLowContainer.getContainerAtIndex(i).iremove(lbStart, lbLast + 1);
            if (c2.getCardinality() > 0) {
                this.highLowContainer.setContainerAtIndex(i, c2);
            } else {
                this.highLowContainer.removeAtIndex(i);
            }
            return;
        }
        int ifirst = this.highLowContainer.getIndex((short)hbStart);
        int ilast = this.highLowContainer.getIndex((short)hbLast);
        if (ifirst >= 0) {
            if (lbStart != 0 && (c = this.highLowContainer.getContainerAtIndex(ifirst).iremove(lbStart, Util.maxLowBitAsInteger() + 1)).getCardinality() > 0) {
                this.highLowContainer.setContainerAtIndex(ifirst, c);
                ++ifirst;
            }
        } else {
            ifirst = -ifirst - 1;
        }
        if (ilast >= 0) {
            if (lbLast != Util.maxLowBitAsInteger()) {
                c = this.highLowContainer.getContainerAtIndex(ilast).iremove(0, lbLast + 1);
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(ilast, c);
                } else {
                    ++ilast;
                }
            } else {
                ++ilast;
            }
        } else {
            ilast = -ilast - 1;
        }
        this.highLowContainer.removeIndexRange(ifirst, ilast);
    }

    public static RoaringBitmap remove(RoaringBitmap rb, int rangeStart, int rangeEnd) {
        Container c;
        if (rangeStart >= rangeEnd) {
            return rb.clone();
        }
        int hbStart = Util.toIntUnsigned(Util.highbits(rangeStart));
        int lbStart = Util.toIntUnsigned(Util.lowbits(rangeStart));
        int hbLast = Util.toIntUnsigned(Util.highbits(rangeEnd - 1));
        int lbLast = Util.toIntUnsigned(Util.lowbits(rangeEnd - 1));
        RoaringBitmap answer = new RoaringBitmap();
        answer.highLowContainer.appendCopiesUntil(rb.highLowContainer, (short)hbStart);
        if (hbStart == hbLast) {
            Container c2;
            int i = rb.highLowContainer.getIndex((short)hbStart);
            if (i >= 0 && (c2 = rb.highLowContainer.getContainerAtIndex(i).remove(lbStart, lbLast + 1)).getCardinality() > 0) {
                answer.highLowContainer.append((short)hbStart, c2);
            }
            answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, (short)hbLast);
            return answer;
        }
        int ifirst = rb.highLowContainer.getIndex((short)hbStart);
        int ilast = rb.highLowContainer.getIndex((short)hbLast);
        if (ifirst >= 0 && lbStart != 0 && (c = rb.highLowContainer.getContainerAtIndex(ifirst).remove(lbStart, Util.maxLowBitAsInteger() + 1)).getCardinality() > 0) {
            answer.highLowContainer.append((short)hbStart, c);
        }
        if (ilast >= 0 && lbLast != Util.maxLowBitAsInteger() && (c = rb.highLowContainer.getContainerAtIndex(ilast).remove(0, lbLast + 1)).getCardinality() > 0) {
            answer.highLowContainer.append((short)hbLast, c);
        }
        answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, (short)hbLast);
        return answer;
    }

    public void and(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int intersectionSize = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = this.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.iand(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.replaceKeyAndContainerAtIndex(intersectionSize++, s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                pos1 = this.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        this.highLowContainer.resize(intersectionSize);
    }

    public void andNot(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int intersectionSize = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            Container c1;
            short s2;
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                c1 = this.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.iandNot(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.replaceKeyAndContainerAtIndex(intersectionSize++, s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                if (pos1 != intersectionSize) {
                    c1 = this.highLowContainer.getContainerAtIndex(pos1);
                    this.highLowContainer.replaceKeyAndContainerAtIndex(intersectionSize, s1, c1);
                }
                ++intersectionSize;
                ++pos1;
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        if (pos1 < length1) {
            this.highLowContainer.copyRange(pos1, length1, intersectionSize);
            intersectionSize += length1 - pos1;
        }
        this.highLowContainer.resize(intersectionSize);
    }

    public void clear() {
        this.highLowContainer = new RoaringArray();
    }

    public RoaringBitmap clone() {
        try {
            RoaringBitmap x = (RoaringBitmap)super.clone();
            x.highLowContainer = this.highLowContainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("shouldn't happen with clone", e);
        }
    }

    @Override
    public boolean contains(int x) {
        short hb = Util.highbits(x);
        Container c = this.highLowContainer.getContainer(hb);
        return c != null && c.contains(Util.lowbits(x));
    }

    public void deserialize(DataInput in) throws IOException {
        this.highLowContainer.deserialize(in);
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringBitmap) {
            RoaringBitmap srb = (RoaringBitmap)o;
            return srb.highLowContainer.equals(this.highLowContainer);
        }
        return false;
    }

    public void flip(int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return;
        }
        int hbStart = Util.toIntUnsigned(Util.highbits(rangeStart));
        int lbStart = Util.toIntUnsigned(Util.lowbits(rangeStart));
        int hbLast = Util.toIntUnsigned(Util.highbits(rangeEnd - 1));
        int lbLast = Util.toIntUnsigned(Util.lowbits(rangeEnd - 1));
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            int containerStart = hb == hbStart ? lbStart : 0;
            int containerLast = hb == hbLast ? lbLast : Util.maxLowBitAsInteger();
            int i = this.highLowContainer.getIndex((short)hb);
            if (i >= 0) {
                Container c = this.highLowContainer.getContainerAtIndex(i).inot(containerStart, containerLast + 1);
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(i, c);
                    continue;
                }
                this.highLowContainer.removeAtIndex(i);
                continue;
            }
            this.highLowContainer.insertNewKeyValueAt(-i - 1, (short)hb, Container.rangeOfOnes(containerStart, containerLast + 1));
        }
    }

    @Override
    public int getCardinality() {
        int size = 0;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += this.highLowContainer.getContainerAtIndex(i).getCardinality();
        }
        return size;
    }

    @Override
    public IntIterator getIntIterator() {
        return new RoaringIntIterator();
    }

    @Override
    public IntIterator getReverseIntIterator() {
        return new RoaringReverseIntIterator();
    }

    @Override
    public int getSizeInBytes() {
        int size = 8;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            size += 2 + c.getSizeInBytes();
        }
        return size;
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        return FastAggregation.or(bitmaps);
    }

    public static RoaringBitmap or(Iterator<RoaringBitmap> bitmaps) {
        return FastAggregation.or(bitmaps);
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    @Override
    public Iterator<Integer> iterator() {
        return (new Iterator<Integer>(){
            private int hs = 0;
            private ShortIterator iter;
            private int pos = 0;
            private int x;

            @Override
            public boolean hasNext() {
                return this.pos < RoaringBitmap.this.highLowContainer.size();
            }

            private Iterator<Integer> init() {
                if (this.pos < RoaringBitmap.this.highLowContainer.size()) {
                    this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).getShortIterator();
                    this.hs = RoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = this.iter.nextAsInt() | this.hs;
                if (!this.iter.hasNext()) {
                    ++this.pos;
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                if ((this.x & this.hs) == this.hs) {
                    this.iter.remove();
                } else {
                    RoaringBitmap.this.remove(this.x);
                }
            }
        }).init();
    }

    @Override
    public boolean isEmpty() {
        return this.highLowContainer.size() == 0;
    }

    public void or(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    this.highLowContainer.setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).ior(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    protected void repairAfterLazy() {
        for (int k = 0; k < this.highLowContainer.size(); ++k) {
            Container c = this.highLowContainer.getContainerAtIndex(k);
            this.highLowContainer.setContainerAtIndex(k, c.repairAfterLazy());
        }
    }

    protected void lazyor(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    this.highLowContainer.setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).lazyIOR(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.highLowContainer.readExternal(in);
    }

    public boolean checkedRemove(int x) {
        short hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i < 0) {
            return false;
        }
        Container C = this.highLowContainer.getContainerAtIndex(i);
        int oldcard = C.getCardinality();
        C.remove(Util.lowbits(x));
        int newcard = C.getCardinality();
        if (newcard == oldcard) {
            return false;
        }
        if (newcard > 0) {
            this.highLowContainer.setContainerAtIndex(i, C);
        } else {
            this.highLowContainer.removeAtIndex(i);
        }
        return true;
    }

    public void remove(int x) {
        short hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i < 0) {
            return;
        }
        this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).remove(Util.lowbits(x)));
        if (this.highLowContainer.getContainerAtIndex(i).getCardinality() == 0) {
            this.highLowContainer.removeAtIndex(i);
        }
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    @Override
    public int serializedSizeInBytes() {
        return this.highLowContainer.serializedSizeInBytes();
    }

    @Override
    public RoaringBitmap limit(int maxcardinality) {
        Container c;
        RoaringBitmap answer = new RoaringBitmap();
        int currentcardinality = 0;
        for (int i = 0; currentcardinality < maxcardinality && i < this.highLowContainer.size(); currentcardinality += c.getCardinality(), ++i) {
            c = this.highLowContainer.getContainerAtIndex(i);
            if (c.getCardinality() + currentcardinality <= maxcardinality) {
                answer.highLowContainer.appendCopy(this.highLowContainer, i);
                continue;
            }
            int leftover = maxcardinality - currentcardinality;
            Container limited = c.limit(leftover);
            answer.highLowContainer.append(this.highLowContainer.getKeyAtIndex(i), limited);
            break;
        }
        return answer;
    }

    @Override
    public int[] toArray() {
        int[] array = new int[this.getCardinality()];
        int pos = 0;
        int pos2 = 0;
        while (pos < this.highLowContainer.size()) {
            int hs = this.highLowContainer.getKeyAtIndex(pos) << 16;
            Container c = this.highLowContainer.getContainerAtIndex(pos++);
            c.fillLeastSignificant16bits(array, pos2, hs);
            pos2 += c.getCardinality();
        }
        return array;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void trim() {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            this.highLowContainer.getContainerAtIndex(i).trim();
        }
    }

    public boolean runOptimize() {
        boolean answer = false;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i).runOptimize();
            if (c instanceof RunContainer) {
                answer = true;
            }
            this.highLowContainer.setContainerAtIndex(i, c);
        }
        return answer;
    }

    public ContainerPointer getContainerPointer() {
        return this.highLowContainer.getContainerPointer();
    }

    public boolean removeRunCompression() {
        boolean answer = false;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            if (!(c instanceof RunContainer)) continue;
            Container newc = ((RunContainer)c).toBitmapOrArrayContainer(c.getCardinality());
            this.highLowContainer.setContainerAtIndex(i, newc);
            answer = true;
        }
        return answer;
    }

    public static boolean intersects(RoaringBitmap x1, RoaringBitmap x2) {
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                if (c1.intersects(c2 = x2.highLowContainer.getContainerAtIndex(pos2))) {
                    return true;
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return false;
    }

    public MutableRoaringBitmap toMutableRoaringBitmap() {
        return new MutableRoaringBitmap(this);
    }

    public boolean hasRunCompression() {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            if (!(c instanceof RunContainer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.highLowContainer.writeExternal(out);
    }

    public void xor(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    Container c = this.highLowContainer.getContainerAtIndex(pos1).ixor(x2.highLowContainer.getContainerAtIndex(pos2));
                    if (c.getCardinality() > 0) {
                        this.highLowContainer.setContainerAtIndex(pos1, c);
                        ++pos1;
                    } else {
                        this.highLowContainer.removeAtIndex(pos1);
                        --length1;
                    }
                    if (pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (Util.compareUnsigned(s1, s2) < 0) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    private final class RoaringReverseIntIterator
    implements IntIterator {
        int hs = 0;
        ShortIterator iter;
        short pos;

        private RoaringReverseIntIterator() {
            this.pos = (short)(RoaringBitmap.this.highLowContainer.size() - 1);
            this.nextContainer();
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        private void nextContainer() {
            if (this.pos >= 0) {
                this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).getReverseShortIterator();
                this.hs = RoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos) << 16;
            }
        }

        @Override
        public int next() {
            int x = this.iter.nextAsInt() | this.hs;
            if (!this.iter.hasNext()) {
                this.pos = (short)(this.pos - 1);
                this.nextContainer();
            }
            return x;
        }

        @Override
        public IntIterator clone() {
            try {
                RoaringReverseIntIterator clone = (RoaringReverseIntIterator)super.clone();
                clone.iter = this.iter.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private final class RoaringIntIterator
    implements IntIterator {
        private int hs = 0;
        private ShortIterator iter;
        private int pos = 0;

        private RoaringIntIterator() {
            this.nextContainer();
        }

        @Override
        public boolean hasNext() {
            return this.pos < RoaringBitmap.this.highLowContainer.size();
        }

        private void nextContainer() {
            if (this.pos < RoaringBitmap.this.highLowContainer.size()) {
                this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).getShortIterator();
                this.hs = RoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos) << 16;
            }
        }

        @Override
        public int next() {
            int x = this.iter.nextAsInt() | this.hs;
            if (!this.iter.hasNext()) {
                ++this.pos;
                this.nextContainer();
            }
            return x;
        }

        @Override
        public IntIterator clone() {
            try {
                RoaringIntIterator x = (RoaringIntIterator)super.clone();
                x.iter = this.iter.clone();
                return x;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

