/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringArray;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class ImmutableRoaringArray
implements PointableRoaringArray {
    protected static final short SERIAL_COOKIE = 12346;
    private static final int startofkeyscardinalities = 8;
    ByteBuffer buffer;
    int size;

    protected int unsignedBinarySearch(short k) {
        int low = 0;
        int high = this.size - 1;
        int ikey = BufferUtil.toIntUnsigned(k);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = this.getKey(middleIndex);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    protected ImmutableRoaringArray(ByteBuffer bbf) {
        this.buffer = bbf.slice();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.buffer.getInt() != 12346) {
            throw new RuntimeException("I failed to find the right cookie.");
        }
        this.size = this.buffer.getInt();
        this.buffer.limit(this.computeSerializedSizeInBytes());
    }

    private int computeSerializedSizeInBytes() {
        int CardinalityOfLastContainer = this.getCardinality(this.size - 1);
        int PositionOfLastContainer = this.getOffsetContainer(this.size - 1);
        int SizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinality(CardinalityOfLastContainer);
        return SizeOfLastContainer + PositionOfLastContainer;
    }

    @Override
    public ImmutableRoaringArray clone() {
        ImmutableRoaringArray sa;
        try {
            sa = (ImmutableRoaringArray)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return sa;
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableRoaringArray) {
            ImmutableRoaringArray srb = (ImmutableRoaringArray)o;
            return srb.buffer.equals(this.buffer);
        }
        if (o instanceof MutableRoaringArray) {
            MutableRoaringArray srb = (MutableRoaringArray)o;
            MappeableContainerPointer cp1 = srb.getContainerPointer();
            MappeableContainerPointer cp2 = srb.getContainerPointer();
            while (cp1.hasContainer()) {
                if (!cp2.hasContainer()) {
                    return false;
                }
                if (cp1.key() != cp2.key()) {
                    return false;
                }
                if (cp1.getCardinality() != cp2.getCardinality()) {
                    return false;
                }
                if (!cp1.getContainer().equals(cp2.getContainer())) {
                    return false;
                }
                cp1.advance();
                cp2.advance();
            }
            return !cp2.hasContainer();
        }
        return false;
    }

    @Override
    public int getCardinality(int k) {
        return BufferUtil.toIntUnsigned(this.buffer.getShort(8 + 4 * k + 2)) + 1;
    }

    @Override
    public MappeableContainer getContainer(short x) {
        int i = this.unsignedBinarySearch(x);
        if (i < 0) {
            return null;
        }
        return this.getContainerAtIndex(i);
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        int cardinality = this.getCardinality(i);
        boolean isBitmap = cardinality > 4096;
        this.buffer.position(this.getOffsetContainer(i));
        if (isBitmap) {
            LongBuffer bitmapArray = this.buffer.asLongBuffer().slice();
            bitmapArray.limit(1024);
            return new MappeableBitmapContainer(bitmapArray, cardinality);
        }
        ShortBuffer shortArray = this.buffer.asShortBuffer().slice();
        shortArray.limit(cardinality);
        return new MappeableArrayContainer(shortArray, cardinality);
    }

    private int getOffsetContainer(int k) {
        return this.buffer.getInt(8 + 4 * this.size + 4 * k);
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return this.getContainerPointer(0);
    }

    @Override
    public MappeableContainerPointer getContainerPointer(final int startIndex) {
        return new MappeableContainerPointer(){
            int k;
            {
                this.k = startIndex;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public void previous() {
                --this.k;
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return BufferUtil.toIntUnsigned(this.key()) - BufferUtil.toIntUnsigned(o.key());
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return ImmutableRoaringArray.this.getCardinality(this.k);
            }

            @Override
            public MappeableContainer getContainer() {
                if (this.k >= ImmutableRoaringArray.this.size) {
                    return null;
                }
                return ImmutableRoaringArray.this.getContainerAtIndex(this.k);
            }

            @Override
            public boolean hasContainer() {
                return 0 <= this.k & this.k < ImmutableRoaringArray.this.size;
            }

            @Override
            public short key() {
                return ImmutableRoaringArray.this.getKeyAtIndex(this.k);
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }
        };
    }

    private int getKey(int k) {
        return BufferUtil.toIntUnsigned(this.buffer.getShort(8 + 4 * k));
    }

    @Override
    public int getIndex(short x) {
        return this.unsignedBinarySearch(x);
    }

    @Override
    public short getKeyAtIndex(int i) {
        return this.buffer.getShort(4 * i + 8);
    }

    public int hashCode() {
        MappeableContainerPointer cp = this.getContainerPointer();
        int hashvalue = 0;
        while (cp.hasContainer()) {
            int th = cp.key() * 0xF0F0F0 + cp.getContainer().hashCode();
            hashvalue = 31 * hashvalue + th;
        }
        return hashvalue;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array());
        } else {
            ByteBuffer tmp = this.buffer.duplicate();
            tmp.position(0);
            byte[] bytes = new byte[256];
            while (tmp.remaining() > bytes.length) {
                tmp.get(bytes);
                out.write(bytes);
            }
            int left = tmp.remaining();
            tmp.get(bytes, 0, left);
            out.write(bytes, 0, left);
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return this.buffer.limit();
    }

    @Override
    public int size() {
        return this.size;
    }
}

