/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.RoaringBitmap;

public final class FastAggregation {
    private FastAggregation() {
    }

    public static RoaringBitmap and(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("Expecting at least 2 bitmaps");
        }
        ImmutableRoaringBitmap[] array = Arrays.copyOf(bitmaps, bitmaps.length);
        Arrays.sort(array, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        ImmutableRoaringBitmap answer = array[0];
        for (int k = 1; k < array.length; ++k) {
            answer = ImmutableRoaringBitmap.and(answer, array[k]);
        }
        return (RoaringBitmap)answer;
    }

    public static RoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("Expecting at least 2 bitmaps");
        }
        PriorityQueue<ImmutableRoaringBitmap> pq = new PriorityQueue<ImmutableRoaringBitmap>(bitmaps.length, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            ImmutableRoaringBitmap x1 = pq.poll();
            ImmutableRoaringBitmap x2 = pq.poll();
            pq.add(ImmutableRoaringBitmap.or(x1, x2));
        }
        return (RoaringBitmap)pq.poll();
    }

    public static RoaringBitmap xor(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("Expecting at least 2 bitmaps");
        }
        PriorityQueue<ImmutableRoaringBitmap> pq = new PriorityQueue<ImmutableRoaringBitmap>(bitmaps.length, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            ImmutableRoaringBitmap x1 = pq.poll();
            ImmutableRoaringBitmap x2 = pq.poll();
            pq.add(ImmutableRoaringBitmap.xor(x1, x2));
        }
        return (RoaringBitmap)pq.poll();
    }
}

