/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.Util;

public final class RoaringArray
implements Cloneable,
Externalizable {
    protected static final short SERIAL_COOKIE = 12345;
    private static final long serialVersionUID = 7L;
    protected Element[] array = new Element[4];
    protected int size = 0;
    private static final int INITIAL_CAPACITY = 4;

    protected RoaringArray() {
    }

    protected void append(short key, Container value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value);
    }

    protected void appendCopy(RoaringArray sa, int index) {
        this.extendArray(1);
        this.array[this.size++] = new Element(sa.array[index].key, sa.array[index].value.clone());
    }

    protected void appendCopy(RoaringArray sa, int startingIndex, int end) {
        this.extendArray(end - startingIndex);
        for (int i = startingIndex; i < end; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void appendCopiesUntil(RoaringArray sourceArray, short stoppingKey) {
        int stopKey = Util.toIntUnsigned(stoppingKey);
        for (int i = 0; i < sourceArray.size && Util.toIntUnsigned(sourceArray.array[i].key) < stopKey; ++i) {
            this.extendArray(1);
            this.array[this.size++] = new Element(sourceArray.array[i].key, sourceArray.array[i].value.clone());
        }
    }

    protected void appendCopiesAfter(RoaringArray sa, short beforeStart) {
        int startLocation = sa.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(sa.size - startLocation);
        for (int i = startLocation; i < sa.size; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void clear() {
        this.array = null;
        this.size = 0;
    }

    public RoaringArray clone() throws CloneNotSupportedException {
        RoaringArray sa = (RoaringArray)super.clone();
        sa.array = Arrays.copyOf(this.array, this.size);
        for (int k = 0; k < this.size; ++k) {
            sa.array[k] = sa.array[k].clone();
        }
        sa.size = this.size;
        return sa;
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringArray) {
            RoaringArray srb = (RoaringArray)o;
            if (srb.size != this.size) {
                return false;
            }
            for (int i = 0; i < srb.size; ++i) {
                Element self = this.array[i];
                Element other = srb.array[i];
                if (self.key == other.key && self.value.equals(other.value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.array.length) {
            int newCapacity = this.array.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.array = Arrays.copyOf(this.array, newCapacity);
        }
    }

    protected Container getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.array[i].value;
    }

    protected Container getContainerAtIndex(int i) {
        return this.array[i].value;
    }

    protected int getIndex(short x) {
        if (this.size == 0 || this.array[this.size - 1].key == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    protected short getKeyAtIndex(int i) {
        return this.array[i].key;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    protected void insertNewKeyValueAt(int i, short key, Container value) {
        this.extendArray(1);
        System.arraycopy(this.array, i, this.array, i + 1, this.size - i);
        this.array[i] = new Element(key, value);
        ++this.size;
    }

    protected void resize(int newLength) {
        for (int k = newLength; k < this.size; ++k) {
            this.array[k] = null;
        }
        this.size = newLength;
    }

    protected boolean remove(short key) {
        int i = this.binarySearch(0, this.size, key);
        if (i >= 0) {
            this.removeAtIndex(i);
            return true;
        }
        return false;
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
        this.array[this.size - 1] = null;
        --this.size;
    }

    protected void setContainerAtIndex(int i, Container c) {
        this.array[i].value = c;
    }

    protected int size() {
        return this.size;
    }

    private int binarySearch(int begin, int end, short key) {
        int low = begin;
        int high = end - 1;
        int ikey = Util.toIntUnsigned(key);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(this.array[middleIndex].key);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void serialize(DataOutput out) throws IOException {
        int k;
        out.write(57);
        out.write(48);
        out.write(0);
        out.write(0);
        out.write(this.size & 0xFF);
        out.write(this.size >>> 8 & 0xFF);
        out.write(this.size >>> 16 & 0xFF);
        out.write(this.size >>> 24 & 0xFF);
        for (k = 0; k < this.size; ++k) {
            out.write(this.array[k].key & 0xFF);
            out.write(this.array[k].key >>> 8 & 0xFF);
            out.write(this.array[k].value.getCardinality() - 1 & 0xFF);
            out.write(this.array[k].value.getCardinality() - 1 >>> 8 & 0xFF);
        }
        for (k = 0; k < this.size; ++k) {
            this.array[k].value.writeArray(out);
        }
    }

    public int serializedSizeInBytes() {
        int count = 8 + 4 * this.size;
        for (int k = 0; k < this.size; ++k) {
            count += this.array[k].value.getArraySizeInBytes();
        }
        return count;
    }

    public void deserialize(DataInput in) throws IOException {
        int k;
        this.clear();
        byte[] buffer4 = new byte[4];
        byte[] buffer = new byte[2];
        in.readFully(buffer4);
        int cookie = buffer4[0] & 0xFF | (buffer4[1] & 0xFF) << 8 | (buffer4[2] & 0xFF) << 16 | (buffer4[3] & 0xFF) << 24;
        if (cookie != 12345) {
            throw new IOException("I failed to find the right cookie.");
        }
        in.readFully(buffer4);
        this.size = buffer4[0] & 0xFF | (buffer4[1] & 0xFF) << 8 | (buffer4[2] & 0xFF) << 16 | (buffer4[3] & 0xFF) << 24;
        if (this.array == null || this.array.length < this.size) {
            this.array = new Element[this.size];
        }
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            in.readFully(buffer);
            keys[k] = (short)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
            in.readFully(buffer);
            cardinalities[k] = 1 + (buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
            isBitmap[k] = cardinalities[k] > 4096;
        }
        for (k = 0; k < this.size; ++k) {
            Container val;
            if (isBitmap[k]) {
                long[] bitmapArray = new long[1024];
                byte[] buf = new byte[8];
                for (int l = 0; l < bitmapArray.length; ++l) {
                    in.readFully(buf);
                    bitmapArray[l] = ((long)buf[7] << 56) + ((long)(buf[6] & 0xFF) << 48) + ((long)(buf[5] & 0xFF) << 40) + ((long)(buf[4] & 0xFF) << 32) + ((long)(buf[3] & 0xFF) << 24) + (long)((buf[2] & 0xFF) << 16) + (long)((buf[1] & 0xFF) << 8) + (long)(buf[0] & 0xFF);
                }
                val = new BitmapContainer(bitmapArray, cardinalities[k]);
            } else {
                short[] shortArray = new short[cardinalities[k]];
                for (int l = 0; l < shortArray.length; ++l) {
                    in.readFully(buffer);
                    shortArray[l] = (short)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
                }
                val = new ArrayContainer(shortArray);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    protected static final class Element
    implements Cloneable {
        public final short key;
        public Container value = null;

        public Element(short key, Container value) {
            this.key = key;
            this.value = value;
        }

        public Element clone() throws CloneNotSupportedException {
            Element c = (Element)super.clone();
            c.value = this.value.clone();
            return c;
        }
    }
}

