/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.roaringbitmap.buffer.ArrayContainer;
import org.roaringbitmap.buffer.BitmapContainer;
import org.roaringbitmap.buffer.Container;
import org.roaringbitmap.buffer.Util;

public final class RoaringArray
implements Cloneable,
Externalizable {
    protected Element[] array = null;
    protected int size = 0;
    private static final long serialVersionUID = 4L;
    protected static final short serialCookie = 12345;
    static final int initialCapacity = 4;

    protected RoaringArray() {
        this.array = new Element[4];
    }

    protected RoaringArray(ByteBuffer bb) {
        int k;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        if (bb.getInt() != 12345) {
            throw new RuntimeException("I failed to find the right cookie.");
        }
        this.size = bb.getInt();
        this.array = new Element[this.size];
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isbitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = bb.getShort();
            cardinalities[k] = Util.toIntUnsigned(bb.getShort()) + 1;
            isbitmap[k] = cardinalities[k] > 4096;
        }
        for (k = 0; k < this.size; ++k) {
            Container val;
            if (cardinalities[k] == 0) {
                throw new RuntimeException("no");
            }
            if (isbitmap[k]) {
                LongBuffer bitmaparray = bb.asLongBuffer().slice();
                bitmaparray.limit(BitmapContainer.maxcapacity / 64);
                bb.position(bb.position() + BitmapContainer.maxcapacity / 8);
                val = new BitmapContainer(bitmaparray, cardinalities[k]);
            } else {
                ShortBuffer shortarray = bb.asShortBuffer().slice();
                shortarray.limit(cardinalities[k]);
                bb.position(bb.position() + cardinalities[k] * 2);
                val = new ArrayContainer(shortarray, cardinalities[k]);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    public RoaringArray clone() throws CloneNotSupportedException {
        RoaringArray sa = (RoaringArray)super.clone();
        sa.array = Arrays.copyOf(this.array, this.size);
        for (int k = 0; k < this.size; ++k) {
            sa.array[k] = sa.array[k].clone();
        }
        sa.size = this.size;
        return sa;
    }

    public void deserialize(DataInput in) throws IOException {
        int k;
        this.clear();
        byte[] buffer4 = new byte[4];
        byte[] buffer = new byte[2];
        in.readFully(buffer4);
        int cookie = buffer4[0] | (buffer4[1] & 0xFF) << 8 | (buffer4[2] & 0xFF) << 16 | (buffer4[3] & 0xFF) << 24;
        if (cookie != 12345) {
            throw new IOException("I failed to find the right cookie.");
        }
        in.readFully(buffer4);
        this.size = buffer4[0] | (buffer4[1] & 0xFF) << 8 | (buffer4[2] & 0xFF) << 16 | (buffer4[3] & 0xFF) << 24;
        if (this.array == null || this.array.length < this.size) {
            this.array = new Element[this.size];
        }
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isbitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            in.readFully(buffer);
            keys[k] = (short)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
            in.readFully(buffer);
            cardinalities[k] = 1 + (buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
            isbitmap[k] = cardinalities[k] > 4096;
        }
        for (k = 0; k < this.size; ++k) {
            Container val;
            if (isbitmap[k]) {
                LongBuffer bitmaparray = LongBuffer.allocate(BitmapContainer.maxcapacity / 64);
                byte[] buf = new byte[8];
                for (int l = 0; l < bitmaparray.limit(); ++l) {
                    in.readFully(buf);
                    bitmaparray.put(l, ((long)buf[7] << 56) + ((long)(buf[6] & 0xFF) << 48) + ((long)(buf[5] & 0xFF) << 40) + ((long)(buf[4] & 0xFF) << 32) + ((long)(buf[3] & 0xFF) << 24) + (long)((buf[2] & 0xFF) << 16) + (long)((buf[1] & 0xFF) << 8) + (long)((buf[0] & 0xFF) << 0));
                }
                val = new BitmapContainer(bitmaparray, cardinalities[k]);
            } else {
                ShortBuffer shortarray = ShortBuffer.allocate(cardinalities[k]);
                for (int l = 0; l < shortarray.limit(); ++l) {
                    in.readFully(buffer);
                    shortarray.put(l, (short)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8));
                }
                val = new ArrayContainer(shortarray, cardinalities[k]);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringArray) {
            RoaringArray srb = (RoaringArray)o;
            if (srb.size != this.size) {
                return false;
            }
            for (int i = 0; i < srb.size; ++i) {
                if (this.array[i].key != srb.array[i].key) {
                    return false;
                }
                if (this.array[i].value.equals(srb.array[i].value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.array.hashCode();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public void serialize(DataOutput out) throws IOException {
        int k;
        out.write(57);
        out.write(48);
        out.write(0);
        out.write(0);
        out.write(this.size >>> 0 & 0xFF);
        out.write(this.size >>> 8 & 0xFF);
        out.write(this.size >>> 16 & 0xFF);
        out.write(this.size >>> 24 & 0xFF);
        for (k = 0; k < this.size; ++k) {
            out.write(this.array[k].key >>> 0 & 0xFF);
            out.write(this.array[k].key >>> 8 & 0xFF);
            out.write(this.array[k].value.getCardinality() - 1 >>> 0 & 0xFF);
            out.write(this.array[k].value.getCardinality() - 1 >>> 8 & 0xFF);
        }
        for (k = 0; k < this.size; ++k) {
            this.array[k].value.writeArray(out);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    private int binarySearch(int begin, int end, short key) {
        int low = begin;
        int high = end - 1;
        int ikey = Util.toIntUnsigned(key);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(this.array[middleIndex].key);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    protected void append(short key, Container value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value);
    }

    protected void appendCopiesAfter(RoaringArray sa, short beforeStart) {
        int startLocation = sa.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(sa.size - startLocation);
        for (int i = startLocation; i < sa.size; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void appendCopiesUntil(RoaringArray sa, short stoppingKey) {
        int stopKey = Util.toIntUnsigned(stoppingKey);
        for (int i = 0; i < sa.size && Util.toIntUnsigned(sa.array[i].key) < stopKey; ++i) {
            this.extendArray(1);
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void appendCopy(RoaringArray sa, int index) {
        this.extendArray(1);
        this.array[this.size++] = new Element(sa.array[index].key, sa.array[index].value.clone());
    }

    protected void appendCopy(RoaringArray sa, int startingindex, int end) {
        this.extendArray(end - startingindex);
        for (int i = startingindex; i < end; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void clear() {
        this.array = null;
        this.size = 0;
    }

    protected boolean ContainsKey(short x) {
        return this.binarySearch(0, this.size, x) >= 0;
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.array.length) {
            int newcapacity = this.array.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.array = Arrays.copyOf(this.array, newcapacity);
        }
    }

    protected Container getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.array[i].value;
    }

    protected Container getContainerAtIndex(int i) {
        return this.array[i].value;
    }

    protected int getIndex(short x) {
        if (this.size == 0 || this.array[this.size - 1].key == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    protected short getKeyAtIndex(int i) {
        return this.array[i].key;
    }

    protected void insertNewKeyValueAt(int i, short key, Container value) {
        this.extendArray(1);
        System.arraycopy(this.array, i, this.array, i + 1, this.size - i);
        this.array[i] = new Element(key, value);
        ++this.size;
    }

    protected boolean remove(short key) {
        int i = this.binarySearch(0, this.size, key);
        if (i >= 0) {
            this.removeAtIndex(i);
            return true;
        }
        return false;
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
        this.array[this.size - 1] = null;
        --this.size;
    }

    protected void resize(int newlength) {
        for (int k = newlength; k < this.size; ++k) {
            this.array[k] = null;
        }
        this.size = newlength;
    }

    protected void setContainerAtIndex(int i, Container c) {
        this.array[i].value = c;
    }

    protected int size() {
        return this.size;
    }

    protected final class Element
    implements Cloneable {
        public short key;
        public Container value = null;

        public Element(short key, Container value) {
            this.key = key;
            this.value = value;
        }

        public Element clone() {
            try {
                Element c = (Element)super.clone();
                c.key = this.key;
                c.value = this.value.clone();
                return c;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

