/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayContainer
extends Container
implements Cloneable,
Serializable {
    protected int cardinality = 0;
    protected short[] content;
    private static final int DEFAULTINITSIZE = 4;
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULTMAXSIZE = 4096;

    public ArrayContainer() {
        this(4);
    }

    public ArrayContainer(int capacity) {
        this.content = new short[capacity];
    }

    public ArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun + 1;
        this.content = new short[valuesInRange];
        for (int i = 0; i < valuesInRange; ++i) {
            this.content[i] = (short)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    private ArrayContainer(int newcard, short[] newcontent) {
        this.cardinality = newcard;
        this.content = Arrays.copyOf(newcontent, newcard);
    }

    @Override
    public Container add(short x) {
        if (this.cardinality >= 4096) {
            BitmapContainer a = this.toBitmapContainer();
            a.add(x);
            return a;
        }
        if (this.cardinality == 0 || Util.toIntUnsigned(x) > Util.toIntUnsigned(this.content[this.cardinality - 1])) {
            if (this.cardinality >= this.content.length) {
                this.increaseCapacity();
            }
            this.content[this.cardinality++] = x;
            return this;
        }
        int loc = Util.unsigned_binarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= this.content.length) {
                this.increaseCapacity();
            }
            System.arraycopy(this.content, -loc - 1, this.content, -loc, this.cardinality + loc + 1);
            this.content[-loc - 1] = x;
            ++this.cardinality;
        }
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredcapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = Util.unsigned_intersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container and(BitmapContainer x) {
        return x.and(this);
    }

    @Override
    public ArrayContainer andNot(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredcapacity = value1.getCardinality();
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = Util.unsigned_difference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public ArrayContainer andNot(BitmapContainer value2) {
        ArrayContainer answer = new ArrayContainer(this.content.length);
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (value2.contains(this.content[k])) continue;
            answer.content[pos++] = this.content[k];
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public void clear() {
        this.cardinality = 0;
    }

    @Override
    public ArrayContainer clone() {
        return new ArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean contains(short x) {
        return Util.unsigned_binarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayContainer) {
            ArrayContainer srb = (ArrayContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            for (int i = 0; i < this.cardinality; ++i) {
                if (this.content[i] == srb.content[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        for (int k = 0; k < this.cardinality; ++k) {
            x[k + i] = Util.toIntUnsigned(this.content[k]) | mask;
        }
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ShortIterator(){
            int pos = 0;

            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            public short next() {
                return ArrayContainer.this.content[this.pos++];
            }

            public void remove() {
                ArrayContainer.this.remove((short)(this.pos - 1));
                --this.pos;
            }
        };
    }

    @Override
    public int getSizeInBytes() {
        return this.cardinality * 2 + 4;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            hash += 31 * this.content[k];
        }
        return hash;
    }

    @Override
    public ArrayContainer iand(ArrayContainer value2) {
        ArrayContainer value1 = this;
        value1.cardinality = Util.unsigned_intersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content);
        return this;
    }

    @Override
    public Container iand(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (!value2.contains(this.content[k])) continue;
            this.content[pos++] = this.content[k];
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public ArrayContainer iandNot(ArrayContainer value2) {
        this.cardinality = Util.unsigned_difference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content);
        return this;
    }

    @Override
    public ArrayContainer iandNot(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (value2.contains(this.content[k])) continue;
            this.content[pos++] = this.content[k];
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange + 1;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        short[] buffer = new short[newValuesInRange];
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.length) {
                if (newCardinality >= 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                this.content = Arrays.copyOf(this.content, newCardinality);
            }
            for (int pos = this.cardinality - 1; pos > lastIndex; --pos) {
                this.content[pos + cardinalityChange] = this.content[pos];
            }
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                for (int i = startIndex + newValuesInRange; i < newCardinality; ++i) {
                    this.content[i] = this.content[i - cardinalityChange];
                }
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public Container ior(ArrayContainer value2) {
        return this.or(value2);
    }

    @Override
    public Container ior(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            short pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            @Override
            public Short next() {
                short s = this.pos;
                this.pos = (short)(s + 1);
                return new Short(ArrayContainer.this.content[s]);
            }

            @Override
            public void remove() {
                ArrayContainer.this.remove((short)(this.pos - 1));
                this.pos = (short)(this.pos - 1);
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange > lastOfRange) {
            return this.clone();
        }
        int startIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange + 1) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) >= 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        ArrayContainer answer = new ArrayContainer();
        if (answer.content.length < newCardinality) {
            answer.content = new short[newCardinality];
        }
        for (int i = 0; i < startIndex; ++i) {
            answer.content[i] = this.content[i];
        }
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange <= lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                answer.content[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastOfRange) {
            answer.content[outPos++] = (short)valInRange;
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content[outPos++] = this.content[i];
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    public Container or(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(value2.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << value2.content[k];
            }
            for (k = 0; k < this.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(this.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << this.content[k];
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredcapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = Util.unsigned_union2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container or(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[2];
        in.readFully(buffer);
        this.cardinality = buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
        if (this.content.length < this.cardinality) {
            this.content = new short[this.cardinality];
        }
        for (int k = 0; k < this.cardinality; ++k) {
            in.readFully(buffer);
            this.content[k] = (short)((buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF);
        }
    }

    @Override
    public Container remove(short x) {
        int loc = Util.unsigned_binarySearch(this.content, 0, this.cardinality, x);
        if (loc >= 0) {
            System.arraycopy(this.content, loc + 1, this.content, loc, this.cardinality - loc - 1);
            --this.cardinality;
        }
        return this;
    }

    public BitmapContainer toBitmapContainer() {
        BitmapContainer bc = new BitmapContainer();
        bc.loadData(this);
        return bc;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append(this.content[i]);
            sb.append(",");
        }
        sb.append(this.content[this.cardinality - 1]);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
        this.content = Arrays.copyOf(this.content, this.cardinality);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.cardinality >>> 0 & 0xFF);
        out.write(this.cardinality >>> 8 & 0xFF);
        for (int k = 0; k < this.cardinality; ++k) {
            out.write(this.content[k] >>> 0 & 0xFF);
            out.write(this.content[k] >>> 8 & 0xFF);
        }
    }

    @Override
    public Container xor(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(value2.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << value2.content[k];
            }
            for (k = 0; k < this.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(this.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << this.content[k];
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredcapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = Util.unsigned_exclusiveunion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container xor(BitmapContainer x) {
        return x.xor(this);
    }

    private void increaseCapacity() {
        int newcapacity;
        int n = this.content.length < 64 ? this.content.length * 2 : (newcapacity = this.content.length < 1024 ? this.content.length * 3 / 2 : this.content.length * 5 / 4);
        if (newcapacity > 4096) {
            newcapacity = 4096;
        }
        this.content = Arrays.copyOf(this.content, newcapacity);
    }

    private void negateRange(short[] buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange <= lastRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                buffer[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastRange) {
            buffer[outPos++] = (short)valInRange;
            ++valInRange;
        }
        if (outPos != buffer.length) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.length);
        }
        assert (outPos == buffer.length);
        int i = startIndex;
        for (short item : buffer) {
            this.content[i++] = item;
        }
    }

    protected void loadData(BitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        bitmapContainer.fillArray(this.content);
    }
}

