/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.ajax4jsf.util.NumericDataInputStream;

public class NumericDataOutputStream {
    private ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
    private byte[] bytes = new byte[4];
    private ByteBuffer buffer = ByteBuffer.wrap(this.bytes).order(NumericDataInputStream.BUFFER_BYTES_ORDER);

    public NumericDataOutputStream writeByte(byte value) {
        this.byteStream.write(value);
        return this;
    }

    public NumericDataOutputStream writeShort(short value) {
        this.buffer.rewind();
        this.buffer.asShortBuffer().put(value);
        this.byteStream.write(this.bytes, 0, 2);
        return this;
    }

    private void writeInteger(int value, int numBytes) {
        this.buffer.rewind();
        this.buffer.asIntBuffer().put(value);
        this.byteStream.write(this.bytes, 0, numBytes);
    }

    public NumericDataOutputStream writeInt(int value) {
        this.writeInteger(value, 4);
        return this;
    }

    public NumericDataOutputStream writeIntColor(int value) {
        this.writeInteger(value, 3);
        return this;
    }

    public NumericDataOutputStream writeColor(Color value) {
        this.writeIntColor(value.getRGB());
        return this;
    }

    public byte[] getBytes() {
        return this.byteStream.toByteArray();
    }
}

