/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HandlersChain {
    private static final Logger log = RichfacesLogger.RENDERKIT.getLogger();
    private boolean hasSubmittingBehavior = false;
    private UIComponent component;
    private Collection<ClientBehaviorContext.Parameter> parameters;
    private boolean includeClientId = false;
    private List<String> handlers = new ArrayList<String>(2);

    private final boolean isNotEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public HandlersChain(UIComponent component) {
        this.component = component;
    }

    public HandlersChain(UIComponent component, boolean includeClientId) {
        this.component = component;
        this.includeClientId = includeClientId;
    }

    public HandlersChain(UIComponent component, Collection<ClientBehaviorContext.Parameter> parameters) {
        this.component = component;
        this.parameters = parameters;
    }

    public HandlersChain(UIComponent component, Collection<ClientBehaviorContext.Parameter> parameters, boolean includeClientId) {
        this.component = component;
        this.parameters = parameters;
        this.includeClientId = includeClientId;
    }

    private final List<ClientBehavior> getBehaviorsList(String behaviorName) {
        ClientBehaviorHolder clientBehaviorHolder;
        Map clientBehaviorsMap;
        List behaviors = null;
        if (this.component instanceof ClientBehaviorHolder && (clientBehaviorsMap = (clientBehaviorHolder = (ClientBehaviorHolder)this.component).getClientBehaviors()) != null) {
            behaviors = (List)clientBehaviorsMap.get(behaviorName);
        }
        return behaviors;
    }

    private Collection<ClientBehaviorContext.Parameter> getParameters(FacesContext context) {
        if (this.parameters == null) {
            RendererUtils rendererUtils = RendererUtils.getInstance();
            Map<String, Object> parametersMap = rendererUtils.createParametersMap(context, this.component);
            this.parameters = HandlersChain.createParametersList(parametersMap);
        }
        return this.parameters;
    }

    public boolean hasSubmittingBehavior() {
        return this.hasSubmittingBehavior;
    }

    public void addInlineHandlerAsValue(FacesContext context, String handlerValue) {
        if (this.isNotEmpty(handlerValue)) {
            this.handlers.add(handlerValue);
        }
    }

    public void addInlineHandlerFromAttribute(FacesContext context, String attributeName) {
        this.addInlineHandlerAsValue(context, (String)this.component.getAttributes().get(attributeName));
    }

    public void addBehaviors(FacesContext context, String evantName) {
        this.addBehaviors(context, evantName, null);
    }

    public void addBehaviors(FacesContext context, String evantName, String defaultEventName) {
        String name = evantName;
        List<ClientBehavior> behaviorsList = this.getBehaviorsList(evantName);
        if (behaviorsList == null && defaultEventName != null) {
            behaviorsList = this.getBehaviorsList(defaultEventName);
            name = defaultEventName;
        }
        if (behaviorsList != null) {
            ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)this.component, (String)name, (String)(this.includeClientId ? this.component.getClientId(context) : null), this.getParameters(context));
            for (ClientBehavior clientBehavior : behaviorsList) {
                String behaviorScript = clientBehavior.getScript(behaviorContext);
                if (!this.isNotEmpty(behaviorScript)) continue;
                if (clientBehavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) {
                    this.hasSubmittingBehavior = true;
                }
                this.handlers.add(behaviorScript);
            }
        }
    }

    public String toScript() {
        String result = null;
        if (!this.handlers.isEmpty()) {
            if (this.handlers.size() == 1) {
                result = this.handlers.get(0);
            } else {
                JSFunction jsFunction = new JSFunction("jsf.util.chain", new Object[]{JSReference.THIS, JSReference.EVENT});
                for (String handler : this.handlers) {
                    jsFunction.addParameter((Object)handler);
                }
                result = jsFunction.toScript();
            }
        }
        return result;
    }

    public static List<ClientBehaviorContext.Parameter> createParametersList(Map<String, Object> parametersMap) {
        ArrayList<ClientBehaviorContext.Parameter> parameters = new ArrayList<ClientBehaviorContext.Parameter>(parametersMap.size());
        for (Map.Entry<String, Object> entry : parametersMap.entrySet()) {
            parameters.add(new ClientBehaviorContext.Parameter(entry.getKey(), entry.getValue()));
        }
        return parameters;
    }
}

