/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class BaseGradient
extends Java2Dresource {
    private int width;
    private int height;
    private int gradientHeight;
    private String baseColor;
    private String gradientColor;
    private boolean horizontal = false;

    public BaseGradient(int width, int height, int gradientHeight) {
        this.width = width;
        this.height = height;
        this.gradientHeight = gradientHeight;
        this.setRenderer(new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        this(width, height, gradientHeight);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient(int width, int height) {
        this(width, height, height);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor) {
        this(width, height, height);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient() {
        this(30, 50, 20);
    }

    public BaseGradient(String baseColor, String gradientColor) {
        this(30, 50, 20);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient(int width, int height, int gradientHeight, boolean horizontal) {
        this(width, height, gradientHeight);
        this.horizontal = horizontal;
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor, boolean horizontal) {
        this(width, height, gradientHeight);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.horizontal = horizontal;
    }

    public BaseGradient(int width, int height, boolean horizontal) {
        this(width, height, horizontal ? width : height);
        this.horizontal = horizontal;
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor, boolean horizontal) {
        this(width, height, horizontal ? width : height);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.horizontal = horizontal;
    }

    public BaseGradient(boolean horizontal) {
        this(30, 50, 20);
        this.horizontal = horizontal;
    }

    public BaseGradient(String baseColor, String gradientColor, boolean horizontal) {
        this(30, 50, 20);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.horizontal = horizontal;
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return new Dimension(this.width, this.height);
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.getDimensions(null, this.restoreData(resourceContext));
    }

    protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        Data dataToStore = (Data)this.restoreData(resourceContext);
        if (dataToStore != null && dataToStore.headerBackgroundColor != null && dataToStore.headerGradientColor != null) {
            Color baseColor = new Color(dataToStore.headerBackgroundColor);
            Dimension dim = this.getDimensions(resourceContext);
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
            boolean gradStart = false;
            int gradEnd = this.gradientHeight;
            Color alternateColor = new Color(dataToStore.headerGradientColor);
            GradientPaint gragient = this.horizontal ? new GradientPaint((float)gradStart, 0.0f, baseColor, gradEnd, 0.0f, alternateColor) : new GradientPaint(0.0f, (float)gradStart, baseColor, 0.0f, gradEnd, alternateColor);
            g2d.setPaint(gragient);
            g2d.fill(rect);
        }
    }

    protected Object deserializeData(byte[] objectArray) {
        Data data = new Data();
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            data.headerBackgroundColor = new Integer(zipper2.nextIntColor());
            data.headerGradientColor = new Integer(zipper2.nextIntColor());
        }
        return data;
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        if (this.baseColor == null) {
            return new Data(context).toByteArray();
        }
        return new Data(context, this.baseColor, this.gradientColor).toByteArray();
    }

    public boolean isCacheable() {
        return true;
    }

    protected static class Data
    implements Serializable {
        private static final long serialVersionUID = 1732700513743861250L;
        protected Integer headerBackgroundColor;
        protected Integer headerGradientColor;

        public Data() {
        }

        protected Data(FacesContext context) {
            this(context, "headerBackgroundColor", "headerGradientColor");
        }

        protected Data(FacesContext context, String baseColor, String gradientColor) {
            this.headerBackgroundColor = this.getColorValueParameter(context, baseColor, false);
            this.headerGradientColor = this.getColorValueParameter(context, gradientColor, false);
            if (this.headerBackgroundColor != null || this.headerGradientColor != null) {
                if (this.headerBackgroundColor == null) {
                    this.headerBackgroundColor = this.getColorValueParameter(context, baseColor, true);
                }
                if (this.headerGradientColor == null) {
                    this.headerGradientColor = this.getColorValueParameter(context, gradientColor, true);
                }
            }
        }

        private Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
            Skin skin = useDefault ? SkinFactory.getInstance().getDefaultSkin(context) : SkinFactory.getInstance().getSkin(context);
            String tmp = (String)skin.getParameter(context, name);
            if (tmp != null && tmp.length() != 0) {
                return new Integer(HtmlColor.decode(tmp).getRGB());
            }
            return null;
        }

        public byte[] toByteArray() {
            if (this.headerBackgroundColor != null && this.headerGradientColor != null) {
                byte[] ret = new byte[6];
                new Zipper2(ret).addColor(this.headerBackgroundColor).addColor(this.headerGradientColor);
                return ret;
            }
            return null;
        }
    }
}

