/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheConfigurationLoader;
import org.ajax4jsf.cache.CacheException;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.CacheLoader;
import org.ajax4jsf.cache.CacheManager;
import org.ajax4jsf.cache.ServletContextInitMap;
import org.ajax4jsf.resource.CacheContext;
import org.ajax4jsf.resource.CachedResourceContext;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceLifecycle;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ServletResourceContext;
import org.ajax4jsf.webapp.CacheContent;
import org.ajax4jsf.webapp.WebXml;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternetResourceService
implements CacheLoader,
CacheConfigurationLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$ajax4jsf$resource$InternetResourceService == null ? (class$org$ajax4jsf$resource$InternetResourceService = InternetResourceService.class$("org.ajax4jsf.resource.InternetResourceService")) : class$org$ajax4jsf$resource$InternetResourceService));
    static final String ENABLE_CACHING_PARAMETER = "enable-cache";
    private static final String RESOURCE_LIFECYCLE_PARAMETER = "org.ajax4jsf.RESOURCE_LIFECYCLE";
    private FilterConfig filterConfig;
    private boolean cacheEnabled = true;
    private Cache cache = null;
    private FacesContextFactory contextFactory;
    private String lifecycleClass;
    private ResourceLifecycle lifecycle;
    private InternetResourceBuilder resourceBuilder;
    private WebXml webXml;
    static /* synthetic */ Class class$org$ajax4jsf$resource$InternetResourceService;
    static /* synthetic */ Class class$org$ajax4jsf$webapp$BaseFilter;

    public void setCacheEnabled(boolean b) {
        this.cacheEnabled = b;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        ServletContext servletContext = config.getServletContext();
        if ("false".equalsIgnoreCase(config.getInitParameter(ENABLE_CACHING_PARAMETER))) {
            this.setCacheEnabled(false);
        } else {
            try {
                CacheManager cacheManager = CacheManager.getInstance();
                ServletContextInitMap env = new ServletContextInitMap(servletContext);
                CacheFactory cacheFactory = cacheManager.getCacheFactory(env);
                this.cache = cacheFactory.createCache((Map)env, (CacheLoader)this, (CacheConfigurationLoader)this);
            }
            catch (CacheException e) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
        }
        this.lifecycleClass = servletContext.getInitParameter(RESOURCE_LIFECYCLE_PARAMETER);
        if (this.lifecycleClass != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(this.lifecycleClass);
                this.lifecycle = (ResourceLifecycle)((Object)clazz.newInstance());
            }
            catch (Exception e) {
                throw new FacesException("Error create instance of resource Lifecycle " + this.lifecycleClass, (Throwable)e);
            }
        } else {
            this.lifecycle = new ResourceLifecycle();
        }
        this.webXml = new WebXml();
        this.webXml.init(servletContext, this.filterConfig.getFilterName());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resources service initialized");
        }
    }

    public boolean serviceResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String resourceKey = this.webXml.getFacesResourceKey(httpServletRequest);
        if (null != resourceKey) {
            this.serviceResource(resourceKey, httpServletRequest, httpServletResponse);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResource(String resourceKey, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            InternetResource resource;
            try {
                resource = this.getResourceBuilder().getResourceForKey(resourceKey);
            }
            catch (ResourceNotFoundException e) {
                throw new ServletException((Throwable)e);
            }
            Object resourceDataForKey = this.getResourceBuilder().getResourceDataForKey(resourceKey);
            ResourceContext resourceContext = this.getResourceContext(resource, request, response);
            resourceContext.setResourceData(resourceDataForKey);
            try {
                if (resource.isCacheable(resourceContext) && this.cacheEnabled) {
                    try {
                        long lastModified;
                        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                        if (ifModifiedSince >= 0L && (lastModified = resource.getLastModified(resourceContext).getTime() - 1000L) <= ifModifiedSince) {
                            response.setStatus(304);
                            return;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)Messages.getMessage((String)"PARSING_IF_MODIFIED_SINCE_WARNING"), (Throwable)e);
                    }
                    String cacheKey = resourceKey;
                    CachedResourceContext cachedResourceContext = new CachedResourceContext(resourceContext);
                    CacheContext cacheLoaderContext = new CacheContext(cachedResourceContext, resource);
                    try {
                        CacheContent content = (CacheContent)this.cache.get((Object)cacheKey, (Object)cacheLoaderContext);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)Messages.getMessage((String)"GET_CONTENT_FROM_CACHE_INFO", (Object)cacheKey));
                        }
                        content.sendHeaders(response);
                        Date expired = resource.getExpired(resourceContext);
                        if (expired != null) {
                            response.setDateHeader("Expires", expired.getTime());
                        } else {
                            response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                        }
                        if (!request.getMethod().equals("HEAD")) {
                            content.send(response);
                        }
                        break block16;
                    }
                    catch (CacheException e) {
                        log.error((Object)Messages.getMessage((String)"SEND_RESOURCE_ERROR"), (Throwable)e);
                        throw new ServletException(Messages.getMessage((String)"SEND_RESOURCE_ERROR_2", (Object)e.getMessage()), (Throwable)e);
                    }
                }
                this.getLifecycle().send(resourceContext, resource);
            }
            finally {
                resourceContext.release();
            }
        }
    }

    protected ResourceContext getResourceContext(InternetResource resource, HttpServletRequest request, HttpServletResponse response) throws FacesException {
        ResourceContext resourceContext;
        FacesContext facesContext = null;
        if (resource.requireFacesContext()) {
            facesContext = this.getFacesContext((ServletRequest)request, (ServletResponse)response);
            resourceContext = new FacesResourceContext(facesContext);
        } else {
            resourceContext = new ServletResourceContext(this.getServletContext(), request, response);
        }
        return resourceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String name) {
        Properties properties = new Properties();
        InputStream props = (class$org$ajax4jsf$webapp$BaseFilter == null ? (class$org$ajax4jsf$webapp$BaseFilter = InternetResourceService.class$("org.ajax4jsf.webapp.BaseFilter")) : class$org$ajax4jsf$webapp$BaseFilter).getResourceAsStream(name);
        if (null != props) {
            try {
                properties.load(props);
            }
            catch (IOException e) {
                log.warn((Object)Messages.getMessage((String)"READING_PROPERTIES_ERROR", (Object)name), (Throwable)e);
            }
            finally {
                try {
                    props.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected ResourceLifecycle getLifecycle() throws FacesException {
        return this.lifecycle;
    }

    protected synchronized FacesContextFactory getContextFactory() {
        if (this.contextFactory == null) {
            this.contextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        return this.contextFactory;
    }

    protected FacesContext getFacesContext(ServletRequest request, ServletResponse response) throws FacesException {
        return this.getContextFactory().getFacesContext((Object)this.getServletContext(), (Object)request, (Object)response, (Lifecycle)this.getLifecycle());
    }

    protected InternetResourceBuilder getResourceBuilder() {
        if (this.resourceBuilder == null) {
            this.resourceBuilder = InternetResourceBuilder.getInstance();
        }
        return this.resourceBuilder;
    }

    public Object load(Object key, Object context) throws CacheException {
        CacheContext cacheKey = (CacheContext)context;
        CachedResourceContext resourceContext = cacheKey.getResourceContext();
        try {
            this.getLifecycle().send(resourceContext, cacheKey.getResource());
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
        return resourceContext.getContent();
    }

    public Properties loadProperties(String name) {
        return this.getProperties(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

