/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartConfig;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;

public class MultiPartRepresentation
extends InputRepresentation {
    private volatile String boundary;
    private volatile List<MultiPart.Part> parts;

    public static MultiPart.Part createPart(String name, String fileName, Representation partContent) throws IOException {
        return new MultiPart.ContentSourcePart(name, fileName, HttpFields.EMPTY, (Content.Source)new InputStreamContentSource(partContent.getStream()));
    }

    public static String getBoundary(MediaType mediaType) {
        String result = mediaType != null ? mediaType.getParameters().getFirstValue("boundary") : null;
        return result;
    }

    public static MediaType setBoundary(MediaType mediaType, String boundary) {
        MediaType result = null;
        if (mediaType != null) {
            result = mediaType.getParameters().getFirst("boundary") != null ? new MediaType(mediaType.getParent(), "boundary", boundary) : new MediaType(mediaType, "boundary", boundary);
        }
        return result;
    }

    public MultiPartRepresentation(List<MultiPart.Part> parts) {
        this(MultiPart.generateBoundary(null, (int)24), parts);
    }

    public MultiPartRepresentation(MediaType mediaType, String boundary, List<MultiPart.Part> parts) {
        super(null, MultiPartRepresentation.setBoundary(mediaType, boundary));
        this.boundary = boundary;
        this.parts = parts;
    }

    public MultiPartRepresentation(MultiPart.Part ... parts) {
        this(Arrays.asList(parts));
    }

    public MultiPartRepresentation(Representation multiPartEntity, MultiPartConfig config) throws IOException {
        this(multiPartEntity.getMediaType(), multiPartEntity.getStream(), config);
    }

    public MultiPartRepresentation(Representation multiPartEntity, Path storageLocation) throws IOException {
        this(multiPartEntity, new MultiPartConfig.Builder().location(storageLocation).build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MultiPartRepresentation(MediaType mediaType, InputStream multiPartEntity, MultiPartConfig config) throws IOException {
        super(null, mediaType);
        if (!MediaType.MULTIPART_FORM_DATA.equals(this.getMediaType(), true)) throw new IllegalArgumentException("The content type must be \"multipart/form-data\" with a \"boundary\" parameter");
        this.boundary = this.getMediaType().getParameters().getFirstValue("boundary");
        if (this.boundary == null) throw new IllegalArgumentException("The content type must have a \"boundary\" parameter");
        if (multiPartEntity == null) {
            throw new IllegalArgumentException("The multipart entity can't be null");
        }
        Content.Source contentSource = Content.Source.from((InputStream)multiPartEntity);
        Attributes.Mapped attributes = new Attributes.Mapped();
        MultiPartFormData.onParts((Content.Source)contentSource, (Attributes)attributes, (String)mediaType.toString(), (MultiPartConfig)config, (Promise.Invocable)new Promise.Invocable<MultiPartFormData.Parts>(){

            public void failed(Throwable failure) {
                throw new IllegalStateException("Unable to parse the multipart form data representation", failure);
            }

            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.BLOCKING;
            }

            public void succeeded(MultiPartFormData.Parts parts) {
                MultiPartRepresentation.this.parts = new ArrayList<MultiPart.Part>();
                parts.iterator().forEachRemaining(part -> MultiPartRepresentation.this.parts.add((MultiPart.Part)part));
            }
        });
    }

    public MultiPartRepresentation(String boundary, List<MultiPart.Part> parts) {
        this(MediaType.MULTIPART_FORM_DATA, boundary, parts);
    }

    public MultiPartRepresentation(String boundary, MultiPart.Part ... parts) {
        this(boundary, Arrays.asList(parts));
    }

    public String getBoundary() {
        return this.boundary;
    }

    public List<MultiPart.Part> getParts() {
        return this.parts;
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.getBoundary() == null) {
            throw new IllegalArgumentException("The boundary can't be null");
        }
        MultiPartFormData.ContentSource content = new MultiPartFormData.ContentSource(this.getBoundary());
        for (MultiPart.Part part : this.parts) {
            content.addPart(part);
        }
        content.close();
        this.setStream(null);
        return Content.Source.asInputStream((Content.Source)content);
    }

    public void setBoundary(String boundary) {
        this.boundary = boundary;
        if (this.getMediaType() == null) {
            this.setMediaType(new MediaType(MediaType.MULTIPART_FORM_DATA, "boundary", boundary));
        } else {
            this.setMediaType(MultiPartRepresentation.setBoundary(this.getMediaType(), boundary));
        }
    }
}

