/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import java.util.Date;
import org.restlet.Context;
import org.restlet.data.CookieSetting;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.StringUtils;

public class CookieSettingReader
extends HeaderReader<CookieSetting> {
    private static final String NAME_SET_ACCESS_RESTRICTED = "httpOnly";
    private static final String NAME_SET_COMMENT = "comment";
    private static final String NAME_SET_COMMENT_URL = "commentURL";
    private static final String NAME_SET_DISCARD = "discard";
    private static final String NAME_SET_DOMAIN = "domain";
    private static final String NAME_SET_EXPIRES = "expires";
    private static final String NAME_SET_MAX_AGE = "max-age";
    private static final String NAME_SET_PATH = "path";
    private static final String NAME_SET_PORT = "port";
    private static final String NAME_SET_SECURE = "secure";
    private static final String NAME_SET_VERSION = "version";
    private volatile Parameter cachedPair = null;
    private volatile int globalVersion = -1;

    public static CookieSetting read(String cookieSetting) throws IllegalArgumentException {
        CookieSettingReader cr = new CookieSettingReader(cookieSetting);
        try {
            return cr.readValue();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the cookie setting", e);
        }
    }

    public CookieSettingReader(String header) {
        super(header);
    }

    private Parameter readPair() throws IOException {
        if (this.cachedPair != null) {
            Parameter pair = this.cachedPair;
            this.cachedPair = null;
            return pair;
        }
        Parameter result = null;
        boolean readingName = true;
        StringBuilder nameBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        int nextChar = 0;
        while (result == null && nextChar != -1) {
            nextChar = this.read();
            if (readingName) {
                if (HeaderUtils.isSpace(nextChar) && nameBuffer.isEmpty()) continue;
                if (nextChar == -1 || nextChar == 59 || nextChar == 44) {
                    if (!nameBuffer.isEmpty()) {
                        result = Parameter.create(nameBuffer, null);
                        continue;
                    }
                    if (nextChar == -1) continue;
                    throw new IOException("Empty cookie name detected. Please check your cookies");
                }
                if (nextChar == 61) {
                    readingName = false;
                    continue;
                }
                if (HeaderUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                    nameBuffer.append((char)nextChar);
                    continue;
                }
                throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
            }
            if (HeaderUtils.isSpace(nextChar) && valueBuffer.isEmpty()) continue;
            if (nextChar == -1 || nextChar == 59) {
                result = Parameter.create(nameBuffer, valueBuffer);
                continue;
            }
            if (nextChar == 34 && valueBuffer.isEmpty()) {
                this.unread();
                valueBuffer.append(this.readQuotedString());
                continue;
            }
            if (HeaderUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                valueBuffer.append((char)nextChar);
                continue;
            }
            throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
        }
        return result;
    }

    @Override
    public CookieSetting readValue() throws IOException {
        Parameter pair = null;
        do {
            if ((pair = this.readPair()) != null) continue;
            return null;
        } while (pair.getName().charAt(0) == '$');
        CookieSetting result = new CookieSetting(pair.getName(), pair.getValue());
        while ((pair = this.readPair()) != null) {
            if (pair.getName().equalsIgnoreCase(NAME_SET_PATH)) {
                result.setPath(pair.getValue());
                continue;
            }
            if (pair.getName().equalsIgnoreCase(NAME_SET_DOMAIN)) {
                result.setDomain(pair.getValue());
                continue;
            }
            if (pair.getName().equalsIgnoreCase(NAME_SET_COMMENT)) {
                result.setComment(pair.getValue());
                continue;
            }
            if (pair.getName().equalsIgnoreCase(NAME_SET_COMMENT_URL)) continue;
            if (pair.getName().equalsIgnoreCase(NAME_SET_DISCARD)) {
                result.setMaxAge(-1);
                continue;
            }
            if (pair.getName().equalsIgnoreCase(NAME_SET_EXPIRES)) {
                Date expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_RFC_1036);
                if (expires == null) {
                    expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_RFC_1123);
                }
                if (expires == null) {
                    expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_ASC_TIME);
                }
                if (expires != null) {
                    Date current = new Date(System.currentTimeMillis());
                    if (DateUtils.after(current, expires)) {
                        result.setMaxAge((int)((expires.getTime() - current.getTime()) / 1000L));
                        continue;
                    }
                    result.setMaxAge(0);
                    continue;
                }
                Context.getCurrentLogger().warning("Ignoring cookie setting expiration date. Unable to parse the date: " + pair.getValue());
                continue;
            }
            if (pair.getName().equalsIgnoreCase(NAME_SET_MAX_AGE)) {
                try {
                    result.setMaxAge(Integer.parseInt(pair.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    result.setMaxAge(Integer.MAX_VALUE);
                    Context.getCurrentLogger().warning("Unable to parse the cookie setting max-age value \"" + pair.getValue() + "\", used Integer.MAX_VALUE instead: 2147483647");
                }
                continue;
            }
            if (pair.getName().equalsIgnoreCase(NAME_SET_PORT)) continue;
            if (pair.getName().equalsIgnoreCase(NAME_SET_SECURE)) {
                if (!StringUtils.isNullOrEmpty(pair.getValue())) continue;
                result.setSecure(true);
                continue;
            }
            if (pair.getName().equalsIgnoreCase(NAME_SET_ACCESS_RESTRICTED)) {
                if (!StringUtils.isNullOrEmpty(pair.getValue())) continue;
                result.setAccessRestricted(true);
                continue;
            }
            if (!pair.getName().equalsIgnoreCase(NAME_SET_VERSION)) continue;
            result.setVersion(Integer.parseInt(pair.getValue()));
        }
        return result;
    }
}

