/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.header.HeaderWriter;

public class ChallengeRequestReader
extends HeaderReader<ChallengeRequest> {
    public ChallengeRequestReader(String header) {
        super(header);
    }

    @Override
    public ChallengeRequest readValue() throws IOException {
        ChallengeRequest result = null;
        this.skipSpaces();
        if (this.peek() != -1) {
            String scheme = this.readToken();
            result = new ChallengeRequest(new ChallengeScheme("HTTP_" + scheme, scheme));
            this.skipSpaces();
            HeaderWriter<Parameter> w = new HeaderWriter<Parameter>(this){

                @Override
                public HeaderWriter<Parameter> append(Parameter value) {
                    this.appendExtension(value);
                    return this;
                }
            };
            boolean stop = false;
            while (this.peek() != -1 && !stop) {
                boolean sepSkipped = this.skipValueSeparator();
                this.mark();
                this.readToken();
                int nextChar = this.read();
                this.reset();
                if (HeaderUtils.isSpace(nextChar)) {
                    stop = true;
                    continue;
                }
                if (sepSkipped) {
                    w.appendValueSeparator();
                }
                w.append(this.readParameter());
            }
            result.setRawValue(w.toString());
            w.close();
        }
        return result;
    }
}

