/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.restlet.Server;
import org.restlet.engine.adapter.HttpServerHelper;
import org.restlet.engine.adapter.JettyServerCall;

public abstract class JettyServerHelper
extends HttpServerHelper {
    private volatile org.eclipse.jetty.server.Server wrappedServer;

    public JettyServerHelper(Server server) {
        super(server);
    }

    protected HttpConfiguration createHttpConfiguration() {
        HttpConfiguration configuration = new HttpConfiguration();
        configuration.setHeaderCacheSize(this.getHttpHeaderCacheSize());
        configuration.setRequestHeaderSize(this.getHttpRequestHeaderSize());
        configuration.setResponseHeaderSize(this.getHttpResponseHeaderSize());
        configuration.setOutputBufferSize(this.getHttpOutputBufferSize());
        configuration.setSendDateHeader(false);
        return configuration;
    }

    protected abstract ConnectionFactory[] createConnectionFactories(HttpConfiguration var1);

    protected abstract List<Connector> createConnectors(org.eclipse.jetty.server.Server var1);

    protected ServerConnector createServerConnector(org.eclipse.jetty.server.Server server, HttpConfiguration configuration) {
        int acceptors = this.getConnectorAcceptors();
        int selectors = this.getConnectorSelectors();
        Executor executor = this.getConnectorExecutor();
        Scheduler scheduler = this.getConnectorScheduler();
        ByteBufferPool byteBufferPool = this.getConnectorByteBufferPool();
        ConnectionFactory[] connectionFactories = this.createConnectionFactories(configuration);
        ServerConnector connector = new ServerConnector(server, executor, scheduler, byteBufferPool, acceptors, selectors, connectionFactories);
        String address = ((Server)this.getHelped()).getAddress();
        if (address != null) {
            connector.setHost(address);
        }
        connector.setPort(((Server)this.getHelped()).getPort());
        connector.setIdleTimeout((long)this.getConnectorIdleTimeout());
        connector.setShutdownIdleTimeout(this.getShutdownTimeout());
        connector.setAcceptQueueSize(this.getConnectorAcceptQueueSize());
        return connector;
    }

    private LowResourceMonitor createLowResourceMonitor(org.eclipse.jetty.server.Server server) {
        LowResourceMonitor result;
        int period = this.getLowResourceMonitorPeriod();
        if (period > 0) {
            result = new LowResourceMonitor(server);
            result.setMonitoredConnectors(Arrays.asList(server.getConnectors()));
            result.setPeriod(period);
            result.setMonitorThreads(this.getLowResourceMonitorThreads());
            result.setMaxMemory(this.getLowResourceMonitorMaxMemory());
            result.setLowResourcesIdleTimeout(this.getLowResourceMonitorIdleTimeout());
        } else {
            result = null;
        }
        return result;
    }

    private org.eclipse.jetty.server.Server createServer() {
        ThreadPool threadPool = this.createThreadPool();
        org.eclipse.jetty.server.Server jettyServer = new org.eclipse.jetty.server.Server(threadPool);
        int serverMaxConnections = this.getServerMaxConnections();
        if (serverMaxConnections > 0) {
            ConnectionLimit connectionLimit = new ConnectionLimit(serverMaxConnections, jettyServer);
            connectionLimit.setIdleTimeout(this.getServerMaxConnectionsIdleTimeout());
            jettyServer.addBean((Object)connectionLimit);
        }
        jettyServer.setStopAtShutdown(this.getShutdownGracefully());
        if (this.getShutdownGracefully()) {
            jettyServer.setStopTimeout(this.getShutdownTimeout());
        } else {
            jettyServer.setStopTimeout(0L);
        }
        jettyServer.setHandler((Handler)this.createJettyHandler());
        this.createConnectors(jettyServer).forEach(arg_0 -> ((org.eclipse.jetty.server.Server)jettyServer).addConnector(arg_0));
        LowResourceMonitor lowResourceMonitor = this.createLowResourceMonitor(jettyServer);
        jettyServer.addBean((Object)lowResourceMonitor);
        return jettyServer;
    }

    private Handler.Abstract createJettyHandler() {
        Handler.Abstract result;
        final JettyServerHelper jettyServerHelper = this;
        Handler.Abstract jettyServerHelperWrapperHandler = new Handler.Abstract(this){

            public boolean handle(Request request, Response response, Callback callback) {
                JettyServerCall httpCall = new JettyServerCall((Server)jettyServerHelper.getHelped(), request, response, callback);
                jettyServerHelper.handle(httpCall);
                return true;
            }
        };
        if (this.getShutdownGracefully()) {
            StatisticsHandler statisticsHandler = new StatisticsHandler();
            statisticsHandler.setHandler((Handler)jettyServerHelperWrapperHandler);
            result = statisticsHandler;
        } else {
            result = jettyServerHelperWrapperHandler;
        }
        return result;
    }

    private ThreadPool createThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(this.getThreadPoolMinThreads());
        threadPool.setMaxThreads(this.getThreadPoolMaxThreads());
        threadPool.setThreadsPriority(this.getThreadPoolThreadsPriority());
        threadPool.setIdleTimeout(this.getThreadPoolIdleTimeout());
        if (this.getShutdownGracefully()) {
            threadPool.setStopTimeout(this.getThreadPoolStopTimeout());
        } else {
            threadPool.setStopTimeout(0L);
        }
        return threadPool;
    }

    public int getConnectorAcceptors() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.acceptors", "-1"));
    }

    public int getConnectorAcceptQueueSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.acceptQueueSize", "0"));
    }

    public ByteBufferPool getConnectorByteBufferPool() {
        return null;
    }

    public Executor getConnectorExecutor() {
        return null;
    }

    public int getConnectorIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.idleTimeout", "30000"));
    }

    public Scheduler getConnectorScheduler() {
        return null;
    }

    public int getConnectorSelectors() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.selectors", "-1"));
    }

    public int getHttpHeaderCacheSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.headerCacheSize", "1024"));
    }

    public int getHttpOutputBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.outputBufferSize", "32768"));
    }

    public int getHttpRequestHeaderSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.requestHeaderSize", "8192"));
    }

    public int getHttpResponseHeaderSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.responseHeaderSize", "8192"));
    }

    public int getLowResourceMonitorIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("lowResource.idleTimeout", "1000"));
    }

    public long getLowResourceMonitorMaxMemory() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("lowResource.maxMemory", "0"));
    }

    public int getLowResourceMonitorPeriod() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("lowResource.period", "1000"));
    }

    public boolean getLowResourceMonitorThreads() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("lowResource.threads", "true"));
    }

    public int getServerMaxConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("server.maxConnections", "0"));
    }

    public long getServerMaxConnectionsIdleTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("server.maxConnections.idleTimeout", "0"));
    }

    public boolean getShutdownGracefully() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("shutdown.gracefully", "true"));
    }

    public long getShutdownTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("shutdown.timeout", "0"));
    }

    public int getThreadPoolIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.idleTimeout", "60000"));
    }

    public int getThreadPoolMaxThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.maxThreads", "200"));
    }

    public int getThreadPoolMinThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.minThreads", "8"));
    }

    public long getThreadPoolStopTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("threadPool.stopTimeout", "5000"));
    }

    public int getThreadPoolThreadsPriority() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.threadsPriority", String.valueOf(5)));
    }

    protected org.eclipse.jetty.server.Server getWrappedServer() {
        if (this.wrappedServer == null) {
            this.wrappedServer = this.createServer();
        }
        return this.wrappedServer;
    }

    protected void setWrappedServer(org.eclipse.jetty.server.Server wrappedServer) {
        Objects.requireNonNull(wrappedServer);
        this.wrappedServer = wrappedServer;
    }

    @Override
    public void start() throws Exception {
        super.start();
        org.eclipse.jetty.server.Server server = this.getWrappedServer();
        AbstractNetworkConnector connector = (AbstractNetworkConnector)server.getConnectors()[0];
        this.getLogger().info("Starting the Jetty " + String.valueOf(this.getProtocols()) + " server on port " + ((Server)this.getHelped()).getPort());
        try {
            server.start();
            this.setEphemeralPort(connector.getLocalPort());
        }
        catch (Exception e) {
            server.stop();
            throw e;
        }
    }

    @Override
    public void stop() throws Exception {
        this.getLogger().info("Stopping the Jetty " + String.valueOf(this.getProtocols()) + " server on port " + ((Server)this.getHelped()).getPort());
        if (this.wrappedServer != null) {
            this.getWrappedServer().stop();
        }
        super.stop();
    }
}

