/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.eclipse.jetty.client.AuthenticationStore;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.transport.HttpClientConnectionFactory;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpCookieStore;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.transport.ClientConnectionFactoryOverHTTP2;
import org.eclipse.jetty.http2.client.transport.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.client.transport.ClientConnectionFactoryOverHTTP3;
import org.eclipse.jetty.http3.client.transport.HttpClientTransportOverHTTP3;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.quic.client.ClientQuicConfiguration;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.data.Protocol;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.adapter.JettyClientCall;
import org.restlet.engine.security.RestletSslContextFactoryClient;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.engine.util.ReferenceUtils;

public class HttpClientHelper
extends org.restlet.engine.adapter.HttpClientHelper {
    private volatile HttpClient httpClient;
    private volatile AuthenticationStore authenticationStore;
    private volatile HttpCookieStore cookieStore;
    private volatile Executor executor;

    public HttpClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTP);
        this.getProtocols().add(Protocol.HTTPS);
        this.authenticationStore = null;
        this.cookieStore = this.isCookieSupported() ? new HttpCookieStore.Default() : new HttpCookieStore.Empty();
        this.executor = null;
    }

    @Override
    public ClientCall create(Request request) {
        JettyClientCall result = null;
        try {
            result = new JettyClientCall(this, request.getMethod().toString(), ReferenceUtils.update(request.getResourceRef(), request).toString());
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Unable to create the Jetty HTTP/HTTPS client call", e);
        }
        return result;
    }

    protected HttpClient createHttpClient() {
        String httpComplianceMode;
        RestletSslContextFactoryClient sslContextFactory = null;
        try {
            sslContextFactory = new RestletSslContextFactoryClient(SslUtils.getSslContextFactory(this));
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to create the Jetty SSL context factory", e);
        }
        HttpTransportProtocol httpTransportProtocol = HttpTransportProtocol.fromName(this.getHttpClientTransportMode());
        HttpClientTransportOverHTTP httpTransport = switch (httpTransportProtocol.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> HttpClientHelper.getHttpTransportForHttp1_1();
            case 1 -> this.getHttpClientTransportForHttp2();
            case 2 -> this.getHttpClientTransportForHttp3(sslContextFactory);
            case 3 -> this.getHttpClientTransportForDynamicMode(sslContextFactory);
        };
        HttpClient httpClient = new HttpClient((HttpClientTransport)httpTransport);
        httpClient.setAddressResolutionTimeout(this.getAddressResolutionTimeout());
        if (this.getAuthenticationStore() != null) {
            httpClient.setAuthenticationStore(this.getAuthenticationStore());
        }
        httpClient.setBindAddress(this.getBindAddress());
        httpClient.setConnectBlocking(this.isConnectBlocking());
        httpClient.setConnectTimeout(this.getConnectTimeout());
        httpClient.setDestinationIdleTimeout(this.getDestinationIdleTimeout());
        httpClient.setExecutor(this.getExecutor());
        httpClient.setFollowRedirects(this.isFollowRedirects());
        HttpCompliance httpCompliance = switch (httpComplianceMode = this.getHttpComplianceMode()) {
            case "RFC7230" -> HttpCompliance.RFC7230;
            case "RFC7230_LEGACY" -> HttpCompliance.RFC7230_LEGACY;
            case "RFC2616" -> HttpCompliance.RFC2616;
            case "RFC2616_LEGACY" -> HttpCompliance.RFC2616_LEGACY;
            default -> {
                this.getLogger().log(Level.WARNING, "Unknown HTTP compliance mode: {0}, default to RFC7230", httpComplianceMode);
                yield HttpCompliance.RFC7230;
            }
        };
        httpClient.setHttpCompliance(httpCompliance);
        httpClient.setHttpCookieStore(this.getCookieStore());
        httpClient.setIdleTimeout(this.getIdleTimeout());
        httpClient.setMaxConnectionsPerDestination(this.getMaxConnectionsPerDestination());
        httpClient.setMaxRedirects(this.getMaxRedirects());
        httpClient.setMaxRequestsQueuedPerDestination(this.getMaxRequestsQueuedPerDestination());
        httpClient.setMaxResponseHeadersSize(this.getMaxResponseHeadersSize());
        String httpProxyHost = this.getProxyHost();
        if (httpProxyHost != null) {
            HttpProxy proxy = new HttpProxy(httpProxyHost, this.getProxyPort());
            httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)proxy);
        }
        httpClient.setRequestBufferSize(this.getRequestBufferSize());
        httpClient.setResponseBufferSize(this.getResponseBufferSize());
        httpClient.setScheduler(this.getScheduler());
        httpClient.setSslContextFactory((SslContextFactory.Client)sslContextFactory);
        httpClient.setStrictEventOrdering(this.isStrictEventOrdering());
        String userAgentField = this.getUserAgentField();
        if (userAgentField != null) {
            httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, userAgentField));
        }
        return httpClient;
    }

    private static HttpClientTransportOverHTTP getHttpTransportForHttp1_1() {
        return new HttpClientTransportOverHTTP();
    }

    private HttpClientTransport getHttpClientTransportForHttp2() {
        HTTP2Client http2Client = new HTTP2Client();
        HttpClientTransportOverHTTP2 http2Transport = new HttpClientTransportOverHTTP2(http2Client);
        http2Transport.setUseALPN(true);
        return http2Transport;
    }

    private HttpClientTransport getHttpClientTransportForHttp3(SslContextFactory.Client sslContextFactory) {
        Path pemWorkDirectory = this.getHttp3PemWorkDirectoryPath();
        ClientQuicConfiguration quicConfiguration = new ClientQuicConfiguration(sslContextFactory, pemWorkDirectory);
        HTTP3Client http3Client = new HTTP3Client(quicConfiguration);
        http3Client.getQuicConfiguration().setSessionRecvWindow(0x4000000);
        return new HttpClientTransportOverHTTP3(http3Client);
    }

    private HttpClientTransport getHttpClientTransportForDynamicMode(SslContextFactory.Client sslContextFactory) {
        ClientConnectionFactory.Info http1 = HttpClientConnectionFactory.HTTP11;
        HTTP2Client http2Client = new HTTP2Client();
        ClientConnectionFactoryOverHTTP2.HTTP2 http2 = new ClientConnectionFactoryOverHTTP2.HTTP2(http2Client);
        ClientQuicConfiguration quicConfiguration = new ClientQuicConfiguration(sslContextFactory, this.getHttp3PemWorkDirectoryPath());
        HTTP3Client http3Client = new HTTP3Client(quicConfiguration);
        ClientConnectionFactoryOverHTTP3.HTTP3 http3 = new ClientConnectionFactoryOverHTTP3.HTTP3(http3Client);
        return new HttpClientTransportDynamic(new ClientConnector(), new ClientConnectionFactory.Info[]{http1, http2, http3});
    }

    public long getAddressResolutionTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("addressResolutionTimeout", "15000"));
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    public void setAuthenticationStore(AuthenticationStore authenticationStore) {
        this.authenticationStore = authenticationStore;
    }

    public SocketAddress getBindAddress() {
        String bindAddress = this.getHelpedParameters().getFirstValue("bindAddress", null);
        String bindPort = this.getHelpedParameters().getFirstValue("bindPort", null);
        if (bindAddress != null && bindPort != null) {
            return new InetSocketAddress(bindAddress, Integer.parseInt(bindPort));
        }
        return null;
    }

    public long getConnectTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("connectTimeout", "15000"));
    }

    public HttpCookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(HttpCookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public long getDestinationIdleTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("destinationIdleTimeout", "0"));
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getHttpComplianceMode() {
        return this.getHelpedParameters().getFirstValue("httpComplianceMode", "RFC7230");
    }

    public String getHttpClientTransportMode() {
        return this.getHelpedParameters().getFirstValue("httpClientTransportMode", HttpTransportProtocol.HTTP1_1.name());
    }

    public String getHttp3PemWorkDir() {
        return this.getHelpedParameters().getFirstValue("http3PemWorkDir");
    }

    private Path getHttp3PemWorkDirectoryPath() {
        return Optional.ofNullable(this.getHttp3PemWorkDir()).map(x$0 -> Path.of(x$0, new String[0])).orElse(null);
    }

    public long getIdleTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("idleTimeout", "30000"));
    }

    public int getMaxConnectionsPerDestination() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerDestination", "64"));
    }

    public int getMaxRedirects() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxRedirects", "8"));
    }

    public int getMaxRequestsQueuedPerDestination() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxRequestsQueuedPerDestination", "1024"));
    }

    public int getMaxResponseHeadersSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxResponseHeadersSize", "-1"));
    }

    public String getProxyHost() {
        return this.getHelpedParameters().getFirstValue("proxyHost", System.getProperty("http.proxyHost"));
    }

    public int getProxyPort() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("proxyPort", System.getProperty("http.proxyPort", "3128")));
    }

    public int getRequestBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("requestBufferSize", "4096"));
    }

    public int getResponseBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("responseBufferSize", "16384"));
    }

    public Scheduler getScheduler() {
        return null;
    }

    public String getUserAgentField() {
        return this.getHelpedParameters().getFirstValue("userAgentField", null);
    }

    public boolean isConnectBlocking() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("connectBlocking", "false"));
    }

    public boolean isCookieSupported() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("cookieSupported", "false"));
    }

    public boolean isFollowRedirects() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("followRedirects", "true"));
    }

    public boolean isStrictEventOrdering() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("strictEventOrdering", "false"));
    }

    @Override
    public void start() throws Exception {
        HttpClient httpClient;
        super.start();
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        if ((httpClient = this.getHttpClient()) != null) {
            this.getLogger().info("Starting a Jetty HTTP/HTTPS client");
            httpClient.start();
        }
    }

    @Override
    public void stop() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient != null) {
            this.getLogger().info("Stopping a Jetty HTTP/HTTPS client");
            httpClient.stop();
        }
        super.stop();
    }

    private static enum HttpTransportProtocol {
        HTTP1_1,
        HTTP2,
        HTTP3,
        DYNAMIC;


        static HttpTransportProtocol fromName(String name) {
            try {
                return HttpTransportProtocol.valueOf(name);
            }
            catch (IllegalArgumentException iae) {
                String supportedHttpTransportProtocols = Arrays.toString((Object[])HttpTransportProtocol.values());
                String errorMessage = String.format("'%s' is not one of the supported values: %s", name, supportedHttpTransportProtocols);
                throw new IllegalArgumentException(errorMessage);
            }
        }
    }
}

