/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.eclipse.jetty.client.InputStreamRequestContent;
import org.eclipse.jetty.client.InputStreamResponseListener;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Header;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.connector.HttpClientHelper;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class JettyClientCall
extends ClientCall {
    private final HttpClientHelper clientHelper;
    private final org.eclipse.jetty.client.Request request;
    private volatile org.eclipse.jetty.client.Response response;
    private volatile InputStreamResponseListener inputStreamResponseListener;
    private volatile boolean responseHeadersAdded;

    public JettyClientCall(HttpClientHelper helper, String method, String requestUri) throws IOException {
        super(helper, method, requestUri);
        this.clientHelper = helper;
        if (!requestUri.startsWith("http")) {
            throw new IllegalArgumentException("Only HTTP or HTTPS resource URIs are allowed here");
        }
        this.request = helper.getHttpClient().newRequest(requestUri);
        this.request.method(method);
        this.setConfidential(this.request.getURI().getScheme().equalsIgnoreCase(Protocol.HTTPS.getSchemeName()));
    }

    public org.eclipse.jetty.client.Request getRequest() {
        return this.request;
    }

    public org.eclipse.jetty.client.Response getResponse() {
        return this.response;
    }

    public InputStreamResponseListener getInputStreamResponseListener() {
        return this.inputStreamResponseListener;
    }

    @Override
    public String getReasonPhrase() {
        org.eclipse.jetty.client.Response httpResponse = this.getResponse();
        return httpResponse == null ? null : httpResponse.getReason();
    }

    @Override
    public OutputStream getRequestEntityStream() {
        return null;
    }

    @Override
    public OutputStream getRequestHeadStream() {
        return null;
    }

    @Override
    public InputStream getResponseEntityStream(long size) {
        InputStreamResponseListener inputStreamResponseListener = this.getInputStreamResponseListener();
        return inputStreamResponseListener == null ? null : inputStreamResponseListener.getInputStream();
    }

    @Override
    public Representation getResponseEntity(Response response) {
        Representation responseEntity = super.getResponseEntity(response);
        if (responseEntity != null && !responseEntity.getEncodings().isEmpty()) {
            responseEntity.getEncodings().clear();
            responseEntity.setSize(-1L);
        }
        return responseEntity;
    }

    @Override
    public Series<Header> getResponseHeaders() {
        Series<Header> result = super.getResponseHeaders();
        if (!this.responseHeadersAdded) {
            HttpFields headers;
            org.eclipse.jetty.client.Response httpResponse = this.getResponse();
            if (httpResponse != null && (headers = httpResponse.getHeaders()) != null) {
                for (HttpField header : headers) {
                    result.add(header.getName(), header.getValue());
                }
            }
            this.responseHeadersAdded = true;
        }
        return result;
    }

    @Override
    public String getServerAddress() {
        return this.request.getURI().getHost();
    }

    @Override
    public int getStatusCode() {
        return this.getResponse().getStatus();
    }

    @Override
    public Status sendRequest(Request request) {
        Status result = null;
        try {
            Representation entity = request.getEntity();
            if (entity != null && entity.isAvailable()) {
                this.request.body((Request.Content)new InputStreamRequestContent(entity.getStream()));
            }
            block13: for (Header header : this.getRequestHeaders()) {
                String name;
                switch (name = header.getName()) {
                    case "Content-Length": {
                        continue block13;
                    }
                    case "User-Agent": {
                        this.request.agent(header.getValue());
                        continue block13;
                    }
                }
                ((HttpFields.Mutable)this.request.getHeaders()).add(name, header.getValue());
            }
            this.inputStreamResponseListener = new InputStreamResponseListener();
            this.request.send((Response.CompleteListener)this.inputStreamResponseListener);
            this.response = this.inputStreamResponseListener.get(this.clientHelper.getIdleTimeout(), TimeUnit.MILLISECONDS);
            result = new Status(this.getStatusCode(), this.getReasonPhrase());
        }
        catch (IOException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "An error occurred while reading the request entity.", e);
            result = new Status(Status.CONNECTOR_ERROR_INTERNAL, (Throwable)e);
            this.getRequest().abort((Throwable)e);
        }
        catch (TimeoutException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "The HTTP request timed out.", e);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)e);
            this.getRequest().abort((Throwable)e);
        }
        catch (InterruptedException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "The HTTP request thread was interrupted.", e);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)e);
            this.getRequest().abort((Throwable)e);
        }
        catch (ExecutionException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "An error occurred while processing the HTTP request.", e);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)e);
            this.getRequest().abort((Throwable)e);
        }
        return result;
    }

    @Override
    public void sendRequest(Request request, Response response, Uniform callback) throws Exception {
        this.sendRequest(request);
        Uniform getOnSent = request.getOnSent();
        if (getOnSent != null) {
            getOnSent.handle(request, response);
        }
        if (callback != null) {
            callback.handle(request, response);
        }
    }
}

