/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.List;
import java.util.Objects;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.NamedValue;

public final class CacheDirective
implements NamedValue<String> {
    private boolean digit;
    private volatile String name;
    private volatile String value;

    public static CacheDirective maxAge(int maxAge) {
        return new CacheDirective("max-age", Integer.toString(maxAge), true);
    }

    public static CacheDirective maxStale() {
        return new CacheDirective("max-stale");
    }

    public static CacheDirective maxStale(int maxStale) {
        return new CacheDirective("max-stale", Integer.toString(maxStale), true);
    }

    public static CacheDirective minFresh(int minFresh) {
        return new CacheDirective("min-fresh", Integer.toString(minFresh), true);
    }

    public static CacheDirective mustRevalidate() {
        return new CacheDirective("must-revalidate");
    }

    public static CacheDirective noCache() {
        return new CacheDirective("no-cache");
    }

    public static CacheDirective noCache(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder();
        if (fieldNames != null) {
            for (int i = 0; i < fieldNames.size(); ++i) {
                sb.append("\"").append(fieldNames.get(i)).append("\"");
                if (i >= fieldNames.size() - 1) continue;
                sb.append(',');
            }
        }
        return new CacheDirective("no-cache", sb.toString());
    }

    public static CacheDirective noCache(String fieldName) {
        return new CacheDirective("no-cache", "\"" + fieldName + "\"");
    }

    public static CacheDirective noStore() {
        return new CacheDirective("no-store");
    }

    public static CacheDirective noTransform() {
        return new CacheDirective("no-transform");
    }

    public static CacheDirective onlyIfCached() {
        return new CacheDirective("only-if-cached");
    }

    public static CacheDirective privateInfo() {
        return new CacheDirective("private");
    }

    public static CacheDirective privateInfo(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder();
        if (fieldNames != null) {
            for (int i = 0; i < fieldNames.size(); ++i) {
                sb.append("\"").append(fieldNames.get(i)).append("\"");
                if (i >= fieldNames.size() - 1) continue;
                sb.append(',');
            }
        }
        return new CacheDirective("private", sb.toString());
    }

    public static CacheDirective privateInfo(String fieldName) {
        return new CacheDirective("private", "\"" + fieldName + "\"");
    }

    public static CacheDirective proxyMustRevalidate() {
        return new CacheDirective("proxy-revalidate");
    }

    public static CacheDirective publicInfo() {
        return new CacheDirective("public");
    }

    public static CacheDirective sharedMaxAge(int sharedMaxAge) {
        return new CacheDirective("s-maxage", Integer.toString(sharedMaxAge), true);
    }

    public CacheDirective(String name) {
        this(name, null);
    }

    public CacheDirective(String name, String value) {
        this(name, value, false);
    }

    public CacheDirective(String name, String value, boolean digit) {
        this.name = name;
        this.value = value;
        this.digit = digit;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CacheDirective)) {
            return false;
        }
        CacheDirective that = (CacheDirective)obj;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getValue(), that.getValue()) && this.digit == that.digit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.getName(), this.getValue(), this.isDigit());
    }

    public boolean isDigit() {
        return this.digit;
    }

    public void setDigit(boolean digit) {
        this.digit = digit;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "CacheDirective [digit=" + this.digit + ", name=" + this.name + ", value=" + this.value + "]";
    }
}

