/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

public final class Status {
    private static final String BASE_ADDED_HTTP = "http://tools.ietf.org/html/rfc6585";
    private static final String BASE_HTTP = "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html";
    private static final String BASE_RESTLET = "https://javadoc.io/static/org.restlet/org.restlet/2.6.0-rc1/";
    public static final Status CLIENT_ERROR_BAD_REQUEST = new Status(400);
    public static final Status CLIENT_ERROR_CONFLICT = new Status(409);
    public static final Status CLIENT_ERROR_EXPECTATION_FAILED = new Status(417);
    public static final Status CLIENT_ERROR_FORBIDDEN = new Status(403);
    public static final Status CLIENT_ERROR_GONE = new Status(410);
    public static final Status CLIENT_ERROR_LENGTH_REQUIRED = new Status(411);
    public static final Status CLIENT_ERROR_METHOD_NOT_ALLOWED = new Status(405);
    public static final Status CLIENT_ERROR_NOT_ACCEPTABLE = new Status(406);
    public static final Status CLIENT_ERROR_NOT_FOUND = new Status(404);
    public static final Status CLIENT_ERROR_PAYMENT_REQUIRED = new Status(402);
    public static final Status CLIENT_ERROR_PRECONDITION_FAILED = new Status(412);
    public static final Status CLIENT_ERROR_PROXY_AUTHENTIFICATION_REQUIRED = new Status(407);
    public static final Status CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE = new Status(413);
    public static final Status CLIENT_ERROR_REQUEST_TIMEOUT = new Status(408);
    public static final Status CLIENT_ERROR_REQUEST_URI_TOO_LONG = new Status(414);
    public static final Status CLIENT_ERROR_REQUESTED_RANGE_NOT_SATISFIABLE = new Status(416);
    public static final Status CLIENT_ERROR_TOO_MANY_REQUESTS = new Status(429);
    public static final Status CLIENT_ERROR_UNAUTHORIZED = new Status(401);
    public static final Status CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE = new Status(415);
    public static final Status CONNECTOR_ERROR_COMMUNICATION = new Status(1001);
    public static final Status CONNECTOR_ERROR_CONNECTION = new Status(1000);
    public static final Status CONNECTOR_ERROR_INTERNAL = new Status(1002);
    public static final Status INFO_CONTINUE = new Status(100);
    public static final Status INFO_DISCONNECTED_OPERATION = new Status(112);
    public static final Status INFO_HEURISTIC_EXPIRATION = new Status(113);
    public static final Status INFO_MISC_WARNING = new Status(199);
    public static final Status INFO_REVALIDATION_FAILED = new Status(111);
    public static final Status INFO_STALE_RESPONSE = new Status(110);
    public static final Status INFO_SWITCHING_PROTOCOL = new Status(101);
    public static final Status REDIRECTION_FOUND = new Status(302);
    public static final Status REDIRECTION_MULTIPLE_CHOICES = new Status(300);
    public static final Status REDIRECTION_NOT_MODIFIED = new Status(304);
    public static final Status REDIRECTION_PERMANENT = new Status(301);
    public static final Status REDIRECTION_SEE_OTHER = new Status(303);
    public static final Status REDIRECTION_TEMPORARY = new Status(307);
    public static final Status REDIRECTION_USE_PROXY = new Status(305);
    public static final Status SERVER_ERROR_BAD_GATEWAY = new Status(502);
    public static final Status SERVER_ERROR_GATEWAY_TIMEOUT = new Status(504);
    public static final Status SERVER_ERROR_INTERNAL = new Status(500);
    public static final Status SERVER_ERROR_NOT_IMPLEMENTED = new Status(501);
    public static final Status SERVER_ERROR_SERVICE_UNAVAILABLE = new Status(503);
    public static final Status SERVER_ERROR_VERSION_NOT_SUPPORTED = new Status(505);
    public static final Status SUCCESS_ACCEPTED = new Status(202);
    public static final Status SUCCESS_CREATED = new Status(201);
    public static final Status SUCCESS_MISC_PERSISTENT_WARNING = new Status(299);
    public static final Status SUCCESS_NO_CONTENT = new Status(204);
    public static final Status SUCCESS_NON_AUTHORITATIVE = new Status(203);
    public static final Status SUCCESS_OK = new Status(200);
    public static final Status SUCCESS_PARTIAL_CONTENT = new Status(206);
    public static final Status SUCCESS_RESET_CONTENT = new Status(205);
    public static final Status SUCCESS_TRANSFORMATION_APPLIED = new Status(214);
    private final int code;
    private final String description;
    private volatile String reasonPhrase;
    private final Throwable throwable;
    private final String uri;

    private static String checkReasonPhrase(String reasonPhrase) {
        if (reasonPhrase != null && (reasonPhrase.contains("\n") || reasonPhrase.contains("\r"))) {
            throw new IllegalArgumentException("Reason phrase of the status must not contain CR or LF characters.");
        }
        return reasonPhrase;
    }

    public static boolean isClientError(int code) {
        return code >= 400 && code <= 499;
    }

    public static boolean isConnectorError(int code) {
        return code >= 1000 && code <= 1099;
    }

    public static boolean isError(int code) {
        return Status.isClientError(code) || Status.isServerError(code) || Status.isConnectorError(code) || Status.isGlobalError(code);
    }

    public static boolean isGlobalError(int code) {
        return code >= 600 && code <= 699;
    }

    public static boolean isInformational(int code) {
        return code >= 100 && code <= 199;
    }

    public static boolean isRedirection(int code) {
        return code >= 300 && code <= 399;
    }

    public static boolean isServerError(int code) {
        return code >= 500 && code <= 599;
    }

    public static boolean isSuccess(int code) {
        return code >= 200 && code <= 299;
    }

    public static Status valueOf(int code) {
        switch (code) {
            case 100: {
                return INFO_CONTINUE;
            }
            case 101: {
                return INFO_SWITCHING_PROTOCOL;
            }
            case 110: {
                return INFO_STALE_RESPONSE;
            }
            case 111: {
                return INFO_REVALIDATION_FAILED;
            }
            case 112: {
                return INFO_DISCONNECTED_OPERATION;
            }
            case 113: {
                return INFO_HEURISTIC_EXPIRATION;
            }
            case 199: {
                return INFO_MISC_WARNING;
            }
            case 200: {
                return SUCCESS_OK;
            }
            case 201: {
                return SUCCESS_CREATED;
            }
            case 202: {
                return SUCCESS_ACCEPTED;
            }
            case 203: {
                return SUCCESS_NON_AUTHORITATIVE;
            }
            case 204: {
                return SUCCESS_NO_CONTENT;
            }
            case 205: {
                return SUCCESS_RESET_CONTENT;
            }
            case 206: {
                return SUCCESS_PARTIAL_CONTENT;
            }
            case 214: {
                return SUCCESS_TRANSFORMATION_APPLIED;
            }
            case 299: {
                return SUCCESS_MISC_PERSISTENT_WARNING;
            }
            case 300: {
                return REDIRECTION_MULTIPLE_CHOICES;
            }
            case 301: {
                return REDIRECTION_PERMANENT;
            }
            case 302: {
                return REDIRECTION_FOUND;
            }
            case 303: {
                return REDIRECTION_SEE_OTHER;
            }
            case 304: {
                return REDIRECTION_NOT_MODIFIED;
            }
            case 305: {
                return REDIRECTION_USE_PROXY;
            }
            case 307: {
                return REDIRECTION_TEMPORARY;
            }
            case 400: {
                return CLIENT_ERROR_BAD_REQUEST;
            }
            case 401: {
                return CLIENT_ERROR_UNAUTHORIZED;
            }
            case 402: {
                return CLIENT_ERROR_PAYMENT_REQUIRED;
            }
            case 403: {
                return CLIENT_ERROR_FORBIDDEN;
            }
            case 404: {
                return CLIENT_ERROR_NOT_FOUND;
            }
            case 405: {
                return CLIENT_ERROR_METHOD_NOT_ALLOWED;
            }
            case 406: {
                return CLIENT_ERROR_NOT_ACCEPTABLE;
            }
            case 407: {
                return CLIENT_ERROR_PROXY_AUTHENTIFICATION_REQUIRED;
            }
            case 408: {
                return CLIENT_ERROR_REQUEST_TIMEOUT;
            }
            case 409: {
                return CLIENT_ERROR_CONFLICT;
            }
            case 410: {
                return CLIENT_ERROR_GONE;
            }
            case 411: {
                return CLIENT_ERROR_LENGTH_REQUIRED;
            }
            case 412: {
                return CLIENT_ERROR_PRECONDITION_FAILED;
            }
            case 413: {
                return CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE;
            }
            case 414: {
                return CLIENT_ERROR_REQUEST_URI_TOO_LONG;
            }
            case 415: {
                return CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE;
            }
            case 416: {
                return CLIENT_ERROR_REQUESTED_RANGE_NOT_SATISFIABLE;
            }
            case 417: {
                return CLIENT_ERROR_EXPECTATION_FAILED;
            }
            case 429: {
                return CLIENT_ERROR_TOO_MANY_REQUESTS;
            }
            case 500: {
                return SERVER_ERROR_INTERNAL;
            }
            case 501: {
                return SERVER_ERROR_NOT_IMPLEMENTED;
            }
            case 502: {
                return SERVER_ERROR_BAD_GATEWAY;
            }
            case 503: {
                return SERVER_ERROR_SERVICE_UNAVAILABLE;
            }
            case 504: {
                return SERVER_ERROR_GATEWAY_TIMEOUT;
            }
            case 505: {
                return SERVER_ERROR_VERSION_NOT_SUPPORTED;
            }
            case 1000: {
                return CONNECTOR_ERROR_CONNECTION;
            }
            case 1001: {
                return CONNECTOR_ERROR_COMMUNICATION;
            }
            case 1002: {
                return CONNECTOR_ERROR_INTERNAL;
            }
        }
        return new Status(code);
    }

    public Status(int code) {
        this(code, null, null, null, null);
    }

    public Status(int code, String reasonPhrase) {
        this(code, null, reasonPhrase, null, null);
    }

    public Status(int code, String reasonPhrase, String description) {
        this(code, null, reasonPhrase, description, null);
    }

    public Status(int code, String reasonPhrase, String description, String uri) {
        this(code, null, reasonPhrase, description, uri);
    }

    public Status(int code, Throwable throwable) {
        this(code, throwable, null, null, null);
    }

    public Status(int code, Throwable throwable, String reasonPhrase) {
        this(code, throwable, reasonPhrase, null, null);
    }

    public Status(int code, Throwable throwable, String reasonPhrase, String description) {
        this(code, throwable, reasonPhrase, description, null);
    }

    public Status(int code, Throwable throwable, String reasonPhrase, String description, String uri) {
        this.code = code;
        this.throwable = throwable;
        this.reasonPhrase = Status.checkReasonPhrase(reasonPhrase);
        this.description = description;
        this.uri = uri;
    }

    public Status(Status status, String description) {
        this(status, null, null, description);
    }

    public Status(Status status, String reasonPhrase, String description) {
        this(status, null, reasonPhrase, description);
    }

    public Status(Status status, Throwable throwable) {
        this(status, throwable, null, null);
    }

    public Status(Status status, Throwable throwable, String reasonPhrase) {
        this(status, throwable, reasonPhrase, null);
    }

    public Status(Status status, Throwable throwable, String reasonPhrase, String description) {
        this(status.getCode(), throwable == null ? status.getThrowable() : throwable, reasonPhrase == null ? status.getReasonPhrase() : reasonPhrase, description == null ? status.getDescription() : description, status.getUri());
    }

    public boolean equals(Object object) {
        return object instanceof Status && this.code == ((Status)object).getCode();
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        switch (this.code) {
            case 100: {
                return "The client should continue with its request";
            }
            case 101: {
                return "The server is willing to change the application protocol being used on this connection";
            }
            case 110: {
                return "MUST be included whenever the returned response is stale";
            }
            case 111: {
                return "MUST be included if a cache returns a stale response because an attempt to revalidate the response failed, due to an inability to reach the server";
            }
            case 112: {
                return "SHOULD be included if the cache is intentionally disconnected from the rest of the network for a period of time";
            }
            case 113: {
                return "MUST be included if the cache heuristically chose a freshness lifetime greater than 24 hours and the response's age is greater than 24 hours";
            }
            case 199: {
                return "The warning text MAY include arbitrary information to be presented to a human user, or logged. A system receiving this warning MUST NOT take any automated action, besides presenting the warning to the user";
            }
            case 200: {
                return "The request has succeeded";
            }
            case 201: {
                return "The request has been fulfilled and resulted in a new resource being created";
            }
            case 202: {
                return "The request has been accepted for processing, but the processing has not been completed";
            }
            case 203: {
                return "The returned meta-information is not the definitive set as available from the origin server";
            }
            case 204: {
                return "The server has fulfilled the request but does not need to return an entity-body, and might want to return updated meta-information";
            }
            case 205: {
                return "The server has fulfilled the request and the user agent should reset the document view which caused the request to be sent";
            }
            case 206: {
                return "The server has fulfilled the partial get request for the resource";
            }
            case 214: {
                return "MUST be added by an intermediate cache or proxy if it applies any transformation changing the content-coding (as specified in the Content-Encoding header) or media-type (as specified in the Content-Type header) of the response, or the entity-body of the response, unless this Warning code already appears in the response";
            }
            case 299: {
                return "The warning text MAY include arbitrary information to be presented to a human user, or logged. A system receiving this warning MUST NOT take any automated action";
            }
            case 300: {
                return "The requested resource corresponds to any one of a set of representations";
            }
            case 301: {
                return "The requested resource has been assigned a new permanent URI";
            }
            case 302: {
                return "The requested resource can be found under a different URI";
            }
            case 303: {
                return "The response to the request can be found under a different URI";
            }
            case 304: {
                return "The client has performed a conditional GET request and the document has not been modified";
            }
            case 305: {
                return "The requested resource must be accessed through the proxy given by the location field";
            }
            case 307: {
                return "The requested resource resides temporarily under a different URI";
            }
            case 400: {
                return "The request could not be understood by the server due to malformed syntax";
            }
            case 401: {
                return "The request requires user authentication";
            }
            case 402: {
                return "This code is reserved for future use";
            }
            case 403: {
                return "The server understood the request, but is refusing to fulfill it";
            }
            case 404: {
                return "The server has not found anything matching the request URI";
            }
            case 405: {
                return "The method specified in the request is not allowed for the resource identified by the request URI";
            }
            case 406: {
                return "The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request";
            }
            case 407: {
                return "This code is similar to Unauthorized, but indicates that the client must first authenticate itself with the proxy";
            }
            case 408: {
                return "The client did not produce a request within the time that the server was prepared to wait";
            }
            case 409: {
                return "The request could not be completed due to a conflict with the current state of the resource";
            }
            case 410: {
                return "The requested resource is no longer available at the server and no forwarding address is known";
            }
            case 411: {
                return "The server refuses to accept the request without a defined content length";
            }
            case 412: {
                return "The precondition given in one or more of the request header fields evaluated to false when it was tested on the server";
            }
            case 413: {
                return "The server is refusing to process a request because the request entity is larger than the server is willing or able to process";
            }
            case 414: {
                return "The server is refusing to service the request because the request URI is longer than the server is willing to interpret";
            }
            case 415: {
                return "The server is refusing to service the request because the entity of the request is in a format not supported by the requested resource for the requested method";
            }
            case 416: {
                return "For byte ranges, this means that the first byte position were greater than the current length of the selected resource";
            }
            case 417: {
                return "The expectation given in the request header could not be met by this server";
            }
            case 429: {
                return "The server is refusing to service the request because the user has sent too many requests in a given amount of time (\"rate limiting\")";
            }
            case 500: {
                return "The server encountered an unexpected condition which prevented it from fulfilling the request";
            }
            case 501: {
                return "The server does not support the functionality required to fulfill the request";
            }
            case 502: {
                return "The server, while acting as a gateway or proxy, received an invalid response from the upstream server it accessed in attempting to fulfill the request";
            }
            case 503: {
                return "The server is currently unable to handle the request due to a temporary overloading or maintenance of the server";
            }
            case 504: {
                return "The server, while acting as a gateway or proxy, did not receive a timely response from the upstream server specified by the URI (e.g. HTTP, FTP, LDAP) or some other auxiliary server (e.g. DNS) it needed to access in attempting to complete the request";
            }
            case 505: {
                return "The server does not support, or refuses to support, the protocol version that was used in the request message";
            }
            case 1000: {
                return "The connector failed to connect to the server";
            }
            case 1001: {
                return "The connector failed to complete the communication with the server";
            }
            case 1002: {
                return "The connector encountered an unexpected condition which prevented it from fulfilling the request";
            }
        }
        return null;
    }

    public String getReasonPhrase() {
        if (this.reasonPhrase != null) {
            return this.reasonPhrase;
        }
        switch (this.code) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 110: {
                return "Response is stale";
            }
            case 111: {
                return "Revalidation failed";
            }
            case 112: {
                return "Disconnected operation";
            }
            case 113: {
                return "Heuristic expiration";
            }
            case 199: {
                return "Miscellaneous warning";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 214: {
                return "Transformation applied";
            }
            case 299: {
                return "Miscellaneous persistent warning";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 429: {
                return "Too Many Requests";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "Version Not Supported";
            }
            case 1000: {
                return "Connection Error";
            }
            case 1001: {
                return "Communication Error";
            }
            case 1002: {
                return "Internal Connector Error";
            }
        }
        return null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getUri() {
        if (this.uri != null) {
            return this.uri;
        }
        switch (this.code) {
            case 100: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.1.1";
            }
            case 101: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.1.2";
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 199: 
            case 214: 
            case 299: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.46";
            }
            case 200: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.1";
            }
            case 201: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.2";
            }
            case 202: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.3";
            }
            case 203: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.4";
            }
            case 204: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.5";
            }
            case 205: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.6";
            }
            case 206: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.7";
            }
            case 300: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.1";
            }
            case 301: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.2";
            }
            case 302: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.3";
            }
            case 303: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.4";
            }
            case 304: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.5";
            }
            case 305: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.6";
            }
            case 307: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.8";
            }
            case 400: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.1";
            }
            case 401: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.2";
            }
            case 402: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.3";
            }
            case 403: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.4";
            }
            case 404: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.5";
            }
            case 405: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.6";
            }
            case 406: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.7";
            }
            case 407: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.8";
            }
            case 408: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.9";
            }
            case 409: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.10";
            }
            case 410: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.11";
            }
            case 411: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.12";
            }
            case 412: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.13";
            }
            case 413: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.14";
            }
            case 414: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.15";
            }
            case 415: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.16";
            }
            case 416: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.17";
            }
            case 417: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.18";
            }
            case 429: {
                return "http://tools.ietf.org/html/rfc6585#section-4";
            }
            case 500: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.1";
            }
            case 501: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.2";
            }
            case 502: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.3";
            }
            case 503: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.4";
            }
            case 504: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.5";
            }
            case 505: {
                return "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.6";
            }
            case 1000: {
                return "https://javadoc.io/static/org.restlet/org.restlet/2.6.0-rc1/org/restlet/data/Status.html#CONNECTOR_ERROR_CONNECTION";
            }
            case 1001: {
                return "https://javadoc.io/static/org.restlet/org.restlet/2.6.0-rc1/org/restlet/data/Status.html#CONNECTOR_ERROR_COMMUNICATION";
            }
            case 1002: {
                return "https://javadoc.io/static/org.restlet/org.restlet/2.6.0-rc1/org/restlet/data/Status.html#CONNECTOR_ERROR_INTERNAL";
            }
        }
        return null;
    }

    public int hashCode() {
        return this.getCode();
    }

    public boolean isClientError() {
        return Status.isClientError(this.getCode());
    }

    public boolean isConnectorError() {
        return Status.isConnectorError(this.getCode());
    }

    public boolean isError() {
        return Status.isError(this.getCode());
    }

    public boolean isGlobalError() {
        return Status.isGlobalError(this.getCode());
    }

    public boolean isInformational() {
        return Status.isInformational(this.getCode());
    }

    public boolean isRecoverableError() {
        return this.isConnectorError() || this.equals(CLIENT_ERROR_REQUEST_TIMEOUT) || this.equals(SERVER_ERROR_GATEWAY_TIMEOUT) || this.equals(SERVER_ERROR_SERVICE_UNAVAILABLE);
    }

    public boolean isRedirection() {
        return Status.isRedirection(this.getCode());
    }

    public boolean isServerError() {
        return Status.isServerError(this.getCode());
    }

    public boolean isSuccess() {
        return Status.isSuccess(this.getCode());
    }

    public String toString() {
        return this.getReasonPhrase() + " (" + this.code + ")" + (String)(this.getDescription() == null ? "" : " - " + this.getDescription());
    }
}

