/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.data.Protocol;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.connector.HttpUrlConnectionCall;
import org.restlet.engine.util.ReferenceUtils;

public class HttpClientHelper
extends org.restlet.engine.adapter.HttpClientHelper {
    public HttpClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTP);
        this.getProtocols().add(Protocol.HTTPS);
    }

    @Override
    public ClientCall create(Request request) {
        HttpUrlConnectionCall result = null;
        try {
            result = new HttpUrlConnectionCall(this, request.getMethod().toString(), ReferenceUtils.update(request.getResourceRef(), request).toString(), request.isEntityAvailable());
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the HTTP client call", ioe);
        }
        return result;
    }

    public int getChunkLength() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("chunkLength", "0"));
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.getContext() == null ? null : this.getContext().getAttributes().get("hostnameVerifier");
    }

    public int getReadTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("readTimeout", "60000"));
    }

    public boolean isAllowUserInteraction() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("allowUserInteraction", "false"));
    }

    public boolean isFollowRedirects() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("followRedirects", "false"));
    }

    public boolean isUseCaches() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("useCaches", "false"));
    }

    @Override
    public synchronized void start() throws Exception {
        super.start();
        this.getLogger().info("Starting the internal HTTP client");
    }

    @Override
    public synchronized void stop() throws Exception {
        super.stop();
        this.getLogger().info("Stopping the internal HTTP client");
    }
}

