/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.engine.Engine;
import org.restlet.engine.component.ComponentHelper;
import org.restlet.engine.component.InternalRouter;
import org.restlet.routing.Router;
import org.restlet.routing.VirtualHost;
import org.restlet.security.Realm;
import org.restlet.service.LogService;
import org.restlet.service.StatusService;
import org.restlet.service.TaskService;
import org.restlet.util.ClientList;
import org.restlet.util.ServerList;
import org.restlet.util.ServiceList;

public class Component
extends Restlet {
    private final ClientList clients;
    private volatile VirtualHost defaultHost;
    private volatile ComponentHelper helper;
    private final List<VirtualHost> hosts = new CopyOnWriteArrayList<VirtualHost>();
    private volatile Router internalRouter;
    private final List<Realm> realms;
    private final ServerList servers;
    private final ServiceList services;

    public Component() {
        this.clients = new ClientList(null);
        this.servers = new ServerList(null, this);
        this.realms = new CopyOnWriteArrayList<Realm>();
        this.services = new ServiceList(this.getContext());
        if (Engine.getInstance() != null) {
            this.services.add(new TaskService());
            this.helper = new ComponentHelper(this);
            Context childContext = this.getContext().createChildContext();
            this.defaultHost = new VirtualHost(childContext);
            this.internalRouter = new InternalRouter(childContext);
            this.services.add(new LogService());
            this.getLogService().setContext(childContext);
            this.services.add(new StatusService());
            this.getStatusService().setContext(childContext);
            this.clients.setContext(childContext);
            this.servers.setContext(childContext);
        }
    }

    public ClientList getClients() {
        return this.clients;
    }

    public VirtualHost getDefaultHost() {
        return this.defaultHost;
    }

    private ComponentHelper getHelper() {
        return this.helper;
    }

    public List<VirtualHost> getHosts() {
        return this.hosts;
    }

    public Router getInternalRouter() {
        return this.internalRouter;
    }

    public LogService getLogService() {
        return this.getServices().get(LogService.class);
    }

    public Realm getRealm(String name) {
        if (name != null) {
            for (Realm realm : this.getRealms()) {
                if (!name.equals(realm.getName())) continue;
                return realm;
            }
        }
        return null;
    }

    public List<Realm> getRealms() {
        return this.realms;
    }

    public ServerList getServers() {
        return this.servers;
    }

    public ServiceList getServices() {
        return this.services;
    }

    @Deprecated
    public StatusService getStatusService() {
        return this.getServices().get(StatusService.class);
    }

    public TaskService getTaskService() {
        return this.getServices().get(TaskService.class);
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClients(ClientList clients) {
        ClientList clientList = this.getClients();
        synchronized (clientList) {
            if (clients != this.getClients()) {
                this.getClients().clear();
                if (clients != null) {
                    this.getClients().addAll(clients);
                }
            }
        }
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.getServices().setContext(context);
    }

    public void setDefaultHost(VirtualHost defaultHost) {
        this.defaultHost = defaultHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHosts(List<VirtualHost> hosts) {
        List<VirtualHost> list = this.getHosts();
        synchronized (list) {
            if (hosts != this.getHosts()) {
                this.getHosts().clear();
                if (hosts != null) {
                    this.getHosts().addAll(hosts);
                }
            }
        }
    }

    public void setInternalRouter(Router internalRouter) {
        this.internalRouter = internalRouter;
    }

    public void setLogService(LogService logService) {
        this.getServices().set(logService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealms(List<Realm> realms) {
        List<Realm> list = this.getRealms();
        synchronized (list) {
            if (realms != this.getRealms()) {
                this.getRealms().clear();
                if (realms != null) {
                    this.getRealms().addAll(realms);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServers(ServerList servers) {
        ServerList serverList = this.getServers();
        synchronized (serverList) {
            if (servers != this.getServers()) {
                this.getServers().clear();
                if (servers != null) {
                    this.getServers().addAll(servers);
                }
            }
        }
    }

    @Deprecated
    public void setStatusService(StatusService statusService) {
        this.getServices().set(statusService);
    }

    public void setTaskService(TaskService taskService) {
        this.getServices().set(taskService);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            this.startClients();
            this.startServers();
            this.startRouters();
            this.startServices();
            this.startRealms();
            this.startHelper();
            super.start();
        }
    }

    protected synchronized void startClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.start();
            }
        }
    }

    protected synchronized void startHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().start();
        }
    }

    protected synchronized void startRealms() throws Exception {
        if (this.realms != null) {
            for (Realm realm : this.realms) {
                realm.start();
            }
        }
    }

    protected synchronized void startRouters() throws Exception {
        if (this.internalRouter != null) {
            this.internalRouter.start();
        }
        if (this.defaultHost != null) {
            this.defaultHost.start();
        }
        for (VirtualHost host : this.getHosts()) {
            host.start();
        }
    }

    protected synchronized void startServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.start();
            }
        }
    }

    protected synchronized void startServices() throws Exception {
        this.getServices().start();
    }

    @Override
    public synchronized void stop() throws Exception {
        this.stopHelper();
        this.stopRealms();
        this.stopServices();
        this.stopRouters();
        this.stopServers();
        this.stopClients();
        super.stop();
    }

    protected synchronized void stopClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.stop();
            }
        }
    }

    protected synchronized void stopHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().stop();
        }
    }

    protected synchronized void stopRealms() throws Exception {
        if (this.realms != null) {
            for (Realm realm : this.realms) {
                realm.stop();
            }
        }
    }

    protected synchronized void stopRouters() throws Exception {
        for (VirtualHost host : this.getHosts()) {
            host.stop();
        }
        if (this.defaultHost != null) {
            this.defaultHost.stop();
        }
        if (this.internalRouter != null) {
            this.internalRouter.stop();
        }
    }

    protected synchronized void stopServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.stop();
            }
        }
    }

    protected synchronized void stopServices() throws Exception {
        this.getServices().stop();
    }

    public synchronized void updateHosts() throws Exception {
        this.getHelper().update();
    }
}

