/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSaxHandler
extends DefaultHandler
implements LSResourceResolver {
    private static boolean debug;
    private volatile boolean loggable;
    private volatile Logger logger = Context.getCurrentLogger();

    public DefaultSaxHandler() {
        this.loggable = this.logger.isLoggable(Level.CONFIG);
    }

    @Override
    public void error(SAXParseException x) throws SAXException {
        if (this.loggable) {
            String msg = "[ERROR] - Unexpected exception while parsing an instance of PUBLIC [" + x.getPublicId() + "], SYSTEM [" + x.getSystemId() + "] - line #" + x.getLineNumber() + ", column #" + x.getColumnNumber();
            if (debug) {
                Context.getCurrentLogger().log(Level.CONFIG, msg, x);
            } else {
                this.logger.config(msg + ": " + x.getLocalizedMessage());
            }
        }
    }

    @Override
    public void fatalError(SAXParseException x) throws SAXException {
        if (this.loggable) {
            String msg = "[FATAL] - Unexpected exception while parsing an instance of PUBLIC [" + x.getPublicId() + "], SYSTEM [" + x.getSystemId() + "] - line #" + x.getLineNumber() + ", column #" + x.getColumnNumber();
            if (debug) {
                Context.getCurrentLogger().log(Level.CONFIG, msg, x);
            } else {
                this.logger.config(msg + ": " + x.getLocalizedMessage());
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (this.loggable) {
            this.logger.config("Resolve entity with PUBLIC [" + publicId + "], and SYSTEM [" + systemId + "]");
        }
        return super.resolveEntity(publicId, systemId);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceUri, String publicId, String systemId, String baseUri) {
        if (this.loggable) {
            this.logger.config("Resolve resource with type [" + type + "], namespace URI [" + namespaceUri + "], PUBLIC [" + publicId + "], SYSTEM [" + systemId + "], and base URI [" + baseUri + "]");
        }
        return null;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        super.skippedEntity(name);
        if (this.loggable) {
            this.logger.config("Skipped entity named [" + name + "]");
        }
    }

    @Override
    public void warning(SAXParseException x) throws SAXException {
        if (this.loggable) {
            String msg = "[WARN] - Unexpected exception while parsing an instance of PUBLIC [" + x.getPublicId() + "], SYSTEM [" + x.getSystemId() + "] - line #" + x.getLineNumber() + ", column #" + x.getColumnNumber();
            if (debug) {
                Context.getCurrentLogger().log(Level.CONFIG, msg, x);
            } else {
                this.logger.config(msg + ": " + x.getLocalizedMessage());
            }
        }
    }

    static {
        try {
            String debugStr = System.getProperty("jaxp.debug");
            debug = debugStr != null && !"false".equalsIgnoreCase(debugStr);
        }
        catch (SecurityException x) {
            debug = false;
        }
    }
}

