/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import java.io.IOException;
import java.io.InputStream;
import org.restlet.representation.Representation;
import org.springframework.core.io.AbstractResource;

public class SpringResource
extends AbstractResource {
    private final String description;
    private volatile boolean read = false;
    private final Representation representation;

    public SpringResource(Representation representation) {
        this(representation, "Restlet Representation");
    }

    public SpringResource(Representation representation, String description) {
        if (representation == null) {
            throw new IllegalArgumentException("Representation must not be null");
        }
        this.representation = representation;
        this.description = description != null ? description : "";
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SpringResource && ((SpringResource)((Object)obj)).representation.equals((Object)this.representation);
    }

    public boolean exists() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.read && this.representation.isTransient()) {
            throw new IllegalStateException("Representation has already been read and is transient.");
        }
        this.read = true;
        return this.representation.getStream();
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public boolean isOpen() {
        return true;
    }
}

