/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.engine.http.HttpRequest;
import org.restlet.engine.http.HttpResponse;
import org.restlet.engine.http.HttpServerAdapter;
import org.restlet.engine.http.HttpServerCall;
import org.restlet.ext.servlet.internal.ServletCall;
import org.restlet.ext.servlet.internal.ServletLogger;

public class ServletAdapter
extends HttpServerAdapter {
    private volatile Restlet target;

    public ServletAdapter(ServletContext context) {
        this(context, null);
    }

    public ServletAdapter(ServletContext context, Restlet target) {
        super(new Context((Logger)new ServletLogger(context)));
        this.target = target;
    }

    public Reference getBaseRef(HttpServletRequest request) {
        int baseIndex;
        Reference result = null;
        String basePath = request.getContextPath() + request.getServletPath();
        String baseUri = request.getRequestURL().toString();
        int pathStart = baseUri.indexOf("/", request.getScheme().length() + 3);
        if (basePath.length() == 0) {
            result = pathStart != -1 ? new Reference(baseUri.substring(0, pathStart)) : new Reference(baseUri);
        } else if (pathStart != -1 && (baseIndex = baseUri.indexOf(basePath, pathStart)) != -1) {
            result = new Reference(baseUri.substring(0, baseIndex + basePath.length()));
        }
        return result;
    }

    public Reference getRootRef(HttpServletRequest request) {
        return this.getBaseRef(request);
    }

    public Restlet getTarget() {
        return this.target;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getTarget() != null) {
            Context.setCurrent((Context)this.getContext());
            ServletCall servletCall = new ServletCall(request.getLocalAddr(), request.getLocalPort(), request, response);
            HttpRequest httpRequest = this.toRequest(servletCall);
            HttpResponse httpResponse = new HttpResponse((HttpServerCall)servletCall, (Request)httpRequest);
            httpRequest.getResourceRef().setBaseRef(this.getBaseRef(request));
            httpRequest.setRootRef(this.getRootRef(request));
            this.getTarget().handle((Request)httpRequest, (Response)httpResponse);
            this.commit(httpResponse);
        } else {
            this.getLogger().warning("Unable to find the Restlet target");
        }
    }

    public void setTarget(Restlet target) {
        this.target = target;
    }

    public HttpRequest toRequest(ServletCall servletCall) {
        HttpRequest result = super.toRequest((HttpServerCall)servletCall);
        Enumeration namesEnum = servletCall.getRequest().getAttributeNames();
        while (namesEnum.hasMoreElements()) {
            String attributeName = (String)namesEnum.nextElement();
            result.getAttributes().put(attributeName, servletCall.getRequest().getAttribute(attributeName));
        }
        return result;
    }
}

