/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.component.ComponentContext;
import org.restlet.engine.http.HttpServerCall;
import org.restlet.engine.http.HttpServerHelper;
import org.restlet.ext.servlet.internal.ServletCall;
import org.restlet.ext.servlet.internal.ServletWarClient;
import org.restlet.routing.Route;
import org.restlet.routing.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerServlet
extends HttpServlet {
    private static final String APPLICATION_KEY = "org.restlet.application";
    private static final String AUTO_WIRE_KEY = "org.restlet.autoWire";
    private static final String AUTO_WIRE_KEY_DEFAULT = "true";
    private static final String CLIENTS_KEY = "org.restlet.clients";
    private static final String COMPONENT_KEY = "org.restlet.component";
    private static final String NAME_APPLICATION_ATTRIBUTE = "org.restlet.attribute.application";
    private static final String NAME_APPLICATION_ATTRIBUTE_DEFAULT = "org.restlet.ext.servlet.ServerServlet.application";
    private static final String NAME_COMPONENT_ATTRIBUTE = "org.restlet.attribute.component";
    private static final String NAME_COMPONENT_ATTRIBUTE_DEFAULT = "org.restlet.ext.servlet.ServerServlet.component";
    private static final String NAME_SERVER_ATTRIBUTE = "org.restlet.attribute.server";
    private static final String NAME_SERVER_ATTRIBUTE_DEFAULT = "org.restlet.ext.servlet.ServerServlet.server";
    private static final long serialVersionUID = 1L;
    private volatile transient Application application = null;
    private volatile transient Component component = null;
    private volatile transient HttpServerHelper helper = null;

    protected void init(Application application) {
        if (application != null) {
            String initParam;
            Context applicationContext = application.getContext();
            applicationContext.getAttributes().put("org.restlet.ext.servlet.ServletContext", this.getServletContext());
            ServletConfig servletConfig = this.getServletConfig();
            Enumeration enum1 = servletConfig.getInitParameterNames();
            while (enum1.hasMoreElements()) {
                initParam = (String)enum1.nextElement();
                applicationContext.getParameters().add(initParam, servletConfig.getInitParameter(initParam));
            }
            enum1 = this.getServletContext().getInitParameterNames();
            while (enum1.hasMoreElements()) {
                initParam = (String)enum1.nextElement();
                applicationContext.getParameters().add(initParam, this.getServletContext().getInitParameter(initParam));
            }
        }
    }

    protected void init(Component component) {
        if (component != null) {
            String initParam;
            component.getClients().add(this.createWarClient(component.getContext(), this.getServletConfig()));
            ComponentContext componentContext = (ComponentContext)component.getContext();
            componentContext.getAttributes().put("org.restlet.ext.servlet.ServletContext", this.getServletContext());
            ServletConfig servletConfig = this.getServletConfig();
            Enumeration enum1 = servletConfig.getInitParameterNames();
            while (enum1.hasMoreElements()) {
                initParam = (String)enum1.nextElement();
                componentContext.getParameters().add(initParam, servletConfig.getInitParameter(initParam));
            }
            enum1 = this.getServletContext().getInitParameterNames();
            while (enum1.hasMoreElements()) {
                initParam = (String)enum1.nextElement();
                componentContext.getParameters().add(initParam, this.getServletContext().getInitParameter(initParam));
            }
            Enumeration namesEnum = this.getServletContext().getAttributeNames();
            while (namesEnum.hasMoreElements()) {
                String attributeName = (String)namesEnum.nextElement();
                componentContext.getAttributes().put(attributeName, this.getServletContext().getAttribute(attributeName));
            }
        }
    }

    protected Application createApplication(Context parentContext) {
        Application application = null;
        String applicationClassName = this.getInitParameter(APPLICATION_KEY, null);
        if (applicationClassName != null) {
            try {
                Class<?> targetClass = this.loadClass(applicationClassName);
                try {
                    application = (Application)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    application.setContext(parentContext.createChildContext());
                }
                catch (NoSuchMethodException e) {
                    this.log("[Restlet] ServerServlet couldn't invoke the constructor of the target class. Please check this class has a constructor without parameter. The constructor with a parameter of type Context will be used instead.");
                    application = (Application)targetClass.getConstructor(Context.class).newInstance(parentContext.createChildContext());
                }
            }
            catch (ClassNotFoundException e) {
                this.log("[Restlet] ServerServlet couldn't find the target class. Please check that your classpath includes " + applicationClassName, e);
            }
            catch (InstantiationException e) {
                this.log("[Restlet] ServerServlet couldn't instantiate the target class. Please check this class has an empty constructor " + applicationClassName, e);
            }
            catch (IllegalAccessException e) {
                this.log("[Restlet] ServerServlet couldn't instantiate the target class. Please check that you have to proper access rights to " + applicationClassName, e);
            }
            catch (NoSuchMethodException e) {
                this.log("[Restlet] ServerServlet couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + applicationClassName, e);
            }
            catch (InvocationTargetException e) {
                this.log("[Restlet] ServerServlet couldn't instantiate the target class. An exception was thrown while creating " + applicationClassName, e);
            }
        }
        return application;
    }

    protected HttpServerCall createCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        return new ServletCall(server, request, response);
    }

    protected Component createComponent() {
        String componentClassName;
        Component component = null;
        Client warClient = this.createWarClient(new Context(), this.getServletConfig());
        Response response = warClient.get("war:///WEB-INF/restlet.xml");
        if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
            component = new Component(response.getEntity());
        }
        if (component == null && (componentClassName = this.getInitParameter(COMPONENT_KEY, null)) != null) {
            try {
                Class<?> targetClass = this.loadClass(componentClassName);
                component = (Component)targetClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.log("[Restlet] ServerServlet couldn't find the target class. Please check that your classpath includes " + componentClassName, e);
            }
            catch (InstantiationException e) {
                this.log("[Restlet] ServerServlet couldn't instantiate the target class. Please check this class has an empty constructor " + componentClassName, e);
            }
            catch (IllegalAccessException e) {
                this.log("[Restlet] ServerServlet couldn't instantiate the target class. Please check that you have to proper access rights to " + componentClassName, e);
            }
        }
        if (component == null) {
            component = new Component();
            component.getStatusService().setEnabled(false);
            String clientProtocolsString = this.getInitParameter(CLIENTS_KEY, null);
            if (clientProtocolsString != null) {
                String[] clientProtocols;
                for (String clientProtocol : clientProtocols = clientProtocolsString.split(" ")) {
                    Client client = new Client(clientProtocol);
                    if (client.isAvailable()) {
                        component.getClients().add(client);
                        continue;
                    }
                    this.log("[Restlet] Couldn't find a client connector for protocol " + clientProtocol);
                }
            }
        }
        return component;
    }

    protected HttpServerHelper createServer(HttpServletRequest request) {
        HttpServerHelper result = null;
        Component component = this.getComponent();
        if (component != null) {
            Server server = new Server(component.getContext().createChildContext(), (List)null, this.getLocalAddr(request), this.getLocalPort(request), (Restlet)component);
            result = new HttpServerHelper(server);
            String uriPattern = this.getContextPath(request) + request.getServletPath();
            if (this.isDefaultComponent()) {
                if (this.application != null) {
                    this.log("[Restlet] Attaching application: " + this.application + " to URI: " + uriPattern);
                    component.getDefaultHost().attach(uriPattern, (Restlet)this.application);
                }
            } else {
                String autoWire = this.getInitParameter(AUTO_WIRE_KEY, AUTO_WIRE_KEY_DEFAULT);
                if (AUTO_WIRE_KEY_DEFAULT.equalsIgnoreCase(autoWire)) {
                    boolean addContextPath = false;
                    boolean addFullServletPath = false;
                    if (component.getDefaultHost().getRoutes().isEmpty()) {
                        addFullServletPath = component.getDefaultHost().getDefaultRoute() != null;
                    } else {
                        for (Route route : component.getDefaultHost().getRoutes()) {
                            if (route.getTemplate().getPattern() == null) {
                                addFullServletPath = true;
                                continue;
                            }
                            if (route.getTemplate().getPattern().startsWith(uriPattern)) continue;
                            if (!route.getTemplate().getPattern().startsWith(request.getServletPath())) {
                                addFullServletPath = true;
                                continue;
                            }
                            addContextPath = true;
                            break;
                        }
                    }
                    if (!addContextPath) {
                        for (VirtualHost virtualHost : component.getHosts()) {
                            if (virtualHost.getRoutes().isEmpty()) {
                                addFullServletPath = virtualHost.getDefaultRoute() != null;
                            } else {
                                for (Route route : virtualHost.getRoutes()) {
                                    if (route.getTemplate().getPattern() == null) {
                                        addFullServletPath = true;
                                        continue;
                                    }
                                    if (route.getTemplate().getPattern().startsWith(uriPattern)) continue;
                                    if (!route.getTemplate().getPattern().startsWith(request.getServletPath())) {
                                        addFullServletPath = true;
                                        continue;
                                    }
                                    addContextPath = true;
                                    break;
                                }
                            }
                            if (!addContextPath) continue;
                            break;
                        }
                    }
                    if (addContextPath || addFullServletPath) {
                        String offsetPath = null;
                        offsetPath = addContextPath ? this.getContextPath(request) : uriPattern;
                        Route defaultRoute = component.getDefaultHost().getDefaultRoute();
                        if (defaultRoute != null) {
                            defaultRoute.getTemplate().setPattern(offsetPath + defaultRoute.getTemplate().getPattern());
                            this.log("[Restlet] Attaching restlet: " + defaultRoute.getNext() + " to URI: " + offsetPath + defaultRoute.getTemplate().getPattern());
                        }
                        for (Route route : component.getDefaultHost().getRoutes()) {
                            this.log("[Restlet] Attaching restlet: " + route.getNext() + " to URI: " + offsetPath + route.getTemplate().getPattern());
                            route.getTemplate().setPattern(offsetPath + route.getTemplate().getPattern());
                        }
                        for (VirtualHost virtualHost : component.getHosts()) {
                            defaultRoute = virtualHost.getDefaultRoute();
                            if (defaultRoute != null) {
                                defaultRoute.getTemplate().setPattern(offsetPath + defaultRoute.getTemplate().getPattern());
                                this.log("[Restlet] Attaching restlet: " + defaultRoute.getNext() + " to URI: " + offsetPath + defaultRoute.getTemplate().getPattern());
                            }
                            for (Route route : virtualHost.getRoutes()) {
                                this.log("[Restlet] Attaching restlet: " + route.getNext() + " to URI: " + offsetPath + route.getTemplate().getPattern());
                                route.getTemplate().setPattern(offsetPath + route.getTemplate().getPattern());
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    protected Client createWarClient(Context context, ServletConfig config) {
        return new ServletWarClient(context, config.getServletContext());
    }

    public void destroy() {
        if (this.getComponent() != null && this.getComponent().isStarted()) {
            try {
                this.getComponent().stop();
            }
            catch (Exception e) {
                this.log("Error during the stopping of the Restlet Component", e);
            }
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Application getApplication() {
        Application result = this.application;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            if (result != null || !this.isDefaultComponent()) return result;
            String applicationAttributeName = this.getInitParameter(NAME_APPLICATION_ATTRIBUTE, NAME_APPLICATION_ATTRIBUTE_DEFAULT);
            result = (Application)this.getServletContext().getAttribute(applicationAttributeName);
            if (result == null) {
                result = this.createApplication(this.getComponent().getContext());
                this.init(result);
                this.getServletContext().setAttribute(applicationAttributeName, (Object)result);
            }
            this.application = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getComponent() {
        Component result = this.component;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            if (result == null) {
                String componentAttributeName = this.getInitParameter(NAME_COMPONENT_ATTRIBUTE, NAME_COMPONENT_ATTRIBUTE_DEFAULT);
                result = (Component)this.getServletContext().getAttribute(componentAttributeName);
                if (result == null) {
                    result = this.createComponent();
                    this.init(result);
                    this.getServletContext().setAttribute(componentAttributeName, (Object)result);
                }
            }
            this.component = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    protected String getContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public String getInitParameter(String name, String defaultValue) {
        String result = this.getServletConfig().getInitParameter(name);
        if (result == null) {
            result = this.getServletConfig().getServletContext().getInitParameter(name);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    protected String getLocalAddr(HttpServletRequest request) {
        return request.getLocalAddr();
    }

    protected int getLocalPort(HttpServletRequest request) {
        return request.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpServerHelper getServer(HttpServletRequest request) {
        HttpServerHelper result = this.helper;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            if (result != null) return result;
            String serverAttributeName = this.getInitParameter(NAME_SERVER_ATTRIBUTE, NAME_SERVER_ATTRIBUTE_DEFAULT);
            result = (HttpServerHelper)this.getServletContext().getAttribute(serverAttributeName);
            if (result == null) {
                result = this.createServer(request);
                this.getServletContext().setAttribute(serverAttributeName, (Object)result);
            }
            this.helper = result;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public void init() throws ServletException {
        if (this.getComponent() != null && this.getApplication() != null && this.getApplication().isStopped()) {
            try {
                this.getApplication().start();
            }
            catch (Exception e) {
                this.log("Error during the starting of the Restlet Application", e);
            }
        }
    }

    private boolean isDefaultComponent() {
        Client client = this.createWarClient(new Context(), this.getServletConfig());
        Response response = client.get("war:///WEB-INF/restlet.xml");
        if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
            return false;
        }
        String componentAttributeName = this.getInitParameter(COMPONENT_KEY, null);
        return componentAttributeName == null;
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        return Engine.loadClass((String)className);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServerHelper helper = this.getServer(request);
        if (helper != null) {
            helper.handle(this.createCall((Server)helper.getHelped(), request, response));
        } else {
            this.log("[Restlet] Unable to get the Restlet HTTP server connector. Status code 500 returned.");
            response.sendError(500);
        }
    }
}

