/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.EntryReader;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.odata.internal.FeedContentHandler;
import org.restlet.ext.odata.internal.edm.AssociationEnd;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Mapping;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.ext.odata.internal.edm.Property;
import org.restlet.ext.odata.internal.reflect.ReflectUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryContentHandler<T>
extends EntryReader {
    private AssociationEnd association;
    private List<String> eltPath;
    private T entity;
    private Class<?> entityClass;
    private EntityType entityType;
    private Content inlineContent;
    private Entry inlineEntry;
    private EntryContentHandler<T> inlineEntryHandler;
    private Feed inlineFeed;
    private FeedContentHandler<T> inlineFeedHandler;
    private Link inlineLink;
    private Logger logger;
    private Mapping mapping;
    private Metadata metadata;
    private boolean parsePropertyNull;
    private List<String> propertyPath;
    private StringBuilder sb = null;
    private List<State> states;

    public EntryContentHandler(Class<?> entityClass, EntityType entityType, Metadata metadata, Logger logger) {
        this.entityClass = entityClass;
        this.entityType = entityType;
        this.metadata = metadata;
        this.logger = logger;
    }

    public EntryContentHandler(Class<?> entityClass, Metadata metadata, Logger logger) {
        this.entityClass = entityClass;
        this.entityType = metadata.getEntityType(entityClass);
        this.metadata = metadata;
        this.logger = logger;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (State.ASSOCIATION == this.getState()) {
            if (this.association.isToMany()) {
                this.inlineFeedHandler.characters(ch, start, length);
            } else {
                this.inlineEntryHandler.characters(ch, start, length);
            }
        } else if (State.PROPERTY == this.getState() || this.mapping != null) {
            this.sb.append(ch, start, length);
        }
    }

    public boolean closeEntry(Entry entry) {
        boolean result = false;
        if (this.getState() == State.ENTRY) {
            this.endEntry(entry);
            result = true;
        }
        return result;
    }

    public boolean closeLink() {
        if (State.ASSOCIATION == this.getState() && this.inlineLink != null) {
            String propertyName = ReflectUtils.normalize(this.inlineLink.getTitle());
            if (this.association.isToMany()) {
                if (this.inlineFeedHandler.closeLink()) {
                    return true;
                }
                try {
                    ReflectUtils.setProperty(this.entity, propertyName, this.association.isToMany(), this.inlineFeedHandler.getEntities().iterator(), ReflectUtils.getSimpleClass(this.entity, propertyName));
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set " + propertyName + " property on " + this.entity + " from link");
                }
                this.inlineFeedHandler = null;
            } else {
                if (this.inlineEntryHandler.closeLink()) {
                    return true;
                }
                try {
                    ReflectUtils.invokeSetter(this.entity, propertyName, this.inlineEntryHandler.getEntity());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set " + propertyName + " property on " + this.entity + " from link");
                }
                this.inlineEntryHandler = null;
            }
            this.popState();
            this.association = null;
            return true;
        }
        return this.getState() != null;
    }

    public void endContent(Content content) {
        if (State.ASSOCIATION == this.getState()) {
            if (this.association.isToMany()) {
                this.inlineFeedHandler.endContent(content);
            } else {
                this.inlineEntryHandler.endContent(content);
            }
        } else if (State.CONTENT == this.getState()) {
            this.popState();
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (State.ASSOCIATION == this.getState()) {
            if (uri.equalsIgnoreCase("http://www.w3.org/2005/Atom")) {
                if (localName.equals("feed")) {
                    if (this.association.isToMany()) {
                        this.inlineFeedHandler.endFeed(this.inlineFeed);
                    }
                } else {
                    if (localName.equals("link")) {
                        if (this.association.isToMany()) {
                            this.inlineFeedHandler.closeLink();
                        } else {
                            this.inlineEntryHandler.closeLink();
                        }
                        return;
                    }
                    if (localName.equalsIgnoreCase("entry")) {
                        if (this.association.isToMany()) {
                            this.inlineFeedHandler.endEntry(this.inlineEntry);
                        } else {
                            this.inlineEntryHandler.closeEntry(this.inlineEntry);
                        }
                    } else if (localName.equalsIgnoreCase("content")) {
                        if (this.association.isToMany()) {
                            this.inlineFeedHandler.endContent(this.inlineContent);
                        } else {
                            this.inlineEntryHandler.endContent(this.inlineContent);
                        }
                    }
                }
            }
            if (this.association.isToMany()) {
                this.inlineFeedHandler.endElement(uri, localName, qName);
            } else {
                this.inlineEntryHandler.endElement(uri, localName, qName);
            }
        } else if (State.PROPERTY == this.getState()) {
            if (this.parsePropertyNull) {
                this.popState();
                this.parsePropertyNull = false;
            } else {
                Property property;
                Object obj = this.entity;
                if (this.propertyPath.size() > 1) {
                    for (int i = 0; i < this.propertyPath.size() - 1; ++i) {
                        try {
                            Object o = ReflectUtils.invokeGetter(obj, this.propertyPath.get(i));
                            if (o == null) {
                                Field[] fields;
                                for (Field field : fields = obj.getClass().getDeclaredFields()) {
                                    if (!field.getName().equalsIgnoreCase(this.propertyPath.get(i))) continue;
                                    o = field.getType().newInstance();
                                    break;
                                }
                            }
                            ReflectUtils.invokeSetter(obj, this.propertyPath.get(i), o);
                            obj = o;
                            continue;
                        }
                        catch (Exception e) {
                            obj = null;
                        }
                    }
                }
                if ((property = this.metadata.getProperty(obj, localName)) != null) {
                    try {
                        ReflectUtils.setProperty(obj, property, this.sb.toString());
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Cannot set " + localName + " property on " + obj + " with value " + this.sb.toString());
                    }
                }
                if (!this.propertyPath.isEmpty()) {
                    this.propertyPath.remove(this.propertyPath.size() - 1);
                }
                if (this.propertyPath.isEmpty()) {
                    this.popState();
                }
            }
        } else if (State.PROPERTIES == this.getState()) {
            this.popState();
        } else if (State.CONTENT == this.getState()) {
            this.popState();
        } else if (this.mapping != null) {
            if (this.sb != null) {
                try {
                    ReflectUtils.invokeSetter(this.entity, this.mapping.getPropertyPath(), this.sb.toString());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set the mapped property " + this.mapping.getPropertyPath() + " on " + this.entity + " with value " + this.sb.toString());
                }
            }
            this.mapping = null;
        } else if (State.ENTRY == this.getState() && !this.eltPath.isEmpty()) {
            this.eltPath.remove(this.eltPath.size() - 1);
        }
    }

    public void endEntry(Entry entry) {
        this.states = new ArrayList<State>();
        for (Mapping m : this.metadata.getMappings()) {
            if (this.entityType == null || !this.entityType.equals(m.getType()) || m.getNsUri() != null || m.getNsPrefix() != null) continue;
            Person author = entry.getAuthors().isEmpty() ? null : (Person)entry.getAuthors().get(0);
            Person contributor = entry.getContributors().isEmpty() ? null : (Person)entry.getContributors().get(0);
            Object value = null;
            if ("SyndicationAuthorEmail".equals(m.getValuePath())) {
                value = author != null ? author.getEmail() : null;
            } else if ("SyndicationAuthorName".equals(m.getValuePath())) {
                value = author != null ? author.getName() : null;
            } else if ("SyndicationAuthorUri".equals(m.getValuePath())) {
                value = author != null ? author.getUri().toString() : null;
            } else if ("SyndicationContributorEmail".equals(m.getValuePath())) {
                value = contributor != null ? contributor.getEmail() : null;
            } else if ("SyndicationContributorName".equals(m.getValuePath())) {
                value = contributor != null ? contributor.getName() : null;
            } else if ("SyndicationContributorUri".equals(m.getValuePath())) {
                value = contributor != null ? contributor.getUri().toString() : null;
            } else if ("SyndicationPublished".equals(m.getValuePath())) {
                value = entry.getPublished();
            } else if ("SyndicationRights".equals(m.getValuePath())) {
                value = entry.getRights() != null ? entry.getRights().getContent() : null;
            } else if ("SyndicationSummary".equals(m.getValuePath())) {
                value = entry.getSummary();
            } else if ("SyndicationTitle".equals(m.getValuePath())) {
                value = entry.getTitle() != null ? entry.getTitle().getContent() : null;
            } else if ("SyndicationUpdated".equals(m.getValuePath())) {
                value = entry.getUpdated();
            }
            try {
                if (value == null) continue;
                ReflectUtils.invokeSetter(this.entity, m.getPropertyPath(), value);
            }
            catch (Exception e) {
                this.getLogger().warning("Cannot set " + m.getPropertyPath() + " property on " + this.entity + " with value " + value);
            }
        }
        if (this.entityType != null && this.entityType.isBlob() && this.entityType.getBlobValueEditRefProperty() != null) {
            Link link = entry.getLink(Relation.EDIT_MEDIA);
            String pty = this.entityType.getBlobValueEditRefProperty().getName();
            if (link != null) {
                try {
                    ReflectUtils.invokeSetter(this.entity, pty, link.getHref());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set the property " + pty + " on " + this.entity + " with value " + link.getHref());
                }
            }
        }
    }

    public void endLink(Link link) {
        if (State.ASSOCIATION == this.getState()) {
            String propertyName = ReflectUtils.normalize(link.getTitle());
            if (this.association.isToMany()) {
                this.inlineFeedHandler.endLink(link);
                try {
                    ReflectUtils.setProperty(this.entity, propertyName, this.association.isToMany(), this.inlineFeedHandler.getEntities().iterator(), ReflectUtils.getSimpleClass(this.entity, propertyName));
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set " + propertyName + " property on " + this.entity + " from link");
                }
                this.inlineFeedHandler = null;
            } else {
                this.inlineEntryHandler.endLink(link);
                try {
                    ReflectUtils.invokeSetter(this.entity, propertyName, this.inlineEntryHandler.getEntity());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set " + propertyName + " property on " + this.entity + " from link");
                }
                this.inlineEntryHandler = null;
            }
            this.popState();
            this.association = null;
        }
    }

    public T getEntity() {
        return this.entity;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Context.getCurrentLogger();
        }
        return this.logger;
    }

    private MediaType getMediaType(String type) {
        MediaType result = null;
        if (type != null) {
            result = type.equals("text") ? MediaType.TEXT_PLAIN : (type.equals("html") ? MediaType.TEXT_HTML : (type.equals("xhtml") ? MediaType.APPLICATION_XHTML : new MediaType(type)));
        }
        return result;
    }

    private State getState() {
        int size;
        State result = null;
        if (this.states != null && (size = this.states.size()) > 0) {
            result = this.states.get(size - 1);
        }
        return result;
    }

    private State popState() {
        State result = null;
        int size = this.states.size();
        if (size > 0) {
            result = this.states.remove(size - 1);
        }
        return result;
    }

    private void pushState(State state) {
        this.states.add(state);
    }

    public void startContent(Content content) {
        if (State.ENTRY == this.getState()) {
            Reference ref;
            this.pushState(State.CONTENT);
            this.inlineContent = content;
            if (this.entityType != null && this.entityType.isBlob() && this.entityType.getBlobValueRefProperty() != null && (ref = content.getExternalRef()) != null) {
                try {
                    ReflectUtils.invokeSetter(this.entity, this.entityType.getBlobValueRefProperty().getName(), ref);
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set " + this.entityType.getBlobValueRefProperty().getName() + " property on " + this.entity + " with value " + ref);
                }
            }
        } else if (State.ASSOCIATION == this.getState()) {
            if (this.association.isToMany()) {
                this.inlineFeedHandler.startContent(content);
            } else {
                this.inlineEntryHandler.startContent(content);
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (State.ASSOCIATION == this.getState()) {
            if (uri.equalsIgnoreCase("http://www.w3.org/2005/Atom")) {
                if (localName.equals("feed")) {
                    Feed feed = new Feed();
                    String attr = attrs.getValue("xml:base");
                    if (attr != null) {
                        feed.setBaseReference(new Reference(attr));
                    }
                    if (this.association.isToMany()) {
                        this.inlineFeedHandler.startFeed(feed);
                    } else {
                        this.inlineEntryHandler.startFeed(feed);
                    }
                } else if (localName.equals("link")) {
                    Link link = new Link();
                    link.setHref(new Reference(attrs.getValue("", "href")));
                    link.setRel(Relation.valueOf((String)attrs.getValue("", "rel")));
                    String type = attrs.getValue("", "type");
                    if (type != null && type.length() > 0) {
                        link.setType(new MediaType(type));
                    }
                    link.setHrefLang(new Language(attrs.getValue("", "hreflang")));
                    link.setTitle(attrs.getValue("", "title"));
                    String attr = attrs.getValue("", "length");
                    link.setLength(attr == null ? -1L : Long.parseLong(attr));
                    if (this.association.isToMany()) {
                        this.inlineFeedHandler.startLink(link);
                    } else {
                        this.inlineEntryHandler.startLink(link);
                    }
                } else if (localName.equalsIgnoreCase("entry")) {
                    Entry entry = new Entry();
                    if (this.association.isToMany()) {
                        this.inlineFeedHandler.startEntry(entry);
                    } else {
                        this.inlineEntryHandler.startEntry(entry);
                    }
                    this.inlineEntry = entry;
                } else if (localName.equalsIgnoreCase("content")) {
                    Content content = new Content();
                    MediaType type = this.getMediaType(attrs.getValue("", "type"));
                    String srcAttr = attrs.getValue("", "src");
                    if (srcAttr != null) {
                        content.setExternalRef(new Reference(srcAttr));
                    }
                    content.setExternalType(type);
                    if (this.association.isToMany()) {
                        this.inlineFeedHandler.startContent(content);
                    } else {
                        this.inlineEntryHandler.startContent(content);
                    }
                }
            }
            if (this.association.isToMany()) {
                this.inlineFeedHandler.startElement(uri, localName, qName, attrs);
            } else {
                this.inlineEntryHandler.startElement(uri, localName, qName, attrs);
            }
        } else if ("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(uri) && "properties".equals(localName)) {
            this.pushState(State.PROPERTIES);
            this.propertyPath = new ArrayList<String>();
        } else if (State.PROPERTIES == this.getState()) {
            this.pushState(State.PROPERTY);
            if (Boolean.parseBoolean(attrs.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null"))) {
                this.parsePropertyNull = true;
            } else {
                this.sb = new StringBuilder();
                this.propertyPath.add(localName);
            }
        } else if (State.PROPERTY == this.getState()) {
            this.sb = new StringBuilder();
            this.propertyPath.add(localName);
        } else if (State.ENTRY == this.getState()) {
            if (localName.equalsIgnoreCase("link") && this.association != null) {
                this.pushState(State.ASSOCIATION);
            } else {
                this.eltPath.add(localName);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.eltPath.size(); ++i) {
                    if (i > 0) {
                        sb.append("/");
                    }
                    sb.append(this.eltPath.get(i));
                }
                String str = sb.toString();
                for (Mapping m : this.metadata.getMappings()) {
                    if (this.entityType == null || !this.entityType.equals(m.getType()) || m.getNsUri() == null || !m.getNsUri().equals(uri) || !str.equals(m.getValueNodePath()) && !str.equals("entry/" + m.getValueNodePath())) continue;
                    if (m.isAttributeValue()) {
                        String value = attrs.getValue(m.getValueAttributeName());
                        if (value == null) break;
                        try {
                            ReflectUtils.invokeSetter(this.entity, m.getPropertyPath(), value);
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Cannot set " + m.getPropertyPath() + " property on " + this.entity + " with value " + value);
                        }
                        break;
                    }
                    this.sb = new StringBuilder();
                    this.mapping = m;
                    break;
                }
            }
        }
    }

    public void startEntry(Entry entry) {
        if (this.getState() != null) {
            switch (this.getState()) {
                case ASSOCIATION: {
                    if (this.association.isToMany()) {
                        this.inlineFeedHandler.startEntry(entry);
                        break;
                    }
                    this.inlineEntryHandler.startEntry(entry);
                    break;
                }
            }
        } else {
            this.states = new ArrayList<State>();
            this.pushState(State.ENTRY);
            this.eltPath = new ArrayList<String>();
            try {
                this.entity = this.entityClass.newInstance();
            }
            catch (Exception e) {
                this.getLogger().warning("Error when instantiating  class " + this.entityClass);
            }
        }
    }

    public void startFeed(Feed feed) {
        if (State.ASSOCIATION == this.getState()) {
            if (this.association.isToMany()) {
                this.inlineFeedHandler.startFeed(feed);
            } else {
                this.inlineEntryHandler.startFeed(feed);
            }
        }
    }

    public void startLink(Link link) {
        if (State.ASSOCIATION == this.getState()) {
            if (this.association.isToMany()) {
                this.inlineFeedHandler.startLink(link);
            } else {
                this.inlineEntryHandler.startLink(link);
            }
        } else if (link.getTitle() != null && this.entityType != null) {
            String propertyName = ReflectUtils.normalize(link.getTitle());
            this.association = this.metadata.getAssociation(this.entityType, propertyName);
            if (this.association != null) {
                this.inlineLink = link;
                if (this.association.isToMany()) {
                    this.inlineFeedHandler = new FeedContentHandler(ReflectUtils.getSimpleClass(this.entity, propertyName), this.metadata, this.getLogger());
                } else {
                    this.inlineEntryHandler = new EntryContentHandler<T>(ReflectUtils.getSimpleClass(this.entity, propertyName), this.metadata, this.getLogger());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ASSOCIATION,
        CONTENT,
        ENTRY,
        PROPERTIES,
        PROPERTY;

    }
}

