/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.json;

import java.io.IOException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source)) {
            result = this.addObjectClass(result, JSONArray.class);
            result = this.addObjectClass(result, JSONObject.class);
            result = this.addObjectClass(result, JSONTokener.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (JSONArray.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_JSON);
        } else if (JSONObject.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_JSON);
        } else if (JSONTokener.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_JSON);
        }
        return result;
    }

    public float score(Object source, Variant target, UniformResource resource) {
        float result = -1.0f;
        if (source instanceof JSONArray) {
            result = MediaType.APPLICATION_JSON.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.5f;
        } else if (source instanceof JSONObject) {
            result = MediaType.APPLICATION_JSON.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.5f;
        } else if (source instanceof JSONTokener) {
            result = MediaType.APPLICATION_JSON.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.5f;
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (target != null) {
            if (JsonRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (JSONArray.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_JSON.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            } else if (JSONObject.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_JSON.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            } else if (JSONTokener.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_JSON.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        Object result = null;
        if (JSONArray.class.isAssignableFrom(target)) {
            try {
                result = new JSONArray(source.getText());
            }
            catch (JSONException e) {
                IOException ioe = new IOException("Unable to convert to JSON array");
                ioe.initCause(e);
            }
        } else if (JSONObject.class.isAssignableFrom(target)) {
            try {
                result = new JSONObject(source.getText());
            }
            catch (JSONException e) {
                IOException ioe = new IOException("Unable to convert to JSON object");
                ioe.initCause(e);
            }
        } else if (JSONTokener.class.isAssignableFrom(target)) {
            result = new JSONTokener(source.getText());
        } else if (JsonRepresentation.class.isAssignableFrom(target)) {
            result = new JsonRepresentation(source);
        }
        return (T)result;
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) {
        StringRepresentation result = null;
        if (source instanceof JSONArray) {
            result = new StringRepresentation((CharSequence)((JSONArray)source).toString());
        } else if (source instanceof JSONObject) {
            result = new StringRepresentation((CharSequence)((JSONObject)source).toString());
        } else if (source instanceof JSONTokener) {
            result = new StringRepresentation((CharSequence)((JSONTokener)source).toString());
        }
        return result;
    }
}

