/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.io.IOException;
import java.util.List;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.internal.CategoriesContentReader;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.xml.sax.SAXException;

public class Categories
extends SaxRepresentation {
    private volatile Reference baseReference;
    private volatile List<Category> entries;
    private boolean fixed;
    private Reference scheme;

    public Categories(Client clientDispatcher, String categoriesUri) throws IOException {
        this(clientDispatcher.handle(new Request(Method.GET, categoriesUri)).getEntity());
    }

    public Categories(Context context, String categoriesUri) throws IOException {
        this(context.getClientDispatcher().handle(new Request(Method.GET, categoriesUri)).getEntity());
    }

    public Categories(Representation categoriesFeed) throws IOException {
        super(categoriesFeed);
        this.setNamespaceAware(true);
        this.parse(new CategoriesContentReader(this));
    }

    public Categories(String categoriesUri) throws IOException {
        this(new Client(new Reference(categoriesUri).getSchemeProtocol()), categoriesUri);
    }

    public Reference getBaseReference() {
        return this.baseReference;
    }

    public List<Category> getEntries() {
        return this.entries;
    }

    public Reference getScheme() {
        return this.scheme;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setBaseReference(Reference baseReference) {
        this.baseReference = baseReference;
    }

    public void setEntries(List<Category> entries) {
        this.entries = entries;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setScheme(Reference scheme) {
        this.scheme = scheme;
    }

    public void write(XmlWriter writer) throws IOException {
        try {
            writer.setPrefix("http://www.w3.org/2007/app", "");
            writer.setPrefix("http://www.w3.org/2005/Atom", "atom");
            writer.setDataFormat(true);
            writer.setIndentStep(3);
            writer.startDocument();
            this.writeElement(writer);
            writer.endDocument();
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Unable to write the AtomPub categories document.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        writer.startElement("http://www.w3.org/2007/app", "categories");
        for (Category entry : this.getEntries()) {
            entry.writeElement(writer);
        }
        writer.endElement("http://www.w3.org/2007/app", "categories");
        writer.endDocument();
    }
}

