/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Collection;
import org.restlet.ext.atom.Service;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace {
    private volatile Reference baseReference;
    private volatile List<Collection> collections;
    private volatile Service service;
    private volatile String title;

    public Workspace(Service service) {
        this(service, null);
    }

    public Workspace(Service service, String title) {
        this.service = service;
        this.title = title;
    }

    public Reference getBaseReference() {
        return this.baseReference;
    }

    public List<Collection> getCollections() {
        if (this.collections == null) {
            this.collections = new ArrayList<Collection>();
        }
        return this.collections;
    }

    public Service getService() {
        return this.service;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBaseReference(Reference baseReference) {
        this.baseReference = baseReference;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        writer.startElement("http://www.w3.org/2007/app", "workspace");
        if (this.getTitle() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "title", this.getTitle());
        }
        for (Collection collection : this.getCollections()) {
            collection.writeElement(writer);
        }
        writer.endElement("http://www.w3.org/2007/app", "workspace");
    }
}

