/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.cache;

import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.restcomm.cache.FqnWrapper;
import org.restcomm.cache.MobicentsCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheData {
    private static final Logger logger = Logger.getLogger(CacheData.class);
    private Node node;
    private final Fqn nodeFqn;
    private boolean isRemoved;
    private final MobicentsCache mobicentsCache;
    private static final boolean doTraceLogs = logger.isTraceEnabled();

    public CacheData(FqnWrapper nodeFqnWrapper, MobicentsCache mobicentsCache) {
        this.nodeFqn = nodeFqnWrapper.getFqn();
        this.mobicentsCache = mobicentsCache;
        this.node = mobicentsCache.getJBossCache().getRoot().getChild(this.nodeFqn);
        if (doTraceLogs) {
            logger.trace((Object)("cache node " + this.nodeFqn + " retrieved, result = " + this.node));
        }
    }

    public boolean exists() {
        return this.node != null;
    }

    public boolean create() {
        if (!this.exists()) {
            this.node = this.mobicentsCache.getJBossCache().getRoot().addChild(this.nodeFqn);
            if (doTraceLogs) {
                logger.trace((Object)("created cache node " + this.nodeFqn));
            }
            return true;
        }
        return false;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean remove() {
        if (this.exists() && !this.isRemoved()) {
            this.isRemoved = true;
            this.node.getParent().removeChild(this.nodeFqn.getLastElement());
            if (doTraceLogs) {
                logger.trace((Object)("removed cache node " + this.nodeFqn));
            }
            return true;
        }
        return false;
    }

    protected Node getNode() {
        if (this.isRemoved()) {
            throw new IllegalStateException();
        }
        return this.node;
    }

    public MobicentsCache getMobicentsCache() {
        return this.mobicentsCache;
    }

    public Fqn getNodeFqn() {
        return this.nodeFqn;
    }

    public FqnWrapper getNodeFqnWrapper() {
        return new FqnWrapper(this.nodeFqn);
    }

    public Object getNodeFqnLastElement() {
        return this.nodeFqn.getLastElement();
    }

    public Object putNodeValue(Object key, Object value) {
        return this.getNode().put(key, value);
    }

    public Object getNodeValue(Object key) {
        return this.getNode().get(key);
    }

    public Object removeNodeValue(Object key) {
        return this.getNode().remove(key);
    }

    public Object addChildNode(FqnWrapper fqnWrapper) {
        Node childNode = this.getNode().addChild(fqnWrapper.getFqn());
        return childNode;
    }

    public Object putChildNodeValue(FqnWrapper fqnWrapper, Object key, Object value) {
        Node childNode = this.getNode().getChild(fqnWrapper.getFqn());
        if (childNode != null) {
            return childNode.put(key, value);
        }
        return null;
    }

    public Object getChildNode(String child) {
        Node childNode = this.getNode().getChild((Object)child);
        return childNode;
    }

    public Map<String, Object> getChildNodeData(String child) {
        Node childNode = this.getNode().getChild((Object)child);
        return childNode.getData();
    }

    public Object getChildNodeValue(String child, Object key) {
        Node childNode = this.getNode().getChild((Object)child);
        return childNode.get(key);
    }

    public boolean removeChildNode(String child) {
        return this.getNode().removeChild((Object)child);
    }
}

